<?php
require __DIR__ . '/bootstrap/app.php';

use App\Core\Database;

$pdo = Database::getInstance()->getPdo();

// Check wallets table structure
$stmt = $pdo->query('DESCRIBE wallets');
echo "Wallets table structure:\n";
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    echo "{$row['Field']} | {$row['Type']} | {$row['Null']} | {$row['Key']} | {$row['Default']} | {$row['Extra']}\n";
}

// Check if user_type column exists
$stmt = $pdo->query("SHOW COLUMNS FROM wallets LIKE 'user_type'");
echo "\nChecking for user_type column: " . ($stmt->rowCount() > 0 ? 'EXISTS' : 'DOES NOT EXIST') . "\n";
