<?php
require 'vendor/autoload.php';

// Database configuration - adjust these as needed
$dbConfig = [
    'host' => 'localhost',
    'dbname' => 'b3bthaihub',
    'user' => 'root',
    'pass' => ''
];

try {
    $pdo = new PDO(
        "mysql:host={$dbConfig['host']};dbname={$dbConfig['dbname']};charset=utf8mb4",
        $dbConfig['user'],
        $dbConfig['pass'],
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );

    // Check wallet_transactions table structure
    $stmt = $pdo->query("SHOW CREATE TABLE wallet_transactions");
    $result = $stmt->fetch();
    
    if (isset($result['Create Table'])) {
        echo "=== wallet_transactions table structure ===\n";
        echo $result['Create Table'] . "\n\n";
    } else {
        echo "wallet_transactions table not found or empty\n";
    }

    // Also show the structure of the wallets table for reference
    $stmt = $pdo->query("SHOW CREATE TABLE wallets");
    $result = $stmt->fetch();
    
    if (isset($result['Create Table'])) {
        echo "=== wallets table structure ===\n";
        echo $result['Create Table'] . "\n";
    } else {
        echo "wallets table not found or empty\n";
    }

} catch (PDOException $e) {
    die("Error: " . $e->getMessage() . "\n");
}
