<?php
// TEMPORARY one-time admin creator. DELETE this file after running once.
// URL: http://localhost:8000/tools_create_admin.php

require_once dirname(__DIR__) . '/config/config.php';

header('Content-Type: text/plain');

try {
    // Set your desired credentials here
    $email = 'admin3@example.com';
    $passwordPlain = 'Admin@12345';
    $name = 'Super Admin';
    $role = 'Admin';

    // Check if user already exists
    $stmt = $pdo->prepare('SELECT id, email FROM users WHERE email = :email LIMIT 1');
    $stmt->execute(['email' => $email]);
    $existing = $stmt->fetch();

    if ($existing) {
        echo "User already exists: {$existing['email']} (id={$existing['id']}).\n";
        echo "No changes made.\n";
        exit;
    }

    $hash = password_hash($passwordPlain, PASSWORD_BCRYPT);
    $stmt = $pdo->prepare('INSERT INTO users (name, email, role, password, created_at) VALUES (:name, :email, :role, :password, NOW())');
    $stmt->execute([
        'name' => $name,
        'email' => $email,
        'role' => $role,
        'password' => $hash,
    ]);

    echo "Admin user created successfully.\n";
    echo "Email: {$email}\n";
    echo "Password: {$passwordPlain}\n";
    echo "\nIMPORTANT: Delete this file: public/tools_create_admin.php\n";
} catch (Throwable $e) {
    http_response_code(500);
    echo 'Error: ' . $e->getMessage();
}
