<?php
// Minimal dispatcher for B2B static pages with pretty URLs
// Examples:
//   /b2bagent/ -> view=index
//   /b2bagent/hotel-list -> view=hotel-list
//   /b2bagent/hotel-list.html -> view=hotel-list

$baseDir = __DIR__;
$view = $_GET['view'] ?? 'index';

// allow only safe slugs
if (!preg_match('~^[a-z0-9\-]+$~i', $view)) {
    http_response_code(404);
    echo 'Not found';
    exit;
}

$phpFile = $baseDir . DIRECTORY_SEPARATOR . $view . '.php';
$htmlFile = $baseDir . DIRECTORY_SEPARATOR . $view . '.html';

if (is_file($phpFile)) {
    // Let PHP files run
    require $phpFile;
    exit;
}

if (is_file($htmlFile)) {
    // Serve static HTML file contents
    header('Content-Type: text/html; charset=utf-8');
    readfile($htmlFile);
    exit;
}

http_response_code(404);
echo 'Page not found';
