<?php
$config = require_once 'config/config.php';
$pdo = $config['pdo'];

echo "=== CREATING FUNCTION DIRECTLY ===\n\n";

// Drop existing function
try {
    $pdo->exec("DROP FUNCTION IF EXISTS insert_wallet_transaction");
    echo "✓ Dropped existing function\n";
} catch (Exception $e) {
    echo "Note: " . $e->getMessage() . "\n";
}

// Create function with proper delimiters
$functionSQL = "
CREATE FUNCTION insert_wallet_transaction(
    p_user_id INT,
    p_transaction_type ENUM('credit','debit'),
    p_category ENUM('admin_credit','booking_payment','taxi_payment','refund','transfer_in','transfer_out','adjustment','topup'),
    p_amount DECIMAL(12,2),
    p_description VARCHAR(255),
    p_reference_id VARCHAR(100),
    p_reference_type ENUM('order','taxi_booking','hotel_booking','admin_action','transfer','refund'),
    p_admin_user_id INT,
    p_metadata JSON
) RETURNS INT
READS SQL DATA
MODIFIES SQL DATA
DETERMINISTIC
BEGIN
    DECLARE current_balance DECIMAL(12,2) DEFAULT 0.00;
    DECLARE new_balance DECIMAL(12,2) DEFAULT 0.00;
    DECLARE transaction_id INT DEFAULT 0;
    
    SELECT COALESCE(balance, 0.00) INTO current_balance 
    FROM wallets 
    WHERE user_id = p_user_id 
    LIMIT 1;
    
    IF p_transaction_type = 'credit' THEN
        SET new_balance = current_balance + p_amount;
    ELSE
        SET new_balance = current_balance - p_amount;
    END IF;
    
    INSERT INTO wallet_transactions (
        user_id, transaction_type, category, amount, 
        balance_before, balance_after, description, 
        reference_id, reference_type, admin_user_id, metadata, 
        status, created_at
    ) VALUES (
        p_user_id, p_transaction_type, p_category, p_amount,
        current_balance, new_balance, p_description,
        p_reference_id, p_reference_type, p_admin_user_id, p_metadata,
        'completed', NOW()
    );
    
    SET transaction_id = LAST_INSERT_ID();
    
    UPDATE wallets 
    SET balance = new_balance 
    WHERE user_id = p_user_id;
    
    RETURN transaction_id;
END";

try {
    $pdo->exec($functionSQL);
    echo "✓ Function created successfully\n";
} catch (Exception $e) {
    echo "✗ Function creation failed: " . $e->getMessage() . "\n";
}

// Test the function
echo "\n=== TESTING FUNCTION ===\n";
try {
    $stmt = $pdo->prepare("SELECT insert_wallet_transaction(10, 'credit', 'admin_credit', 75.00, 'Test direct function', 'TEST_DIRECT', 'admin_action', NULL, JSON_OBJECT('test', 'direct'))");
    $stmt->execute();
    $result = $stmt->fetchColumn();
    echo "✓ Function test successful! Transaction ID: $result\n";
    
    // Verify the transaction was created
    $stmt = $pdo->prepare("SELECT * FROM wallet_transactions WHERE id = ?");
    $stmt->execute([$result]);
    $tx = $stmt->fetch();
    echo "  Created: {$tx['category']} ฿{$tx['amount']} '{$tx['description']}'\n";
    
    // Clean up
    $pdo->prepare("DELETE FROM wallet_transactions WHERE id = ?")->execute([$result]);
    $pdo->prepare("UPDATE wallets SET balance = balance - 75.00 WHERE user_id = 10")->execute();
    echo "  Test transaction cleaned up\n";
} catch (Exception $e) {
    echo "✗ Function test failed: " . $e->getMessage() . "\n";
}

echo "\nFunction is now ready!\n";
?>
