<?php
require_once __DIR__ . '/config/config.php';
header('Content-Type: text/plain');

try {
    $status = trim((string)($_GET['status'] ?? ''));
    $where = [];$params=[];
    if ($status !== '') { $where[] = 'status = :st'; $params[':st'] = $status; }
    $sql = 'SELECT t.*, u.email AS user_email FROM support_tickets t LEFT JOIN users u ON u.id = t.user_id';
    if ($where) { $sql .= ' WHERE ' . implode(' AND ', $where); }
    $sql .= " ORDER BY FIELD(t.status,'open','in_progress','resolved','closed'), COALESCE(t.updated_at, t.created_at) DESC LIMIT 200";
    echo "SQL: $sql\n";
    $st = $pdo->prepare($sql);
    $ok = $st->execute($params);
    echo "execute ok: ".$ok."\n";
    $rows = $st->fetchAll(PDO::FETCH_ASSOC);
    echo "rows: ".count($rows)."\n";
    foreach ($rows as $r) {
        echo json_encode(['id'=>$r['id'],'subject'=>$r['subject'],'status'=>$r['status'],'user_email'=>$r['user_email'],'created_at'=>$r['created_at'],'updated_at'=>$r['updated_at']], JSON_UNESCAPED_SLASHES)."\n";
    }
} catch (Throwable $e) {
    echo "Error: ".$e->getMessage()."\n";
}
