-- phpMyAdmin SQL Dump
-- version 5.2.2
-- https://www.phpmyadmin.net/
--
-- Host: localhost:3306
-- Generation Time: Sep 25, 2025 at 01:50 PM
-- Server version: 8.4.3
-- PHP Version: 8.3.16

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `b2b_travel`
--

-- --------------------------------------------------------

--
-- Table structure for table `taxi_bookings`
--

CREATE TABLE `taxi_bookings` (
  `id` int UNSIGNED NOT NULL,
  `booking_code` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `agent_id` int UNSIGNED NOT NULL,
  `taxi_id` int UNSIGNED NOT NULL,
  `vendor_id` int UNSIGNED DEFAULT NULL,
  `trip_date` date NOT NULL,
  `pickup_time` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `flight_no` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `pickup_photo_path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pickup_type` enum('airport','hotel','apartment','address') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `drop_type` enum('airport','hotel','apartment','address') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pickup_airport_code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `drop_airport_code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pickup_hotel_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pickup_hotel_address` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pickup_apartment_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pickup_apartment_address` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pickup_address` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `drop_hotel_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `drop_hotel_address` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `drop_apartment_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `drop_apartment_address` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `drop_address` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `itinerary_id` int UNSIGNED DEFAULT NULL,
  `itinerary_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `itinerary_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin,
  `pax` int UNSIGNED NOT NULL DEFAULT '1',
  `from_text` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `to_text` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_email` varchar(160) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_phone` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `driver_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `driver_phone` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vehicle_number` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_round_trip` tinyint(1) NOT NULL DEFAULT '0',
  `return_date` date DEFAULT NULL,
  `return_time` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount_total` decimal(12,2) NOT NULL DEFAULT '0.00',
  `vendor_cost` decimal(10,2) DEFAULT NULL,
  `vendor_currency` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT 'THB',
  `vendor_pay_status` enum('pending','cleared') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `vendor_paid_at` datetime DEFAULT NULL,
  `vendor_invoice_no` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vendor_pay_note` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vendor_pay_method` enum('bank_transfer','cash','other') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vendor_pay_txn_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency` char(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'THB',
  `status` enum('pending','confirmed','cancelled','refunded') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `status_detail` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_status` enum('unpaid','paid','refunded','partial','failed') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unpaid',
  `payment_method` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gateway_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_txn_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_at` datetime DEFAULT NULL,
  `vendor_assigned_at` datetime DEFAULT NULL,
  `vendor_accepted_at` datetime DEFAULT NULL,
  `driver_assigned_at` datetime DEFAULT NULL,
  `enroute_at` datetime DEFAULT NULL,
  `picked_up_at` datetime DEFAULT NULL,
  `completed_at` datetime DEFAULT NULL,
  `cancelled_at` datetime DEFAULT NULL,
  `cancel_reason` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cancelled_by` enum('agent','admin','vendor') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `refund_amount` decimal(12,2) DEFAULT NULL,
  `refunded_at` datetime DEFAULT NULL,
  `refund_txn_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `channel` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int UNSIGNED DEFAULT NULL,
  `updated_by` int UNSIGNED DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL
) ;

--
-- Dumping data for table `taxi_bookings`
--

INSERT INTO `taxi_bookings` (`id`, `booking_code`, `agent_id`, `taxi_id`, `vendor_id`, `trip_date`, `pickup_time`, `flight_no`, `notes`, `pickup_photo_path`, `pickup_type`, `drop_type`, `pickup_airport_code`, `drop_airport_code`, `pickup_hotel_name`, `pickup_hotel_address`, `pickup_apartment_name`, `pickup_apartment_address`, `pickup_address`, `drop_hotel_name`, `drop_hotel_address`, `drop_apartment_name`, `drop_apartment_address`, `drop_address`, `itinerary_id`, `itinerary_name`, `itinerary_json`, `pax`, `from_text`, `to_text`, `customer_name`, `customer_email`, `customer_phone`, `driver_name`, `driver_phone`, `vehicle_number`, `is_round_trip`, `return_date`, `return_time`, `amount_total`, `vendor_cost`, `vendor_currency`, `vendor_pay_status`, `vendor_paid_at`, `vendor_invoice_no`, `vendor_pay_note`, `vendor_pay_method`, `vendor_pay_txn_id`, `currency`, `status`, `status_detail`, `payment_status`, `payment_method`, `gateway_name`, `payment_txn_id`, `paid_at`, `vendor_assigned_at`, `vendor_accepted_at`, `driver_assigned_at`, `enroute_at`, `picked_up_at`, `completed_at`, `cancelled_at`, `cancel_reason`, `cancelled_by`, `refund_amount`, `refunded_at`, `refund_txn_id`, `channel`, `ip_address`, `user_agent`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
(1, 'TAX-20250909-1', 10, 5, 7, '2025-09-10', '16:09', 'tg123', '', NULL, 'airport', 'hotel', 'BKK', '', '', '', '', '', '', 'Hotel Fx', 'Pattaya', '', '', '', 2, 'Extra Addon', '[{\"seq\":1,\"label\":\"Stop 1 Pattaya Activity\",\"address\":\"alcazar\",\"wait_minutes\":60,\"extra_price\":1000,\"notes\":\"60 Minute is Highest wait time\"}]', 2, 'BKK', 'Hotel Fx', 'sanjay gandhi', 'ali@ok.com', '9800000', NULL, NULL, NULL, 1, '2025-09-10', NULL, 1600.00, 500.00, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'confirmed', NULL, 'paid', 'wallet', 'wallet', '112', '2025-09-10 02:20:44', '2025-09-10 06:04:42', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 10, 10, '2025-09-10 02:20:44', '2025-09-10 02:20:44'),
(2, 'TAX-20250910-2', 10, 3, 7, '2025-09-20', '08:14', 'TGX1234', '', NULL, 'airport', 'apartment', 'BKK', '', 'Hotel Fx', '', '', '', '', '', '', 'fx hotel', 'pattaya', '', NULL, NULL, NULL, 8, 'BKK', 'fx hotel', 'RAHUL SINGH', 'ok@ok.com', '98656321015', NULL, NULL, NULL, 0, NULL, NULL, 600.00, 400.00, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'refunded', NULL, 'refunded', 'wallet', 'wallet', '113', '2025-09-10 05:11:50', '2025-09-10 08:02:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 10, 10, '2025-09-10 05:11:50', '2025-09-10 05:12:33'),
(3, 'TAX-20250910-3', 10, 5, 7, '2025-09-11', '07:46', 'tg123', '', NULL, 'airport', 'hotel', 'BKK', '', '', '', '', '', '', 'Hotel Fx', 'Pattaya', '', '', '', NULL, NULL, NULL, 2, 'BKK', 'Hotel Fx', 'sanjay', 'ali@ok.com', '9800000', NULL, NULL, NULL, 1, '2025-09-11', NULL, 600.00, 500.00, 'THB', 'cleared', '2025-09-10 00:00:00', NULL, 'K BANK Traanfser', 'bank_transfer', '2232323', 'THB', 'confirmed', NULL, 'paid', 'wallet', 'wallet', '115', '2025-09-10 05:47:20', '2025-09-10 08:56:25', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 10, 10, '2025-09-10 05:47:20', '2025-09-10 05:47:20'),
(4, 'TAX-20250910-4', 10, 5, 7, '2025-09-11', '', '', '', '/assets/vendor/pickups/bk_4_4d117952d557.jpg', 'hotel', 'apartment', '', '', 'Hotel Fx', 'Pattaya', '', '', '', '', '', 'fx hotel', 'pattaya', '', NULL, NULL, NULL, 3, 'Hotel Fx', 'fx hotel', 'rahul', 'ali@ok.com', '9800000', 'Samik', '98658999999', 'XYZ 123 483', 1, '2025-09-11', NULL, 600.00, 500.00, 'THB', 'cleared', '2025-09-11 08:00:00', NULL, NULL, 'cash', NULL, 'THB', 'confirmed', NULL, 'paid', 'wallet', 'wallet', '116', '2025-09-10 05:52:22', '2025-09-10 05:52:22', NULL, '2025-09-10 07:30:10', '2025-09-10 07:30:15', '2025-09-10 07:30:19', '2025-09-10 07:30:21', NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 10, 10, '2025-09-10 05:52:22', '2025-09-10 05:52:22'),
(5, 'TAX-20250910-5', 10, 3, 7, '2025-09-17', '09:57', 'tg123', '', NULL, 'airport', 'apartment', 'BKK', '', '', '', '', '', '', '', '', 'fx hotel', 'pattaya', '', NULL, NULL, NULL, 3, 'BKK', 'fx hotel', 'sanjay', 'ali@ok.com', '9800000', NULL, NULL, NULL, 0, NULL, NULL, 600.00, 400.00, 'THB', 'cleared', '2025-09-11 07:43:00', NULL, NULL, 'bank_transfer', '2232323', 'THB', 'cancelled', NULL, 'refunded', 'wallet', 'wallet', '117', '2025-09-10 06:54:45', '2025-09-10 06:54:45', NULL, NULL, '2025-09-10 08:45:14', '2025-09-10 08:45:23', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 10, 10, '2025-09-10 06:54:45', '2025-09-10 08:57:06'),
(6, 'TAX-20250910-6', 10, 5, 7, '2025-09-10', '', '', '', '/assets/vendor/pickups/bk_6_d3906ad649aa.jpg', 'hotel', 'hotel', '', '', 'Hotel Fx', 'Pattaya', '', '', '', 'Hotel Fx', 'Pattaya', '', '', '', NULL, NULL, NULL, 4, 'Hotel Fx', 'Hotel Fx', 'sanjay sukla', 'ali@ok.com', '9800000', 'xxx', 'xxx', 'xx', 1, '2025-09-10', NULL, 600.00, NULL, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'confirmed', NULL, 'paid', 'wallet', 'wallet', '119', '2025-09-10 10:06:36', '2025-09-10 10:06:36', NULL, '2025-09-10 12:06:43', NULL, '2025-09-10 14:23:16', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 10, 10, '2025-09-10 10:06:36', '2025-09-10 10:06:36'),
(7, 'TAX-20250910-7', 10, 5, 7, '2025-09-10', '16:34', 'TGX1234', '', NULL, 'airport', 'hotel', 'BKK', '', '', '', '', '', '', 'Hotel Fx2', 'Pattaya2', '', '', '', NULL, NULL, NULL, 3, 'BKK', 'Hotel Fx2', 'wwww', 'ali@ok.com', '98656321015', NULL, NULL, NULL, 1, '2025-09-10', NULL, 600.00, NULL, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'confirmed', NULL, 'refunded', 'wallet', 'wallet', '120', '2025-09-10 13:33:06', '2025-09-10 13:33:06', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 10, 10, '2025-09-10 13:33:06', '2025-09-22 22:04:48'),
(8, 'TAX-20250910-8', 10, 5, 7, '2025-09-11', '', '', '', '/assets/vendor/pickups/bk_8_048833faec59.jpg', 'hotel', 'apartment', '', '', 'Hotel Fx', 'Pattaya', '', '', '', '', '', 'fx hotel', 'pattaya', '', NULL, NULL, NULL, 3, 'Hotel Fx', 'fx hotel', 'RAHUL SINGH', 'ok@Ok.com', '98656321015', 'xxxx', 'xxx', 'xxxx', 1, '2025-09-11', NULL, 600.00, NULL, 'THB', 'cleared', '2025-09-10 00:00:00', NULL, NULL, 'cash', '2232323', 'THB', 'confirmed', NULL, 'paid', 'wallet', 'wallet', '121', '2025-09-10 14:28:10', '2025-09-10 14:28:10', NULL, '2025-09-10 14:29:27', '2025-09-10 14:29:30', '2025-09-10 14:29:34', '2025-09-10 14:29:45', NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 10, 10, '2025-09-10 14:28:10', '2025-09-10 14:28:10'),
(9, 'TAX-20250910-9', 10, 5, 7, '2025-09-10', '16:43', 'tg123', '', NULL, 'airport', 'hotel', 'BKK', '', 'Hotel Fx', 'Pattaya', '', '', '', 'Hotel Fx', 'Pattaya', '', '', '', NULL, NULL, NULL, 2, 'BKK', 'Hotel Fx', 'sanjay sukla', 'ali@ok.com', '9800000', NULL, NULL, NULL, 1, '2025-09-10', NULL, 600.00, NULL, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'confirmed', NULL, 'paid', 'wallet', 'wallet', '123', '2025-09-10 14:41:50', '2025-09-10 14:41:50', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 10, 10, '2025-09-10 14:41:50', '2025-09-10 14:41:50'),
(10, 'TAX-20250910-10', 10, 5, 7, '2025-09-12', '03:32', 'tg123', '', NULL, 'airport', 'hotel', 'BKK', '', '', '', '', '', '', 'Hotel Fx', 'Pattaya', '', '', '', NULL, NULL, NULL, 2, 'BKK', 'Hotel Fx', 'RAHUL SINGH', 'sanjay@gandhi.com', '98656321015', NULL, NULL, NULL, 1, '2025-09-12', NULL, 600.00, NULL, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'confirmed', NULL, 'paid', 'wallet', 'wallet', '125', '2025-09-11 01:54:47', '2025-09-11 01:54:47', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 10, 10, '2025-09-11 01:54:47', '2025-09-11 01:54:47'),
(11, 'TAX-20250910-11', 10, 5, 7, '2025-09-12', '05:40', 'tg123', '', NULL, 'airport', 'hotel', 'BKK', '', '', '', '', '', '', 'Hotel Fx', 'qwrqrwqwqwr sfasfsa', '', '', '', NULL, NULL, NULL, 2, 'BKK', 'Hotel Fx', 'RAHUL SINGH', 'ok@Ok.com', '98888888', NULL, NULL, NULL, 1, '2025-09-12', NULL, 600.00, NULL, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'refunded', NULL, 'refunded', 'wallet', 'wallet', '126', '2025-09-11 03:38:04', '2025-09-11 03:38:04', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 10, 10, '2025-09-11 03:38:04', '2025-09-11 19:33:00'),
(12, 'TAX-20250911-12', 10, 5, 7, '2025-09-12', '', '', '', NULL, 'hotel', 'hotel', '', '', 'Hotel Fx', 'Pattaya', '', '', '', 'Hotel Fx', 'Pattaya', '', '', '', NULL, NULL, NULL, 2, 'Hotel Fx', 'Hotel Fx', 'RAHUL SINGH', 'ali@ok.com', '98656321015', NULL, NULL, NULL, 1, '2025-09-12', NULL, 600.00, NULL, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'confirmed', NULL, 'paid', 'wallet', 'wallet', '130', '2025-09-11 20:03:52', '2025-09-11 20:03:52', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 10, 10, '2025-09-11 20:03:52', '2025-09-11 20:03:52'),
(13, 'TAX-20250911-13', 10, 5, 7, '2025-09-17', '20:49', 'TG123', '', NULL, 'airport', 'hotel', 'BKK', '', '', '', '', '', '', 'FX HOTEL', 'aaaa', '', '', '', NULL, NULL, NULL, 2, 'BKK', 'FX HOTEL', 'akal', '', '09865623101', NULL, NULL, NULL, 1, '2025-09-17', NULL, 600.00, NULL, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'cancelled', NULL, 'paid', 'wallet', 'wallet', '5', '2025-09-12 04:45:02', '2025-09-12 04:45:02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 Edg/140.0.0.0', 10, 10, '2025-09-12 04:45:02', '2025-09-20 10:31:12'),
(14, 'TAX-20250911-14', 10, 5, 7, '2025-09-12', '', '', '', NULL, 'hotel', 'hotel', '', '', 'aaaa', 'aaaa', '', '', '', 'FX HOTEL', 'aaaa', '', '', '', NULL, NULL, NULL, 2, 'aaaa', 'FX HOTEL', 'akal', '', '09865623101', NULL, NULL, NULL, 1, '2025-09-12', NULL, 600.00, NULL, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'refunded', NULL, 'refunded', 'wallet', 'wallet', '6', '2025-09-12 04:50:11', '2025-09-12 04:50:11', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 Edg/140.0.0.0', 10, 10, '2025-09-12 04:50:11', '2025-09-12 05:36:07'),
(15, 'TAX-20250912-15', 10, 5, 7, '2025-09-12', '', '', '', NULL, 'hotel', 'hotel', '', '', 'aaaa', 'aaaa', '', '', '', 'FX HOTEL', 'aaaa', '', '', '', NULL, NULL, NULL, 2, 'aaaa', 'FX HOTEL', 'akal', '', '09865623101', NULL, NULL, NULL, 1, '2025-09-12', NULL, 600.00, NULL, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'refunded', NULL, 'refunded', 'wallet', 'wallet', '9', '2025-09-12 05:07:21', '2025-09-12 05:07:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 Edg/140.0.0.0', 10, 10, '2025-09-12 05:07:21', '2025-09-12 05:31:51'),
(16, 'TAX-20250912-16', 10, 5, 7, '2025-09-12', '', '', '', NULL, 'hotel', 'hotel', '', '', 'aaaa', 'aaaa', '', '', '', 'FX HOTEL', 'aaaa', '', '', '', NULL, NULL, NULL, 2, 'Airport', 'Hotel', 'akal', '', '09865623101', NULL, NULL, NULL, 1, '2025-09-12', NULL, 600.00, NULL, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'refunded', NULL, 'refunded', 'wallet', 'wallet', '10', '2025-09-12 05:08:52', '2025-09-12 05:08:52', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 Edg/140.0.0.0', 10, 10, '2025-09-12 05:08:52', '2025-09-12 05:26:11'),
(17, 'TAX-20250912-17', 10, 5, 7, '2025-09-12', '', '', '', NULL, 'hotel', 'hotel', '', '', 'aaaa', 'aaaa', '', '', '', 'FX HOTEL', 'aaaa', '', '', '', NULL, NULL, NULL, 2, 'aaaa', 'FX HOTEL', 'akal', '', '09865623101', NULL, NULL, NULL, 1, '2025-09-12', NULL, 600.00, NULL, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'confirmed', NULL, 'refunded', 'wallet', 'wallet', '11', '2025-09-12 05:14:01', '2025-09-12 05:14:01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 Edg/140.0.0.0', 10, 10, '2025-09-12 05:14:01', '2025-09-22 21:50:17'),
(18, 'TAX-20250922-18', 10, 5, 7, '2025-09-23', '00:34', '', 'Hello', NULL, 'hotel', 'airport', '', 'BKK', 'Hotel fx', '', '', '', '', '', '', '', '', '', NULL, NULL, NULL, 1, 'Hotel fx', 'BKK', 'SURAJ KUMAR', 'ancientjbr@gmail.com', '98888888', NULL, NULL, NULL, 1, '2025-09-23', NULL, 600.00, 600.00, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'confirmed', NULL, 'paid', 'wallet', 'wallet', '', '2025-09-22 10:42:25', '2025-09-22 10:42:25', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 Edg/140.0.0.0', 10, 10, '2025-09-22 10:42:25', '2025-09-22 10:42:25'),
(19, 'TAX-20250922-19', 10, 5, 7, '2025-09-23', '01:48', '', '', NULL, 'airport', 'airport', 'BKK', 'ddd', '', '', '', '', '', '', '', '', '', '', NULL, NULL, NULL, 1, 'BKK', 'ddd', 'Suresh Kumar', 'ancientjbr@gmail.com', '66968826252', NULL, NULL, NULL, 1, '2025-09-23', NULL, 600.00, 600.00, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'cancelled', NULL, 'paid', 'wallet', 'wallet', '', '2025-09-22 10:47:04', '2025-09-22 10:47:04', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 Edg/140.0.0.0', 10, 10, '2025-09-22 10:47:04', '2025-09-22 10:51:24'),
(20, 'TAX-20250922-20', 10, 5, 7, '2025-09-24', '02:03', '', '', NULL, 'airport', 'hotel', 'BKK Aiport', '', '', '', '', '', '', 'Hotel FX Pattaya', '', '', '', '', NULL, NULL, NULL, 4, 'BKK Aiport', 'Hotel FX Pattaya', 'vishwah kumar', 'ancientjbr@gmail.com', '98656231211', NULL, NULL, NULL, 1, '2025-09-24', NULL, 600.00, 600.00, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'confirmed', NULL, 'paid', 'wallet', 'wallet', '', '2025-09-22 11:01:38', '2025-09-22 11:01:38', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 Edg/140.0.0.0', 10, 10, '2025-09-22 11:01:38', '2025-09-22 11:01:38'),
(21, 'TAX-20250922-21', 10, 3, 7, '2025-09-23', '17:12', '', '', NULL, 'airport', 'hotel', 'Bkk Aiport', '', '', '', '', '', '', 'Hotel Fx South Pattaya Pratumnak', '', '', '', '', NULL, NULL, NULL, 1, 'Bkk Aiport', 'Hotel Fx South Pattaya Pratumnak', 'Vinod', 'ancientjbr@gmail.com', '98656895210', NULL, NULL, NULL, 0, NULL, NULL, 600.00, 600.00, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'confirmed', NULL, 'paid', 'wallet', 'wallet', '', '2025-09-22 13:10:38', '2025-09-22 13:10:38', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 Edg/140.0.0.0', 10, 10, '2025-09-22 13:10:38', '2025-09-22 13:10:38'),
(22, 'TAX-20250922-22', 10, 5, 7, '2025-09-23', '17:56', '', '', NULL, 'airport', 'hotel', 'bkk', '', '', '', '', '', '', 'ok hotel', '', '', '', '', NULL, NULL, NULL, 1, 'bkk', 'ok hotel', 'montu', 'ok@gmail.com', '787878787878', NULL, NULL, NULL, 1, '2025-09-23', NULL, 600.00, 600.00, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'confirmed', NULL, 'paid', 'wallet', 'wallet', '', '2025-09-22 14:02:14', '2025-09-22 14:02:14', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 10, 10, '2025-09-22 14:02:14', '2025-09-22 14:02:14'),
(23, 'TAX-20250922-23', 10, 3, 7, '2025-09-24', '22:20', '', '', NULL, 'airport', 'hotel', 'bkk', '', '', '', '', '', '', 'fx hotel', '', '', '', '', NULL, NULL, NULL, 8, 'bkk', 'fx hotel', 'SURESH KUMAR', 'OK@OK.COM', '89878788878', NULL, NULL, NULL, 0, NULL, NULL, 600.00, 600.00, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'confirmed', NULL, 'paid', 'wallet', 'wallet', '', '2025-09-22 19:18:24', '2025-09-22 19:18:24', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 Edg/140.0.0.0', 10, 10, '2025-09-22 19:18:24', '2025-09-22 19:18:24'),
(24, 'TAX-20250922-24', 10, 5, 7, '2025-09-23', '16:30', '', '1 Activity Alcazar Show', NULL, 'hotel', 'hotel', '', '', 'Marine Plaza Pattaya', '', '', '', '', 'Marine Plaza Pattaya', '', '', '', '', NULL, NULL, NULL, 4, 'Marine Plaza Pattaya', 'Marine Plaza Pattaya', 'Vivek Kumar', 'viverkkumar@gmail.com', '9869568910', NULL, NULL, NULL, 1, '2025-09-23', NULL, 600.00, 600.00, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'confirmed', NULL, 'paid', 'wallet', 'wallet', '', '2025-09-22 21:38:43', '2025-09-22 21:38:43', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 Edg/140.0.0.0', 10, 10, '2025-09-22 21:38:43', '2025-09-22 21:38:43'),
(25, 'TAX-20250922-25', 10, 5, 7, '2025-09-25', '12:55', '', '', NULL, 'airport', 'hotel', 'bkk', 'Bkk Aiport', '', '', '', '', '', 'fx hotel', '', '', '', '', NULL, NULL, NULL, 1, 'bkk', 'fx hotel', 'SURESH KUMAR', 'OK@OK.COM', '89878788878', NULL, NULL, NULL, 1, '2025-09-25', NULL, 600.00, 600.00, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'confirmed', NULL, 'paid', 'wallet', 'wallet', '', '2025-09-22 21:51:34', '2025-09-22 21:51:34', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 Edg/140.0.0.0', 10, 10, '2025-09-22 21:51:34', '2025-09-22 21:51:34'),
(26, 'TAX-20250922-26', 10, 3, 7, '2025-09-24', '14:02', '', '', NULL, 'airport', 'airport', 'bkk', 'Bkk Aiport', '', '', '', '', '', '', '', '', '', '', NULL, NULL, NULL, 1, 'bkk', 'Bkk Aiport', 'SURESH KUMAR', 'OK@OK.COM', '89878788878', NULL, NULL, NULL, 0, NULL, NULL, 600.00, 600.00, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'confirmed', NULL, 'paid', 'wallet', 'wallet', '', '2025-09-22 22:03:16', '2025-09-22 22:03:16', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 Edg/140.0.0.0', 10, 10, '2025-09-22 22:03:16', '2025-09-22 22:03:16'),
(27, 'TAX-20250923-27', 10, 6, 11, '2025-09-27', '04:21', '', '', NULL, 'airport', 'hotel', 'bkk', 'Bkk Aiport', '', '', '', '', '', 'Hotel Fx Pratumnak Pattaya', '', '', '', '', NULL, NULL, NULL, 4, 'bkk', 'Hotel Fx Pratumnak Pattaya', 'SURESH KUMAR', 'OK@OK.COM', '89878788878', NULL, NULL, NULL, 0, NULL, NULL, 1200.00, 1200.00, 'THB', 'pending', NULL, NULL, NULL, NULL, NULL, 'THB', 'confirmed', NULL, 'paid', 'wallet', 'wallet', '', '2025-09-24 00:18:39', '2025-09-24 00:18:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'portal', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 Edg/140.0.0.0', 10, 10, '2025-09-24 00:18:39', '2025-09-24 00:18:39');

--
-- Triggers `taxi_bookings`
--
DELIMITER $$
CREATE TRIGGER `taxi_refund_wallet_transaction` AFTER UPDATE ON `taxi_bookings` FOR EACH ROW BEGIN
    DECLARE refund_amount DECIMAL(12,2) DEFAULT 0.00;
    DECLARE transaction_id INT DEFAULT 0;
    
    -- Check if this is a refund update
    IF (NEW.status = 'refunded' OR NEW.payment_status = 'refunded' OR NEW.refund_amount IS NOT NULL) 
       AND (OLD.status != 'refunded' AND OLD.payment_status != 'refunded' AND OLD.refund_amount IS NULL) THEN
        
        -- Determine refund amount
        SET refund_amount = COALESCE(NEW.refund_amount, NEW.amount_total);
        
        -- Only process if refund amount > 0 and payment was via wallet
        IF refund_amount > 0 AND NEW.payment_method = 'wallet' THEN
            -- Insert wallet transaction for refund
            SET transaction_id = insert_wallet_transaction(
                NEW.agent_id,
                'credit',
                'refund',
                refund_amount,
                CONCAT('Taxi Booking Refund - ', COALESCE(NEW.booking_code, NEW.id)),
                NEW.id,
                'taxi_booking',
                NULL,
                JSON_OBJECT(
                    'original_amount', NEW.amount_total,
                    'refund_amount', refund_amount,
                    'booking_code', NEW.booking_code,
                    'refund_reason', 'Taxi booking cancelled'
                )
            );
        END IF;
    END IF;
END
$$
DELIMITER ;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `taxi_bookings`
--
ALTER TABLE `taxi_bookings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_taxi_booking_code` (`booking_code`),
  ADD KEY `idx_tb_agent` (`agent_id`),
  ADD KEY `idx_tb_taxi` (`taxi_id`),
  ADD KEY `idx_tb_status` (`status`),
  ADD KEY `idx_tb_paid` (`payment_status`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `taxi_bookings`
--
ALTER TABLE `taxi_bookings`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
