USE b2b_travel;

-- Demo Users (hashes to replace after import)
INSERT INTO users (name,email,password,role,status) VALUES
('Admin','admin@example.com','$2y$10$REPLACE_ADMIN_HASH','Admin','Active'),
('Employee','employee@example.com','$2y$10$REPLACE_EMP_HASH','Employee','Active'),
('Channel Partner','partner@example.com','$2y$10$REPLACE_PART_HASH','Channel Partner','Active'),
('B2B Agent','agent@example.com','$2y$10$REPLACE_AGENT_HASH','B2B Agent','Active'),
('Vendor Admin','vendor@example.com','$2y$10$REPLACE_VENDOR_HASH','Vendor','Active');

-- Vendors
INSERT INTO vendors (name, contact_email) VALUES ('Sample Vendor','vendor@example.com');

-- Hotels and rooms placeholder
INSERT INTO hotels (vendor_id,name,city,country,base_price) VALUES (1,'Sample Hotel','Bangkok','Thailand',80.00);

-- Activities with tiers placeholder
INSERT INTO activities (vendor_id,name,city,base_price) VALUES (1,'Alcazar Show','Pattaya',30.00);

-- Taxi
INSERT INTO taxis (vendor_id,name,route,base_price) VALUES (1,'Airport Transfer','BKK -> City',25.00);

-- eVisa
INSERT INTO evisas (vendor_id,country,base_price) VALUES (1,'Thailand',50.00);

-- Wallets for agent and partner
INSERT INTO wallets (user_id,balance) VALUES
((SELECT id FROM users WHERE email='agent@example.com'), 1000.00),
((SELECT id FROM users WHERE email='partner@example.com'), 0.00);

-- API Token for agent (replace with secure token)
INSERT INTO api_tokens (user_id, token)
SELECT id, 'CHANGE_ME_TOKEN_64' FROM users WHERE email='agent@example.com';
