-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Aug 29, 2025 at 08:19 AM
-- Server version: 10.4.32-MariaDB
-- PHP Version: 8.0.30

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `b2b_travel`
--

-- --------------------------------------------------------

--
-- Table structure for table `activities`
--

CREATE TABLE `activities` (
  `id` int(11) NOT NULL,
  `vendor_id` int(11) NOT NULL,
  `name` varchar(200) NOT NULL,
  `city` varchar(100) NOT NULL,
  `base_price` decimal(10,2) NOT NULL DEFAULT 0.00
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `activity_prices`
--

CREATE TABLE `activity_prices` (
  `id` int(11) NOT NULL,
  `activity_id` int(11) NOT NULL,
  `tier_id` int(11) DEFAULT NULL,
  `showtime_id` int(11) DEFAULT NULL,
  `pax_type` enum('adult','child','infant') NOT NULL DEFAULT 'adult',
  `is_group` tinyint(1) NOT NULL DEFAULT 0,
  `pax_threshold` int(11) DEFAULT NULL,
  `price` decimal(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `activity_showtimes`
--

CREATE TABLE `activity_showtimes` (
  `id` int(11) NOT NULL,
  `activity_id` int(11) NOT NULL,
  `show_time` time NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `activity_tiers`
--

CREATE TABLE `activity_tiers` (
  `id` int(11) NOT NULL,
  `activity_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `agent_business_docs`
--

CREATE TABLE `agent_business_docs` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `doc_type` enum('selfie','registration_certificate','partnership_deed','incorporation_certificate','gst_certificate','address_proof') NOT NULL,
  `file_path` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `agent_business_docs`
--

INSERT INTO `agent_business_docs` (`id`, `user_id`, `doc_type`, `file_path`, `created_at`) VALUES
(1, 6, 'selfie', 'assets/uploads/business_docs/agent_6_selfie_1755325864.jpg', '2025-08-16 06:31:04'),
(2, 6, 'address_proof', 'assets/uploads/business_docs/agent_6_address_proof_1755325864.jpg', '2025-08-16 06:31:04'),
(3, 10, 'selfie', 'storage/business_docs/agent_10_selfie_1755330820_aaccb79e490db21a.enc', '2025-08-16 07:53:40'),
(4, 10, 'address_proof', 'storage/business_docs/agent_10_address_proof_1755330820_0129bcc43f8e23d1.enc', '2025-08-16 07:53:40');

-- --------------------------------------------------------

--
-- Table structure for table `agent_kyc`
--

CREATE TABLE `agent_kyc` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `id_type` enum('passport','national_id','driving_license','other') NOT NULL,
  `id_number` varchar(64) NOT NULL,
  `doc_front_path` varchar(255) NOT NULL,
  `doc_back_path` varchar(255) DEFAULT NULL,
  `status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `remarks` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `verified_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `agent_kyc`
--

INSERT INTO `agent_kyc` (`id`, `user_id`, `id_type`, `id_number`, `doc_front_path`, `doc_back_path`, `status`, `remarks`, `created_at`, `verified_at`) VALUES
(1, 6, 'national_id', '12345678', 'assets/uploads/kyc/agent_6_front_1755325864.jpg', 'assets/uploads/kyc/agent_6_back_1755325864.jpg', 'rejected', 'Document Incomplete', '2025-08-16 06:31:04', '2025-08-16 07:22:08'),
(2, 10, 'national_id', '12345678', 'storage/kyc/agent_10_front_1755330820_f822627b443de1c2.enc', 'storage/kyc/agent_10_back_1755330820_1889df33a2674047.enc', 'pending', NULL, '2025-08-16 07:53:40', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `agent_profiles`
--

CREATE TABLE `agent_profiles` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `company` varchar(150) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `commission_percent` decimal(5,2) NOT NULL DEFAULT 0.00,
  `credit_limit` decimal(12,2) NOT NULL DEFAULT 0.00,
  `business_type` enum('freelancer','sole_proprietor','partnership','company') NOT NULL DEFAULT 'freelancer',
  `agency_name` varchar(150) DEFAULT NULL,
  `profile_photo_path` varchar(255) DEFAULT NULL,
  `title` varchar(20) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `pincode` varchar(20) DEFAULT NULL,
  `address_line` varchar(255) DEFAULT NULL,
  `gst_number` varchar(30) DEFAULT NULL,
  `gst_company` varchar(150) DEFAULT NULL,
  `iata_registered` tinyint(1) NOT NULL DEFAULT 0,
  `iata_code` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `agent_profiles`
--

INSERT INTO `agent_profiles` (`id`, `user_id`, `company`, `phone`, `commission_percent`, `credit_limit`, `business_type`, `agency_name`, `profile_photo_path`, `title`, `country`, `state`, `city`, `pincode`, `address_line`, `gst_number`, `gst_company`, `iata_registered`, `iata_code`, `created_at`, `updated_at`) VALUES
(1, 6, 'B2BTHAIHUB', '+66 968826252', 0.00, 0.00, 'freelancer', NULL, 'assets/uploads/agents/agent_6_1755325864.jpg', 'Mr', 'Thailand', 'Bangkok', 'Bangkok', '12505', 'Pattaya', NULL, NULL, 0, NULL, '2025-08-16 06:31:04', NULL),
(5, 10, 'K Digital Solutions', '9863562310', 0.00, 0.00, 'freelancer', NULL, 'assets/uploads/agents/agent_10_1755330820.jpg', 'Mr', 'Thailand', 'Chonburi', 'Pattaya', '12505', 'Pattaya', NULL, NULL, 0, NULL, '2025-08-16 07:53:40', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `agent_settings`
--

CREATE TABLE `agent_settings` (
  `user_id` int(11) NOT NULL,
  `allow_wallet_transfer` tinyint(1) NOT NULL DEFAULT 1,
  `require_tx_password` tinyint(1) NOT NULL DEFAULT 1,
  `wallet_transfer_daily_limit` decimal(12,2) DEFAULT NULL,
  `api_enabled` tinyint(1) NOT NULL DEFAULT 0,
  `allow_extra_margin` tinyint(1) NOT NULL DEFAULT 0,
  `max_margin_percent` decimal(5,2) DEFAULT NULL,
  `max_flat_markup` decimal(10,2) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  `wallet_pay_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `gateway_booking_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `api_key` varchar(64) DEFAULT NULL,
  `api_secret_hash` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `agent_settings`
--

INSERT INTO `agent_settings` (`user_id`, `allow_wallet_transfer`, `require_tx_password`, `wallet_transfer_daily_limit`, `api_enabled`, `allow_extra_margin`, `max_margin_percent`, `max_flat_markup`, `created_at`, `updated_at`, `wallet_pay_enabled`, `gateway_booking_enabled`, `api_key`, `api_secret_hash`) VALUES
(10, 0, 1, 10000.00, 1, 1, NULL, NULL, '2025-08-17 02:06:24', '2025-08-17 23:22:42', 1, 1, 'ag_3b14c18438036651d0648dd998b81016', '$2y$10$uyn2AAuY1KO0R1N7o7rNrOV/5Fl4o5/xAyc8otkbKPMLaciyMU0sO');

-- --------------------------------------------------------

--
-- Table structure for table `api_tokens`
--

CREATE TABLE `api_tokens` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `token` varchar(64) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `attachments`
--

CREATE TABLE `attachments` (
  `id` int(11) NOT NULL,
  `ticket_id` int(11) DEFAULT NULL,
  `message_id` int(11) DEFAULT NULL,
  `file_path` varchar(255) NOT NULL,
  `mime` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `audit_logs`
--

CREATE TABLE `audit_logs` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  `action` varchar(150) NOT NULL,
  `details` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `blackout_windows`
--

CREATE TABLE `blackout_windows` (
  `id` int(11) NOT NULL,
  `module` enum('hotel','activity','taxi','evisa') NOT NULL,
  `item_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `bookings`
--

CREATE TABLE `bookings` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `order_id` int(11) DEFAULT NULL,
  `module` enum('hotel','activity','taxi','evisa') NOT NULL,
  `item_id` int(11) NOT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `price_id` int(11) DEFAULT NULL,
  `pax` int(11) NOT NULL DEFAULT 1,
  `price` decimal(12,2) NOT NULL,
  `pax_type` enum('adult','child','infant','flat','') DEFAULT NULL,
  `show_time` varchar(16) DEFAULT NULL,
  `details_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`details_json`)),
  `status` enum('pending','confirmed','completed','cancelled') NOT NULL DEFAULT 'pending',
  `payment_status` enum('unpaid','paid','refunded') NOT NULL DEFAULT 'unpaid',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `vendor_cost` decimal(12,2) DEFAULT NULL,
  `agent_price` decimal(12,2) DEFAULT NULL,
  `promo_applied` tinyint(1) NOT NULL DEFAULT 0,
  `group_applied` tinyint(1) NOT NULL DEFAULT 0,
  `profit_system` decimal(12,2) DEFAULT NULL,
  `partner_commission` decimal(12,2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `bookings`
--

INSERT INTO `bookings` (`id`, `user_id`, `order_id`, `module`, `item_id`, `variant_id`, `price_id`, `pax`, `price`, `pax_type`, `show_time`, `details_json`, `status`, `payment_status`, `created_at`, `vendor_cost`, `agent_price`, `promo_applied`, `group_applied`, `profit_system`, `partner_commission`) VALUES
(1, 10, NULL, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:27:43', NULL, 150.00, 0, 0, NULL, NULL),
(2, 10, NULL, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:27:45', NULL, 150.00, 0, 0, NULL, NULL),
(3, 10, NULL, 'activity', 2, NULL, NULL, 2, 300.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:27:50', NULL, 150.00, 0, 0, NULL, NULL),
(4, 10, NULL, 'activity', 2, NULL, NULL, 2, 300.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:27:51', NULL, 150.00, 0, 0, NULL, NULL),
(5, 10, NULL, 'activity', 2, NULL, NULL, 2, 300.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:27:55', NULL, 150.00, 0, 0, NULL, NULL),
(6, 10, NULL, 'activity', 2, NULL, NULL, 2, 300.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:27:55', NULL, 150.00, 0, 0, NULL, NULL),
(7, 10, NULL, 'activity', 2, NULL, NULL, 1, 100.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:35:51', NULL, 100.00, 0, 0, NULL, NULL),
(8, 10, NULL, 'activity', 2, NULL, NULL, 10, 1400.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:36:15', NULL, 1400.00, 0, 0, NULL, NULL),
(9, 10, NULL, 'activity', 2, NULL, NULL, 10, 1400.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:36:16', NULL, 1400.00, 0, 0, NULL, NULL),
(10, 10, NULL, 'activity', 2, NULL, NULL, 10, 1400.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:36:16', NULL, 1400.00, 0, 0, NULL, NULL),
(11, 10, NULL, 'activity', 2, NULL, NULL, 10, 1000.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:36:30', NULL, 100.00, 0, 0, NULL, NULL),
(12, 10, NULL, 'activity', 2, NULL, NULL, 1, 100.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:40:27', NULL, 100.00, 0, 0, NULL, NULL),
(13, 10, NULL, 'activity', 2, NULL, NULL, 1, 100.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:40:51', NULL, 100.00, 0, 0, NULL, NULL),
(14, 10, NULL, 'activity', 2, NULL, NULL, 2, 300.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:46:18', NULL, 150.00, 0, 0, NULL, NULL),
(15, 10, NULL, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:46:30', NULL, 150.00, 0, 0, NULL, NULL),
(16, 10, NULL, 'activity', 2, NULL, NULL, 2, 300.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:46:30', NULL, 150.00, 0, 0, NULL, NULL),
(17, 10, NULL, 'activity', 2, NULL, NULL, 1, 1800.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:46:30', NULL, 1800.00, 0, 0, NULL, NULL),
(18, 10, NULL, 'activity', 2, NULL, NULL, 2, 300.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:46:46', NULL, 150.00, 0, 0, NULL, NULL),
(19, 10, NULL, 'activity', 2, NULL, NULL, 2, 300.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:46:47', NULL, 150.00, 0, 0, NULL, NULL),
(20, 10, NULL, 'activity', 2, NULL, NULL, 2, 300.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:46:47', NULL, 150.00, 0, 0, NULL, NULL),
(21, 10, NULL, 'activity', 2, NULL, NULL, 2, 300.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:46:48', NULL, 150.00, 0, 0, NULL, NULL),
(22, 10, 50, 'activity', 2, NULL, NULL, 1, 1800.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:48:24', NULL, 1800.00, 0, 0, NULL, NULL),
(23, 10, NULL, 'activity', 2, NULL, NULL, 1, 1800.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:48:25', NULL, 1800.00, 0, 0, NULL, NULL),
(24, 10, NULL, 'activity', 2, NULL, NULL, 1, 1800.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:48:25', NULL, 1800.00, 0, 0, NULL, NULL),
(25, 10, NULL, 'activity', 2, NULL, NULL, 1, 1800.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:48:25', NULL, 1800.00, 0, 0, NULL, NULL),
(26, 10, NULL, 'activity', 2, NULL, NULL, 10, 1000.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:49:49', NULL, 100.00, 0, 0, NULL, NULL),
(27, 10, NULL, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:55:17', NULL, 150.00, 0, 0, NULL, NULL),
(28, 10, NULL, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:55:17', NULL, 150.00, 0, 0, NULL, NULL),
(29, 10, NULL, 'activity', 2, NULL, NULL, 1, 1800.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 11:55:32', NULL, 1800.00, 0, 0, NULL, NULL),
(30, 10, NULL, 'activity', 2, NULL, NULL, 2, 200.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 12:02:40', NULL, 100.00, 0, 0, NULL, NULL),
(31, 10, NULL, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 12:03:23', NULL, 150.00, 0, 0, NULL, NULL),
(32, 10, NULL, 'activity', 2, NULL, NULL, 1, 1800.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 12:33:17', NULL, 1800.00, 0, 0, NULL, NULL),
(33, 10, NULL, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 12:33:17', NULL, 150.00, 0, 0, NULL, NULL),
(34, 10, NULL, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 12:33:17', NULL, 150.00, 0, 0, NULL, NULL),
(35, 10, NULL, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 12:34:57', NULL, 150.00, 0, 0, NULL, NULL),
(36, 10, NULL, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 12:34:57', NULL, 150.00, 0, 0, NULL, NULL),
(37, 10, NULL, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'unpaid', '2025-08-19 12:35:06', NULL, 150.00, 0, 0, NULL, NULL),
(38, 10, 8, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-19 13:22:38', NULL, 150.00, 0, 0, NULL, NULL),
(39, 10, 9, 'activity', 2, NULL, NULL, 2, 300.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-19 13:24:40', NULL, 150.00, 0, 0, NULL, NULL),
(40, 10, 22, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-19 14:34:34', NULL, 150.00, 0, 0, NULL, NULL),
(41, 10, 22, 'activity', 2, NULL, NULL, 2, 300.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-19 14:34:34', NULL, 150.00, 0, 0, NULL, NULL),
(42, 10, 23, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-19 14:43:22', NULL, 150.00, 0, 0, NULL, NULL),
(43, 10, 24, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-19 15:03:59', NULL, 150.00, 0, 0, NULL, NULL),
(44, 10, 26, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-19 15:25:22', NULL, 150.00, 0, 0, NULL, NULL),
(45, 10, 26, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-19 15:25:22', NULL, 150.00, 0, 0, NULL, NULL),
(46, 10, 27, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-19 15:42:44', NULL, 150.00, 0, 0, NULL, NULL),
(47, 10, 28, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-19 15:50:41', NULL, 150.00, 0, 0, NULL, NULL),
(48, 10, 29, 'activity', 2, NULL, NULL, 1, 100.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-19 22:43:52', NULL, 100.00, 0, 0, NULL, NULL),
(49, 10, 29, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-19 22:43:52', NULL, 150.00, 0, 0, NULL, NULL),
(50, 10, 32, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-19 23:31:48', NULL, 150.00, 0, 0, NULL, NULL),
(51, 10, 33, 'activity', 2, NULL, NULL, 2, 300.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-20 00:04:19', NULL, 150.00, 0, 0, NULL, NULL),
(52, 10, 34, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-20 00:06:36', NULL, 150.00, 0, 0, NULL, NULL),
(53, 10, 35, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-20 00:25:45', NULL, 150.00, 0, 0, NULL, NULL),
(54, 10, 36, 'activity', 2, NULL, NULL, 1, 150.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-20 00:43:31', NULL, 150.00, 0, 0, NULL, NULL),
(55, 10, 37, 'activity', 2, NULL, NULL, 2, 300.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-20 00:54:52', NULL, 150.00, 0, 0, NULL, NULL),
(56, 10, 50, 'activity', 2, NULL, NULL, 1, 1800.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-20 02:21:02', NULL, 1800.00, 0, 0, NULL, NULL),
(57, 10, 57, 'activity', 2, NULL, NULL, 2, 300.00, NULL, NULL, NULL, 'pending', 'paid', '2025-08-26 13:15:04', NULL, 150.00, 0, 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `calendars`
--

CREATE TABLE `calendars` (
  `id` int(11) NOT NULL,
  `module` enum('hotel','activity','taxi','evisa') NOT NULL,
  `item_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `blackout` tinyint(1) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `calendar_overrides`
--

CREATE TABLE `calendar_overrides` (
  `id` int(11) NOT NULL,
  `module` enum('hotel','activity','taxi','evisa') NOT NULL,
  `item_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `price` decimal(10,2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `channel_partners`
--

CREATE TABLE `channel_partners` (
  `id` int(11) NOT NULL,
  `name` varchar(150) NOT NULL,
  `contact_email` varchar(150) DEFAULT NULL,
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `contact_person` varchar(150) DEFAULT NULL,
  `contact_mobile` varchar(50) DEFAULT NULL,
  `contact_whatsapp` varchar(50) DEFAULT NULL,
  `contact_line` varchar(100) DEFAULT NULL,
  `address_line` varchar(255) DEFAULT NULL,
  `city` varchar(120) DEFAULT NULL,
  `state` varchar(120) DEFAULT NULL,
  `pincode` varchar(30) DEFAULT NULL,
  `country` varchar(120) DEFAULT NULL,
  `transaction_password_hash` varchar(255) DEFAULT NULL,
  `tx_pin_enc` varbinary(255) DEFAULT NULL,
  `tx_pin_iv` varbinary(16) DEFAULT NULL,
  `tx_pin_tag` varbinary(16) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `channel_partners`
--

INSERT INTO `channel_partners` (`id`, `name`, `contact_email`, `status`, `created_at`, `contact_person`, `contact_mobile`, `contact_whatsapp`, `contact_line`, `address_line`, `city`, `state`, `pincode`, `country`, `transaction_password_hash`, `tx_pin_enc`, `tx_pin_iv`, `tx_pin_tag`) VALUES
(1, 'K DIGITAL SOLUTIONS', 'k@gmail.com', 'Active', '2025-08-16 08:29:57', 'jitendra', '+6888888', '88888888', NULL, 'Pattaya', 'Pattaya', 'PATTAYA', '200522', 'THAILAND', '$2y$10$tsyu4zOrpUE77aGS9Sl1kOA6PmJHioDbHgO8l/1HSdPomHBWLEoRW', 0xca94a9df6901, 0x5155ba5eec0a4a8434f66578, 0xee57cb0daab00b74bfe5e152c71e0601);

-- --------------------------------------------------------

--
-- Table structure for table `channel_partner_agents`
--

CREATE TABLE `channel_partner_agents` (
  `id` int(11) NOT NULL,
  `partner_id` int(11) NOT NULL,
  `agent_user_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `channel_partner_commissions`
--

CREATE TABLE `channel_partner_commissions` (
  `id` int(11) NOT NULL,
  `partner_id` int(11) NOT NULL,
  `booking_id` int(11) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `status` enum('pending','approved','paid') NOT NULL DEFAULT 'pending',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `channel_partner_settings`
--

CREATE TABLE `channel_partner_settings` (
  `partner_id` int(11) NOT NULL,
  `default_margin_percent` decimal(5,2) DEFAULT NULL,
  `fallback_share_percent` decimal(5,2) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `allow_wallet_transfer` tinyint(1) NOT NULL DEFAULT 1,
  `require_tx_password` tinyint(1) NOT NULL DEFAULT 1,
  `wallet_transfer_daily_limit` decimal(12,2) DEFAULT NULL,
  `allow_agent_creation` tinyint(1) NOT NULL DEFAULT 1,
  `agent_creation_limit` int(11) DEFAULT NULL,
  `allow_agent_password_change` tinyint(1) NOT NULL DEFAULT 0,
  `api_enabled` tinyint(1) NOT NULL DEFAULT 0,
  `allow_extra_margin` tinyint(1) NOT NULL DEFAULT 0,
  `max_margin_percent` decimal(5,2) DEFAULT NULL,
  `max_flat_markup` decimal(10,2) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `channel_partner_settings`
--

INSERT INTO `channel_partner_settings` (`partner_id`, `default_margin_percent`, `fallback_share_percent`, `notes`, `allow_wallet_transfer`, `require_tx_password`, `wallet_transfer_daily_limit`, `allow_agent_creation`, `agent_creation_limit`, `allow_agent_password_change`, `api_enabled`, `allow_extra_margin`, `max_margin_percent`, `max_flat_markup`, `created_at`, `updated_at`) VALUES
(1, 20.00, 20.00, NULL, 1, 1, NULL, 1, NULL, 0, 0, 0, NULL, NULL, '2025-08-16 23:08:06', '2025-08-17 00:38:12');

-- --------------------------------------------------------

--
-- Table structure for table `channel_partner_wallet`
--

CREATE TABLE `channel_partner_wallet` (
  `id` int(11) NOT NULL,
  `partner_id` int(11) NOT NULL,
  `balance` decimal(12,2) NOT NULL DEFAULT 0.00
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `channel_partner_wallet`
--

INSERT INTO `channel_partner_wallet` (`id`, `partner_id`, `balance`) VALUES
(1, 1, 500.00);

-- --------------------------------------------------------

--
-- Table structure for table `channel_partner_wallet_ledger`
--

CREATE TABLE `channel_partner_wallet_ledger` (
  `id` int(11) NOT NULL,
  `wallet_id` int(11) NOT NULL,
  `type` enum('credit','debit') NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `method` enum('manual','transfer') NOT NULL,
  `status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`meta`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `channel_partner_wallet_ledger`
--

INSERT INTO `channel_partner_wallet_ledger` (`id`, `wallet_id`, `type`, `amount`, `method`, `status`, `meta`, `created_at`) VALUES
(1, 1, 'credit', 500.00, 'transfer', 'approved', '{\"flow\":\"admin_to_partner\",\"ip\":\"::1\",\"at\":\"2025-08-16T11:31:47+02:00\"}', '2025-08-16 09:31:47'),
(2, 1, 'debit', 500.00, 'transfer', 'approved', '{\"flow\":\"reverse_admin_to_partner\",\"reason\":\"ok\",\"reversed_at\":\"2025-08-16 12:11:06\",\"original_user_id\":3,\"partner_id\":1,\"reversal_of_flow\":\"admin_to_partner\",\"from_admin_id\":3,\"from_admin_email\":\"admin3@example.com\",\"ip\":\"::1\",\"at\":\"2025-08-16T12:11:06+02:00\"}', '2025-08-16 10:11:06'),
(3, 1, 'credit', 500.00, 'transfer', 'approved', '{\"flow\":\"admin_to_partner\",\"from_admin_id\":3,\"from_admin_email\":\"admin3@example.com\",\"partner_id\":1,\"ip\":\"::1\",\"at\":\"2025-08-17T03:00:36+02:00\"}', '2025-08-17 01:00:36');

-- --------------------------------------------------------

--
-- Table structure for table `corporate_accounts`
--

CREATE TABLE `corporate_accounts` (
  `id` int(11) NOT NULL,
  `name` varchar(150) NOT NULL,
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `corporate_mappings`
--

CREATE TABLE `corporate_mappings` (
  `id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `corporate_rates`
--

CREATE TABLE `corporate_rates` (
  `id` int(11) NOT NULL,
  `company_name` varchar(150) NOT NULL,
  `discount_percent` decimal(5,2) NOT NULL DEFAULT 0.00
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `corporate_rates`
--

INSERT INTO `corporate_rates` (`id`, `company_name`, `discount_percent`) VALUES
(1, 'Hello x', 26.00);

-- --------------------------------------------------------

--
-- Table structure for table `country_currencies`
--

CREATE TABLE `country_currencies` (
  `country` varchar(100) NOT NULL,
  `currency_code` char(3) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country_currencies`
--

INSERT INTO `country_currencies` (`country`, `currency_code`) VALUES
('Thailand', 'THB');

-- --------------------------------------------------------

--
-- Table structure for table `currencies`
--

CREATE TABLE `currencies` (
  `id` int(11) NOT NULL,
  `code` char(3) NOT NULL,
  `rate_to_base` decimal(12,6) NOT NULL DEFAULT 1.000000,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `currencies`
--

INSERT INTO `currencies` (`id`, `code`, `rate_to_base`, `updated_at`) VALUES
(1, 'THB', 1.000000, '2025-08-14 22:40:01'),
(2, 'THN', 1.000000, '2025-08-14 22:09:35');

-- --------------------------------------------------------

--
-- Table structure for table `db_patches`
--

CREATE TABLE `db_patches` (
  `id` int(11) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `applied_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `db_patches`
--

INSERT INTO `db_patches` (`id`, `filename`, `applied_at`) VALUES
(1, '2025-08-19_checkout.sql', '2025-08-19 23:31:13'),
(2, '2025-08-19_checkout_contact.sql', '2025-08-19 23:31:13'),
(3, '2025-08-19_vendor_packages_thumbnail.sql', '2025-08-19 23:31:13'),
(4, '2025-08-20_agent_tx_password.sql', '2025-08-19 23:31:13'),
(5, '2025-08-20_tx_pin_lockout.sql', '2025-08-19 23:31:13'),
(6, '2025-08-20_security_audit.sql', '2025-08-20 00:17:21');

-- --------------------------------------------------------

--
-- Table structure for table `email_logs`
--

CREATE TABLE `email_logs` (
  `id` int(11) NOT NULL,
  `to_email` varchar(150) NOT NULL,
  `subject` varchar(200) DEFAULT NULL,
  `body` mediumtext DEFAULT NULL,
  `meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`meta`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `evisas`
--

CREATE TABLE `evisas` (
  `id` int(11) NOT NULL,
  `vendor_id` int(11) NOT NULL,
  `country` varchar(100) NOT NULL,
  `base_price` decimal(10,2) NOT NULL DEFAULT 0.00
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `evisa_applications`
--

CREATE TABLE `evisa_applications` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `type_id` int(11) NOT NULL,
  `status` enum('draft','submitted','approved','rejected') NOT NULL DEFAULT 'draft',
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`data`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `evisa_docs`
--

CREATE TABLE `evisa_docs` (
  `id` int(11) NOT NULL,
  `type_id` int(11) NOT NULL,
  `doc_name` varchar(120) NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `evisa_types`
--

CREATE TABLE `evisa_types` (
  `id` int(11) NOT NULL,
  `name` varchar(120) NOT NULL,
  `country` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `group_pricing`
--

CREATE TABLE `group_pricing` (
  `id` int(11) NOT NULL,
  `module` enum('hotel','activity','taxi','evisa') NOT NULL,
  `item_id` int(11) NOT NULL,
  `pax_threshold` int(11) NOT NULL,
  `group_price` decimal(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hotels`
--

CREATE TABLE `hotels` (
  `id` int(11) NOT NULL,
  `vendor_id` int(11) NOT NULL,
  `name` varchar(200) NOT NULL,
  `city` varchar(100) NOT NULL,
  `country` varchar(100) NOT NULL,
  `base_price` decimal(10,2) NOT NULL DEFAULT 0.00,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `stars` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `visible_customer` tinyint(1) NOT NULL DEFAULT 1,
  `visible_agent` tinyint(1) NOT NULL DEFAULT 1,
  `featured_customer` tinyint(1) NOT NULL DEFAULT 0,
  `featured_agent` tinyint(1) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `hotels`
--

INSERT INTO `hotels` (`id`, `vendor_id`, `name`, `city`, `country`, `base_price`, `active`, `stars`, `visible_customer`, `visible_agent`, `featured_customer`, `featured_agent`) VALUES
(3, 8, 'Hotel FX', 'Pattaya', 'Thailand', 2000.00, 1, 3, 1, 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `hotel_bookings`
--

CREATE TABLE `hotel_bookings` (
  `id` int(11) NOT NULL,
  `hotel_id` int(11) NOT NULL,
  `vendor_id` int(11) NOT NULL,
  `booking_code` varchar(40) NOT NULL,
  `checkin` date NOT NULL,
  `checkout` date NOT NULL,
  `nights` int(11) NOT NULL,
  `room_id` int(11) NOT NULL,
  `rate_plan_id` int(11) DEFAULT NULL,
  `rooms_qty` int(11) NOT NULL DEFAULT 1,
  `guests_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`guests_json`)),
  `customer_name` varchar(150) NOT NULL,
  `customer_email` varchar(150) DEFAULT NULL,
  `status` enum('pending','confirmed','cancelled') NOT NULL DEFAULT 'pending',
  `total_price` decimal(12,2) NOT NULL,
  `currency` char(3) NOT NULL DEFAULT 'THB',
  `payment_status` enum('unpaid','paid','refunded') NOT NULL DEFAULT 'unpaid',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hotel_gallery`
--

CREATE TABLE `hotel_gallery` (
  `id` int(11) NOT NULL,
  `hotel_id` int(11) NOT NULL,
  `image_path` varchar(255) NOT NULL,
  `caption` varchar(150) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hotel_images`
--

CREATE TABLE `hotel_images` (
  `id` int(11) NOT NULL,
  `hotel_id` int(11) DEFAULT NULL,
  `room_id` int(11) DEFAULT NULL,
  `file_path` varchar(255) NOT NULL,
  `caption` varchar(150) DEFAULT NULL,
  `sort_order` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `hotel_images`
--

INSERT INTO `hotel_images` (`id`, `hotel_id`, `room_id`, `file_path`, `caption`, `sort_order`) VALUES
(1, 3, NULL, '\\assets\\uploads\\hotels\\e8a5a6a5dde4133f.jpg', '', NULL),
(2, 3, 1, '\\assets\\uploads\\hotels\\13cef0b4e44d96b6.png', '', NULL),
(3, 3, NULL, '\\assets\\uploads\\hotels\\44fd60773dd0a615.jpg', '', NULL),
(4, 3, NULL, '\\assets\\uploads\\hotels\\2674335ca5ef2f44.jpg', '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `hotel_policies`
--

CREATE TABLE `hotel_policies` (
  `id` int(11) NOT NULL,
  `hotel_id` int(11) NOT NULL,
  `checkin_time` varchar(10) DEFAULT NULL,
  `checkout_time` varchar(10) DEFAULT NULL,
  `child_policy` text DEFAULT NULL,
  `pet_policy` text DEFAULT NULL,
  `terms_html` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `hotel_policies`
--

INSERT INTO `hotel_policies` (`id`, `hotel_id`, `checkin_time`, `checkout_time`, `child_policy`, `pet_policy`, `terms_html`) VALUES
(1, 3, '14:00', '12:00', 'Below 5 year Free', 'Pets Not Allowes', 'You have to agree terms and condition of hotel.\r\nno refund before 24hr.');

-- --------------------------------------------------------

--
-- Table structure for table `hotel_rooms`
--

CREATE TABLE `hotel_rooms` (
  `id` int(11) NOT NULL,
  `hotel_id` int(11) NOT NULL,
  `name` varchar(120) NOT NULL,
  `occupancy_adults` int(11) NOT NULL DEFAULT 2,
  `occupancy_children` int(11) NOT NULL DEFAULT 0,
  `size_sqm` int(11) DEFAULT NULL,
  `bed_info` varchar(120) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `capacity` int(11) NOT NULL DEFAULT 2
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `hotel_rooms`
--

INSERT INTO `hotel_rooms` (`id`, `hotel_id`, `name`, `occupancy_adults`, `occupancy_children`, `size_sqm`, `bed_info`, `active`, `capacity`) VALUES
(1, 3, 'Deluxe Room', 2, 0, 25, '1 King Size, Twin Sharing', 1, 2);

-- --------------------------------------------------------

--
-- Table structure for table `hotel_room_prices`
--

CREATE TABLE `hotel_room_prices` (
  `id` int(11) NOT NULL,
  `room_id` int(11) NOT NULL,
  `date` date DEFAULT NULL,
  `is_group` tinyint(1) NOT NULL DEFAULT 0,
  `pax_threshold` int(11) DEFAULT NULL,
  `price` decimal(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ip_action_logs`
--

CREATE TABLE `ip_action_logs` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  `action` varchar(150) NOT NULL,
  `meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`meta`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ip_action_logs`
--

INSERT INTO `ip_action_logs` (`id`, `user_id`, `ip`, `action`, `meta`, `created_at`) VALUES
(1, 3, '::1', 'wallet_seed', '{\"ip\":\"::1\",\"x_forwarded_for\":null,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/139.0.0.0 Safari\\/537.36 Edg\\/139.0.0.0\",\"request_uri\":\"\\/admin\\/wallet\\/secure\\/seed\",\"at\":\"2025-08-16T11:24:51+02:00\",\"email\":\"admin3@example.com\",\"amount\":10000,\"ok\":true}', '2025-08-16 09:24:51'),
(2, 3, '::1', 'transfer_admin_to_partner', '{\"ip\":\"::1\",\"x_forwarded_for\":null,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/139.0.0.0 Safari\\/537.36 Edg\\/139.0.0.0\",\"request_uri\":\"\\/admin\\/wallet\\/secure\\/admin-to-partner\",\"at\":\"2025-08-16T11:31:47+02:00\",\"from\":\"admin3@example.com\",\"partner_id\":1,\"amount\":500,\"ok\":true}', '2025-08-16 09:31:47'),
(3, 3, '::1', 'transfer_admin_to_agent', '{\"ip\":\"::1\",\"x_forwarded_for\":null,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/139.0.0.0 Safari\\/537.36 Edg\\/139.0.0.0\",\"request_uri\":\"\\/admin\\/wallet\\/secure\\/admin-to-agent\",\"at\":\"2025-08-16T11:39:46+02:00\",\"from\":\"admin3@example.com\",\"to_user_id\":6,\"amount\":100000,\"ok\":false}', '2025-08-16 09:39:46'),
(4, 3, '::1', 'transfer_admin_to_agent', '{\"ip\":\"::1\",\"x_forwarded_for\":null,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/139.0.0.0 Safari\\/537.36 Edg\\/139.0.0.0\",\"request_uri\":\"\\/admin\\/wallet\\/secure\\/admin-to-agent\",\"at\":\"2025-08-16T11:52:58+02:00\",\"from\":\"admin3@example.com\",\"to_user_id\":10,\"amount\":8000,\"ok\":true}', '2025-08-16 09:52:58'),
(5, 3, '::1', 'reverse_admin_agent', '{\"ip\":\"::1\",\"x_forwarded_for\":null,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/139.0.0.0 Safari\\/537.36 Edg\\/139.0.0.0\",\"request_uri\":\"\\/admin\\/wallet\\/secure\\/reverse\\/admin-agent\",\"at\":\"2025-08-16T12:09:14+02:00\",\"from\":\"admin3@example.com\",\"agent_user_id\":10,\"amount\":2000,\"ok\":true,\"reason\":\"ok\"}', '2025-08-16 10:09:14'),
(6, 3, '::1', 'reverse_admin_agent', '{\"ip\":\"::1\",\"x_forwarded_for\":null,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/139.0.0.0 Safari\\/537.36 Edg\\/139.0.0.0\",\"request_uri\":\"\\/admin\\/wallet\\/secure\\/reverse\\/admin-agent\",\"at\":\"2025-08-16T12:09:47+02:00\",\"from\":\"admin3@example.com\",\"agent_user_id\":10,\"amount\":8000,\"ok\":false,\"reason\":\"123456\"}', '2025-08-16 10:09:47'),
(7, 3, '::1', 'reverse_admin_partner', '{\"ip\":\"::1\",\"x_forwarded_for\":null,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/139.0.0.0 Safari\\/537.36 Edg\\/139.0.0.0\",\"request_uri\":\"\\/admin\\/wallet\\/secure\\/reverse\\/admin-partner\",\"at\":\"2025-08-16T12:11:06+02:00\",\"from\":\"admin3@example.com\",\"partner_id\":1,\"amount\":500,\"ok\":true,\"reason\":\"ok\"}', '2025-08-16 10:11:06'),
(8, 3, '::1', 'transfer_admin_to_partner', '{\"ip\":\"::1\",\"x_forwarded_for\":null,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/136.0.0.0 Safari\\/537.36\",\"request_uri\":\"\\/admin\\/wallet\\/secure\\/admin-to-partner\",\"at\":\"2025-08-17T03:00:36+02:00\",\"from\":\"admin3@example.com\",\"partner_id\":1,\"amount\":500,\"ok\":true}', '2025-08-17 01:00:36'),
(9, 3, '::1', 'wallet_seed', '{\"ip\":\"::1\",\"x_forwarded_for\":null,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/139.0.0.0 Safari\\/537.36 Edg\\/139.0.0.0\",\"request_uri\":\"\\/admin\\/wallet\\/secure\\/seed\",\"at\":\"2025-08-18T12:22:47+02:00\",\"email\":\"admin3@example.com\",\"amount\":500,\"ok\":true}', '2025-08-18 10:22:47'),
(10, 3, '::1', 'wallet_seed', '{\"ip\":\"::1\",\"x_forwarded_for\":null,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/139.0.0.0 Safari\\/537.36 Edg\\/139.0.0.0\",\"request_uri\":\"\\/admin\\/wallet\\/secure\\/seed\",\"at\":\"2025-08-26T15:02:40+02:00\",\"email\":\"admin3@example.com\",\"amount\":10000,\"ok\":true}', '2025-08-26 13:02:40'),
(11, 3, '::1', 'transfer_admin_to_agent', '{\"ip\":\"::1\",\"x_forwarded_for\":null,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/139.0.0.0 Safari\\/537.36 Edg\\/139.0.0.0\",\"request_uri\":\"\\/admin\\/wallet\\/secure\\/admin-to-agent\",\"at\":\"2025-08-26T15:02:51+02:00\",\"from\":\"admin3@example.com\",\"to_user_id\":6,\"amount\":5000,\"ok\":true}', '2025-08-26 13:02:51');

-- --------------------------------------------------------

--
-- Table structure for table `locations`
--

CREATE TABLE `locations` (
  `id` int(11) NOT NULL,
  `country` varchar(100) NOT NULL,
  `city` varchar(100) DEFAULT NULL,
  `timezone` varchar(64) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `locations`
--

INSERT INTO `locations` (`id`, `country`, `city`, `timezone`) VALUES
(3, 'Thailand', NULL, NULL),
(4, 'Thailand', 'Pattaya', NULL),
(6, 'Thailand', 'Phuket', NULL),
(7, 'Thailand', 'Krabi', NULL),
(8, 'Thailand', 'Bangkok', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `modules`
--

CREATE TABLE `modules` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `slug` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `modules`
--

INSERT INTO `modules` (`id`, `name`, `slug`, `created_at`) VALUES
(1, 'Activity', 'activity', '2025-08-14 23:19:29'),
(2, 'Hotel', 'hotel', '2025-08-14 23:19:45'),
(3, 'Taxi', 'taxi', '2025-08-14 23:21:32'),
(4, 'Visa', 'visa', '2025-08-14 23:21:40'),
(5, 'Package', 'package', '2025-08-14 23:21:48');

-- --------------------------------------------------------

--
-- Table structure for table `orders`
--

CREATE TABLE `orders` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `status` enum('pending','paid','failed','cancelled') NOT NULL DEFAULT 'pending',
  `total_amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `currency` char(3) NOT NULL DEFAULT 'THB',
  `payment_method` enum('wallet','stripe','paypal','none') NOT NULL DEFAULT 'none',
  `customer_name` varchar(191) DEFAULT NULL,
  `customer_mobile` varchar(50) DEFAULT NULL,
  `customer_email` varchar(191) DEFAULT NULL,
  `customer_whatsapp` varchar(50) DEFAULT NULL,
  `payment_ref` varchar(100) DEFAULT NULL,
  `meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`meta`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `orders`
--

INSERT INTO `orders` (`id`, `user_id`, `status`, `total_amount`, `currency`, `payment_method`, `customer_name`, `customer_mobile`, `customer_email`, `customer_whatsapp`, `payment_ref`, `meta`, `created_at`, `updated_at`) VALUES
(1, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 12:56:29', NULL),
(2, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 12:57:47', NULL),
(3, 10, 'pending', 300.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 13:00:00', NULL),
(4, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 13:04:20', NULL),
(5, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 13:04:40', NULL),
(6, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 13:05:48', NULL),
(7, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 13:07:25', NULL),
(8, 10, 'paid', 150.00, 'THB', 'wallet', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 13:19:57', '2025-08-19 13:22:38'),
(9, 10, 'paid', 300.00, 'THB', 'wallet', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 13:23:11', '2025-08-19 13:24:40'),
(10, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 13:25:01', NULL),
(11, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 13:27:49', NULL),
(12, 10, 'pending', 2250.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 13:28:34', NULL),
(13, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 13:31:02', NULL),
(14, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 13:35:15', NULL),
(15, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 14:01:39', NULL),
(16, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 14:03:26', NULL),
(17, 10, 'pending', 200.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 14:16:12', NULL),
(18, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 14:16:36', NULL),
(19, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 14:18:45', NULL),
(20, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 14:19:00', NULL),
(21, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 14:19:13', NULL),
(22, 10, 'paid', 450.00, 'THB', 'wallet', 'kilk', '98655555', NULL, NULL, NULL, NULL, '2025-08-19 14:25:08', '2025-08-19 14:34:34'),
(23, 10, 'paid', 150.00, 'THB', 'wallet', 'ramesh', '90000000', NULL, NULL, NULL, NULL, '2025-08-19 14:35:03', '2025-08-19 14:43:22'),
(24, 10, 'paid', 150.00, 'THB', 'wallet', 'sakil', '9000000000', NULL, NULL, NULL, NULL, '2025-08-19 14:44:11', '2025-08-19 15:03:59'),
(25, 10, 'pending', 6150.00, 'THB', 'none', 'sakil', '9000000000', NULL, NULL, NULL, NULL, '2025-08-19 15:06:07', '2025-08-19 15:08:13'),
(26, 10, 'paid', 300.00, 'THB', 'wallet', 'ramesh', '989895989888', NULL, NULL, NULL, NULL, '2025-08-19 15:25:00', '2025-08-19 15:25:22'),
(27, 10, 'paid', 150.00, 'THB', 'wallet', 'kalio', '900000000', NULL, NULL, NULL, NULL, '2025-08-19 15:42:24', '2025-08-19 15:42:44'),
(28, 10, 'paid', 150.00, 'THB', 'wallet', 'kaliok', '900000000', NULL, NULL, NULL, NULL, '2025-08-19 15:44:26', '2025-08-19 15:50:41'),
(29, 10, 'paid', 250.00, 'THB', 'wallet', 'ravi kumar', '9000000', 'ok@ok.com', '9000000000', NULL, NULL, '2025-08-19 22:43:03', '2025-08-19 22:43:52'),
(30, 10, 'pending', 300.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 22:45:19', NULL),
(31, 10, 'pending', 1950.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-19 22:47:03', NULL),
(32, 10, 'paid', 150.00, 'THB', 'wallet', 'ravsa', '90000000', NULL, NULL, NULL, NULL, '2025-08-19 22:51:29', '2025-08-19 23:31:48'),
(33, 10, 'paid', 300.00, 'THB', 'wallet', 'jim', '900000000', NULL, NULL, NULL, NULL, '2025-08-19 23:35:45', '2025-08-20 00:04:19'),
(34, 10, 'paid', 150.00, 'THB', 'wallet', 'rahul', '9000000', NULL, NULL, NULL, NULL, '2025-08-20 00:06:14', '2025-08-20 00:06:36'),
(35, 10, 'paid', 150.00, 'THB', 'wallet', 'rahul', '90000000', NULL, NULL, NULL, NULL, '2025-08-20 00:06:58', '2025-08-20 00:25:45'),
(36, 10, 'paid', 150.00, 'THB', 'wallet', 'rahul', '9000000', NULL, NULL, NULL, NULL, '2025-08-20 00:43:13', '2025-08-20 00:43:31'),
(37, 10, 'paid', 300.00, 'THB', 'wallet', 'ramesh', '9000000', NULL, NULL, NULL, NULL, '2025-08-20 00:52:19', '2025-08-20 00:54:52'),
(38, 10, 'pending', 5700.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-20 01:50:23', NULL),
(39, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-20 02:11:17', NULL),
(49, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-20 02:19:12', NULL),
(50, 10, 'paid', 1800.00, 'THB', 'wallet', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-20 02:20:54', '2025-08-20 02:21:02'),
(51, 10, 'pending', 300.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-20 02:24:02', NULL),
(52, 10, 'pending', 1800.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-20 02:49:13', NULL),
(53, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-20 03:05:24', NULL),
(54, 10, 'pending', 250.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-20 03:07:05', NULL),
(55, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-20 03:21:42', NULL),
(56, 10, 'pending', 150.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-20 03:52:07', NULL),
(57, 10, 'paid', 300.00, 'THB', 'wallet', 'ROHAN', '9000000', NULL, NULL, NULL, NULL, '2025-08-26 13:14:36', '2025-08-26 13:15:04'),
(58, 10, 'pending', 3900.00, 'THB', 'none', 'RAHUL', '90000000', NULL, NULL, NULL, NULL, '2025-08-26 13:16:38', '2025-08-26 13:17:04'),
(59, 10, 'pending', 250.00, 'THB', 'none', NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-28 02:39:17', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `order_items`
--

CREATE TABLE `order_items` (
  `id` int(11) NOT NULL,
  `order_id` int(11) NOT NULL,
  `module` enum('activity','hotel','taxi','evisa') NOT NULL,
  `item_id` int(11) NOT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `price_id` int(11) DEFAULT NULL,
  `qty` int(11) NOT NULL DEFAULT 1,
  `unit_price` decimal(12,2) NOT NULL DEFAULT 0.00,
  `line_total` decimal(12,2) NOT NULL DEFAULT 0.00,
  `currency` char(3) NOT NULL DEFAULT 'THB',
  `booking_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `order_items`
--

INSERT INTO `order_items` (`id`, `order_id`, `module`, `item_id`, `variant_id`, `price_id`, `qty`, `unit_price`, `line_total`, `currency`, `booking_id`) VALUES
(1, 1, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(2, 2, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(3, 3, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(4, 3, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(5, 4, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(6, 5, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(7, 6, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(8, 7, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(9, 8, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', 38),
(10, 9, 'activity', 2, 3, 4, 2, 150.00, 300.00, 'THB', 39),
(11, 10, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(12, 11, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(13, 12, 'activity', 2, 3, 4, 2, 150.00, 300.00, 'THB', NULL),
(14, 12, 'activity', 2, 3, 5, 1, 150.00, 150.00, 'THB', NULL),
(15, 12, 'activity', 2, 4, 7, 1, 1800.00, 1800.00, 'THB', NULL),
(16, 13, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(17, 14, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(18, 15, 'activity', 2, 3, 5, 1, 150.00, 150.00, 'THB', NULL),
(19, 16, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(20, 17, 'activity', 2, 3, 6, 2, 100.00, 200.00, 'THB', NULL),
(21, 18, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(22, 19, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(23, 20, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(24, 21, 'activity', 2, 3, 5, 1, 150.00, 150.00, 'THB', NULL),
(25, 22, 'activity', 2, 3, 5, 1, 150.00, 150.00, 'THB', 40),
(26, 22, 'activity', 2, 3, 4, 2, 150.00, 300.00, 'THB', 41),
(27, 23, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', 42),
(28, 24, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', 43),
(29, 25, 'activity', 2, 3, 4, 5, 150.00, 750.00, 'THB', NULL),
(30, 25, 'activity', 2, 4, 7, 3, 1800.00, 5400.00, 'THB', NULL),
(31, 26, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', 44),
(32, 26, 'activity', 2, 3, 5, 1, 150.00, 150.00, 'THB', 45),
(33, 27, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', 46),
(34, 28, 'activity', 2, 3, 5, 1, 150.00, 150.00, 'THB', 47),
(35, 29, 'activity', 2, 3, 6, 1, 100.00, 100.00, 'THB', 48),
(36, 29, 'activity', 2, 3, 5, 1, 150.00, 150.00, 'THB', 49),
(37, 30, 'activity', 2, 3, 4, 2, 150.00, 300.00, 'THB', NULL),
(38, 31, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(39, 31, 'activity', 2, 4, 7, 1, 1800.00, 1800.00, 'THB', NULL),
(40, 32, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', 50),
(41, 33, 'activity', 2, 3, 4, 2, 150.00, 300.00, 'THB', 51),
(42, 34, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', 52),
(43, 35, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', 53),
(44, 36, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', 54),
(45, 37, 'activity', 2, 3, 4, 2, 150.00, 300.00, 'THB', 55),
(46, 38, 'activity', 2, 3, 4, 2, 150.00, 300.00, 'THB', NULL),
(47, 38, 'activity', 2, 4, 7, 3, 1800.00, 5400.00, 'THB', NULL),
(48, 39, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(49, 49, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(50, 50, 'activity', 2, NULL, NULL, 1, 1800.00, 1800.00, 'THB', 56),
(51, 51, 'activity', 2, 3, 4, 2, 150.00, 300.00, 'THB', NULL),
(52, 52, 'activity', 2, 4, 7, 1, 1800.00, 1800.00, 'THB', NULL),
(53, 53, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(54, 54, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(55, 54, 'activity', 2, 3, 6, 1, 100.00, 100.00, 'THB', NULL),
(56, 55, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(57, 56, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(58, 57, 'activity', 2, 3, 4, 2, 150.00, 300.00, 'THB', 57),
(59, 58, 'activity', 2, 3, 4, 2, 150.00, 300.00, 'THB', NULL),
(60, 58, 'activity', 2, 4, 7, 2, 1800.00, 3600.00, 'THB', NULL),
(61, 59, 'activity', 2, 3, 4, 1, 150.00, 150.00, 'THB', NULL),
(62, 59, 'activity', 2, 3, 6, 1, 100.00, 100.00, 'THB', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `packages`
--

CREATE TABLE `packages` (
  `id` int(11) NOT NULL,
  `name` varchar(150) NOT NULL,
  `description` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `package_items`
--

CREATE TABLE `package_items` (
  `id` int(11) NOT NULL,
  `package_id` int(11) NOT NULL,
  `module` enum('hotel','activity','taxi','evisa') NOT NULL,
  `item_id` int(11) NOT NULL,
  `qty` int(11) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `partner_commissions`
--

CREATE TABLE `partner_commissions` (
  `id` int(11) NOT NULL,
  `booking_id` int(11) NOT NULL,
  `partner_user_id` int(11) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `status` enum('pending','paid') NOT NULL DEFAULT 'pending'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `payments`
--

CREATE TABLE `payments` (
  `id` int(11) NOT NULL,
  `order_id` int(11) NOT NULL,
  `method` enum('wallet','stripe','paypal') NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `currency` char(3) NOT NULL DEFAULT 'THB',
  `status` enum('succeeded','failed') NOT NULL DEFAULT 'succeeded',
  `gateway_ref` varchar(120) DEFAULT NULL,
  `meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`meta`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `payments`
--

INSERT INTO `payments` (`id`, `order_id`, `method`, `amount`, `currency`, `status`, `gateway_ref`, `meta`, `created_at`) VALUES
(15, 8, 'wallet', 150.00, 'THB', 'succeeded', NULL, '{\"flow\":\"checkout\"}', '2025-08-19 13:22:38'),
(16, 9, 'wallet', 300.00, 'THB', 'succeeded', NULL, '{\"flow\":\"checkout\"}', '2025-08-19 13:24:40'),
(17, 22, 'wallet', 450.00, 'THB', 'succeeded', NULL, '{\"flow\":\"checkout\"}', '2025-08-19 14:34:34'),
(18, 23, 'wallet', 150.00, 'THB', 'succeeded', NULL, '{\"flow\":\"checkout\"}', '2025-08-19 14:43:22'),
(19, 24, 'wallet', 150.00, 'THB', 'succeeded', NULL, '{\"flow\":\"checkout\"}', '2025-08-19 15:03:59'),
(20, 26, 'wallet', 300.00, 'THB', 'succeeded', NULL, '{\"flow\":\"checkout\"}', '2025-08-19 15:25:22'),
(21, 27, 'wallet', 150.00, 'THB', 'succeeded', NULL, '{\"flow\":\"checkout\"}', '2025-08-19 15:42:44'),
(22, 28, 'wallet', 150.00, 'THB', 'succeeded', NULL, '{\"flow\":\"checkout\"}', '2025-08-19 15:50:41'),
(23, 29, 'wallet', 250.00, 'THB', 'succeeded', NULL, '{\"flow\":\"checkout\"}', '2025-08-19 22:43:52'),
(24, 32, 'wallet', 150.00, 'THB', 'succeeded', NULL, '{\"flow\":\"checkout\"}', '2025-08-19 23:31:48'),
(25, 33, 'wallet', 300.00, 'THB', 'succeeded', NULL, '{\"flow\":\"checkout\"}', '2025-08-20 00:04:19'),
(26, 34, 'wallet', 150.00, 'THB', 'succeeded', NULL, '{\"flow\":\"checkout\"}', '2025-08-20 00:06:36'),
(27, 35, 'wallet', 150.00, 'THB', 'succeeded', NULL, '{\"flow\":\"checkout\"}', '2025-08-20 00:25:45'),
(28, 36, 'wallet', 150.00, 'THB', 'succeeded', NULL, '{\"flow\":\"checkout\"}', '2025-08-20 00:43:31'),
(29, 37, 'wallet', 300.00, 'THB', 'succeeded', NULL, '{\"flow\":\"checkout\"}', '2025-08-20 00:54:52'),
(30, 50, 'wallet', 1800.00, 'THB', 'succeeded', NULL, '{\"flow\":\"checkout\"}', '2025-08-20 02:21:02'),
(31, 57, 'wallet', 300.00, 'THB', 'succeeded', NULL, '{\"flow\":\"checkout\"}', '2025-08-26 13:15:04');

-- --------------------------------------------------------

--
-- Table structure for table `promo_codes`
--

CREATE TABLE `promo_codes` (
  `id` int(11) NOT NULL,
  `code` varchar(50) NOT NULL,
  `discount_type` enum('flat','percent') NOT NULL,
  `discount_value` decimal(10,2) NOT NULL,
  `valid_from` date DEFAULT NULL,
  `valid_to` date DEFAULT NULL,
  `usage_limit` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `promo_codes`
--

INSERT INTO `promo_codes` (`id`, `code`, `discount_type`, `discount_value`, `valid_from`, `valid_to`, `usage_limit`) VALUES
(1, 'XYZ', 'percent', 5.00, '2025-08-15', '2025-08-21', 1),
(3, 'DIGVIJAY', 'flat', 50.00, '2025-08-07', '2026-09-09', 2);

-- --------------------------------------------------------

--
-- Table structure for table `promo_redemptions`
--

CREATE TABLE `promo_redemptions` (
  `id` int(11) NOT NULL,
  `promo_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `booking_id` int(11) DEFAULT NULL,
  `redeemed_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rate_plans`
--

CREATE TABLE `rate_plans` (
  `id` int(11) NOT NULL,
  `hotel_id` int(11) NOT NULL,
  `name` varchar(120) NOT NULL,
  `meal_plan` enum('RO','BB','HB','FB') NOT NULL DEFAULT 'RO',
  `refundable` tinyint(1) NOT NULL DEFAULT 1,
  `refund_window_days` int(11) DEFAULT NULL,
  `advance_purchase_days` int(11) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `rate_plans`
--

INSERT INTO `rate_plans` (`id`, `hotel_id`, `name`, `meal_plan`, `refundable`, `refund_window_days`, `advance_purchase_days`, `active`) VALUES
(1, 3, 'Rate Plan1', 'HB', 0, 7, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `room_allocations`
--

CREATE TABLE `room_allocations` (
  `id` int(11) NOT NULL,
  `room_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `allotment` int(11) NOT NULL DEFAULT 0,
  `min_stay` int(11) DEFAULT NULL,
  `max_stay` int(11) DEFAULT NULL,
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  `cta` tinyint(1) NOT NULL DEFAULT 0,
  `ctd` tinyint(1) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `room_allocations`
--

INSERT INTO `room_allocations` (`id`, `room_id`, `date`, `allotment`, `min_stay`, `max_stay`, `closed`, `cta`, `ctd`) VALUES
(1, 1, '2025-08-01', 3, 1, 30, 0, 0, 0),
(2, 1, '2025-08-02', 2, 1, NULL, 0, 0, 0),
(3, 1, '2025-08-03', 0, NULL, NULL, 0, 0, 0),
(4, 1, '2025-08-04', 0, NULL, NULL, 0, 0, 0),
(5, 1, '2025-08-05', 0, NULL, NULL, 0, 0, 0),
(6, 1, '2025-08-06', 0, NULL, NULL, 0, 0, 0),
(7, 1, '2025-08-07', 0, NULL, NULL, 0, 0, 0),
(8, 1, '2025-08-08', 0, NULL, NULL, 0, 0, 0),
(9, 1, '2025-08-09', 0, NULL, NULL, 0, 0, 0),
(10, 1, '2025-08-10', 0, NULL, NULL, 0, 0, 0),
(11, 1, '2025-08-11', 0, NULL, NULL, 0, 0, 0),
(12, 1, '2025-08-12', 0, NULL, NULL, 0, 0, 0),
(13, 1, '2025-08-13', 0, NULL, NULL, 0, 0, 0),
(14, 1, '2025-08-14', 0, NULL, NULL, 0, 0, 0),
(15, 1, '2025-08-15', 0, NULL, NULL, 0, 0, 0),
(16, 1, '2025-08-16', 0, NULL, NULL, 0, 0, 0),
(17, 1, '2025-08-17', 0, NULL, NULL, 0, 0, 0),
(18, 1, '2025-08-18', 0, NULL, NULL, 0, 0, 0),
(19, 1, '2025-08-19', 0, NULL, NULL, 0, 0, 0),
(20, 1, '2025-08-20', 0, NULL, NULL, 0, 0, 0),
(21, 1, '2025-08-21', 0, NULL, NULL, 0, 0, 0),
(22, 1, '2025-08-22', 0, NULL, NULL, 0, 0, 0),
(23, 1, '2025-08-23', 0, NULL, NULL, 0, 0, 0),
(24, 1, '2025-08-24', 0, NULL, NULL, 0, 0, 0),
(25, 1, '2025-08-25', 0, NULL, NULL, 0, 0, 0),
(26, 1, '2025-08-26', 0, NULL, NULL, 0, 0, 0),
(27, 1, '2025-08-27', 0, NULL, NULL, 0, 0, 0),
(28, 1, '2025-08-28', 0, NULL, NULL, 0, 0, 0),
(29, 1, '2025-08-29', 0, NULL, NULL, 0, 0, 0),
(30, 1, '2025-08-30', 0, NULL, NULL, 0, 0, 0),
(31, 1, '2025-08-31', 0, NULL, NULL, 0, 0, 0),
(161, 1, '2025-09-01', 2, 1, 10, 0, 0, 0),
(162, 1, '2025-09-02', 0, NULL, NULL, 0, 0, 0),
(163, 1, '2025-09-03', 0, NULL, NULL, 0, 0, 0),
(164, 1, '2025-09-04', 0, NULL, NULL, 0, 0, 0),
(165, 1, '2025-09-05', 0, NULL, NULL, 0, 0, 0),
(166, 1, '2025-09-06', 0, NULL, NULL, 0, 0, 0),
(167, 1, '2025-09-07', 0, NULL, NULL, 0, 0, 0),
(168, 1, '2025-09-08', 0, NULL, NULL, 0, 0, 0),
(169, 1, '2025-09-09', 0, NULL, NULL, 0, 0, 0),
(170, 1, '2025-09-10', 0, NULL, NULL, 0, 0, 0),
(171, 1, '2025-09-11', 0, NULL, NULL, 0, 0, 0),
(172, 1, '2025-09-12', 0, NULL, NULL, 0, 0, 0),
(173, 1, '2025-09-13', 0, NULL, NULL, 0, 0, 0),
(174, 1, '2025-09-14', 0, NULL, NULL, 0, 0, 0),
(175, 1, '2025-09-15', 0, NULL, NULL, 0, 0, 0),
(176, 1, '2025-09-16', 0, NULL, NULL, 0, 0, 0),
(177, 1, '2025-09-17', 0, NULL, NULL, 0, 0, 0),
(178, 1, '2025-09-18', 0, NULL, NULL, 0, 0, 0),
(179, 1, '2025-09-19', 0, NULL, NULL, 0, 0, 0),
(180, 1, '2025-09-20', 0, NULL, NULL, 0, 0, 0),
(181, 1, '2025-09-21', 0, NULL, NULL, 0, 0, 0),
(182, 1, '2025-09-22', 0, NULL, NULL, 0, 0, 0),
(183, 1, '2025-09-23', 0, NULL, NULL, 0, 0, 0),
(184, 1, '2025-09-24', 0, NULL, NULL, 0, 0, 0),
(185, 1, '2025-09-25', 0, NULL, NULL, 0, 0, 0),
(186, 1, '2025-09-26', 0, NULL, NULL, 0, 0, 0),
(187, 1, '2025-09-27', 0, NULL, NULL, 0, 0, 0),
(188, 1, '2025-09-28', 0, NULL, NULL, 0, 0, 0),
(189, 1, '2025-09-29', 0, NULL, NULL, 0, 0, 0),
(190, 1, '2025-09-30', 0, NULL, NULL, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `room_prices`
--

CREATE TABLE `room_prices` (
  `id` int(11) NOT NULL,
  `room_id` int(11) NOT NULL,
  `rate_plan_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `vendor_cost` decimal(10,2) DEFAULT NULL,
  `agent_price` decimal(10,2) DEFAULT NULL,
  `customer_price` decimal(10,2) DEFAULT NULL,
  `tax_included` tinyint(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `room_prices`
--

INSERT INTO `room_prices` (`id`, `room_id`, `rate_plan_id`, `date`, `price`, `vendor_cost`, `agent_price`, `customer_price`, `tax_included`) VALUES
(1, 1, 1, '2025-08-01', 1500.00, 1200.00, 1500.00, 1900.00, 1),
(2, 1, 1, '2025-08-02', 2000.00, 1900.00, 2000.00, 2200.00, 1),
(3, 1, 1, '2025-08-03', 0.00, NULL, 0.00, NULL, 1),
(4, 1, 1, '2025-08-04', 0.00, NULL, 0.00, NULL, 1),
(5, 1, 1, '2025-08-05', 0.00, NULL, 0.00, NULL, 1),
(6, 1, 1, '2025-08-06', 0.00, NULL, 0.00, NULL, 1),
(7, 1, 1, '2025-08-07', 0.00, NULL, 0.00, NULL, 1),
(8, 1, 1, '2025-08-08', 0.00, NULL, 0.00, NULL, 1),
(9, 1, 1, '2025-08-09', 0.00, NULL, 0.00, NULL, 1),
(10, 1, 1, '2025-08-10', 0.00, NULL, 0.00, NULL, 1),
(11, 1, 1, '2025-08-11', 0.00, NULL, 0.00, NULL, 1),
(12, 1, 1, '2025-08-12', 0.00, NULL, 0.00, NULL, 1),
(13, 1, 1, '2025-08-13', 0.00, NULL, 0.00, NULL, 1),
(14, 1, 1, '2025-08-14', 0.00, NULL, 0.00, NULL, 1),
(15, 1, 1, '2025-08-15', 0.00, NULL, 0.00, NULL, 1),
(16, 1, 1, '2025-08-16', 0.00, NULL, 0.00, NULL, 1),
(17, 1, 1, '2025-08-17', 0.00, NULL, 0.00, NULL, 1),
(18, 1, 1, '2025-08-18', 0.00, NULL, 0.00, NULL, 1),
(19, 1, 1, '2025-08-19', 0.00, NULL, 0.00, NULL, 1),
(20, 1, 1, '2025-08-20', 0.00, NULL, 0.00, NULL, 1),
(21, 1, 1, '2025-08-21', 0.00, NULL, 0.00, NULL, 1),
(22, 1, 1, '2025-08-22', 0.00, NULL, 0.00, NULL, 1),
(23, 1, 1, '2025-08-23', 0.00, NULL, 0.00, NULL, 1),
(24, 1, 1, '2025-08-24', 0.00, NULL, 0.00, NULL, 1),
(25, 1, 1, '2025-08-25', 0.00, NULL, 0.00, NULL, 1),
(26, 1, 1, '2025-08-26', 0.00, NULL, 0.00, NULL, 1),
(27, 1, 1, '2025-08-27', 0.00, NULL, 0.00, NULL, 1),
(28, 1, 1, '2025-08-28', 0.00, NULL, 0.00, NULL, 1),
(29, 1, 1, '2025-08-29', 0.00, NULL, 0.00, NULL, 1),
(30, 1, 1, '2025-08-30', 0.00, NULL, 0.00, NULL, 1),
(31, 1, 1, '2025-08-31', 0.00, NULL, 0.00, NULL, 1),
(156, 1, 1, '2025-09-01', 1100.00, 900.00, 1100.00, 1500.00, 1),
(157, 1, 1, '2025-09-02', 0.00, NULL, NULL, NULL, 1),
(158, 1, 1, '2025-09-03', 0.00, NULL, NULL, NULL, 1),
(159, 1, 1, '2025-09-04', 0.00, NULL, NULL, NULL, 1),
(160, 1, 1, '2025-09-05', 0.00, NULL, NULL, NULL, 1),
(161, 1, 1, '2025-09-06', 0.00, NULL, NULL, NULL, 1),
(162, 1, 1, '2025-09-07', 0.00, NULL, NULL, NULL, 1),
(163, 1, 1, '2025-09-08', 0.00, NULL, NULL, NULL, 1),
(164, 1, 1, '2025-09-09', 0.00, NULL, NULL, NULL, 1),
(165, 1, 1, '2025-09-10', 0.00, NULL, NULL, NULL, 1),
(166, 1, 1, '2025-09-11', 0.00, NULL, NULL, NULL, 1),
(167, 1, 1, '2025-09-12', 0.00, NULL, NULL, NULL, 1),
(168, 1, 1, '2025-09-13', 0.00, NULL, NULL, NULL, 1),
(169, 1, 1, '2025-09-14', 0.00, NULL, NULL, NULL, 1),
(170, 1, 1, '2025-09-15', 0.00, NULL, NULL, NULL, 1),
(171, 1, 1, '2025-09-16', 0.00, NULL, NULL, NULL, 1),
(172, 1, 1, '2025-09-17', 0.00, NULL, NULL, NULL, 1),
(173, 1, 1, '2025-09-18', 0.00, NULL, NULL, NULL, 1),
(174, 1, 1, '2025-09-19', 0.00, NULL, NULL, NULL, 1),
(175, 1, 1, '2025-09-20', 0.00, NULL, NULL, NULL, 1),
(176, 1, 1, '2025-09-21', 0.00, NULL, NULL, NULL, 1),
(177, 1, 1, '2025-09-22', 0.00, NULL, NULL, NULL, 1),
(178, 1, 1, '2025-09-23', 0.00, NULL, NULL, NULL, 1),
(179, 1, 1, '2025-09-24', 0.00, NULL, NULL, NULL, 1),
(180, 1, 1, '2025-09-25', 0.00, NULL, NULL, NULL, 1),
(181, 1, 1, '2025-09-26', 0.00, NULL, NULL, NULL, 1),
(182, 1, 1, '2025-09-27', 0.00, NULL, NULL, NULL, 1),
(183, 1, 1, '2025-09-28', 0.00, NULL, NULL, NULL, 1),
(184, 1, 1, '2025-09-29', 0.00, NULL, NULL, NULL, 1),
(185, 1, 1, '2025-09-30', 0.00, NULL, NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `security_audit_events`
--

CREATE TABLE `security_audit_events` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `agent_id` bigint(20) DEFAULT NULL,
  `order_id` bigint(20) DEFAULT NULL,
  `event_type` varchar(100) NOT NULL,
  `action` varchar(150) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `details` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`details`)),
  `route` varchar(255) DEFAULT NULL,
  `method` varchar(10) DEFAULT NULL,
  `ip` varchar(64) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `status_code` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `security_audit_events`
--

INSERT INTO `security_audit_events` (`id`, `user_id`, `agent_id`, `order_id`, `event_type`, `action`, `message`, `details`, `route`, `method`, `ip`, `user_agent`, `status_code`, `created_at`) VALUES
(1, 10, NULL, 35, 'wallet_pay_success', 'wallet_debit_and_order_paid', 'Wallet debit succeeded and order marked paid', '{\"amount\":150,\"currency\":\"THB\",\"bookings_count\":1}', '/b2b/api/checkout/pay-wallet', 'POST', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 200, '2025-08-20 00:25:45'),
(2, 10, NULL, 36, 'wallet_pay_success', 'wallet_debit_and_order_paid', 'Wallet debit succeeded and order marked paid', '{\"amount\":150,\"currency\":\"THB\",\"bookings_count\":1}', '/b2b/api/checkout/pay-wallet', 'POST', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 200, '2025-08-20 00:43:31'),
(3, 10, NULL, 36, 'wallet_pay_validation', 'order_not_pending', 'Attempted to pay non-pending order', '{\"status\":\"paid\"}', '/b2b/api/checkout/pay-wallet', 'POST', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 422, '2025-08-20 00:49:08'),
(4, 10, NULL, 37, 'wallet_pay_success', 'wallet_debit_and_order_paid', 'Wallet debit succeeded and order marked paid', '{\"amount\":300,\"currency\":\"THB\",\"bookings_count\":1}', '/b2b/api/checkout/pay-wallet', 'POST', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 200, '2025-08-20 00:54:52'),
(5, 10, NULL, 37, 'wallet_pay_validation', 'order_not_pending', 'Attempted to pay non-pending order', '{\"status\":\"paid\"}', '/b2b/api/checkout/pay-wallet', 'POST', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 422, '2025-08-20 02:20:36'),
(6, 10, NULL, 50, 'wallet_pay_success', 'wallet_debit_and_order_paid', 'Wallet debit succeeded and order marked paid', '{\"amount\":1800,\"currency\":\"THB\",\"bookings_count\":1}', '/b2b/api/checkout/pay-wallet', 'POST', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 200, '2025-08-20 02:21:02'),
(7, 10, NULL, 35, 'wallet_pay_validation', 'order_not_pending', 'Attempted to pay non-pending order', '{\"status\":\"paid\"}', '/b2b/api/checkout/pay-wallet', 'POST', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 422, '2025-08-20 03:52:26'),
(8, 10, NULL, 57, 'wallet_pay_pin', 'pin_invalid', 'Invalid PIN submitted', '{\"attempts\":1,\"remaining\":9}', '/b2b/api/checkout/pay-wallet', 'POST', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36 Edg/139.0.0.0', 422, '2025-08-26 13:14:55'),
(9, 10, NULL, 57, 'wallet_pay_pin', 'pin_invalid', 'Invalid PIN submitted', '{\"attempts\":2,\"remaining\":8}', '/b2b/api/checkout/pay-wallet', 'POST', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36 Edg/139.0.0.0', 422, '2025-08-26 13:15:00'),
(10, 10, NULL, 57, 'wallet_pay_success', 'wallet_debit_and_order_paid', 'Wallet debit succeeded and order marked paid', '{\"amount\":300,\"currency\":\"THB\",\"bookings_count\":1}', '/b2b/api/checkout/pay-wallet', 'POST', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36 Edg/139.0.0.0', 200, '2025-08-26 13:15:04');

-- --------------------------------------------------------

--
-- Table structure for table `support_messages`
--

CREATE TABLE `support_messages` (
  `id` int(11) NOT NULL,
  `ticket_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `support_tickets`
--

CREATE TABLE `support_tickets` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `subject` varchar(200) NOT NULL,
  `status` enum('open','closed') NOT NULL DEFAULT 'open',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `taxis`
--

CREATE TABLE `taxis` (
  `id` int(11) NOT NULL,
  `vendor_id` int(11) NOT NULL,
  `name` varchar(200) NOT NULL,
  `route` varchar(200) NOT NULL,
  `base_price` decimal(10,2) NOT NULL DEFAULT 0.00,
  `title` varchar(200) DEFAULT NULL,
  `vehicle_type` enum('sedan','suv','van','bus','luxury','other') DEFAULT NULL,
  `capacity` int(11) DEFAULT NULL,
  `luggage_capacity` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `series_no` varchar(32) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `taxis`
--

INSERT INTO `taxis` (`id`, `vendor_id`, `name`, `route`, `base_price`, `title`, `vehicle_type`, `capacity`, `luggage_capacity`, `description`, `active`, `series_no`) VALUES
(3, 7, 'SUV VAR Bangkok airport - Pattaya Hotel', 'BKK-Pattaya', 2500.00, 'SUV VAR Bangkok airport - Pattaya Hotel2', 'van', 8, NULL, NULL, 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `taxi_availability`
--

CREATE TABLE `taxi_availability` (
  `id` int(11) NOT NULL,
  `taxi_id` int(11) NOT NULL,
  `dow` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`dow`)),
  `blackout_dates` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`blackout_dates`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `taxi_availability`
--

INSERT INTO `taxi_availability` (`id`, `taxi_id`, `dow`, `blackout_dates`, `created_at`) VALUES
(6, 3, '{\"mon\":{\"on\":0,\"start\":null,\"end\":null},\"tue\":{\"on\":0,\"start\":null,\"end\":null},\"wed\":{\"on\":0,\"start\":null,\"end\":null},\"thu\":{\"on\":0,\"start\":null,\"end\":null},\"fri\":{\"on\":0,\"start\":null,\"end\":null},\"sat\":{\"on\":0,\"start\":null,\"end\":null},\"sun\":{\"on\":0,\"start\":null,\"end\":null}}', '[]', '2025-08-26 13:00:44');

-- --------------------------------------------------------

--
-- Table structure for table `taxi_companies`
--

CREATE TABLE `taxi_companies` (
  `id` int(11) NOT NULL,
  `name` varchar(150) NOT NULL,
  `support_phone` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `taxi_images`
--

CREATE TABLE `taxi_images` (
  `id` int(11) NOT NULL,
  `taxi_id` int(11) NOT NULL,
  `file_path` varchar(255) NOT NULL,
  `is_cover` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `taxi_images`
--

INSERT INTO `taxi_images` (`id`, `taxi_id`, `file_path`, `is_cover`, `created_at`) VALUES
(13, 3, '/assets/uploads/2464a58c026c029d.jpg', 1, '2025-08-26 13:00:44'),
(14, 3, '/assets/uploads/10d841c1095af883.jpg', 0, '2025-08-26 13:00:44');

-- --------------------------------------------------------

--
-- Table structure for table `taxi_prices`
--

CREATE TABLE `taxi_prices` (
  `id` int(11) NOT NULL,
  `taxi_id` int(11) NOT NULL,
  `company_id` int(11) DEFAULT NULL,
  `is_group` tinyint(1) NOT NULL DEFAULT 0,
  `pax_threshold` int(11) DEFAULT NULL,
  `price` decimal(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `taxi_pricing`
--

CREATE TABLE `taxi_pricing` (
  `id` int(11) NOT NULL,
  `taxi_id` int(11) NOT NULL,
  `model` enum('fixed','distance','hourly') NOT NULL DEFAULT 'fixed',
  `currency` char(3) NOT NULL DEFAULT 'THB',
  `base_fare` decimal(10,2) NOT NULL DEFAULT 0.00,
  `per_km` decimal(10,2) DEFAULT NULL,
  `per_hour` decimal(10,2) DEFAULT NULL,
  `wait_per_hour` decimal(10,2) DEFAULT NULL,
  `min_km` decimal(10,2) DEFAULT NULL,
  `min_hours` decimal(10,2) DEFAULT NULL,
  `tax_pct` decimal(5,2) DEFAULT NULL,
  `fee_pct` decimal(5,2) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `taxi_pricing`
--

INSERT INTO `taxi_pricing` (`id`, `taxi_id`, `model`, `currency`, `base_fare`, `per_km`, `per_hour`, `wait_per_hour`, `min_km`, `min_hours`, `tax_pct`, `fee_pct`, `created_at`) VALUES
(1, 3, 'fixed', 'THB', 2500.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-18 05:55:23'),
(2, 3, 'fixed', 'THB', 2500.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-18 06:40:12'),
(3, 3, 'fixed', 'THB', 2500.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-18 06:40:45'),
(4, 3, 'fixed', 'THB', 2500.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-18 06:46:16'),
(5, 3, 'fixed', 'THB', 2500.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-18 06:46:32');

-- --------------------------------------------------------

--
-- Table structure for table `taxi_routes`
--

CREATE TABLE `taxi_routes` (
  `id` int(11) NOT NULL,
  `taxi_id` int(11) NOT NULL,
  `pickup_name` varchar(150) NOT NULL,
  `pickup_lat` decimal(10,7) DEFAULT NULL,
  `pickup_lng` decimal(10,7) DEFAULT NULL,
  `drop_name` varchar(150) NOT NULL,
  `drop_lat` decimal(10,7) DEFAULT NULL,
  `drop_lng` decimal(10,7) DEFAULT NULL,
  `notes` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `taxi_routes`
--

INSERT INTO `taxi_routes` (`id`, `taxi_id`, `pickup_name`, `pickup_lat`, `pickup_lng`, `drop_name`, `drop_lat`, `drop_lng`, `notes`, `created_at`) VALUES
(6, 3, 'BKK', NULL, NULL, 'Pattaya', NULL, NULL, NULL, '2025-08-26 13:00:44');

-- --------------------------------------------------------

--
-- Table structure for table `tickets`
--

CREATE TABLE `tickets` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `subject` varchar(200) NOT NULL,
  `message` text NOT NULL,
  `status` enum('open','closed') NOT NULL DEFAULT 'open',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `email` varchar(150) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role` enum('Admin','Employee','Channel Partner','B2B Agent','Vendor','Customer') NOT NULL DEFAULT 'Employee',
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `partner_id` int(11) DEFAULT NULL,
  `transaction_password_hash` varchar(255) DEFAULT NULL,
  `tx_pin_enc` varbinary(255) DEFAULT NULL,
  `tx_pin_iv` varbinary(16) DEFAULT NULL,
  `tx_pin_tag` varbinary(16) DEFAULT NULL,
  `require_tx_password` tinyint(1) NOT NULL DEFAULT 0,
  `tx_pin_attempts` int(11) NOT NULL DEFAULT 0,
  `tx_pin_locked_until` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `name`, `email`, `password`, `role`, `status`, `created_at`, `partner_id`, `transaction_password_hash`, `tx_pin_enc`, `tx_pin_iv`, `tx_pin_tag`, `require_tx_password`, `tx_pin_attempts`, `tx_pin_locked_until`) VALUES
(1, 'Admin', 'admin@example.com', '$2y$10$VwXuoZvmx4FiLGUerNhzsuDFFLttC8K6FYbAJ0U3Eposps/8rB8O6', 'Admin', 'Active', '2025-08-14 18:50:21', NULL, NULL, NULL, NULL, NULL, 0, 0, NULL),
(2, 'Super Admin', 'admin2@example.com', '$2y$10$VwXuoZvmx4FiLGUerNhzsuDFFLttC8K6FYbAJ0U3Eposps/8rB8O6', 'Admin', 'Active', '2025-08-14 19:16:39', NULL, NULL, NULL, NULL, NULL, 0, 0, NULL),
(3, 'Super Admin', 'admin3@example.com', '$2y$10$MZaWRSvx5DrCMvZPMlUE4uQICavndw6ZZkAGqPej/Q9.y2/fnpn5e', 'Admin', 'Active', '2025-08-14 21:09:00', NULL, NULL, NULL, NULL, NULL, 0, 0, NULL),
(6, 'JITENDRA', 'ancientjbr@gmail.com', '$2y$10$3vBQp862upglCQlA930.z.XTHrMIViPCzDuRwxsCrmI7u7BQYfaIK', 'B2B Agent', 'Active', '2025-08-16 06:31:04', NULL, NULL, NULL, NULL, NULL, 0, 0, NULL),
(10, 'KARNI Digital Solution', 'ancientjbr2@gmail.com', '$2y$10$AwtCIpp1/5SDsWjCdAkWiO2ZC63NKANKTkK/yGBHSqzE9JKdUOhD.', 'B2B Agent', 'Active', '2025-08-16 07:53:40', NULL, '$2y$10$mMYPgXD89oXMvsZPKrwUFudhJioOw4RphHFOKsUAsCXBaNrp7AfV2', 0xb44b06b4b2d3, 0x4fb5980717146b7ecba1bc4a, 0xbb06ee05004a4f3de17e998e0745ac3b, 0, 0, NULL),
(11, 'K DIGITAL SOLUTIONS', 'k@gmail.com', '$2y$10$QLEmodBvPf1XDUiYMeoFqO02zzKwBSQ4QMd3UfSz5x2D.stkf3z8K', 'Channel Partner', 'Active', '2025-08-16 08:29:57', NULL, NULL, NULL, NULL, NULL, 0, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `user_sessions`
--

CREATE TABLE `user_sessions` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `session_id` varchar(128) NOT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `last_seen` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `vendors`
--

CREATE TABLE `vendors` (
  `id` int(11) NOT NULL,
  `name` varchar(150) NOT NULL,
  `contact_email` varchar(150) DEFAULT NULL,
  `company_name` varchar(150) DEFAULT NULL,
  `module` enum('hotel','activity','taxi','evisa','other') DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `whatsapp_number` varchar(30) DEFAULT NULL,
  `calling_number` varchar(30) DEFAULT NULL,
  `line_id` varchar(100) DEFAULT NULL,
  `enquiry_email` varchar(150) DEFAULT NULL,
  `confirm_email` varchar(150) DEFAULT NULL,
  `is_adult_only` tinyint(1) NOT NULL DEFAULT 0,
  `is_family_allowed` tinyint(1) NOT NULL DEFAULT 1,
  `has_show_times` tinyint(1) NOT NULL DEFAULT 0,
  `show_times` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`show_times`)),
  `last_booking_cutoff` time DEFAULT NULL,
  `vat_number` varchar(50) DEFAULT NULL,
  `tat_number` varchar(50) DEFAULT NULL,
  `bank_account` varchar(100) DEFAULT NULL,
  `contact_person_name` varchar(150) DEFAULT NULL,
  `contact_person_phone` varchar(50) DEFAULT NULL,
  `contact_person_email` varchar(150) DEFAULT NULL,
  `bank_name` varchar(150) DEFAULT NULL,
  `bank_branch` varchar(150) DEFAULT NULL,
  `bank_account_name` varchar(150) DEFAULT NULL,
  `bank_swift` varchar(50) DEFAULT NULL,
  `bank_iban` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `vendors`
--

INSERT INTO `vendors` (`id`, `name`, `contact_email`, `company_name`, `module`, `country`, `city`, `address`, `whatsapp_number`, `calling_number`, `line_id`, `enquiry_email`, `confirm_email`, `is_adult_only`, `is_family_allowed`, `has_show_times`, `show_times`, `last_booking_cutoff`, `vat_number`, `tat_number`, `bank_account`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `bank_name`, `bank_branch`, `bank_account_name`, `bank_swift`, `bank_iban`) VALUES
(3, 'Alcazar Cabaret Show', 'alcazarshow@hotmail.com', 'Alcazar Co., Ltd.', 'activity', 'Thailand', 'Pattaya', 'Pattaya', '+66 3841 0224', '+66 3841 0224', NULL, 'alcazarshow@hotmail.com', 'alcazarshow@hotmail.com', 0, 1, 1, '[\"21:30\"]', '13:00:00', '123456', '123456', '123456789', 'abc', '356588888', NULL, 'K BANK', 'PATTAYA', 'OK', NULL, NULL),
(5, 'Coral Island', 'ok@ok.com', 'Oversea company', 'activity', 'Thailand', 'Pattaya', 'pattaya', '00000', '0000', NULL, 'ok@ok.com', 'ok@ok.com', 0, 1, 0, NULL, '11:00:00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(6, 'Sunshine Taxi Service', 'ok@ok.com', 'SunShine Taxi Services', 'taxi', 'Thailand', 'Pattaya', 'Pattay', '0000', '00000', NULL, 'ok@ok.com', 'ok@ok.com', 0, 1, 0, NULL, NULL, NULL, NULL, '1234-12444-144', 'Sunshin', '0000', 'ok@ok.com', 'K bank', 'Pattaya', 'Sunshine', NULL, NULL),
(7, 'Spice Taxi Service', NULL, 'Spice Taxi Service', 'taxi', 'Thailand', 'Pattaya', 'Ok', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(8, 'FX Hotel Co.', NULL, 'FX Hotel Co.Ltd', 'hotel', 'Thailand', 'Pattaya', 'Pattaya', NULL, NULL, NULL, NULL, NULL, 0, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `vendor_bank_accounts`
--

CREATE TABLE `vendor_bank_accounts` (
  `id` int(11) NOT NULL,
  `vendor_id` int(11) NOT NULL,
  `bank_name` varchar(120) DEFAULT NULL,
  `account_name` varchar(120) DEFAULT NULL,
  `account_number` varchar(64) DEFAULT NULL,
  `swift_code` varchar(32) DEFAULT NULL,
  `json_details` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`json_details`))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `vendor_packages`
--

CREATE TABLE `vendor_packages` (
  `id` int(11) NOT NULL,
  `vendor_id` int(11) NOT NULL,
  `name` varchar(150) NOT NULL,
  `module` enum('activity','hotel','taxi','evisa') NOT NULL DEFAULT 'activity',
  `requires_show_time` tinyint(1) NOT NULL DEFAULT 1,
  `age_policy` enum('adult_only','family') NOT NULL DEFAULT 'adult_only',
  `address_override` text DEFAULT NULL,
  `thumbnail_path` varchar(255) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `vendor_packages`
--

INSERT INTO `vendor_packages` (`id`, `vendor_id`, `name`, `module`, `requires_show_time`, `age_policy`, `address_override`, `thumbnail_path`, `active`, `created_at`, `updated_at`) VALUES
(2, 5, 'Coral Island', 'activity', 0, 'family', NULL, '/assets/uploads/packages/pkg_5_1755228536_58b27f17.jpg', 1, '2025-08-15 03:28:56', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `vendor_package_prices`
--

CREATE TABLE `vendor_package_prices` (
  `id` int(11) NOT NULL,
  `package_id` int(11) NOT NULL,
  `variant_id` int(11) NOT NULL,
  `price_type` enum('base','group_tier') NOT NULL DEFAULT 'base',
  `pax_type` enum('adult','child','flat') NOT NULL DEFAULT 'adult',
  `min_quantity` int(11) DEFAULT NULL,
  `vendor_cost` decimal(10,2) NOT NULL,
  `agent_price` decimal(10,2) NOT NULL,
  `customer_price` decimal(10,2) DEFAULT NULL,
  `customer_promo_price` decimal(10,2) DEFAULT NULL,
  `promo_start_at` datetime DEFAULT NULL,
  `promo_end_at` datetime DEFAULT NULL,
  `currency` char(3) NOT NULL DEFAULT 'THB',
  `pickup_type` enum('none','included','optional') NOT NULL DEFAULT 'none',
  `pickup_scope` enum('pickup_only','pickup_and_drop') NOT NULL DEFAULT 'pickup_and_drop',
  `pickup_radius_km` decimal(4,1) DEFAULT NULL,
  `pickup_fee` decimal(10,2) DEFAULT NULL,
  `pickup_notes` varchar(255) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `vendor_package_prices`
--

INSERT INTO `vendor_package_prices` (`id`, `package_id`, `variant_id`, `price_type`, `pax_type`, `min_quantity`, `vendor_cost`, `agent_price`, `customer_price`, `customer_promo_price`, `promo_start_at`, `promo_end_at`, `currency`, `pickup_type`, `pickup_scope`, `pickup_radius_km`, `pickup_fee`, `pickup_notes`, `active`, `created_at`, `updated_at`) VALUES
(4, 2, 3, 'base', 'adult', 150, 100.00, 150.00, NULL, NULL, NULL, NULL, 'THB', 'none', 'pickup_and_drop', NULL, NULL, NULL, 1, '2025-08-15 03:30:41', NULL),
(5, 2, 3, 'base', 'child', 1, 100.00, 150.00, NULL, NULL, NULL, NULL, 'THB', 'none', 'pickup_and_drop', NULL, NULL, NULL, 1, '2025-08-15 03:31:01', NULL),
(6, 2, 3, 'base', 'flat', 1, 100.00, 100.00, NULL, NULL, NULL, NULL, 'THB', 'none', 'pickup_and_drop', NULL, NULL, NULL, 1, '2025-08-15 03:31:22', NULL),
(7, 2, 4, 'base', 'adult', 1, 1500.00, 1800.00, NULL, NULL, NULL, NULL, 'THB', 'none', 'pickup_and_drop', NULL, NULL, NULL, 1, '2025-08-15 03:34:09', '2025-08-16 01:17:03'),
(8, 2, 4, 'base', 'child', 1, 1500.00, 1800.00, NULL, NULL, NULL, NULL, 'THB', 'included', 'pickup_and_drop', NULL, NULL, NULL, 1, '2025-08-15 03:34:35', '2025-08-16 01:03:57'),
(9, 2, 4, 'base', 'flat', 10, 1300.00, 1400.00, 1800.00, 1900.00, '2025-08-16 07:51:00', '2025-08-16 07:51:00', 'THB', 'none', 'pickup_and_drop', NULL, NULL, NULL, 1, '2025-08-15 03:34:57', '2025-08-16 00:47:34');

-- --------------------------------------------------------

--
-- Table structure for table `vendor_package_showtimes`
--

CREATE TABLE `vendor_package_showtimes` (
  `id` int(11) NOT NULL,
  `package_id` int(11) NOT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `time` varchar(8) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `vendor_package_variants`
--

CREATE TABLE `vendor_package_variants` (
  `id` int(11) NOT NULL,
  `package_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `notes` text DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `vendor_package_variants`
--

INSERT INTO `vendor_package_variants` (`id`, `package_id`, `name`, `notes`, `active`, `created_at`, `updated_at`) VALUES
(3, 2, 'Basic Coral Island with Lunch', NULL, 1, '2025-08-15 03:30:16', NULL),
(4, 2, 'Coral Island Full Package with Lunch', 'Pickup and Drop Free,Best', 1, '2025-08-15 03:33:34', '2025-08-16 01:28:10'),
(5, 2, 'CORAL ISLAND EXTRA', NULL, 1, '2025-08-26 13:08:58', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `vendor_users`
--

CREATE TABLE `vendor_users` (
  `id` int(11) NOT NULL,
  `vendor_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `role` varchar(50) DEFAULT 'Manager'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `wallets`
--

CREATE TABLE `wallets` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `balance` decimal(12,2) NOT NULL DEFAULT 0.00
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `wallets`
--

INSERT INTO `wallets` (`id`, `user_id`, `balance`) VALUES
(1, 1, 0.00),
(3, 6, 5000.00),
(7, 10, 650.00),
(8, 11, 0.00),
(9, 3, 9000.00);

-- --------------------------------------------------------

--
-- Table structure for table `wallet_ledger`
--

CREATE TABLE `wallet_ledger` (
  `id` int(11) NOT NULL,
  `wallet_id` int(11) NOT NULL,
  `type` enum('credit','debit') NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `method` enum('stripe','manual') NOT NULL,
  `status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`meta`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `wallet_ledger`
--

INSERT INTO `wallet_ledger` (`id`, `wallet_id`, `type`, `amount`, `method`, `status`, `meta`, `created_at`) VALUES
(1, 1, 'credit', 5000.00, 'manual', 'pending', '{\"note\":\"ok given\",\"by\":\"admin\"}', '2025-08-14 19:58:01'),
(2, 1, 'debit', 500.00, 'manual', 'pending', '{\"note\":\"\",\"by\":\"admin\"}', '2025-08-14 19:58:25'),
(3, 8, 'credit', 100.00, 'manual', 'pending', '{\"note\":\"\",\"by\":\"admin\"}', '2025-08-16 09:07:03'),
(4, 9, 'credit', 10000.00, 'manual', 'approved', '{\"reason\":\"treasury_seed\",\"by\":\"admin_controller\",\"ip\":\"::1\",\"at\":\"2025-08-16T11:24:51+02:00\"}', '2025-08-16 09:24:51'),
(5, 9, 'debit', 500.00, 'manual', 'approved', '{\"flow\":\"admin_to_partner\",\"ip\":\"::1\",\"at\":\"2025-08-16T11:31:47+02:00\"}', '2025-08-16 09:31:47'),
(6, 9, 'debit', 8000.00, 'manual', 'approved', '{\"flow\":\"admin_to_agent\",\"from_admin_email\":\"admin3@example.com\",\"to_user_id\":10,\"ip\":\"::1\",\"at\":\"2025-08-16T11:52:58+02:00\"}', '2025-08-16 09:52:58'),
(7, 7, 'credit', 8000.00, 'manual', 'approved', '{\"flow\":\"admin_to_agent\",\"from_admin_email\":\"admin3@example.com\",\"to_user_id\":10,\"ip\":\"::1\",\"at\":\"2025-08-16T11:52:58+02:00\"}', '2025-08-16 09:52:58'),
(8, 7, 'debit', 2000.00, 'manual', 'approved', '{\"flow\":\"reverse_admin_to_agent\",\"reason\":\"ok\",\"reversed_at\":\"2025-08-16 12:09:14\",\"original_from_user_id\":3,\"original_to_user_id\":10,\"reversal_of_flow\":\"admin_to_agent\",\"from_admin_id\":3,\"from_admin_email\":\"admin3@example.com\",\"agent_user_id\":10,\"ip\":\"::1\",\"at\":\"2025-08-16T12:09:14+02:00\"}', '2025-08-16 10:09:14'),
(9, 9, 'credit', 2000.00, 'manual', 'approved', '{\"flow\":\"reverse_admin_to_agent\",\"reason\":\"ok\",\"reversed_at\":\"2025-08-16 12:09:14\",\"original_from_user_id\":3,\"original_to_user_id\":10,\"reversal_of_flow\":\"admin_to_agent\",\"from_admin_id\":3,\"from_admin_email\":\"admin3@example.com\",\"agent_user_id\":10,\"ip\":\"::1\",\"at\":\"2025-08-16T12:09:14+02:00\"}', '2025-08-16 10:09:14'),
(10, 9, 'credit', 500.00, 'manual', 'approved', '{\"flow\":\"reverse_admin_to_partner\",\"reason\":\"ok\",\"reversed_at\":\"2025-08-16 12:11:06\",\"original_user_id\":3,\"partner_id\":1,\"reversal_of_flow\":\"admin_to_partner\",\"from_admin_id\":3,\"from_admin_email\":\"admin3@example.com\",\"ip\":\"::1\",\"at\":\"2025-08-16T12:11:06+02:00\"}', '2025-08-16 10:11:06'),
(11, 9, 'debit', 500.00, 'manual', 'approved', '{\"flow\":\"admin_to_partner\",\"from_admin_id\":3,\"from_admin_email\":\"admin3@example.com\",\"partner_id\":1,\"ip\":\"::1\",\"at\":\"2025-08-17T03:00:36+02:00\"}', '2025-08-17 01:00:36'),
(12, 9, 'credit', 500.00, 'manual', 'approved', '{\"reason\":\"treasury_seed\",\"by\":\"admin_controller\",\"ip\":\"::1\",\"at\":\"2025-08-18T12:22:47+02:00\"}', '2025-08-18 10:22:47'),
(27, 7, 'debit', 150.00, 'manual', 'approved', '{\"flow\":\"checkout\",\"order_id\":8}', '2025-08-19 13:22:38'),
(28, 7, 'debit', 300.00, 'manual', 'approved', '{\"flow\":\"checkout\",\"order_id\":9}', '2025-08-19 13:24:40'),
(29, 7, 'debit', 450.00, 'manual', 'approved', '{\"flow\":\"checkout\",\"order_id\":22}', '2025-08-19 14:34:34'),
(30, 7, 'debit', 150.00, 'manual', 'approved', '{\"flow\":\"checkout\",\"order_id\":23}', '2025-08-19 14:43:22'),
(31, 7, 'debit', 150.00, 'manual', 'approved', '{\"flow\":\"checkout\",\"order_id\":24}', '2025-08-19 15:03:59'),
(32, 7, 'debit', 300.00, 'manual', 'approved', '{\"flow\":\"checkout\",\"order_id\":26}', '2025-08-19 15:25:22'),
(33, 7, 'debit', 150.00, 'manual', 'approved', '{\"flow\":\"checkout\",\"order_id\":27}', '2025-08-19 15:42:44'),
(34, 7, 'debit', 150.00, 'manual', 'approved', '{\"flow\":\"checkout\",\"order_id\":28}', '2025-08-19 15:50:41'),
(35, 7, 'debit', 250.00, 'manual', 'approved', '{\"flow\":\"checkout\",\"order_id\":29}', '2025-08-19 22:43:52'),
(36, 7, 'debit', 150.00, 'manual', 'approved', '{\"flow\":\"checkout\",\"order_id\":32}', '2025-08-19 23:31:48'),
(37, 7, 'debit', 300.00, 'manual', 'approved', '{\"flow\":\"checkout\",\"order_id\":33}', '2025-08-20 00:04:19'),
(38, 7, 'debit', 150.00, 'manual', 'approved', '{\"flow\":\"checkout\",\"order_id\":34}', '2025-08-20 00:06:36'),
(39, 7, 'debit', 150.00, 'manual', 'approved', '{\"flow\":\"checkout\",\"order_id\":35}', '2025-08-20 00:25:45'),
(40, 7, 'debit', 150.00, 'manual', 'approved', '{\"flow\":\"checkout\",\"order_id\":36}', '2025-08-20 00:43:31'),
(41, 7, 'debit', 300.00, 'manual', 'approved', '{\"flow\":\"checkout\",\"order_id\":37}', '2025-08-20 00:54:52'),
(42, 7, 'debit', 1800.00, 'manual', 'approved', '{\"flow\":\"checkout\",\"order_id\":50}', '2025-08-20 02:21:02'),
(43, 9, 'credit', 10000.00, 'manual', 'approved', '{\"reason\":\"treasury_seed\",\"by\":\"admin_controller\",\"ip\":\"::1\",\"at\":\"2025-08-26T15:02:40+02:00\"}', '2025-08-26 13:02:40'),
(44, 9, 'debit', 5000.00, 'manual', 'approved', '{\"flow\":\"admin_to_agent\",\"from_admin_id\":3,\"from_admin_email\":\"admin3@example.com\",\"to_user_id\":6,\"ip\":\"::1\",\"at\":\"2025-08-26T15:02:51+02:00\"}', '2025-08-26 13:02:51'),
(45, 3, 'credit', 5000.00, 'manual', 'approved', '{\"flow\":\"admin_to_agent\",\"from_admin_id\":3,\"from_admin_email\":\"admin3@example.com\",\"to_user_id\":6,\"ip\":\"::1\",\"at\":\"2025-08-26T15:02:51+02:00\"}', '2025-08-26 13:02:51'),
(46, 7, 'debit', 300.00, 'manual', 'approved', '{\"flow\":\"checkout\",\"order_id\":57}', '2025-08-26 13:15:04');

-- --------------------------------------------------------

--
-- Table structure for table `wallet_requests`
--

CREATE TABLE `wallet_requests` (
  `id` int(11) NOT NULL,
  `wallet_id` int(11) NOT NULL,
  `type` enum('topup','withdraw') NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`meta`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `whatsapp_logs`
--

CREATE TABLE `whatsapp_logs` (
  `id` int(11) NOT NULL,
  `to_number` varchar(30) NOT NULL,
  `message` text DEFAULT NULL,
  `meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`meta`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `activities`
--
ALTER TABLE `activities`
  ADD PRIMARY KEY (`id`),
  ADD KEY `vendor_id` (`vendor_id`);

--
-- Indexes for table `activity_prices`
--
ALTER TABLE `activity_prices`
  ADD PRIMARY KEY (`id`),
  ADD KEY `activity_id` (`activity_id`),
  ADD KEY `tier_id` (`tier_id`),
  ADD KEY `showtime_id` (`showtime_id`);

--
-- Indexes for table `activity_showtimes`
--
ALTER TABLE `activity_showtimes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `activity_id` (`activity_id`);

--
-- Indexes for table `activity_tiers`
--
ALTER TABLE `activity_tiers`
  ADD PRIMARY KEY (`id`),
  ADD KEY `activity_id` (`activity_id`);

--
-- Indexes for table `agent_business_docs`
--
ALTER TABLE `agent_business_docs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `agent_kyc`
--
ALTER TABLE `agent_kyc`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `agent_profiles`
--
ALTER TABLE `agent_profiles`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_agent_profile` (`user_id`);

--
-- Indexes for table `agent_settings`
--
ALTER TABLE `agent_settings`
  ADD PRIMARY KEY (`user_id`);

--
-- Indexes for table `api_tokens`
--
ALTER TABLE `api_tokens`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `token` (`token`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `attachments`
--
ALTER TABLE `attachments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `ticket_id` (`ticket_id`),
  ADD KEY `message_id` (`message_id`);

--
-- Indexes for table `audit_logs`
--
ALTER TABLE `audit_logs`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `blackout_windows`
--
ALTER TABLE `blackout_windows`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `bookings`
--
ALTER TABLE `bookings`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_bookings_order` (`order_id`),
  ADD KEY `idx_bookings_user` (`user_id`),
  ADD KEY `idx_bookings_status` (`status`),
  ADD KEY `idx_bookings_module_item` (`module`,`item_id`);

--
-- Indexes for table `calendars`
--
ALTER TABLE `calendars`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_date` (`module`,`item_id`,`date`);

--
-- Indexes for table `calendar_overrides`
--
ALTER TABLE `calendar_overrides`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_override` (`module`,`item_id`,`date`);

--
-- Indexes for table `channel_partners`
--
ALTER TABLE `channel_partners`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `channel_partner_agents`
--
ALTER TABLE `channel_partner_agents`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_partner_agent` (`partner_id`,`agent_user_id`),
  ADD KEY `agent_user_id` (`agent_user_id`);

--
-- Indexes for table `channel_partner_commissions`
--
ALTER TABLE `channel_partner_commissions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `partner_id` (`partner_id`),
  ADD KEY `booking_id` (`booking_id`);

--
-- Indexes for table `channel_partner_settings`
--
ALTER TABLE `channel_partner_settings`
  ADD PRIMARY KEY (`partner_id`),
  ADD UNIQUE KEY `uniq_partner` (`partner_id`);

--
-- Indexes for table `channel_partner_wallet`
--
ALTER TABLE `channel_partner_wallet`
  ADD PRIMARY KEY (`id`),
  ADD KEY `partner_id` (`partner_id`);

--
-- Indexes for table `channel_partner_wallet_ledger`
--
ALTER TABLE `channel_partner_wallet_ledger`
  ADD PRIMARY KEY (`id`),
  ADD KEY `wallet_id` (`wallet_id`);

--
-- Indexes for table `corporate_accounts`
--
ALTER TABLE `corporate_accounts`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `corporate_mappings`
--
ALTER TABLE `corporate_mappings`
  ADD PRIMARY KEY (`id`),
  ADD KEY `account_id` (`account_id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `corporate_rates`
--
ALTER TABLE `corporate_rates`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `country_currencies`
--
ALTER TABLE `country_currencies`
  ADD PRIMARY KEY (`country`);

--
-- Indexes for table `currencies`
--
ALTER TABLE `currencies`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `code` (`code`);

--
-- Indexes for table `db_patches`
--
ALTER TABLE `db_patches`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `filename` (`filename`);

--
-- Indexes for table `email_logs`
--
ALTER TABLE `email_logs`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `evisas`
--
ALTER TABLE `evisas`
  ADD PRIMARY KEY (`id`),
  ADD KEY `vendor_id` (`vendor_id`);

--
-- Indexes for table `evisa_applications`
--
ALTER TABLE `evisa_applications`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `type_id` (`type_id`);

--
-- Indexes for table `evisa_docs`
--
ALTER TABLE `evisa_docs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `type_id` (`type_id`);

--
-- Indexes for table `evisa_types`
--
ALTER TABLE `evisa_types`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `group_pricing`
--
ALTER TABLE `group_pricing`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `hotels`
--
ALTER TABLE `hotels`
  ADD PRIMARY KEY (`id`),
  ADD KEY `vendor_id` (`vendor_id`);

--
-- Indexes for table `hotel_bookings`
--
ALTER TABLE `hotel_bookings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_booking_code` (`booking_code`),
  ADD KEY `hotel_id` (`hotel_id`),
  ADD KEY `vendor_id` (`vendor_id`),
  ADD KEY `room_id` (`room_id`),
  ADD KEY `rate_plan_id` (`rate_plan_id`);

--
-- Indexes for table `hotel_gallery`
--
ALTER TABLE `hotel_gallery`
  ADD PRIMARY KEY (`id`),
  ADD KEY `hotel_id` (`hotel_id`);

--
-- Indexes for table `hotel_images`
--
ALTER TABLE `hotel_images`
  ADD PRIMARY KEY (`id`),
  ADD KEY `hotel_id` (`hotel_id`),
  ADD KEY `room_id` (`room_id`);

--
-- Indexes for table `hotel_policies`
--
ALTER TABLE `hotel_policies`
  ADD PRIMARY KEY (`id`),
  ADD KEY `hotel_id` (`hotel_id`);

--
-- Indexes for table `hotel_rooms`
--
ALTER TABLE `hotel_rooms`
  ADD PRIMARY KEY (`id`),
  ADD KEY `hotel_id` (`hotel_id`);

--
-- Indexes for table `hotel_room_prices`
--
ALTER TABLE `hotel_room_prices`
  ADD PRIMARY KEY (`id`),
  ADD KEY `room_id` (`room_id`);

--
-- Indexes for table `ip_action_logs`
--
ALTER TABLE `ip_action_logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `locations`
--
ALTER TABLE `locations`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `modules`
--
ALTER TABLE `modules`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`),
  ADD UNIQUE KEY `slug` (`slug`);

--
-- Indexes for table `orders`
--
ALTER TABLE `orders`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `order_items`
--
ALTER TABLE `order_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_order_items_order` (`order_id`),
  ADD KEY `idx_order_items_booking` (`booking_id`);

--
-- Indexes for table `packages`
--
ALTER TABLE `packages`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `package_items`
--
ALTER TABLE `package_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `package_id` (`package_id`);

--
-- Indexes for table `partner_commissions`
--
ALTER TABLE `partner_commissions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `booking_id` (`booking_id`),
  ADD KEY `partner_user_id` (`partner_user_id`);

--
-- Indexes for table `payments`
--
ALTER TABLE `payments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `order_id` (`order_id`);

--
-- Indexes for table `promo_codes`
--
ALTER TABLE `promo_codes`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `code` (`code`);

--
-- Indexes for table `promo_redemptions`
--
ALTER TABLE `promo_redemptions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `promo_id` (`promo_id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `booking_id` (`booking_id`);

--
-- Indexes for table `rate_plans`
--
ALTER TABLE `rate_plans`
  ADD PRIMARY KEY (`id`),
  ADD KEY `hotel_id` (`hotel_id`);

--
-- Indexes for table `room_allocations`
--
ALTER TABLE `room_allocations`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_alloc` (`room_id`,`date`);

--
-- Indexes for table `room_prices`
--
ALTER TABLE `room_prices`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_price` (`room_id`,`rate_plan_id`,`date`),
  ADD KEY `rate_plan_id` (`rate_plan_id`);

--
-- Indexes for table `security_audit_events`
--
ALTER TABLE `security_audit_events`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_event_type_created` (`event_type`,`created_at`),
  ADD KEY `idx_user_created` (`user_id`,`created_at`),
  ADD KEY `idx_agent_created` (`agent_id`,`created_at`),
  ADD KEY `idx_order_created` (`order_id`,`created_at`);

--
-- Indexes for table `support_messages`
--
ALTER TABLE `support_messages`
  ADD PRIMARY KEY (`id`),
  ADD KEY `ticket_id` (`ticket_id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `support_tickets`
--
ALTER TABLE `support_tickets`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `taxis`
--
ALTER TABLE `taxis`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_taxi_series` (`series_no`),
  ADD KEY `vendor_id` (`vendor_id`);

--
-- Indexes for table `taxi_availability`
--
ALTER TABLE `taxi_availability`
  ADD PRIMARY KEY (`id`),
  ADD KEY `taxi_id` (`taxi_id`);

--
-- Indexes for table `taxi_companies`
--
ALTER TABLE `taxi_companies`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `taxi_images`
--
ALTER TABLE `taxi_images`
  ADD PRIMARY KEY (`id`),
  ADD KEY `taxi_id` (`taxi_id`);

--
-- Indexes for table `taxi_prices`
--
ALTER TABLE `taxi_prices`
  ADD PRIMARY KEY (`id`),
  ADD KEY `taxi_id` (`taxi_id`),
  ADD KEY `company_id` (`company_id`);

--
-- Indexes for table `taxi_pricing`
--
ALTER TABLE `taxi_pricing`
  ADD PRIMARY KEY (`id`),
  ADD KEY `taxi_id` (`taxi_id`);

--
-- Indexes for table `taxi_routes`
--
ALTER TABLE `taxi_routes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `taxi_id` (`taxi_id`);

--
-- Indexes for table `tickets`
--
ALTER TABLE `tickets`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `email` (`email`);

--
-- Indexes for table `user_sessions`
--
ALTER TABLE `user_sessions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_user_session` (`user_id`,`session_id`);

--
-- Indexes for table `vendors`
--
ALTER TABLE `vendors`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_vendors_module_city` (`name`);

--
-- Indexes for table `vendor_bank_accounts`
--
ALTER TABLE `vendor_bank_accounts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `vendor_id` (`vendor_id`);

--
-- Indexes for table `vendor_packages`
--
ALTER TABLE `vendor_packages`
  ADD PRIMARY KEY (`id`),
  ADD KEY `vendor_id` (`vendor_id`);

--
-- Indexes for table `vendor_package_prices`
--
ALTER TABLE `vendor_package_prices`
  ADD PRIMARY KEY (`id`),
  ADD KEY `package_id` (`package_id`),
  ADD KEY `variant_id` (`variant_id`);

--
-- Indexes for table `vendor_package_showtimes`
--
ALTER TABLE `vendor_package_showtimes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `package_id` (`package_id`),
  ADD KEY `variant_id` (`variant_id`);

--
-- Indexes for table `vendor_package_variants`
--
ALTER TABLE `vendor_package_variants`
  ADD PRIMARY KEY (`id`),
  ADD KEY `package_id` (`package_id`);

--
-- Indexes for table `vendor_users`
--
ALTER TABLE `vendor_users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_vendor_user` (`vendor_id`,`user_id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `wallets`
--
ALTER TABLE `wallets`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `wallet_ledger`
--
ALTER TABLE `wallet_ledger`
  ADD PRIMARY KEY (`id`),
  ADD KEY `wallet_id` (`wallet_id`);

--
-- Indexes for table `wallet_requests`
--
ALTER TABLE `wallet_requests`
  ADD PRIMARY KEY (`id`),
  ADD KEY `wallet_id` (`wallet_id`);

--
-- Indexes for table `whatsapp_logs`
--
ALTER TABLE `whatsapp_logs`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `activities`
--
ALTER TABLE `activities`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `activity_prices`
--
ALTER TABLE `activity_prices`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `activity_showtimes`
--
ALTER TABLE `activity_showtimes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `activity_tiers`
--
ALTER TABLE `activity_tiers`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `agent_business_docs`
--
ALTER TABLE `agent_business_docs`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `agent_kyc`
--
ALTER TABLE `agent_kyc`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `agent_profiles`
--
ALTER TABLE `agent_profiles`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;

--
-- AUTO_INCREMENT for table `api_tokens`
--
ALTER TABLE `api_tokens`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `attachments`
--
ALTER TABLE `attachments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `audit_logs`
--
ALTER TABLE `audit_logs`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `blackout_windows`
--
ALTER TABLE `blackout_windows`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `bookings`
--
ALTER TABLE `bookings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=58;

--
-- AUTO_INCREMENT for table `calendars`
--
ALTER TABLE `calendars`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `calendar_overrides`
--
ALTER TABLE `calendar_overrides`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `channel_partners`
--
ALTER TABLE `channel_partners`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `channel_partner_agents`
--
ALTER TABLE `channel_partner_agents`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `channel_partner_commissions`
--
ALTER TABLE `channel_partner_commissions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `channel_partner_wallet`
--
ALTER TABLE `channel_partner_wallet`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `channel_partner_wallet_ledger`
--
ALTER TABLE `channel_partner_wallet_ledger`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `corporate_accounts`
--
ALTER TABLE `corporate_accounts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `corporate_mappings`
--
ALTER TABLE `corporate_mappings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `corporate_rates`
--
ALTER TABLE `corporate_rates`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `currencies`
--
ALTER TABLE `currencies`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `db_patches`
--
ALTER TABLE `db_patches`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `email_logs`
--
ALTER TABLE `email_logs`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `evisas`
--
ALTER TABLE `evisas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `evisa_applications`
--
ALTER TABLE `evisa_applications`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `evisa_docs`
--
ALTER TABLE `evisa_docs`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `evisa_types`
--
ALTER TABLE `evisa_types`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `group_pricing`
--
ALTER TABLE `group_pricing`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `hotels`
--
ALTER TABLE `hotels`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `hotel_bookings`
--
ALTER TABLE `hotel_bookings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `hotel_gallery`
--
ALTER TABLE `hotel_gallery`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `hotel_images`
--
ALTER TABLE `hotel_images`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `hotel_policies`
--
ALTER TABLE `hotel_policies`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `hotel_rooms`
--
ALTER TABLE `hotel_rooms`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `hotel_room_prices`
--
ALTER TABLE `hotel_room_prices`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ip_action_logs`
--
ALTER TABLE `ip_action_logs`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `locations`
--
ALTER TABLE `locations`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `modules`
--
ALTER TABLE `modules`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `orders`
--
ALTER TABLE `orders`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=60;

--
-- AUTO_INCREMENT for table `order_items`
--
ALTER TABLE `order_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=63;

--
-- AUTO_INCREMENT for table `packages`
--
ALTER TABLE `packages`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `package_items`
--
ALTER TABLE `package_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `partner_commissions`
--
ALTER TABLE `partner_commissions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `payments`
--
ALTER TABLE `payments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=32;

--
-- AUTO_INCREMENT for table `promo_codes`
--
ALTER TABLE `promo_codes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `promo_redemptions`
--
ALTER TABLE `promo_redemptions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `rate_plans`
--
ALTER TABLE `rate_plans`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `room_allocations`
--
ALTER TABLE `room_allocations`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=191;

--
-- AUTO_INCREMENT for table `room_prices`
--
ALTER TABLE `room_prices`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=186;

--
-- AUTO_INCREMENT for table `security_audit_events`
--
ALTER TABLE `security_audit_events`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `support_messages`
--
ALTER TABLE `support_messages`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `support_tickets`
--
ALTER TABLE `support_tickets`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `taxis`
--
ALTER TABLE `taxis`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `taxi_availability`
--
ALTER TABLE `taxi_availability`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `taxi_companies`
--
ALTER TABLE `taxi_companies`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `taxi_images`
--
ALTER TABLE `taxi_images`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;

--
-- AUTO_INCREMENT for table `taxi_prices`
--
ALTER TABLE `taxi_prices`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `taxi_pricing`
--
ALTER TABLE `taxi_pricing`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

--
-- AUTO_INCREMENT for table `taxi_routes`
--
ALTER TABLE `taxi_routes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `tickets`
--
ALTER TABLE `tickets`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=18;

--
-- AUTO_INCREMENT for table `user_sessions`
--
ALTER TABLE `user_sessions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `vendors`
--
ALTER TABLE `vendors`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `vendor_bank_accounts`
--
ALTER TABLE `vendor_bank_accounts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `vendor_packages`
--
ALTER TABLE `vendor_packages`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `vendor_package_prices`
--
ALTER TABLE `vendor_package_prices`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `vendor_package_showtimes`
--
ALTER TABLE `vendor_package_showtimes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `vendor_package_variants`
--
ALTER TABLE `vendor_package_variants`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `vendor_users`
--
ALTER TABLE `vendor_users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `wallets`
--
ALTER TABLE `wallets`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `wallet_ledger`
--
ALTER TABLE `wallet_ledger`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=47;

--
-- AUTO_INCREMENT for table `wallet_requests`
--
ALTER TABLE `wallet_requests`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `whatsapp_logs`
--
ALTER TABLE `whatsapp_logs`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `activities`
--
ALTER TABLE `activities`
  ADD CONSTRAINT `activities_ibfk_1` FOREIGN KEY (`vendor_id`) REFERENCES `vendors` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `activity_prices`
--
ALTER TABLE `activity_prices`
  ADD CONSTRAINT `activity_prices_ibfk_1` FOREIGN KEY (`activity_id`) REFERENCES `activities` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `activity_prices_ibfk_2` FOREIGN KEY (`tier_id`) REFERENCES `activity_tiers` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `activity_prices_ibfk_3` FOREIGN KEY (`showtime_id`) REFERENCES `activity_showtimes` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `activity_showtimes`
--
ALTER TABLE `activity_showtimes`
  ADD CONSTRAINT `activity_showtimes_ibfk_1` FOREIGN KEY (`activity_id`) REFERENCES `activities` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `activity_tiers`
--
ALTER TABLE `activity_tiers`
  ADD CONSTRAINT `activity_tiers_ibfk_1` FOREIGN KEY (`activity_id`) REFERENCES `activities` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `agent_business_docs`
--
ALTER TABLE `agent_business_docs`
  ADD CONSTRAINT `agent_business_docs_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `agent_kyc`
--
ALTER TABLE `agent_kyc`
  ADD CONSTRAINT `agent_kyc_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `agent_profiles`
--
ALTER TABLE `agent_profiles`
  ADD CONSTRAINT `agent_profiles_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `agent_settings`
--
ALTER TABLE `agent_settings`
  ADD CONSTRAINT `agent_settings_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `api_tokens`
--
ALTER TABLE `api_tokens`
  ADD CONSTRAINT `api_tokens_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `attachments`
--
ALTER TABLE `attachments`
  ADD CONSTRAINT `attachments_ibfk_1` FOREIGN KEY (`ticket_id`) REFERENCES `support_tickets` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `attachments_ibfk_2` FOREIGN KEY (`message_id`) REFERENCES `support_messages` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `bookings`
--
ALTER TABLE `bookings`
  ADD CONSTRAINT `bookings_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_bookings_order` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `channel_partner_agents`
--
ALTER TABLE `channel_partner_agents`
  ADD CONSTRAINT `channel_partner_agents_ibfk_1` FOREIGN KEY (`partner_id`) REFERENCES `channel_partners` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `channel_partner_agents_ibfk_2` FOREIGN KEY (`agent_user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `channel_partner_commissions`
--
ALTER TABLE `channel_partner_commissions`
  ADD CONSTRAINT `channel_partner_commissions_ibfk_1` FOREIGN KEY (`partner_id`) REFERENCES `channel_partners` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `channel_partner_commissions_ibfk_2` FOREIGN KEY (`booking_id`) REFERENCES `bookings` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `channel_partner_settings`
--
ALTER TABLE `channel_partner_settings`
  ADD CONSTRAINT `channel_partner_settings_ibfk_1` FOREIGN KEY (`partner_id`) REFERENCES `channel_partners` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `channel_partner_wallet`
--
ALTER TABLE `channel_partner_wallet`
  ADD CONSTRAINT `channel_partner_wallet_ibfk_1` FOREIGN KEY (`partner_id`) REFERENCES `channel_partners` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `channel_partner_wallet_ledger`
--
ALTER TABLE `channel_partner_wallet_ledger`
  ADD CONSTRAINT `channel_partner_wallet_ledger_ibfk_1` FOREIGN KEY (`wallet_id`) REFERENCES `channel_partner_wallet` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `corporate_mappings`
--
ALTER TABLE `corporate_mappings`
  ADD CONSTRAINT `corporate_mappings_ibfk_1` FOREIGN KEY (`account_id`) REFERENCES `corporate_accounts` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `corporate_mappings_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `evisas`
--
ALTER TABLE `evisas`
  ADD CONSTRAINT `evisas_ibfk_1` FOREIGN KEY (`vendor_id`) REFERENCES `vendors` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `evisa_applications`
--
ALTER TABLE `evisa_applications`
  ADD CONSTRAINT `evisa_applications_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `evisa_applications_ibfk_2` FOREIGN KEY (`type_id`) REFERENCES `evisa_types` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `evisa_docs`
--
ALTER TABLE `evisa_docs`
  ADD CONSTRAINT `evisa_docs_ibfk_1` FOREIGN KEY (`type_id`) REFERENCES `evisa_types` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `hotels`
--
ALTER TABLE `hotels`
  ADD CONSTRAINT `hotels_ibfk_1` FOREIGN KEY (`vendor_id`) REFERENCES `vendors` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `hotel_bookings`
--
ALTER TABLE `hotel_bookings`
  ADD CONSTRAINT `hotel_bookings_ibfk_1` FOREIGN KEY (`hotel_id`) REFERENCES `hotels` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `hotel_bookings_ibfk_2` FOREIGN KEY (`vendor_id`) REFERENCES `vendors` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `hotel_bookings_ibfk_3` FOREIGN KEY (`room_id`) REFERENCES `hotel_rooms` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `hotel_bookings_ibfk_4` FOREIGN KEY (`rate_plan_id`) REFERENCES `rate_plans` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `hotel_gallery`
--
ALTER TABLE `hotel_gallery`
  ADD CONSTRAINT `hotel_gallery_ibfk_1` FOREIGN KEY (`hotel_id`) REFERENCES `hotels` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `hotel_images`
--
ALTER TABLE `hotel_images`
  ADD CONSTRAINT `hotel_images_ibfk_1` FOREIGN KEY (`hotel_id`) REFERENCES `hotels` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `hotel_images_ibfk_2` FOREIGN KEY (`room_id`) REFERENCES `hotel_rooms` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `hotel_policies`
--
ALTER TABLE `hotel_policies`
  ADD CONSTRAINT `hotel_policies_ibfk_1` FOREIGN KEY (`hotel_id`) REFERENCES `hotels` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `hotel_rooms`
--
ALTER TABLE `hotel_rooms`
  ADD CONSTRAINT `hotel_rooms_ibfk_1` FOREIGN KEY (`hotel_id`) REFERENCES `hotels` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `hotel_room_prices`
--
ALTER TABLE `hotel_room_prices`
  ADD CONSTRAINT `hotel_room_prices_ibfk_1` FOREIGN KEY (`room_id`) REFERENCES `hotel_rooms` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ip_action_logs`
--
ALTER TABLE `ip_action_logs`
  ADD CONSTRAINT `ip_action_logs_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `orders`
--
ALTER TABLE `orders`
  ADD CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `order_items`
--
ALTER TABLE `order_items`
  ADD CONSTRAINT `order_items_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `order_items_ibfk_2` FOREIGN KEY (`booking_id`) REFERENCES `bookings` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `package_items`
--
ALTER TABLE `package_items`
  ADD CONSTRAINT `package_items_ibfk_1` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `partner_commissions`
--
ALTER TABLE `partner_commissions`
  ADD CONSTRAINT `partner_commissions_ibfk_1` FOREIGN KEY (`booking_id`) REFERENCES `bookings` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `partner_commissions_ibfk_2` FOREIGN KEY (`partner_user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `payments`
--
ALTER TABLE `payments`
  ADD CONSTRAINT `payments_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `promo_redemptions`
--
ALTER TABLE `promo_redemptions`
  ADD CONSTRAINT `promo_redemptions_ibfk_1` FOREIGN KEY (`promo_id`) REFERENCES `promo_codes` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `promo_redemptions_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `promo_redemptions_ibfk_3` FOREIGN KEY (`booking_id`) REFERENCES `bookings` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `rate_plans`
--
ALTER TABLE `rate_plans`
  ADD CONSTRAINT `rate_plans_ibfk_1` FOREIGN KEY (`hotel_id`) REFERENCES `hotels` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `room_allocations`
--
ALTER TABLE `room_allocations`
  ADD CONSTRAINT `room_allocations_ibfk_1` FOREIGN KEY (`room_id`) REFERENCES `hotel_rooms` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `room_prices`
--
ALTER TABLE `room_prices`
  ADD CONSTRAINT `room_prices_ibfk_1` FOREIGN KEY (`room_id`) REFERENCES `hotel_rooms` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `room_prices_ibfk_2` FOREIGN KEY (`rate_plan_id`) REFERENCES `rate_plans` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `support_messages`
--
ALTER TABLE `support_messages`
  ADD CONSTRAINT `support_messages_ibfk_1` FOREIGN KEY (`ticket_id`) REFERENCES `support_tickets` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `support_messages_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `support_tickets`
--
ALTER TABLE `support_tickets`
  ADD CONSTRAINT `support_tickets_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `taxis`
--
ALTER TABLE `taxis`
  ADD CONSTRAINT `taxis_ibfk_1` FOREIGN KEY (`vendor_id`) REFERENCES `vendors` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `taxi_availability`
--
ALTER TABLE `taxi_availability`
  ADD CONSTRAINT `taxi_availability_ibfk_1` FOREIGN KEY (`taxi_id`) REFERENCES `taxis` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `taxi_images`
--
ALTER TABLE `taxi_images`
  ADD CONSTRAINT `taxi_images_ibfk_1` FOREIGN KEY (`taxi_id`) REFERENCES `taxis` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `taxi_prices`
--
ALTER TABLE `taxi_prices`
  ADD CONSTRAINT `taxi_prices_ibfk_1` FOREIGN KEY (`taxi_id`) REFERENCES `taxis` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `taxi_prices_ibfk_2` FOREIGN KEY (`company_id`) REFERENCES `taxi_companies` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `taxi_pricing`
--
ALTER TABLE `taxi_pricing`
  ADD CONSTRAINT `taxi_pricing_ibfk_1` FOREIGN KEY (`taxi_id`) REFERENCES `taxis` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `taxi_routes`
--
ALTER TABLE `taxi_routes`
  ADD CONSTRAINT `taxi_routes_ibfk_1` FOREIGN KEY (`taxi_id`) REFERENCES `taxis` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tickets`
--
ALTER TABLE `tickets`
  ADD CONSTRAINT `tickets_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `user_sessions`
--
ALTER TABLE `user_sessions`
  ADD CONSTRAINT `user_sessions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `vendor_bank_accounts`
--
ALTER TABLE `vendor_bank_accounts`
  ADD CONSTRAINT `vendor_bank_accounts_ibfk_1` FOREIGN KEY (`vendor_id`) REFERENCES `vendors` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `vendor_packages`
--
ALTER TABLE `vendor_packages`
  ADD CONSTRAINT `vendor_packages_ibfk_1` FOREIGN KEY (`vendor_id`) REFERENCES `vendors` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `vendor_package_prices`
--
ALTER TABLE `vendor_package_prices`
  ADD CONSTRAINT `vendor_package_prices_ibfk_1` FOREIGN KEY (`package_id`) REFERENCES `vendor_packages` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `vendor_package_prices_ibfk_2` FOREIGN KEY (`variant_id`) REFERENCES `vendor_package_variants` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `vendor_package_showtimes`
--
ALTER TABLE `vendor_package_showtimes`
  ADD CONSTRAINT `vendor_package_showtimes_ibfk_1` FOREIGN KEY (`package_id`) REFERENCES `vendor_packages` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `vendor_package_showtimes_ibfk_2` FOREIGN KEY (`variant_id`) REFERENCES `vendor_package_variants` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `vendor_package_variants`
--
ALTER TABLE `vendor_package_variants`
  ADD CONSTRAINT `vendor_package_variants_ibfk_1` FOREIGN KEY (`package_id`) REFERENCES `vendor_packages` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `vendor_users`
--
ALTER TABLE `vendor_users`
  ADD CONSTRAINT `vendor_users_ibfk_1` FOREIGN KEY (`vendor_id`) REFERENCES `vendors` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `vendor_users_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `wallets`
--
ALTER TABLE `wallets`
  ADD CONSTRAINT `wallets_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `wallet_ledger`
--
ALTER TABLE `wallet_ledger`
  ADD CONSTRAINT `wallet_ledger_ibfk_1` FOREIGN KEY (`wallet_id`) REFERENCES `wallets` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `wallet_requests`
--
ALTER TABLE `wallet_requests`
  ADD CONSTRAINT `wallet_requests_ibfk_1` FOREIGN KEY (`wallet_id`) REFERENCES `wallets` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
