-- Patch: Add IP+Email login throttle table for agent login
-- Date: 2025-09-18

START TRANSACTION;

CREATE TABLE IF NOT EXISTS `login_ip_throttle` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `email` VARCHAR(150) NOT NULL,
  `ip` VARCHAR(45) NOT NULL,
  `attempts` INT NOT NULL DEFAULT 0,
  `last_attempt_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `blocked_until` DATETIME NULL,
  PRIMARY KEY (`id`),
  KEY `idx_email_ip` (`email`, `ip`),
  KEY `idx_blocked_until` (`blocked_until`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

COMMIT;
