-- Patch: Ensure wallet deposit tables exist and have AUTO_INCREMENT PKs
-- Date: 2025-09-17

START TRANSACTION;

-- 1) wallet_deposit_requests (create if missing)
CREATE TABLE IF NOT EXISTS `wallet_deposit_requests` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `agent_user_id` INT(11) NOT NULL,
  `reference_code` VARCHAR(32) NOT NULL,
  `amount` DECIMAL(12,2) NOT NULL,
  `currency` CHAR(3) NOT NULL DEFAULT 'THB',
  `payment_mode` ENUM('bank','cash','none') NOT NULL DEFAULT 'bank',
  `status` ENUM('pending','bank_assigned','under_verification','approved','rejected') NOT NULL DEFAULT 'pending',
  `bank_account_id` INT(11) DEFAULT NULL,
  `assigned_admin_id` INT(11) DEFAULT NULL,
  `assigned_ip` VARCHAR(45) DEFAULT NULL,
  `assigned_at` DATETIME DEFAULT NULL,
  `verified_admin_id` INT(11) DEFAULT NULL,
  `verified_ip` VARCHAR(45) DEFAULT NULL,
  `verified_at` DATETIME DEFAULT NULL,
  `rejection_reason` VARCHAR(255) DEFAULT NULL,
  `requested_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_reference_code` (`reference_code`),
  KEY `idx_agent_user_id` (`agent_user_id`),
  KEY `idx_bank_account_id` (`bank_account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 1a) Add FKs if tables exist
ALTER TABLE `wallet_deposit_requests`
  ADD CONSTRAINT `fk_wdr_agent` FOREIGN KEY (`agent_user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_wdr_bank` FOREIGN KEY (`bank_account_id`) REFERENCES `company_bank_accounts` (`id`) ON DELETE SET NULL;

-- 2) wallet_deposit_audit (create if missing)
CREATE TABLE IF NOT EXISTS `wallet_deposit_audit` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `request_id` INT(11) NOT NULL,
  `action` ENUM('created','assigned','under_verification','approved','rejected') NOT NULL DEFAULT 'created',
  `actor_user_id` INT(11) DEFAULT NULL,
  `actor_role` VARCHAR(50) DEFAULT NULL,
  `ip` VARCHAR(45) DEFAULT NULL,
  `meta` LONGTEXT,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_request_id` (`request_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 2a) Add FK
ALTER TABLE `wallet_deposit_audit`
  ADD CONSTRAINT `fk_wda_request` FOREIGN KEY (`request_id`) REFERENCES `wallet_deposit_requests` (`id`) ON DELETE CASCADE;

-- 3) If tables exist already but `id` was not AUTO_INCREMENT, fix it safely
-- wallet_deposit_requests.id
ALTER TABLE `wallet_deposit_requests`
  MODIFY `id` INT(11) NOT NULL AUTO_INCREMENT;
-- wallet_deposit_audit.id
ALTER TABLE `wallet_deposit_audit`
  MODIFY `id` INT(11) NOT NULL AUTO_INCREMENT;

COMMIT;
