-- Wallet Deposits: One-shot fix to align FKs and recreate tables cleanly
-- Date: 2025-09-17
-- This script aligns referenced tables and recreates wallet deposit tables with proper PK/FKs.
-- WARNING: It DROPs wallet_deposit_requests and wallet_deposit_audit (data in those two will be removed).

START TRANSACTION;

-- Use safest settings during rebuild
SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0;

-- 1) Ensure referenced tables exist and are compatible (engine, collation, types)
-- USERS
CREATE TABLE IF NOT EXISTS `users` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(100) NOT NULL,
  `email` VARCHAR(150) NOT NULL,
  `password` VARCHAR(255) NOT NULL,
  `role` ENUM('Admin','Employee','Channel Partner','B2B Agent','Vendor','Customer') NOT NULL DEFAULT 'Employee',
  `status` ENUM('Active','Inactive') NOT NULL DEFAULT 'Active',
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE `users`
  MODIFY `id` INT(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `users` ENGINE=InnoDB;
ALTER TABLE `users` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- COMPANY BANK ACCOUNTS
CREATE TABLE IF NOT EXISTS `company_bank_accounts` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `bank_name` VARCHAR(150) NOT NULL,
  `account_name` VARCHAR(150) NOT NULL,
  `account_number` VARCHAR(100) NOT NULL,
  `branch` VARCHAR(150) DEFAULT NULL,
  `swift_code` VARCHAR(50) DEFAULT NULL,
  `currency` CHAR(3) NOT NULL DEFAULT 'THB',
  `active` TINYINT(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE `company_bank_accounts` ENGINE=InnoDB;
ALTER TABLE `company_bank_accounts` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
ALTER TABLE `company_bank_accounts`
  MODIFY `id` INT(11) NOT NULL AUTO_INCREMENT;

-- 2) Recreate wallet deposit tables fresh (drop if exists)
DROP TABLE IF EXISTS `wallet_deposit_audit`;
DROP TABLE IF EXISTS `wallet_deposit_requests`;

CREATE TABLE `wallet_deposit_requests` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `agent_user_id` INT(11) NOT NULL,
  `reference_code` VARCHAR(32) NOT NULL,
  `amount` DECIMAL(12,2) NOT NULL,
  `currency` CHAR(3) NOT NULL DEFAULT 'THB',
  `payment_mode` ENUM('bank','cash','none') NOT NULL DEFAULT 'bank',
  `status` ENUM('pending','bank_assigned','under_verification','approved','rejected') NOT NULL DEFAULT 'pending',
  `bank_account_id` INT(11) DEFAULT NULL,
  `assigned_admin_id` INT(11) DEFAULT NULL,
  `assigned_ip` VARCHAR(45) DEFAULT NULL,
  `assigned_at` DATETIME DEFAULT NULL,
  `verified_admin_id` INT(11) DEFAULT NULL,
  `verified_ip` VARCHAR(45) DEFAULT NULL,
  `verified_at` DATETIME DEFAULT NULL,
  `rejection_reason` VARCHAR(255) DEFAULT NULL,
  `requested_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_reference_code` (`reference_code`),
  KEY `idx_agent_user_id` (`agent_user_id`),
  KEY `idx_bank_account_id` (`bank_account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wallet_deposit_audit` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `request_id` INT(11) NOT NULL,
  `action` ENUM('created','assigned','under_verification','approved','rejected') NOT NULL DEFAULT 'created',
  `actor_user_id` INT(11) DEFAULT NULL,
  `actor_role` VARCHAR(50) DEFAULT NULL,
  `ip` VARCHAR(45) DEFAULT NULL,
  `meta` LONGTEXT,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_request_id` (`request_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 3) Add FKs with unique names after everything is aligned
ALTER TABLE `wallet_deposit_requests`
  ADD CONSTRAINT `fk_wdr_agent_20250917`
    FOREIGN KEY (`agent_user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_wdr_bank_20250917`
    FOREIGN KEY (`bank_account_id`) REFERENCES `company_bank_accounts` (`id`) ON DELETE SET NULL;

ALTER TABLE `wallet_deposit_audit`
  ADD CONSTRAINT `fk_wda_request_20250917`
    FOREIGN KEY (`request_id`) REFERENCES `wallet_deposit_requests` (`id`) ON DELETE CASCADE;

-- Restore settings
SET SQL_NOTES=@OLD_SQL_NOTES;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;

COMMIT;
