-- Patch: Fix users.id auto-increment and create verification_tokens table if missing
-- Date: 2025-09-17

START TRANSACTION;

-- 1) Ensure `users.id` is PRIMARY KEY and AUTO_INCREMENT
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `users`
  MODIFY `id` INT(11) NOT NULL AUTO_INCREMENT;

-- 2) Create `verification_tokens` table used by AgentAuthController if it does not exist
CREATE TABLE IF NOT EXISTS `verification_tokens` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `user_id` INT(11) NOT NULL,
  `type` ENUM('email_otp','tx_pin_reset','password_reset') NOT NULL DEFAULT 'email_otp',
  `token_hash` VARCHAR(255) NOT NULL,
  `otp_code` VARCHAR(12) DEFAULT NULL,
  `expires_at` DATETIME NOT NULL,
  `consumed_at` DATETIME DEFAULT NULL,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `fk_verif_tokens_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

COMMIT;
