-- WhatsApp messaging system core tables
-- whatsapp_settings: one row (id=1) storing active provider and credentials
CREATE TABLE IF NOT EXISTS whatsapp_settings (
  id INT PRIMARY KEY DEFAULT 1,
  active_provider ENUM('disabled','mittos','twilio') NOT NULL DEFAULT 'disabled',
  -- Mittos
  mittos_api_base VARCHAR(255) DEFAULT 'https://app.mittosapi.com',
  mittos_api_token VARCHAR(255) DEFAULT NULL,
  mittos_sender VARCHAR(100) DEFAULT NULL,
  -- Twilio
  twilio_sid VARCHAR(64) DEFAULT NULL,
  twilio_token VARCHAR(64) DEFAULT NULL,
  twilio_from VARCHAR(32) DEFAULT NULL,
  -- Defaults
  default_locale VARCHAR(10) DEFAULT 'en',
  enable_taxi_vendor TINYINT(1) DEFAULT 1,
  enable_taxi_agent TINYINT(1) DEFAULT 1,
  enable_taxi_internal TINYINT(1) DEFAULT 1,
  enable_hotel_vendor TINYINT(1) DEFAULT 1,
  enable_hotel_agent TINYINT(1) DEFAULT 1,
  enable_hotel_internal TINYINT(1) DEFAULT 1,
  enable_activity_vendor TINYINT(1) DEFAULT 1,
  enable_activity_agent TINYINT(1) DEFAULT 1,
  enable_activity_internal TINYINT(1) DEFAULT 1,
  created_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- whatsapp_queue: queued outbound messages
CREATE TABLE IF NOT EXISTS whatsapp_queue (
  id BIGINT PRIMARY KEY AUTO_INCREMENT,
  event_key VARCHAR(100) NOT NULL,
  audience ENUM('vendor','agent','internal') NOT NULL,
  module ENUM('taxi','hotel','activity','general') NOT NULL DEFAULT 'general',
  booking_id BIGINT NULL,
  to_phone VARCHAR(32) NOT NULL,
  message_text TEXT NOT NULL,
  locale VARCHAR(10) DEFAULT 'en',
  status ENUM('pending','sent','failed','suppressed') NOT NULL DEFAULT 'pending',
  attempts INT NOT NULL DEFAULT 0,
  last_error TEXT NULL,
  created_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  sent_at TIMESTAMP NULL DEFAULT NULL,
  KEY idx_status_created (status, created_at),
  KEY idx_booking (booking_id),
  KEY idx_module (module)
);

-- whatsapp_logs: per-attempt log
CREATE TABLE IF NOT EXISTS whatsapp_logs (
  id BIGINT PRIMARY KEY AUTO_INCREMENT,
  queue_id BIGINT NULL,
  provider ENUM('mittos','twilio') NOT NULL,
  to_phone VARCHAR(32) NOT NULL,
  status ENUM('sent','failed') NOT NULL,
  provider_message_id VARCHAR(100) NULL,
  error_text TEXT NULL,
  created_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  KEY idx_queue (queue_id),
  KEY idx_status (status)
);
