-- Wallet deposit request workflow tables

-- Main request table
CREATE TABLE IF NOT EXISTS `wallet_deposit_requests` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `agent_user_id` INT NOT NULL,
  `amount` DECIMAL(12,2) NOT NULL,
  `payment_mode` ENUM('bank_transfer','cash_deposit') NOT NULL,
  `status` ENUM('pending','bank_assigned','under_verification','approved','rejected') NOT NULL DEFAULT 'pending',
  `request_ip` VARCHAR(45) DEFAULT NULL,
  `requested_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,

  `assigned_admin_id` INT DEFAULT NULL,
  `assigned_ip` VARCHAR(45) DEFAULT NULL,
  `assigned_at` TIMESTAMP NULL DEFAULT NULL,
  `bank_account_id` INT UNSIGNED DEFAULT NULL,

  `proof_file` VARCHAR(255) DEFAULT NULL,
  `transaction_ref` VARCHAR(100) DEFAULT NULL,
  `proof_uploaded_at` TIMESTAMP NULL DEFAULT NULL,

  `verified_admin_id` INT DEFAULT NULL,
  `verified_ip` VARCHAR(45) DEFAULT NULL,
  `verified_at` TIMESTAMP NULL DEFAULT NULL,
  `rejection_reason` VARCHAR(255) DEFAULT NULL,

  `reference_code` VARCHAR(32) NOT NULL,

  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_reference_code` (`reference_code`),
  KEY `idx_agent_status` (`agent_user_id`,`status`),
  KEY `idx_status_created` (`status`,`created_at`),
  CONSTRAINT `fk_wdr_bank_account` FOREIGN KEY (`bank_account_id`) REFERENCES `company_bank_accounts`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Audit trail table (normalized audit for each stage)
CREATE TABLE IF NOT EXISTS `wallet_deposit_audit` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `request_id` INT UNSIGNED NOT NULL,
  `action` ENUM('created','assigned','proof_uploaded','approved','rejected','status_change') NOT NULL,
  `actor_user_id` INT DEFAULT NULL,
  `actor_role` ENUM('agent','admin','system') NOT NULL DEFAULT 'system',
  `ip` VARCHAR(45) DEFAULT NULL,
  `meta` JSON DEFAULT NULL,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_request` (`request_id`),
  CONSTRAINT `fk_wda_request` FOREIGN KEY (`request_id`) REFERENCES `wallet_deposit_requests`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
