-- 2025-09-13: Vendor package transport options (fixed-price per package)
START TRANSACTION;

-- Add toggle on vendor_packages
ALTER TABLE vendor_packages
  ADD COLUMN IF NOT EXISTS transport_enabled TINYINT(1) NOT NULL DEFAULT 0 AFTER requires_show_time;

-- Fixed-price transport options per package
CREATE TABLE IF NOT EXISTS package_transport_options (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  package_id INT(11) NOT NULL,
  vehicle_type VARCHAR(50) NOT NULL COMMENT 'e.g., 4-seater, 7-seater, Van',
  max_pax TINYINT UNSIGNED NOT NULL DEFAULT 4,
  -- Legacy single price kept for backward compatibility; will mirror agent_price
  price DECIMAL(10,2) NOT NULL,
  vendor_cost DECIMAL(10,2) NOT NULL DEFAULT 0.00,
  agent_price DECIMAL(10,2) NOT NULL DEFAULT 0.00,
  customer_price DECIMAL(10,2) NULL,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  display_order INT NOT NULL DEFAULT 0,
  created_at DATETIME NOT NULL DEFAULT NOW(),
  updated_at DATETIME NOT NULL DEFAULT NOW() ON UPDATE NOW(),
  PRIMARY KEY (id),
  KEY idx_pkg_active (package_id, is_active, display_order)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Ensure max_pax exists if table was created earlier
ALTER TABLE package_transport_options
  ADD COLUMN IF NOT EXISTS max_pax TINYINT UNSIGNED NOT NULL DEFAULT 4 AFTER vehicle_type;

-- Add multi-price columns if missing
ALTER TABLE package_transport_options
  ADD COLUMN IF NOT EXISTS vendor_cost DECIMAL(10,2) NOT NULL DEFAULT 0.00 AFTER price,
  ADD COLUMN IF NOT EXISTS agent_price DECIMAL(10,2) NOT NULL DEFAULT 0.00 AFTER vendor_cost,
  ADD COLUMN IF NOT EXISTS customer_price DECIMAL(10,2) NULL AFTER agent_price;

-- Add FK separately to avoid failures if table was created earlier without FK
-- Drop any conflicting FK name if it exists
SET @fk_exists := (
  SELECT COUNT(*) FROM information_schema.REFERENTIAL_CONSTRAINTS
  WHERE CONSTRAINT_SCHEMA = DATABASE() AND CONSTRAINT_NAME = 'fk_pto_package'
);
SET @sql := IF(@fk_exists > 0,
  'ALTER TABLE package_transport_options DROP FOREIGN KEY fk_pto_package',
  'SELECT 1'
);
PREPARE stmt FROM @sql; EXECUTE stmt; DEALLOCATE PREPARE stmt;

-- Add a uniquely named FK to avoid name collision across schema
ALTER TABLE package_transport_options
  ADD CONSTRAINT fk_package_transport_options_package
    FOREIGN KEY (package_id) REFERENCES vendor_packages(id)
    ON DELETE CASCADE;

COMMIT;
