-- 2025-09-10: MVP Vendor workflow for Taxi
START TRANSACTION;

-- Extend taxi_bookings with vendor/driver/status/proof fields
ALTER TABLE taxi_bookings
  ADD COLUMN IF NOT EXISTS vendor_id INT UNSIGNED NULL AFTER taxi_id,
  ADD COLUMN IF NOT EXISTS driver_name VARCHAR(120) NULL AFTER customer_phone,
  ADD COLUMN IF NOT EXISTS driver_phone VARCHAR(50) NULL AFTER driver_name,
  ADD COLUMN IF NOT EXISTS vehicle_number VARCHAR(50) NULL AFTER driver_phone,
  ADD COLUMN IF NOT EXISTS vendor_assigned_at DATETIME NULL AFTER paid_at,
  ADD COLUMN IF NOT EXISTS vendor_accepted_at DATETIME NULL AFTER vendor_assigned_at,
  ADD COLUMN IF NOT EXISTS driver_assigned_at DATETIME NULL AFTER vendor_accepted_at,
  ADD COLUMN IF NOT EXISTS enroute_at DATETIME NULL AFTER driver_assigned_at,
  ADD COLUMN IF NOT EXISTS picked_up_at DATETIME NULL AFTER enroute_at,
  ADD COLUMN IF NOT EXISTS completed_at DATETIME NULL AFTER picked_up_at,
  ADD COLUMN IF NOT EXISTS status_detail VARCHAR(50) NULL AFTER status,
  ADD COLUMN IF NOT EXISTS pickup_photo_path VARCHAR(255) NULL AFTER notes,
  ADD COLUMN IF NOT EXISTS cancel_reason VARCHAR(255) NULL AFTER status_detail,
  ADD COLUMN IF NOT EXISTS cancelled_by ENUM('agent','admin','vendor') NULL AFTER cancel_reason;

-- Vendor dispatch table for invitations and response flow
CREATE TABLE IF NOT EXISTS taxi_vendor_dispatch (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  booking_id INT UNSIGNED NOT NULL,
  vendor_id INT UNSIGNED NOT NULL,
  status ENUM('pending','accepted','rejected','expired','cancelled') NOT NULL DEFAULT 'pending',
  invite_token VARCHAR(64) NOT NULL,
  expires_at DATETIME NOT NULL,
  accepted_at DATETIME NULL,
  rejected_at DATETIME NULL,
  note TEXT NULL,
  raw_email JSON NULL,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY(id),
  UNIQUE KEY uniq_invite_token (invite_token),
  KEY idx_booking (booking_id),
  KEY idx_vendor (vendor_id),
  CONSTRAINT fk_tvd_booking FOREIGN KEY (booking_id) REFERENCES taxi_bookings(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

COMMIT;
