-- Add vendor price and vendor cost tracking for taxi
START TRANSACTION;

-- Pricing master: optional vendor_price
ALTER TABLE taxi_pricing
  ADD COLUMN IF NOT EXISTS vendor_price DECIMAL(10,2) NULL AFTER customer_price;

-- Bookings snapshot: vendor_cost and currency
ALTER TABLE taxi_bookings
  ADD COLUMN IF NOT EXISTS vendor_cost DECIMAL(10,2) NULL AFTER amount_total,
  ADD COLUMN IF NOT EXISTS vendor_currency VARCHAR(3) NULL DEFAULT 'THB' AFTER vendor_cost;

COMMIT;
