-- 2025-09-10: Align taxi_payment_intents schema with AgentPortalController::taxiPayment() insert
START TRANSACTION;

ALTER TABLE taxi_payment_intents
  ADD COLUMN IF NOT EXISTS pickup_time VARCHAR(20) NULL AFTER trip_date,
  ADD COLUMN IF NOT EXISTS flight_no VARCHAR(30) NULL AFTER pickup_time,
  ADD COLUMN IF NOT EXISTS notes TEXT NULL AFTER flight_no,
  ADD COLUMN IF NOT EXISTS pickup_type VARCHAR(20) NULL AFTER channel,
  ADD COLUMN IF NOT EXISTS drop_type VARCHAR(20) NULL AFTER pickup_type,
  ADD COLUMN IF NOT EXISTS pickup_airport_code VARCHAR(8) NULL AFTER drop_type,
  ADD COLUMN IF NOT EXISTS drop_airport_code VARCHAR(8) NULL AFTER pickup_airport_code,
  ADD COLUMN IF NOT EXISTS pickup_hotel_name VARCHAR(200) NULL AFTER drop_airport_code,
  ADD COLUMN IF NOT EXISTS pickup_hotel_address VARCHAR(255) NULL AFTER pickup_hotel_name,
  ADD COLUMN IF NOT EXISTS pickup_apartment_name VARCHAR(200) NULL AFTER pickup_hotel_address,
  ADD COLUMN IF NOT EXISTS pickup_apartment_address VARCHAR(255) NULL AFTER pickup_apartment_name,
  ADD COLUMN IF NOT EXISTS pickup_address VARCHAR(255) NULL AFTER pickup_apartment_address,
  ADD COLUMN IF NOT EXISTS drop_hotel_name VARCHAR(200) NULL AFTER pickup_address,
  ADD COLUMN IF NOT EXISTS drop_hotel_address VARCHAR(255) NULL AFTER drop_hotel_name,
  ADD COLUMN IF NOT EXISTS drop_apartment_name VARCHAR(200) NULL AFTER drop_hotel_address,
  ADD COLUMN IF NOT EXISTS drop_apartment_address VARCHAR(255) NULL AFTER drop_apartment_name,
  ADD COLUMN IF NOT EXISTS drop_address VARCHAR(255) NULL AFTER drop_apartment_address,
  ADD COLUMN IF NOT EXISTS customer_name VARCHAR(120) NULL AFTER user_agent,
  ADD COLUMN IF NOT EXISTS customer_email VARCHAR(150) NULL AFTER customer_name,
  ADD COLUMN IF NOT EXISTS customer_phone VARCHAR(50) NULL AFTER customer_email,
  ADD COLUMN IF NOT EXISTS is_round_trip TINYINT(1) NOT NULL DEFAULT 0 AFTER customer_phone,
  ADD COLUMN IF NOT EXISTS return_date DATE NULL AFTER is_round_trip,
  ADD COLUMN IF NOT EXISTS return_time VARCHAR(10) NULL AFTER return_date,
  ADD COLUMN IF NOT EXISTS itinerary_id INT UNSIGNED NULL AFTER booking_id,
  ADD COLUMN IF NOT EXISTS itinerary_name VARCHAR(200) NULL AFTER itinerary_id,
  ADD COLUMN IF NOT EXISTS itinerary_json JSON NULL AFTER itinerary_name;

COMMIT;
