-- MySQL 5.7-compatible backfill for taxi_bookings.vendor_cost
-- No CTE, uses derived tables only
START TRANSACTION;

UPDATE taxi_bookings b
JOIN (
  SELECT tp.*
  FROM taxi_pricing tp
  JOIN (
    SELECT taxi_id, MAX(id) AS max_id
    FROM taxi_pricing
    GROUP BY taxi_id
  ) m ON m.taxi_id = tp.taxi_id AND m.max_id = tp.id
) p ON p.taxi_id = b.taxi_id
SET b.vendor_cost = COALESCE(p.vendor_cost, p.vendor_price, p.base_fare, 0),
    b.vendor_currency = COALESCE(p.currency, b.vendor_currency, 'THB')
WHERE b.vendor_cost IS NULL;

COMMIT;
