-- Backfill vendor_cost on existing taxi_bookings from taxi_pricing
-- Strategy:
-- 1) Find the latest pricing row per taxi
-- 2) Use pricing.vendor_cost first; fallback to vendor_price; fallback to base_fare
-- 3) Set taxi_bookings.vendor_cost and vendor_currency where vendor_cost IS NULL
-- Note: This backfill does not attempt to recompute extras/per-km from itinerary_json.
--       New bookings already compute a precise vendor_cost in code.

START TRANSACTION;

-- Helper: latest pricing per taxi
WITH latest_pricing AS (
  SELECT tp.*
  FROM taxi_pricing tp
  JOIN (agent
    SELECT taxi_id, MAX(id) AS max_id
    FROM taxi_pricing
    GROUP BY taxi_id
  ) m ON m.taxi_id = tp.taxi_id AND m.max_id = tp.id
)
UPDATE taxi_bookings b
JOIN latest_pricing p ON p.taxi_id = b.taxi_id
SET b.vendor_cost = COALESCE(p.vendor_cost, p.vendor_price, p.base_fare, 0),
    b.vendor_currency = COALESCE(p.currency, b.vendor_currency, 'THB')
WHERE b.vendor_cost IS NULL;

COMMIT;
