-- Add vendor user if not exists (with correct email in WHERE clause)
INSERT IGNORE INTO users (email, name, role, status, password_hash, created_at, updated_at)
SELECT 
    'ancientjbrx@gmail.com',
    'Vendor User',
    'Vendor',
    'Active',
    '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', -- password is '123456'
    NOW(),
    NOW()
FROM DUAL
WHERE NOT EXISTS (
    SELECT 1 FROM users WHERE email = 'ancientjbrx@gmail.com' AND role = 'Vendor'
);

-- Ensure vendor record exists
INSERT IGNORE INTO vendors (name, contact_email, status, created_at, updated_at)
SELECT 
    'Vendor Account',
    'ancientjbrx@gmail.com',
    'Active',
    NOW(),
    NOW()
FROM DUAL
WHERE NOT EXISTS (
    SELECT 1 FROM vendors WHERE contact_email = 'ancientjbrx@gmail.com'
);
