-- 2025-09-08: Taxi pay-first booking schema (agent portal)
-- Creates taxi booking lifecycle tables analogous to yachts, including payment intents.

START TRANSACTION;

-- Taxi bookings
CREATE TABLE IF NOT EXISTS taxi_bookings (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  booking_code VARCHAR(100) NULL,
  agent_id INT UNSIGNED NOT NULL,
  taxi_id INT UNSIGNED NOT NULL,
  trip_date DATE NOT NULL,
  pax INT UNSIGNED NOT NULL DEFAULT 1,
  from_text VARCHAR(200) NULL,
  to_text VARCHAR(200) NULL,
  amount_total DECIMAL(12,2) NOT NULL DEFAULT 0.00,
  currency CHAR(3) NOT NULL DEFAULT 'THB',
  status ENUM('pending','confirmed','cancelled','refunded') NOT NULL DEFAULT 'pending',
  payment_status ENUM('unpaid','paid','refunded','partial','failed') NOT NULL DEFAULT 'unpaid',
  payment_method VARCHAR(50) NULL,
  gateway_name VARCHAR(50) NULL,
  payment_txn_id VARCHAR(100) NULL,
  paid_at DATETIME NULL,
  -- Cancellation / Refunds
  cancelled_at DATETIME NULL,
  cancel_reason VARCHAR(500) NULL,
  refund_amount DECIMAL(12,2) NULL,
  refunded_at DATETIME NULL,
  refund_txn_id VARCHAR(100) NULL,
  -- Audit
  channel VARCHAR(50) NULL,
  ip_address VARCHAR(64) NULL,
  user_agent VARCHAR(255) NULL,
  created_by INT UNSIGNED NULL,
  updated_by INT UNSIGNED NULL,
  created_at DATETIME NOT NULL,
  updated_at DATETIME NOT NULL,
  PRIMARY KEY (id),
  UNIQUE KEY uq_taxi_booking_code (booking_code),
  KEY idx_tb_agent (agent_id),
  KEY idx_tb_taxi (taxi_id),
  KEY idx_tb_status (status),
  KEY idx_tb_paid (payment_status)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Taxi booking events
CREATE TABLE IF NOT EXISTS taxi_booking_events (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  booking_id INT UNSIGNED NOT NULL,
  user_id INT UNSIGNED NULL,
  event_type VARCHAR(50) NOT NULL,
  note VARCHAR(255) NULL,
  data_json JSON NULL,
  created_at DATETIME NOT NULL,
  PRIMARY KEY (id),
  KEY idx_tbe_booking (booking_id),
  KEY idx_tbe_type (event_type)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Taxi payments
CREATE TABLE IF NOT EXISTS taxi_payments (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  booking_id INT UNSIGNED NOT NULL,
  method VARCHAR(50) NOT NULL,
  gateway_name VARCHAR(50) NULL,
  amount DECIMAL(12,2) NOT NULL,
  currency CHAR(3) NOT NULL DEFAULT 'THB',
  status ENUM('pending','captured','failed','refunded','partial') NOT NULL DEFAULT 'pending',
  txn_id VARCHAR(100) NULL,
  idempotency_key VARCHAR(64) NULL,
  provider_ref VARCHAR(100) NULL,
  session_url TEXT NULL,
  raw_session JSON NULL,
  event_id VARCHAR(100) NULL,
  raw_event JSON NULL,
  meta_json JSON NULL,
  created_at DATETIME NOT NULL DEFAULT NOW(),
  updated_at DATETIME NOT NULL DEFAULT NOW(),
  PRIMARY KEY (id),
  KEY idx_tp_booking (booking_id),
  KEY idx_tp_status (status),
  KEY idx_tp_event (event_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Taxi payment intents
CREATE TABLE IF NOT EXISTS taxi_payment_intents (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  agent_id INT UNSIGNED NOT NULL,
  taxi_id INT UNSIGNED NOT NULL,
  trip_date DATE NOT NULL,
  pax INT UNSIGNED NOT NULL DEFAULT 1,
  from_text VARCHAR(200) NULL,
  to_text VARCHAR(200) NULL,
  amount DECIMAL(12,2) NOT NULL,
  currency CHAR(3) NOT NULL DEFAULT 'THB',
  status ENUM('pending','succeeded','failed') NOT NULL DEFAULT 'pending',
  method VARCHAR(50) NULL,
  gateway_name VARCHAR(50) NULL,
  gateway_session_id VARCHAR(100) NULL,
  booking_id INT UNSIGNED NULL,
  -- Audit
  channel VARCHAR(50) NULL,
  ip_address VARCHAR(64) NULL,
  user_agent VARCHAR(255) NULL,
  created_at DATETIME NOT NULL DEFAULT NOW(),
  updated_at DATETIME NOT NULL DEFAULT NOW(),
  PRIMARY KEY (id),
  KEY idx_ti_agent (agent_id),
  KEY idx_ti_taxi (taxi_id),
  KEY idx_ti_status (status)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

COMMIT;
