-- Patch: Add pricing tiers for hotels and room nightly prices
-- Date: 2025-09-01

START TRANSACTION;

-- 1) Hotels: add standard price tiers
ALTER TABLE hotels
  ADD COLUMN IF NOT EXISTS base_price_vendor DECIMAL(10,2) NULL AFTER base_price,
  ADD COLUMN IF NOT EXISTS base_price_agent DECIMAL(10,2) NULL AFTER base_price_vendor,
  ADD COLUMN IF NOT EXISTS base_price_customer DECIMAL(10,2) NULL AFTER base_price_agent;

-- Backfill from legacy base_price
UPDATE hotels
SET 
  base_price_vendor = COALESCE(base_price_vendor, base_price),
  base_price_agent = COALESCE(base_price_agent, base_price),
  base_price_customer = COALESCE(base_price_customer, base_price);

-- 2) Room nightly prices: add optional vendor and customer columns
ALTER TABLE room_prices
  ADD COLUMN IF NOT EXISTS vendor_price DECIMAL(10,2) NULL AFTER price,
  ADD COLUMN IF NOT EXISTS customer_price DECIMAL(10,2) NULL AFTER agent_price;

-- Optional helpful indexes (noop if exist)
CREATE INDEX IF NOT EXISTS idx_room_prices_room_date ON room_prices(room_id, date);

COMMIT;
