-- Patch: 2025-09-01_hotel_bookings.sql
-- Adds hotel_quotes, hotel_quote_items, hotel_bookings, hotel_booking_rooms
-- Enables API-based quote -> book flow for agents

START TRANSACTION;

CREATE TABLE IF NOT EXISTS `hotel_quotes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `quote_code` varchar(32) NOT NULL,
  `agent_user_id` int(11) NOT NULL,
  `hotel_id` int(11) NOT NULL,
  `checkin` date NOT NULL,
  `checkout` date NOT NULL,
  `adults` int(11) NOT NULL DEFAULT 2,
  `rooms` int(11) NOT NULL DEFAULT 1,
  `currency` char(3) NOT NULL DEFAULT 'THB',
  `subtotal` decimal(12,2) NOT NULL DEFAULT 0.00,
  `taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `pay_at_property` tinyint(1) NOT NULL DEFAULT 0,
  `status` enum('draft','expired','booked') NOT NULL DEFAULT 'draft',
  `expires_at` datetime NOT NULL,
  `meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`meta`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_quote_code` (`quote_code`),
  KEY `idx_quote_agent` (`agent_user_id`),
  KEY `idx_quote_hotel` (`hotel_id`),
  CONSTRAINT `fk_quote_hotel` FOREIGN KEY (`hotel_id`) REFERENCES `hotels`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `hotel_quote_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `quote_id` int(11) NOT NULL,
  `room_id` int(11) NOT NULL,
  `rate_plan_id` int(11) DEFAULT NULL,
  `offer_id` varchar(64) NOT NULL,
  `nightly_agent_price` decimal(12,2) NOT NULL DEFAULT 0.00,
  `nights` int(11) NOT NULL DEFAULT 1,
  `qty_rooms` int(11) NOT NULL DEFAULT 1,
  `total` decimal(12,2) NOT NULL DEFAULT 0.00,
  `policy_snapshot` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`policy_snapshot`)),
  PRIMARY KEY (`id`),
  KEY `idx_quote_items_quote` (`quote_id`),
  KEY `idx_quote_items_room` (`room_id`),
  CONSTRAINT `fk_quote_items_quote` FOREIGN KEY (`quote_id`) REFERENCES `hotel_quotes`(`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_quote_items_room` FOREIGN KEY (`room_id`) REFERENCES `hotel_rooms`(`id`) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `hotel_bookings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `booking_code` varchar(40) NOT NULL,
  `agent_user_id` int(11) NOT NULL,
  `quote_id` int(11) DEFAULT NULL,
  `hotel_id` int(11) NOT NULL,
  `checkin` date NOT NULL,
  `checkout` date NOT NULL,
  `adults` int(11) NOT NULL DEFAULT 2,
  `rooms` int(11) NOT NULL DEFAULT 1,
  `currency` char(3) NOT NULL DEFAULT 'THB',
  `subtotal` decimal(12,2) NOT NULL DEFAULT 0.00,
  `taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `payment_status` enum('pending','paid','none') NOT NULL DEFAULT 'pending',
  `status` enum('pending','confirmed','cancelled') NOT NULL DEFAULT 'pending',
  `pay_at_property` tinyint(1) NOT NULL DEFAULT 0,
  `policy_snapshot` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`policy_snapshot`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_booking_code` (`booking_code`),
  KEY `idx_booking_agent` (`agent_user_id`),
  KEY `idx_booking_hotel` (`hotel_id`),
  CONSTRAINT `fk_booking_hotel` FOREIGN KEY (`hotel_id`) REFERENCES `hotels`(`id`) ON DELETE RESTRICT,
  CONSTRAINT `fk_booking_quote` FOREIGN KEY (`quote_id`) REFERENCES `hotel_quotes`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `hotel_booking_rooms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `booking_id` int(11) NOT NULL,
  `room_id` int(11) NOT NULL,
  `rate_plan_id` int(11) DEFAULT NULL,
  `price_per_night` decimal(12,2) NOT NULL DEFAULT 0.00,
  `nights` int(11) NOT NULL DEFAULT 1,
  `qty_rooms` int(11) NOT NULL DEFAULT 1,
  `total` decimal(12,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`),
  KEY `idx_booking_rooms_booking` (`booking_id`),
  KEY `idx_booking_rooms_room` (`room_id`),
  CONSTRAINT `fk_booking_rooms_booking` FOREIGN KEY (`booking_id`) REFERENCES `hotel_bookings`(`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_booking_rooms_room` FOREIGN KEY (`room_id`) REFERENCES `hotel_rooms`(`id`) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Register patch
INSERT INTO `db_patches` (`filename`) VALUES ('2025-09-01_hotel_bookings.sql');

COMMIT;
