-- Patch: Add featured label for agent marketplace
-- Safely add column `featured_agent_label` to `hotels` to support multiple trust labels for B2B Agent UI.
-- Allowed values: top_choice, recommended, trusted_partner, best_value (NULL means no label)

ALTER TABLE hotels
  ADD COLUMN IF NOT EXISTS featured_agent_label VARCHAR(32) NULL AFTER featured_agent;

-- Optional: constrain to allowed values if your MySQL supports CHECK (8.0.16+)
-- ALTER TABLE hotels ADD CONSTRAINT chk_featured_agent_label
--   CHECK (featured_agent_label IN ('top_choice','recommended','trusted_partner','best_value'));

-- Helpful index for sorting and filtering featured items
CREATE INDEX IF NOT EXISTS idx_hotels_featured_agent ON hotels (featured_agent, featured_agent_label);
