-- Seed activities, tiers, showtimes, and prices for demo/listing
USE b2b_travel;

-- Activities
INSERT INTO activities (vendor_id, name, city, base_price) VALUES
(1, 'Alcazar Show', 'Pattaya', 30.00),
(1, 'Tiffany Cabaret', 'Pattaya', 35.00),
(1, 'Safari World + Marine Park', 'Bangkok', 45.00),
(1, 'Ayutthaya Day Tour', 'Bangkok', 59.00),
(1, 'Chiang Mai Elephant Sanctuary', 'Chiang Mai', 75.00)
ON DUPLICATE KEY UPDATE name = VALUES(name), city = VALUES(city), base_price = VALUES(base_price);

-- Showtimes (basic)
INSERT INTO activity_showtimes (activity_id, show_time)
SELECT a.id, '18:00' FROM activities a WHERE a.name = 'Alcazar Show'
UNION ALL
SELECT a.id, '19:30' FROM activities a WHERE a.name = 'Alcazar Show'
UNION ALL
SELECT a.id, '18:00' FROM activities a WHERE a.name = 'Tiffany Cabaret'
UNION ALL
SELECT a.id, '19:45' FROM activities a WHERE a.name = 'Tiffany Cabaret';

-- Tiers
INSERT INTO activity_tiers (activity_id, name, description)
SELECT a.id, 'Standard', NULL FROM activities a WHERE a.name IN ('Alcazar Show','Tiffany Cabaret')
UNION ALL
SELECT a.id, 'VIP', 'Front rows' FROM activities a WHERE a.name IN ('Alcazar Show','Tiffany Cabaret');

-- Prices (adult, non-group)
INSERT INTO activity_prices (activity_id, tier_id, showtime_id, pax_type, is_group, pax_threshold, price)
SELECT a.id, NULL, NULL, 'adult', 0, NULL, a.base_price FROM activities a WHERE a.name IN ('Ayutthaya Day Tour','Chiang Mai Elephant Sanctuary')
UNION ALL
SELECT a.id, t.id, NULL, 'adult', 0, NULL, 30.00 FROM activities a JOIN activity_tiers t ON t.activity_id=a.id AND t.name='Standard' WHERE a.name='Alcazar Show'
UNION ALL
SELECT a.id, t.id, NULL, 'adult', 0, NULL, 42.00 FROM activities a JOIN activity_tiers t ON t.activity_id=a.id AND t.name='VIP' WHERE a.name='Alcazar Show'
UNION ALL
SELECT a.id, t.id, NULL, 'adult', 0, NULL, 35.00 FROM activities a JOIN activity_tiers t ON t.activity_id=a.id AND t.name='Standard' WHERE a.name='Tiffany Cabaret'
UNION ALL
SELECT a.id, t.id, NULL, 'adult', 0, NULL, 49.00 FROM activities a JOIN activity_tiers t ON t.activity_id=a.id AND t.name='VIP' WHERE a.name='Tiffany Cabaret';
