-- Patch: Add is_cover flag to hotel_images for explicit hero selection
-- Safe for repeated runs (checks INFORMATION_SCHEMA)

-- Add column if missing
SET @col := (
  SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
  WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'hotel_images' AND COLUMN_NAME = 'is_cover'
);
SET @qry := IF(@col = 0,
  'ALTER TABLE hotel_images ADD COLUMN is_cover TINYINT(1) NOT NULL DEFAULT 0 AFTER caption',
  'DO 0'
);
PREPARE stmt FROM @qry; EXECUTE stmt; DEALLOCATE PREPARE stmt;

-- Add index for faster lookup (optional)
SET @idx := (
  SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS
  WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'hotel_images' AND INDEX_NAME = 'idx_hotel_images_is_cover'
);
SET @iqry := IF(@idx = 0,
  'CREATE INDEX idx_hotel_images_is_cover ON hotel_images (is_cover)',
  'DO 0'
);
PREPARE istmt FROM @iqry; EXECUTE istmt; DEALLOCATE PREPARE istmt;
