-- 2025-08-29: B2B Bookings + Checkout foundational tables/columns
-- Safe to run multiple times

USE b2b_travel;

-- 1) Orders table (minimal)
CREATE TABLE IF NOT EXISTS orders (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  status ENUM('pending','paid','failed','cancelled') NOT NULL DEFAULT 'pending',
  total_amount DECIMAL(12,2) NOT NULL DEFAULT 0.00,
  currency CHAR(3) NOT NULL DEFAULT 'THB',
  payment_method VARCHAR(32) NOT NULL DEFAULT 'none',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NULL,
  FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB;

-- 2) Order Items table (links to bookings optionally)
CREATE TABLE IF NOT EXISTS order_items (
  id INT AUTO_INCREMENT PRIMARY KEY,
  order_id INT NOT NULL,
  module ENUM('hotel','activity','taxi','evisa') NOT NULL,
  item_id INT NOT NULL,
  qty INT NOT NULL DEFAULT 1,
  unit_price DECIMAL(12,2) NOT NULL DEFAULT 0.00,
  line_total DECIMAL(12,2) NOT NULL DEFAULT 0.00,
  currency CHAR(3) NOT NULL DEFAULT 'THB',
  booking_id INT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (order_id) REFERENCES orders(id) ON DELETE CASCADE
) ENGINE=InnoDB;

-- Helpful indexes
CREATE INDEX IF NOT EXISTS idx_order_items_order ON order_items(order_id);
CREATE INDEX IF NOT EXISTS idx_order_items_booking ON order_items(booking_id);

-- 3) Extend bookings used by AgentController for activities/hotels flows
ALTER TABLE bookings
  ADD COLUMN IF NOT EXISTS variant_id INT NULL AFTER item_id,
  ADD COLUMN IF NOT EXISTS price_id INT NULL AFTER variant_id,
  ADD COLUMN IF NOT EXISTS pax_type ENUM('adult','child','infant','flat','') NULL AFTER price,
  ADD COLUMN IF NOT EXISTS show_time VARCHAR(16) NULL AFTER pax_type,
  ADD COLUMN IF NOT EXISTS details_json JSON NULL AFTER show_time,
  ADD COLUMN IF NOT EXISTS order_id INT NULL AFTER status;

-- Helpful indexes
CREATE INDEX IF NOT EXISTS idx_bookings_user ON bookings(user_id);
CREATE INDEX IF NOT EXISTS idx_bookings_status ON bookings(status);
CREATE INDEX IF NOT EXISTS idx_bookings_module_item ON bookings(module, item_id);
