-- 2025-08-19_checkout_contact.sql
-- Add customer contact fields to orders for B2B checkout (idempotent)

-- customer_name
SET @has_col := (
  SELECT COUNT(*) FROM information_schema.COLUMNS
  WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'orders' AND COLUMN_NAME = 'customer_name'
);
SET @sql := IF(@has_col = 0,
  'ALTER TABLE orders ADD COLUMN customer_name VARCHAR(191) NULL AFTER payment_method',
  'SELECT 1'
);
PREPARE s1 FROM @sql; EXECUTE s1; DEALLOCATE PREPARE s1;

-- customer_mobile
SET @has_col := (
  SELECT COUNT(*) FROM information_schema.COLUMNS
  WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'orders' AND COLUMN_NAME = 'customer_mobile'
);
SET @sql := IF(@has_col = 0,
  'ALTER TABLE orders ADD COLUMN customer_mobile VARCHAR(50) NULL AFTER customer_name',
  'SELECT 1'
);
PREPARE s2 FROM @sql; EXECUTE s2; DEALLOCATE PREPARE s2;

-- customer_email
SET @has_col := (
  SELECT COUNT(*) FROM information_schema.COLUMNS
  WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'orders' AND COLUMN_NAME = 'customer_email'
);
SET @sql := IF(@has_col = 0,
  'ALTER TABLE orders ADD COLUMN customer_email VARCHAR(191) NULL AFTER customer_mobile',
  'SELECT 1'
);
PREPARE s3 FROM @sql; EXECUTE s3; DEALLOCATE PREPARE s3;

-- customer_whatsapp
SET @has_col := (
  SELECT COUNT(*) FROM information_schema.COLUMNS
  WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'orders' AND COLUMN_NAME = 'customer_whatsapp'
);
SET @sql := IF(@has_col = 0,
  'ALTER TABLE orders ADD COLUMN customer_whatsapp VARCHAR(50) NULL AFTER customer_email',
  'SELECT 1'
);
PREPARE s4 FROM @sql; EXECUTE s4; DEALLOCATE PREPARE s4;
