<?php
// config/kyc.php
// KYC toggles for B2B Agent form. Controlled via .env overrides.
// Each flag is string 'true'/'false' in .env; cast here to boolean.

if (!function_exists('env')) {
  require __DIR__ . '/config.php'; // ensures env() exists when called directly
}

function boolenv($key, $default = 'true') {
  $v = env($key, $default);
  return $v === 'true' || $v === true || $v === 1 || $v === '1' ? true : false;
}

return [
  'agent' => [
    // Media
    'profile_photo' => [
      'enabled' => boolenv('KYC_ENABLE_PROFILE_PHOTO', 'true'),
      'required' => boolenv('KYC_REQUIRE_PROFILE_PHOTO', 'true'),
    ],
    'business_card' => [
      'enabled' => boolenv('KYC_ENABLE_BUSINESS_CARD', 'true'),
      'required' => boolenv('KYC_REQUIRE_BUSINESS_CARD', 'true'),
    ],
    'selfie' => [
      'enabled' => boolenv('KYC_ENABLE_SELFIE', 'true'),
      'required' => boolenv('KYC_REQUIRE_SELFIE', 'true'),
    ],

    // Documents by business type
    'reg_certificate_sp' => [ // Sole Proprietor
      'enabled' => boolenv('KYC_ENABLE_REG_CERT_SP', 'true'),
      'required' => boolenv('KYC_REQUIRE_REG_CERT_SP', 'false'),
    ],
    'partnership_deed_llp' => [
      'enabled' => boolenv('KYC_ENABLE_PARTNERSHIP_DEED_LLP', 'true'),
      'required' => boolenv('KYC_REQUIRE_PARTNERSHIP_DEED_LLP', 'false'),
    ],
    'incorp_cert_company' => [
      'enabled' => boolenv('KYC_ENABLE_INCORP_CERT_COMPANY', 'true'),
      'required' => boolenv('KYC_REQUIRE_INCORP_CERT_COMPANY', 'false'),
    ],
    'address_proof_freelancer' => [
      'enabled' => boolenv('KYC_ENABLE_ADDRESS_PROOF_FREELANCER', 'true'),
      'required' => boolenv('KYC_REQUIRE_ADDRESS_PROOF_FREELANCER', 'true'),
    ],

    // Government ID section
    'gov_id' => [
      'enabled' => boolenv('KYC_ENABLE_GOV_ID_SECTION', 'true'),
      'require_type' => boolenv('KYC_REQUIRE_GOV_ID_TYPE', 'true'),
      'require_number' => boolenv('KYC_REQUIRE_GOV_ID_NUMBER', 'true'),
      'require_front' => boolenv('KYC_REQUIRE_GOV_ID_FRONT', 'true'),
      'back_enabled' => boolenv('KYC_ENABLE_GOV_ID_BACK', 'true'),
      'require_back' => boolenv('KYC_REQUIRE_GOV_ID_BACK', 'false'),
    ],

    // Business registration toggles
    'registration' => [
      'iata_enabled' => boolenv('KYC_ENABLE_IATA_BLOCK', 'true'),
      'iata_code_required_on_yes' => boolenv('KYC_REQUIRE_IATA_CODE_ON_YES', 'true'),
      'gst_number' => [
        'enabled' => boolenv('KYC_ENABLE_GST_NUMBER', 'true'),
        'required' => boolenv('KYC_REQUIRE_GST_NUMBER', 'false'),
      ],
      'gst_company' => [
        'enabled' => boolenv('KYC_ENABLE_GST_COMPANY', 'true'),
        'required' => boolenv('KYC_REQUIRE_GST_COMPANY', 'false'),
      ],
    ],

    // Business info
    'business_info' => [
      'agency_name' => [
        'enabled' => boolenv('KYC_ENABLE_AGENCY_NAME', 'true'),
        'required_non_freelancer' => boolenv('KYC_REQUIRE_AGENCY_NAME_NON_FREELANCER', 'false'),
      ],
    ],

    // Financials
    'financials' => [
      'commission' => [
        'enabled' => boolenv('KYC_ENABLE_COMMISSION', 'true'),
        'default' => (float)(env('KYC_DEFAULT_COMMISSION', '0')), // string to float
      ],
      'credit_limit' => [
        'enabled' => boolenv('KYC_ENABLE_CREDIT_LIMIT', 'true'),
        'default' => (float)(env('KYC_DEFAULT_CREDIT_LIMIT', '0')),
      ],
    ],
    // Per-business-type overrides structure
    'per_type' => [
      'freelancer' => [
        'gov_id' => [
          'override' => boolenv('BT_FREELANCER_OVERRIDE_GOVID', 'false'),
          'require_type' => boolenv('BT_FREELANCER_REQUIRE_ID_TYPE', 'false'),
          'require_number' => boolenv('BT_FREELANCER_REQUIRE_ID_NUMBER', 'false'),
          'front_enabled' => boolenv('BT_FREELANCER_ENABLE_ID_FRONT', 'false'),
          'require_front' => boolenv('BT_FREELANCER_REQUIRE_ID_FRONT', 'false'),
          'back_enabled' => boolenv('BT_FREELANCER_ENABLE_ID_BACK', 'false'),
          'require_back' => boolenv('BT_FREELANCER_REQUIRE_ID_BACK', 'false'),
        ],
        'registration' => [
          'override' => boolenv('BT_FREELANCER_OVERRIDE_REG', 'false'),
          'iata_enabled' => boolenv('BT_FREELANCER_IATA_ENABLE', 'false'),
          'iata_code_required_on_yes' => boolenv('BT_FREELANCER_IATA_REQUIRE_CODE', 'false'),
          'gst_number' => [
            'enabled' => boolenv('BT_FREELANCER_GST_NUMBER_ENABLE', 'false'),
            'required' => boolenv('BT_FREELANCER_GST_NUMBER_REQUIRE', 'false'),
          ],
          'gst_company' => [
            'enabled' => boolenv('BT_FREELANCER_GST_COMPANY_ENABLE', 'false'),
            'required' => boolenv('BT_FREELANCER_GST_COMPANY_REQUIRE', 'false'),
          ],
        ],
        'business_info' => [
          'override' => boolenv('BT_FREELANCER_OVERRIDE_BIZINFO', 'false'),
          'agency_name' => [
            'enabled' => boolenv('BT_FREELANCER_AGENCY_NAME_ENABLE', 'false'),
            'required' => boolenv('BT_FREELANCER_AGENCY_NAME_REQUIRE', 'false'),
          ],
        ],
        'media' => [
          'override' => boolenv('BT_FREELANCER_OVERRIDE_MEDIA', 'false'),
          'profile_photo' => [
            'enabled' => boolenv('BT_FREELANCER_PROFILE_PHOTO_ENABLE', 'false'),
            'required' => boolenv('BT_FREELANCER_PROFILE_PHOTO_REQUIRE', 'false'),
          ],
          'business_card' => [
            'enabled' => boolenv('BT_FREELANCER_BUSINESS_CARD_ENABLE', 'false'),
            'required' => boolenv('BT_FREELANCER_BUSINESS_CARD_REQUIRE', 'false'),
          ],
        ],
      ],
      'sp' => [
        'gov_id' => [
          'override' => boolenv('BT_SP_OVERRIDE_GOVID', 'false'),
          'require_type' => boolenv('BT_SP_REQUIRE_ID_TYPE', 'false'),
          'require_number' => boolenv('BT_SP_REQUIRE_ID_NUMBER', 'false'),
          'front_enabled' => boolenv('BT_SP_ENABLE_ID_FRONT', 'false'),
          'require_front' => boolenv('BT_SP_REQUIRE_ID_FRONT', 'false'),
          'back_enabled' => boolenv('BT_SP_ENABLE_ID_BACK', 'false'),
          'require_back' => boolenv('BT_SP_REQUIRE_ID_BACK', 'false'),
        ],
        'registration' => [
          'override' => boolenv('BT_SP_OVERRIDE_REG', 'false'),
          'iata_enabled' => boolenv('BT_SP_IATA_ENABLE', 'false'),
          'iata_code_required_on_yes' => boolenv('BT_SP_IATA_REQUIRE_CODE', 'false'),
          'gst_number' => [
            'enabled' => boolenv('BT_SP_GST_NUMBER_ENABLE', 'false'),
            'required' => boolenv('BT_SP_GST_NUMBER_REQUIRE', 'false'),
          ],
          'gst_company' => [
            'enabled' => boolenv('BT_SP_GST_COMPANY_ENABLE', 'false'),
            'required' => boolenv('BT_SP_GST_COMPANY_REQUIRE', 'false'),
          ],
        ],
        'business_info' => [
          'override' => boolenv('BT_SP_OVERRIDE_BIZINFO', 'false'),
          'agency_name' => [
            'enabled' => boolenv('BT_SP_AGENCY_NAME_ENABLE', 'false'),
            'required' => boolenv('BT_SP_AGENCY_NAME_REQUIRE', 'false'),
          ],
        ],
        'media' => [
          'override' => boolenv('BT_SP_OVERRIDE_MEDIA', 'false'),
          'profile_photo' => [
            'enabled' => boolenv('BT_SP_PROFILE_PHOTO_ENABLE', 'false'),
            'required' => boolenv('BT_SP_PROFILE_PHOTO_REQUIRE', 'false'),
          ],
          'business_card' => [
            'enabled' => boolenv('BT_SP_BUSINESS_CARD_ENABLE', 'false'),
            'required' => boolenv('BT_SP_BUSINESS_CARD_REQUIRE', 'false'),
          ],
        ],
      ],
      'llp' => [
        'gov_id' => [
          'override' => boolenv('BT_LLP_OVERRIDE_GOVID', 'false'),
          'require_type' => boolenv('BT_LLP_REQUIRE_ID_TYPE', 'false'),
          'require_number' => boolenv('BT_LLP_REQUIRE_ID_NUMBER', 'false'),
          'front_enabled' => boolenv('BT_LLP_ENABLE_ID_FRONT', 'false'),
          'require_front' => boolenv('BT_LLP_REQUIRE_ID_FRONT', 'false'),
          'back_enabled' => boolenv('BT_LLP_ENABLE_ID_BACK', 'false'),
          'require_back' => boolenv('BT_LLP_REQUIRE_ID_BACK', 'false'),
        ],
        'registration' => [
          'override' => boolenv('BT_LLP_OVERRIDE_REG', 'false'),
          'iata_enabled' => boolenv('BT_LLP_IATA_ENABLE', 'false'),
          'iata_code_required_on_yes' => boolenv('BT_LLP_IATA_REQUIRE_CODE', 'false'),
          'gst_number' => [
            'enabled' => boolenv('BT_LLP_GST_NUMBER_ENABLE', 'false'),
            'required' => boolenv('BT_LLP_GST_NUMBER_REQUIRE', 'false'),
          ],
          'gst_company' => [
            'enabled' => boolenv('BT_LLP_GST_COMPANY_ENABLE', 'false'),
            'required' => boolenv('BT_LLP_GST_COMPANY_REQUIRE', 'false'),
          ],
        ],
        'business_info' => [
          'override' => boolenv('BT_LLP_OVERRIDE_BIZINFO', 'false'),
          'agency_name' => [
            'enabled' => boolenv('BT_LLP_AGENCY_NAME_ENABLE', 'false'),
            'required' => boolenv('BT_LLP_AGENCY_NAME_REQUIRE', 'false'),
          ],
        ],
        'media' => [
          'override' => boolenv('BT_LLP_OVERRIDE_MEDIA', 'false'),
          'profile_photo' => [
            'enabled' => boolenv('BT_LLP_PROFILE_PHOTO_ENABLE', 'false'),
            'required' => boolenv('BT_LLP_PROFILE_PHOTO_REQUIRE', 'false'),
          ],
          'business_card' => [
            'enabled' => boolenv('BT_LLP_BUSINESS_CARD_ENABLE', 'false'),
            'required' => boolenv('BT_LLP_BUSINESS_CARD_REQUIRE', 'false'),
          ],
        ],
      ],
      'co' => [
        'gov_id' => [
          'override' => boolenv('BT_CO_OVERRIDE_GOVID', 'false'),
          'require_type' => boolenv('BT_CO_REQUIRE_ID_TYPE', 'false'),
          'require_number' => boolenv('BT_CO_REQUIRE_ID_NUMBER', 'false'),
          'front_enabled' => boolenv('BT_CO_ENABLE_ID_FRONT', 'false'),
          'require_front' => boolenv('BT_CO_REQUIRE_ID_FRONT', 'false'),
          'back_enabled' => boolenv('BT_CO_ENABLE_ID_BACK', 'false'),
          'require_back' => boolenv('BT_CO_REQUIRE_ID_BACK', 'false'),
        ],
        'registration' => [
          'override' => boolenv('BT_CO_OVERRIDE_REG', 'false'),
          'iata_enabled' => boolenv('BT_CO_IATA_ENABLE', 'false'),
          'iata_code_required_on_yes' => boolenv('BT_CO_IATA_REQUIRE_CODE', 'false'),
          'gst_number' => [
            'enabled' => boolenv('BT_CO_GST_NUMBER_ENABLE', 'false'),
            'required' => boolenv('BT_CO_GST_NUMBER_REQUIRE', 'false'),
          ],
          'gst_company' => [
            'enabled' => boolenv('BT_CO_GST_COMPANY_ENABLE', 'false'),
            'required' => boolenv('BT_CO_GST_COMPANY_REQUIRE', 'false'),
          ],
        ],
        'business_info' => [
          'override' => boolenv('BT_CO_OVERRIDE_BIZINFO', 'false'),
          'agency_name' => [
            'enabled' => boolenv('BT_CO_AGENCY_NAME_ENABLE', 'false'),
            'required' => boolenv('BT_CO_AGENCY_NAME_REQUIRE', 'false'),
          ],
        ],
        'media' => [
          'override' => boolenv('BT_CO_OVERRIDE_MEDIA', 'false'),
          'profile_photo' => [
            'enabled' => boolenv('BT_CO_PROFILE_PHOTO_ENABLE', 'false'),
            'required' => boolenv('BT_CO_PROFILE_PHOTO_REQUIRE', 'false'),
          ],
          'business_card' => [
            'enabled' => boolenv('BT_CO_BUSINESS_CARD_ENABLE', 'false'),
            'required' => boolenv('BT_CO_BUSINESS_CARD_REQUIRE', 'false'),
          ],
        ],
      ],
    ],
  ],
];
