<?php
// check_vendor.php
require __DIR__ . '/vendor/autoload.php';

$config = require __DIR__ . '/config/database.php';

try {
    $pdo = new PDO(
        "mysql:host={$config['host']};dbname={$config['database']};charset={$config['charset']}",
        $config['username'],
        $config['password'],
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );

    // Check vendor user
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ? AND role = 'Vendor'");
    $stmt->execute(['ancientjbrx@gmail.com']);
    $user = $stmt->fetch();

    echo "Vendor User:\n";
    print_r($user);

    // Check vendor record
    if ($user) {
        $stmt = $pdo->prepare("SELECT * FROM vendors WHERE contact_email = ? OR id = ?");
        $stmt->execute([$user['email'], $user['vendor_id'] ?? 0]);
        $vendor = $stmt->fetch();
        
        echo "\nVendor Record:\n";
        print_r($vendor);
    }

} catch (PDOException $e) {
    die("Error: " . $e->getMessage());
}
