<?php
$config = require_once 'config/config.php';
$pdo = $config['pdo'];

echo "=== WALLET TRANSACTIONS ANALYSIS ===\n\n";

// Check what types of transactions exist
$stmt = $pdo->query('SELECT category, transaction_type, COUNT(*) as count FROM wallet_transactions WHERE user_id = 10 GROUP BY category, transaction_type ORDER BY count DESC');
echo "Transaction types for agent 10:\n";
while ($row = $stmt->fetch()) {
    echo "  {$row['category']} ({$row['transaction_type']}): {$row['count']}\n";
}

echo "\n=== REFUND TRANSACTIONS ===\n";
$stmt = $pdo->prepare('SELECT * FROM wallet_transactions WHERE user_id = 10 AND category = "refund" ORDER BY created_at DESC LIMIT 5');
$stmt->execute();
$refunds = $stmt->fetchAll();
if (empty($refunds)) {
    echo "No refund transactions found\n";
} else {
    foreach ($refunds as $r) {
        echo "ID:{$r['id']} {$r['transaction_type']} ฿{$r['amount']} '{$r['description']}' {$r['created_at']}\n";
    }
}

echo "\n=== ADMIN CREDIT TRANSACTIONS ===\n";
$stmt = $pdo->prepare('SELECT * FROM wallet_transactions WHERE user_id = 10 AND category = "admin_credit" ORDER BY created_at DESC LIMIT 5');
$stmt->execute();
$credits = $stmt->fetchAll();
if (empty($credits)) {
    echo "No admin credit transactions found\n";
} else {
    foreach ($credits as $c) {
        echo "ID:{$c['id']} {$c['transaction_type']} ฿{$c['amount']} '{$c['description']}' {$c['created_at']}\n";
    }
}

echo "\n=== TAXI BOOKINGS STATUS ===\n";
$stmt = $pdo->prepare('SELECT id, status, payment_status, refund_amount, amount_total, payment_method FROM taxi_bookings WHERE agent_id = 10 ORDER BY created_at DESC LIMIT 5');
$stmt->execute();
$bookings = $stmt->fetchAll();
foreach ($bookings as $b) {
    echo "Booking {$b['id']}: status={$b['status']}, payment_status={$b['payment_status']}, refund_amount={$b['refund_amount']}, total={$b['amount_total']}, method={$b['payment_method']}\n";
}

echo "\n=== TEST REFUND TRIGGER ===\n";
// Test the refund trigger by updating a booking
$stmt = $pdo->prepare('SELECT id FROM taxi_bookings WHERE agent_id = 10 AND payment_method = "wallet" AND status != "refunded" LIMIT 1');
$stmt->execute();
$testBooking = $stmt->fetch();
if ($testBooking) {
    echo "Testing refund trigger on booking {$testBooking['id']}\n";
    
    // Count transactions before
    $stmt = $pdo->prepare('SELECT COUNT(*) FROM wallet_transactions WHERE user_id = 10');
    $stmt->execute();
    $countBefore = $stmt->fetchColumn();
    
    // Trigger refund
    $stmt = $pdo->prepare('UPDATE taxi_bookings SET status = "refunded", refund_amount = 100.00 WHERE id = ?');
    $stmt->execute([$testBooking['id']]);
    
    // Count transactions after
    $stmt = $pdo->prepare('SELECT COUNT(*) FROM wallet_transactions WHERE user_id = 10');
    $stmt->execute();
    $countAfter = $stmt->fetchColumn();
    
    echo "Transactions before: $countBefore, after: $countAfter\n";
    
    if ($countAfter > $countBefore) {
        echo "✓ Refund trigger worked! New transaction created.\n";
        
        // Show the new transaction
        $stmt = $pdo->prepare('SELECT * FROM wallet_transactions WHERE user_id = 10 ORDER BY created_at DESC LIMIT 1');
        $stmt->execute();
        $newTx = $stmt->fetch();
        echo "New transaction: ID:{$newTx['id']} {$newTx['category']} ฿{$newTx['amount']} '{$newTx['description']}'\n";
    } else {
        echo "✗ Refund trigger did not work\n";
    }
    
    // Revert the test
    $stmt = $pdo->prepare('UPDATE taxi_bookings SET status = "confirmed", refund_amount = NULL WHERE id = ?');
    $stmt->execute([$testBooking['id']]);
    echo "Test booking reverted\n";
}

echo "\n=== TEST ADMIN CREDIT TRIGGER ===\n";
// Test admin credit trigger
$stmt = $pdo->prepare('SELECT balance FROM wallets WHERE user_id = 10');
$stmt->execute();
$currentBalance = $stmt->fetchColumn();

echo "Current balance: ฿$currentBalance\n";

// Count transactions before
$stmt = $pdo->prepare('SELECT COUNT(*) FROM wallet_transactions WHERE user_id = 10');
$stmt->execute();
$countBefore = $stmt->fetchColumn();

// Add 50 THB credit
$stmt = $pdo->prepare('UPDATE wallets SET balance = balance + 50.00 WHERE user_id = 10');
$stmt->execute();

// Count transactions after
$stmt = $pdo->prepare('SELECT COUNT(*) FROM wallet_transactions WHERE user_id = 10');
$stmt->execute();
$countAfter = $stmt->fetchColumn();

echo "Transactions before: $countBefore, after: $countAfter\n";

if ($countAfter > $countBefore) {
    echo "✓ Admin credit trigger worked! New transaction created.\n";
    
    // Show the new transaction
    $stmt = $pdo->prepare('SELECT * FROM wallet_transactions WHERE user_id = 10 ORDER BY created_at DESC LIMIT 1');
    $stmt->execute();
    $newTx = $stmt->fetch();
    echo "New transaction: ID:{$newTx['id']} {$newTx['category']} ฿{$newTx['amount']} '{$newTx['description']}'\n";
} else {
    echo "✗ Admin credit trigger did not work\n";
}

// Revert the test
$stmt = $pdo->prepare('UPDATE wallets SET balance = balance - 50.00 WHERE user_id = 10');
$stmt->execute();
echo "Test credit reverted\n";
?>
