<?php
// app/Views/agent/wallet.php
?>
<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <h1 class="h4 mb-0">My Wallet</h1>
    <div>
      <a href="/agent" class="btn btn-sm btn-outline-secondary">Dashboard</a>
    </div>
  </div>

  <div class="row g-3 mb-3">
    <div class="col-12 col-md-4">
      <div class="card shadow-sm border-0">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center">
            <div>
              <div class="text-muted small">Current Balance</div>
              <div class="fs-4 fw-bold"><?php echo number_format((float)($balance ?? 0.0), 2); ?> THB</div>
            </div>
            <div class="text-end">
              <span class="badge bg-primary">Wallet</span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="row g-3">
    <div class="col-12 col-lg-6">
      <div class="card shadow-sm h-100">
        <div class="card-header bg-white">
          <strong>Recent Ledger</strong> <span class="text-muted small">(last 50)</span>
        </div>
        <div class="table-responsive">
          <table class="table align-middle mb-0">
            <thead>
              <tr>
                <th>ID</th>
                <th>Type</th>
                <th>Amount</th>
                <th>Method</th>
                <th>Status</th>
                <th>Created</th>
              </tr>
            </thead>
            <tbody>
            <?php if (!empty($ledger)): foreach ($ledger as $r): ?>
              <tr>
                <td>#<?php echo (int)$r['id']; ?></td>
                <td class="text-uppercase">
                  <?php $t = (string)$r['type']; $tBadge = $t==='credit' ? 'bg-success' : 'bg-danger'; ?>
                  <span class="badge <?php echo $tBadge; ?>"><?php echo htmlspecialchars($t); ?></span>
                </td>
                <td><strong><?php echo number_format((float)$r['amount'], 2); ?></strong></td>
                <td><?php echo htmlspecialchars($r['method']); ?></td>
                <td>
                  <?php $s = (string)$r['status']; $sBadge = $s==='approved' ? 'bg-success' : ($s==='pending'?'bg-warning text-dark':'bg-danger'); ?>
                  <span class="badge <?php echo $sBadge; ?>"><?php echo htmlspecialchars($s); ?></span>
                </td>
                <td class="text-nowrap">&nbsp;<?php echo htmlspecialchars($r['created_at'] ?? ''); ?></td>
              </tr>
            <?php endforeach; else: ?>
              <tr>
                <td colspan="6" class="text-center text-muted py-4">No ledger entries yet.</td>
              </tr>
            <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>

    <div class="col-12 col-lg-6">
      <div class="card shadow-sm h-100">
        <div class="card-header bg-white">
          <strong>Recent Bookings</strong> <span class="text-muted small">(last 50)</span>
        </div>
        <div class="table-responsive">
          <table class="table align-middle mb-0">
            <thead>
              <tr>
                <th>ID</th>
                <th>Module</th>
                <th>PAX</th>
                <th>Price</th>
                <th>Status</th>
                <th>Created</th>
              </tr>
            </thead>
            <tbody>
            <?php if (!empty($bookings)): foreach ($bookings as $b): ?>
              <tr>
                <td>#<?php echo (int)$b['id']; ?></td>
                <td class="text-capitalize"><?php echo htmlspecialchars($b['module']); ?></td>
                <td><?php echo (int)$b['pax']; ?></td>
                <td><strong><?php echo number_format((float)$b['price'], 2); ?></strong></td>
                <td>
                  <?php $bs = (string)$b['status']; $bsBadge = $bs==='confirmed' ? 'bg-success' : ($bs==='pending'?'bg-warning text-dark':($bs==='cancelled'?'bg-danger':'bg-secondary')); ?>
                  <span class="badge <?php echo $bsBadge; ?>"><?php echo htmlspecialchars($bs); ?></span>
                </td>
                <td class="text-nowrap">&nbsp;<?php echo htmlspecialchars($b['created_at'] ?? ''); ?></td>
              </tr>
            <?php endforeach; else: ?>
              <tr>
                <td colspan="6" class="text-center text-muted py-4">No bookings yet.</td>
              </tr>
            <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
