<?php
  // app/Views/agent/index.php
  // Mobile-first Agent shell with bottom tabs (Hotels, Activities, Taxi)
?>
<style>
  /* Sticky bottom nav on mobile (frosted) */
  .agent-bottom-nav{position:sticky;bottom:0;z-index:1020;background:rgba(255,255,255,.85);backdrop-filter:saturate(140%) blur(10px);border-top:1px solid rgba(2,6,23,.08)}
  .agent-bottom-nav .nav-pills{display:flex;gap:6px;padding:8px 10px}
  .agent-bottom-nav .nav-item{flex:1}
  .agent-bottom-nav .nav-link{position:relative;display:flex;flex-direction:column;align-items:center;justify-content:center;gap:2px;border:1px solid rgba(2,6,23,.10);background:rgba(2,6,23,.02);color:#334155;border-radius:12px;padding:10px 0;min-height:48px;box-shadow:0 1px 0 rgba(255,255,255,.9) inset;-webkit-tap-highlight-color:transparent}
  .agent-bottom-nav .nav-link i{font-size:1.15rem;line-height:1;opacity:.9}
  .agent-bottom-nav .nav-link .small{margin-top:2px;font-weight:600;letter-spacing:.1px}
  .agent-bottom-nav .nav-link:hover{background:rgba(2,6,23,.04)}
  .agent-bottom-nav .nav-link:active{transform:translateY(.5px)}
  .agent-bottom-nav .nav-link:focus-visible{outline:2px solid rgba(42,140,240,.35);outline-offset:2px}
  .agent-bottom-nav .nav-link.active{color:#0b4aa1;background:linear-gradient(180deg, rgba(42,140,240,.16) 0%, rgba(42,140,240,.08) 100%);border-color:rgba(42,140,240,.45);box-shadow:0 6px 14px rgba(11,74,161,.15), 0 0 0 1px rgba(255,255,255,.7) inset}
  .agent-bottom-nav .nav-link.active i{opacity:1}
  .agent-cta{position:fixed;right:16px;bottom:72px;z-index:1020}
  @media (min-width: 992px){.agent-cta{bottom:24px}}
  .input-chip{display:inline-flex;align-items:center;gap:.375rem;background:#f1f5f9;border-radius:999px;padding:.375rem .625rem;font-size:.85rem}
  /* Hero: subtle gradient overlay for premium feel */
  .agent-hero{background:linear-gradient(180deg, rgba(2,6,23,.70) 0%, rgba(2,6,23,.42) 60%, rgba(2,6,23,0) 100%);color:#fff;padding:28px 0 36px;border-bottom-left-radius:0;border-bottom-right-radius:0}
  /* Global polish */
  .btn, .nav-link, .form-control, .form-select { transition: all .12s ease-in-out }
  .form-control:focus, .form-select:focus { box-shadow:0 0 0 3px rgba(13,110,253,.15) }
  /* Page typography scope */
  .agent-scope{font-size:15px;line-height:1.55;color:#0f172a}

  /* Input icons */
  .input-icon-wrap{position:relative}
  .input-icon{position:absolute;left:10px;top:50%;transform:translateY(-50%);color:#64748b}
  .input-icon + .form-control, .input-icon + .form-select{padding-left:2rem}

  /* Skeleton loader */
  .skeleton{background:linear-gradient(90deg, rgba(148,163,184,.18), rgba(148,163,184,.10), rgba(148,163,184,.18));background-size:200% 100%;animation:sk 1.2s infinite}
  @keyframes sk{0%{background-position:200% 0}100%{background-position:-200% 0}}
  .skeleton-line{height:10px;border-radius:6px}
  .skeleton-box{border:1px solid rgba(2,6,23,.06);border-radius:12px;padding:12px;background:#fff}

  /* Trust bar */
  .trust-bar{background:#fff;border:1px solid rgba(2,6,23,.08);border-radius:10px;box-shadow:0 4px 12px rgba(2,6,23,.05)}
  .trust-item{display:flex;align-items:center;gap:.5rem;color:#0f172a}
  .trust-item .icon{width:24px;height:24px;border-radius:50%;display:inline-flex;align-items:center;justify-content:center;background:#e6f0ff;color:#0b4aa1;font-size:.9rem}
  .trust-item .label{font-weight:600;font-size:.9rem}
  .trust-item + .trust-item{position:relative;padding-left:14px;margin-left:4px}
  .trust-item + .trust-item::before{content:"";position:absolute;left:0;top:50%;transform:translateY(-50%);height:22px;width:1px;background:rgba(2,6,23,.10)}
  .support-cta{border:1px dashed rgba(2,6,23,.2);border-radius:10px}
  /* Trust strip (footer) */
  .trust-strip{border-radius:12px}
  .trust-grid{display:grid;grid-template-columns:repeat(4,minmax(0,1fr));gap:10px 18px;align-items:center}
  .trust-grid .trust-item{display:flex;align-items:flex-start;gap:.55rem;padding:6px 10px}
  .trust-grid .trust-item .icon{width:22px;height:22px}
  .trust-grid .trust-item .label{font-size:.95rem}
  @media (min-width: 768px){
    .trust-grid .trust-item + .trust-item{margin-left:0;padding-left:18px}
    .trust-grid .trust-item + .trust-item::before{left:0;height:26px}
  }
  @media (max-width: 575.98px){
    .trust-grid{grid-template-columns:repeat(2,minmax(0,1fr))}
    .trust-grid .trust-item{padding:6px 4px}
  }
  /* Wallet summary */
  .wallet-summary{background:#fff;border:1px solid rgba(2,6,23,.08);border-radius:10px;box-shadow:0 4px 12px rgba(2,6,23,.05);padding:14px}
  .wallet-summary .amount{font-weight:800;font-size:1.15rem;color:#0f172a}
  .wallet-summary .meta{color:#64748b}
  .wallet-summary .actions .btn{--bs-btn-padding-y:.35rem;--bs-btn-padding-x:.7rem}
  /* Welcome card (right) */
  .welcome-card .fw-semibold{font-size:.95rem}
  .welcome-card .small{font-size:.8rem}
  .welcome-card .btn{--bs-btn-padding-y:.35rem;--bs-btn-padding-x:.7rem;font-size:.875rem}
  @media (max-width: 991.98px){
    .trust-item + .trust-item{padding-left:0;margin-left:0}
    .trust-item + .trust-item::before{display:none}
  }

  /* Elevated search box */
  .search-card{background:transparent;border:none;box-shadow:none;overflow:visible;position:relative;z-index:0;border-radius:0}
  .search-card .card-body{padding:0}
  .search-floating{background:#fff;border:1px solid rgba(2,6,23,.06);border-radius:8px;box-shadow:0 18px 30px rgba(2,6,23,.12), 0 2px 6px rgba(2,6,23,.06);position:relative;padding:20px 16px 16px;z-index:1}
  .search-floating::before{content:"";position:absolute;inset:0;border-radius:8px;box-shadow:inset 0 1px 0 rgba(255,255,255,.9);pointer-events:none;z-index:0}
  .search-floating::after{content:"";position:absolute;left:12px;right:12px;bottom:-14px;height:22px;border-radius:50%;background:radial-gradient(50% 50% at 50% 50%, rgba(2,6,23,.18) 0%, rgba(2,6,23,0) 70%);filter:blur(6px);opacity:.35;z-index:0}
  .search-floating h2{margin-top:0;margin-bottom:12px;color:#0f172a}
  .search-floating:hover, .search-floating:focus-within{box-shadow:0 26px 42px rgba(2,6,23,.16), 0 8px 16px rgba(2,6,23,.08);transform:translateY(-2px)}
  body.b2b.theme-light .search-floating{background:#ffffff}

  /* Mobile/iPhone responsiveness */
  @media (max-width: 575.98px){
    /* Single-column search */
    .search-floating{padding:16px 12px}
    .search-floating .row > [class*="col-"]{flex:0 0 100%;max-width:100%}
    .search-floating .btn{width:100%}
    /* Avoid iOS zoom on focus */
    .search-floating input.form-control, .search-floating select.form-select{font-size:16px}
    /* Trust strip */
    .trust-bar{padding:10px 12px !important}
    .trust-bar .flex-grow-1{gap:.5rem !important}
    .trust-item .label{font-size:.88rem}
    .trust-item .icon{width:22px;height:22px}
    /* Welcome card CTA smaller */
    .welcome-card .btn{font-size:.8rem;padding:.35rem .6rem}
  }

  /* Safe area for iPhone bottom notch */
  .agent-bottom-nav{padding-bottom:max(6px, env(safe-area-inset-bottom))}
  .agent-scope{padding-bottom: max(12px, env(safe-area-inset-bottom))}

  /* Helper badges (e.g., Instant) */
  .agent-hero .badge-soft{display:inline-flex;align-items:center;gap:.4rem;background:#eef6ff;color:#0b4aa1;border:1px solid #d7e8ff;border-radius:999px;padding:.25rem .55rem;font-weight:600}
  /* Card elevation + polish */
  .card-elevated{border:1px solid rgba(16,24,40,.06);box-shadow:0 8px 18px rgba(2,24,57,.08);border-radius:14px;background:var(--b2b-white,#fff)}
  .card-elevated .card-body{padding:16px}
  @media (min-width:768px){.card-elevated .card-body{padding:18px}}
  @media (min-width:1200px){.card-elevated .card-body{padding:20px}}
  /* Hero quick actions: single line below title */
  .hero-row{display:flex;flex-wrap:wrap;gap:.35rem .5rem;margin-top:.35rem}
  .hero-row .ha-link{display:inline-flex;align-items:center;gap:.35rem;border:1px solid rgba(255,255,255,.35);color:#fff;background:rgba(255,255,255,.08);border-radius:999px;padding:.18rem .55rem;font-weight:700;line-height:1}
  .hero-row .ha-link i{opacity:.95}
  .hero-row .ha-link:hover{background:rgba(255,255,255,.16);text-decoration:none}
  body.b2b.theme-light .hero-row .ha-link{color:#0f172a;border-color:rgba(2,6,23,.18);background:rgba(255,255,255,.75)}
  /* Desktop content tabs below hero */
  #agentTabs{border-bottom:1px solid var(--b2b-primary-200, rgba(11,74,161,.18));gap:.25rem;margin-top:.25rem}
  #agentTabs .nav-link{border:none;border-radius:.5rem;color:rgba(255,255,255,.92);background:transparent;padding:.4rem .8rem;font-weight:700}
  #agentTabs .nav-link i{opacity:.9}
  #agentTabs .nav-link:hover{background:rgba(255,255,255,.09);color:#ffffff}
  #agentTabs .nav-link:focus-visible{outline:2px solid rgba(255,255,255,.65);outline-offset:2px}
  #agentTabs .nav-link.active{background:#fff;color:var(--b2b-primary-700,#0b4aa1);border:1px solid var(--b2b-primary-200, rgba(11,74,161,.18));box-shadow:0 1px 0 rgba(0,0,0,.04)}
  /* Hero typography */
  .agent-hero .hero-title{font-family: ui-sans-serif, -apple-system, Segoe UI, Roboto, Helvetica, Arial, "Apple Color Emoji", "Segoe UI Emoji"; font-weight:700; letter-spacing:.1px; line-height:1.25; font-size:12px; margin:0 0 .25rem}
  .agent-hero .lead{opacity:.95; font-size:12px; line-height:1.45}
  .agent-hero h1{font-family: ui-sans-serif, -apple-system, Segoe UI, Roboto, Helvetica, Arial, "Apple Color Emoji", "Segoe UI Emoji"; font-weight:700; letter-spacing:.1px; line-height:1.25; font-size:16px; margin:0 0 .25rem}
  /* Light theme overrides for readability */
  body.b2b.theme-light .agent-hero{color:var(--b2b-text-900,#0f172a);background:linear-gradient(180deg, rgba(255,255,255,0) 0%, rgba(239,244,249,.65) 100%)}
  body.b2b.theme-light .agent-hero .text-white{color:var(--b2b-text-900,#0f172a)!important}
  body.b2b.theme-light .agent-hero .lead{opacity:.9}
  /* Corporate Minimal: underline tabs, no chip */
  body.b2b.theme-light #agentTabs{border-bottom:1px solid rgba(2,6,23,.08)}
  body.b2b.theme-light #agentTabs .nav-link{color:rgba(2,6,23,.80);background:transparent;border:none;border-radius:0;padding:.5rem .75rem;position:relative}
  body.b2b.theme-light #agentTabs .nav-link:hover{background:transparent;color:#0f172a}
  body.b2b.theme-light #agentTabs .nav-link:focus-visible{outline:2px solid rgba(2,6,23,.25)}
  body.b2b.theme-light #agentTabs .nav-link.active{background:transparent;color:var(--b2b-accent,#2a8cf0);border:none;box-shadow:none}
  body.b2b.theme-light #agentTabs .nav-link.active::after{content:"";position:absolute;left:.5rem;right:.5rem;bottom:-1px;height:2px;border-radius:2px;background:var(--b2b-accent,#2a8cf0)}
  /* Flatter cards in light */
  body.b2b.theme-light .card-elevated{box-shadow:0 4px 12px rgba(2,6,23,.06);border:1px solid rgba(2,6,23,.06);border-radius:12px}

  /* Bottom nav: icon-only on small screens */
  @media (max-width: 575.98px){
    .agent-bottom-nav .nav-link .small{display:none}
    .agent-bottom-nav .nav-link i{font-size:1.25rem}
    .agent-bottom-nav .nav-pills{gap:6px}
    .agent-bottom-nav .nav-link{min-height:44px;padding:10px 0}
    /* Fix to bottom for app-like feel */
    .agent-bottom-nav{position:fixed;left:0;right:0;bottom:0;background:rgba(255,255,255,.92);backdrop-filter:saturate(140%) blur(12px);box-shadow:0 -8px 22px rgba(2,6,23,.12)}
    /* Page padding so content never sits under fixed nav */
    .agent-scope{padding-bottom:calc(86px + env(safe-area-inset-bottom))}
  }
</style>

<!-- Hero header -->
<section class="agent-hero">
  <div class="tw-max-w-screen-2xl tw-mx-auto tw-px-4">
    <div class="tw-flex tw-flex-col md:tw-flex-row md:tw-items-center tw-justify-between tw-gap-3">
      <div class="tw-text-white">
        <h1 class="tw-text-xl md:tw-text-2xl tw-font-bold tw-mb-1">Thailand’s Premier B2B Travel Booking Engine</h1>
        <p class="tw-opacity-95 tw-text-sm md:tw-text-base tw-m-0">Live inventory for Activities, Hotels, Cars, Yachts & Packages — with API access, agent-only rates, and THB wallet support</p>
      </div>
      <div class="tw-hidden md:tw-block">
        <!-- Optional CTA buttons could go here -->
      </div>
    </div>
  </div>

  </section>
<!-- Welcome + Trust signals -->
<?php 
  $agentName = $_SESSION['agent']['name'] ?? ($_SESSION['user']['name'] ?? 'Agent');
  $kycStatus = $_SESSION['agent']['kyc_status'] ?? ($_SESSION['user']['kyc_status'] ?? 'pending');
  $kycDone = in_array(strtolower((string)$kycStatus), ['approved','verified','complete','1'], true);
?>
<div class="tw-max-w-screen-2xl tw-mx-auto tw-px-4 tw-pt-2 agent-scope">
  <div class="tw-grid tw-grid-cols-1 lg:tw-grid-cols-12 tw-gap-3">
    <div class="tw-col-span-12 lg:tw-col-span-8">
      <?php 
        $walletBalance = $_SESSION['agent']['wallet_balance'] ?? ($_SESSION['wallet']['balance'] ?? 0);
        $walletCurrency = $_SESSION['agent']['wallet_currency'] ?? ($_SESSION['wallet']['currency'] ?? 'THB');
        $walletUpdated = $_SESSION['agent']['wallet_updated_at'] ?? null;
      ?>
      <div class="wallet-summary tw-flex tw-items-center tw-justify-between">
        <div>
          <div class="tw-text-slate-500 tw-text-xs">Wallet Balance</div>
          <div class="amount"><?= htmlspecialchars($walletCurrency) ?> <?= number_format((float)$walletBalance, 2) ?></div>
          <div class="meta tw-text-slate-500 tw-text-xs"><?= $walletUpdated ? 'Updated '.htmlspecialchars($walletUpdated) : 'Updated just now' ?></div>
        </div>
        <div class="tw-flex tw-gap-2">
          <a href="/agent/wallet" class="tw-inline-flex tw-items-center tw-gap-1 tw-rounded tw-border tw-border-[var(--b2b-primary-300,#7fb4f6)] tw-text-[var(--b2b-primary-700,#0b4aa1)] hover:tw-bg-[var(--b2b-primary-50,#e6f0ff)] tw-px-3 tw-py-1 tw-text-sm"><i class="bi bi-wallet2"></i> Wallet</a>
          <a href="/agent/wallet/add-funds" class="tw-inline-flex tw-items-center tw-gap-1 tw-rounded tw-bg-[var(--b2b-primary-600,#2563eb)] hover:tw-bg-[var(--b2b-primary-700,#1d4ed8)] tw-text-white tw-px-3 tw-py-1 tw-text-sm"><i class="bi bi-plus-circle"></i> Add Funds</a>
        </div>
      </div>
    </div>
    <div class="tw-col-span-12 lg:tw-col-span-4">
      <div class="tw-p-3 trust-bar welcome-card tw-flex tw-items-center tw-justify-between">
        <div>
          <div class="tw-font-semibold">Welcome, <?= htmlspecialchars($agentName) ?></div>
          <div class="tw-text-xs <?= $kycDone ? 'tw-text-green-600' : 'tw-text-amber-600' ?>">
            <i class="bi <?= $kycDone ? 'bi-shield-check' : 'bi-exclamation-triangle' ?> tw-mr-1"></i>
            KYC <?= $kycDone ? 'Verified' : 'Pending' ?>
          </div>
        </div>
        <div>
          <a href="mailto:support@b3bthaihub.com" class="tw-inline-flex tw-items-center tw-gap-1 tw-rounded tw-border tw-border-[var(--b2b-primary-300,#7fb4f6)] tw-text-[var(--b2b-primary-700,#0b4aa1)] hover:tw-bg-[var(--b2b-primary-50,#e6f0ff)] tw-px-3 tw-py-1 tw-text-sm"><i class="bi bi-life-preserver"></i> Contact Support</a>
        </div>
      </div>
    </div>
  </div>
  </div>

<div class="tw-max-w-screen-2xl tw-mx-auto tw-px-4 tw-pb-3 agent-scope">
  <div class="tw-grid tw-grid-cols-1">
    <div class="tw-col-span-1">
      

      <div class="tw-hidden md:tw-flex tw-gap-1" id="agentTabs">
        <button class="tw-px-3 tw-py-1.5 tw-rounded tw-font-semibold tw-text-white tw-bg-white/10 tw-border tw-border-white/20 tab-btn" data-target="#activities"><i class="bi bi-ticket-perforated tw-mr-1"></i> Activities</button>
        <button class="tw-px-3 tw-py-1.5 tw-rounded tw-font-semibold tw-text-white/90 hover:tw-text-white tw-border tw-border-transparent tab-btn" data-target="#cars"><i class="bi bi-taxi-front-fill tw-mr-1"></i> Taxi</button>
        <button class="tw-px-3 tw-py-1.5 tw-rounded tw-font-semibold tw-text-white/90 hover:tw-text-white tw-border tw-border-transparent tab-btn" data-target="#hotels"><i class="bi bi-building tw-mr-1"></i> Hotels</button>
        <button class="tw-px-3 tw-py-1.5 tw-rounded tw-font-semibold tw-text-white/90 hover:tw-text-white tw-border tw-border-transparent tab-btn" data-target="#yachts"><i class="bi bi-tsunami tw-mr-1"></i> Yachts</button>
        <button class="tw-px-3 tw-py-1.5 tw-rounded tw-font-semibold tw-text-white/90 hover:tw-text-white tw-border tw-border-transparent tab-btn" data-target="#packages"><i class="bi bi-box-seam tw-mr-1"></i> Packages</button>
      </div>

      <div class="tw-pt-2" id="agentTabsContent">
        <!-- Hotels -->
        <div id="hotels" class="tw-hidden" role="tabpanel" aria-labelledby="hotels-tab">
          <div class="card search-card tw-mb-4">
            <div class="card-body search-floating">
              <h2 class="tw-text-sm tw-font-semibold tw-mb-3">Search Hotels</h2>
              <form class="tw-grid tw-grid-cols-12 tw-gap-2" id="hotelSearchForm">
                <div class="tw-col-span-12 md:tw-col-span-4">
                  <label class="tw-text-xs tw-font-medium tw-text-slate-600">Destination</label>
                  <div class="input-icon-wrap">
                    <span class="input-icon"><i class="bi bi-geo-alt"></i></span>
                    <input type="text" id="hotelCity" name="city" class="tw-w-full tw-border tw-rounded tw-py-2 tw-px-3" placeholder="City, area, or hotel name" autocomplete="off">
                  </div>
                </div>
                <div class="tw-col-span-6 md:tw-col-span-2">
                  <label class="tw-text-xs tw-font-medium tw-text-slate-600">Check-in</label>
                  <div class="input-icon-wrap">
                    <span class="input-icon"><i class="bi bi-calendar-event"></i></span>
                    <input type="date" id="hotelCheckin" name="checkin" class="tw-w-full tw-border tw-rounded tw-py-2 tw-pl-8 tw-pr-2">
                  </div>
                </div>
                <div class="tw-col-span-6 md:tw-col-span-2">
                  <label class="tw-text-xs tw-font-medium tw-text-slate-600">Check-out</label>
                  <div class="input-icon-wrap">
                    <span class="input-icon"><i class="bi bi-calendar-check"></i></span>
                    <input type="date" id="hotelCheckout" name="checkout" class="tw-w-full tw-border tw-rounded tw-py-2 tw-pl-8 tw-pr-2">
                  </div>
                </div>
                <div class="tw-col-span-6 md:tw-col-span-2">
                  <label class="tw-text-xs tw-font-medium tw-text-slate-600">Guests</label>
                  <div class="input-icon-wrap">
                    <span class="input-icon"><i class="bi bi-people"></i></span>
                    <input type="number" min="1" value="2" id="hotelGuests" name="adults" class="tw-w-full tw-border tw-rounded tw-py-2 tw-pl-8 tw-pr-2">
                  </div>
                </div>
                <div class="tw-col-span-6 md:tw-col-span-2">
                  <label class="tw-invisible md:tw-visible tw-text-xs">Search</label>
                  <button class="tw-w-full tw-inline-flex tw-items-center tw-justify-center tw-gap-2 tw-rounded tw-bg-[var(--b2b-primary-600,#2563eb)] hover:tw-bg-[var(--b2b-primary-700,#1d4ed8)] tw-text-white tw-px-3 tw-py-2"><i class="bi bi-search"></i> Find</button>
                </div>
              </form>
            </div>
          </div>

          
        </div>

        <!-- Activities -->
        <div id="activities" class="tw-block" role="tabpanel" aria-labelledby="activities-tab">
          <div class="card card-elevated tw-mb-3">
            <div class="card-body">
              <h2 class="tw-text-sm tw-font-semibold tw-mb-3">Search Activities</h2>
              <form class="tw-grid tw-grid-cols-12 tw-gap-2" id="activitySearchForm">
                <div class="tw-col-span-12 md:tw-col-span-6">
                  <label class="tw-text-xs tw-font-medium tw-text-slate-600">Activity / City</label>
                  <div class="input-icon-wrap">
                    <span class="input-icon"><i class="bi bi-search"></i></span>
                    <input type="text" id="activityQuery" name="q" class="tw-w-full tw-border tw-rounded tw-py-2 tw-pl-8 tw-pr-2" placeholder="Type activity name or city" autocomplete="off">
                  </div>
                </div>
                <div class="tw-col-span-12 md:tw-col-span-2">
                  <label class="tw-invisible md:tw-visible tw-text-xs">Search</label>
                  <button class="tw-w-full tw-inline-flex tw-items-center tw-justify-center tw-gap-2 tw-rounded tw-bg-[var(--b2b-primary-600,#2563eb)] hover:tw-bg-[var(--b2b-primary-700,#1d4ed8)] tw-text-white tw-px-3 tw-py-2" type="submit"><i class="bi bi-search"></i> Find</button>
                </div>
              </form>
            </div>
          </div>
          <!-- Results moved to dedicated Activities List page -->
        </div>

        <!-- Cars (renamed from Taxi) -->
        <div id="cars" class="tw-hidden" role="tabpanel" aria-labelledby="cars-tab">
          <div class="card card-elevated tw-mb-3">
            <div class="card-body">
              <h2 class="tw-text-sm tw-font-semibold tw-mb-3">Book Car</h2>
              <form class="tw-grid tw-grid-cols-12 tw-gap-2" id="taxiQuoteForm">
                <div class="tw-col-span-12 md:tw-col-span-4">
                  <label class="tw-text-xs tw-font-medium tw-text-slate-600">Pickup</label>
                  <input type="text" id="taxiFrom" name="from" class="tw-w-full tw-border tw-rounded tw-py-2 tw-px-3" placeholder="Airport, hotel, or address" autocomplete="off">
                </div>
                <div class="tw-col-span-12 md:tw-col-span-4">
                  <label class="tw-text-xs tw-font-medium tw-text-slate-600">Drop</label>
                  <input type="text" id="taxiTo" name="to" class="tw-w-full tw-border tw-rounded tw-py-2 tw-px-3" placeholder="Destination" autocomplete="off">
                </div>
                <div class="tw-col-span-6 md:tw-col-span-2">
                  <label class="tw-text-xs tw-font-medium tw-text-slate-600">Date</label>
                  <input type="datetime-local" id="taxiAt" name="at" class="tw-w-full tw-border tw-rounded tw-py-2 tw-px-3">
                </div>
                <div class="tw-col-span-6 md:tw-col-span-2">
                  <label class="tw-invisible md:tw-visible tw-text-xs">Search</label>
                  <button class="tw-w-full tw-inline-flex tw-items-center tw-justify-center tw-gap-2 tw-rounded tw-bg-[var(--b2b-primary-600,#2563eb)] hover:tw-bg-[var(--b2b-primary-700,#1d4ed8)] tw-text-white tw-px-3 tw-py-2"><i class="bi bi-search"></i> Quote</button>
                </div>
              </form>
            </div>
          </div>
          <div class="card card-elevated">
            <div class="card-body">
              <h3 class="tw-text-sm tw-font-semibold tw-mb-2">Saved routes</h3>
              <div class="tw-text-slate-500 tw-text-xs">No saved routes yet.</div>
              <hr>
              <div id="taxiResults" class="tw-mt-2">
                <div class="tw-text-slate-500 tw-text-xs">Enter pickup and drop to get quotes.</div>
              </div>
            </div>
          </div>
        </div>
        <!-- Yachts placeholder -->
        <div id="yachts" class="tw-hidden" role="tabpanel" aria-labelledby="yachts-tab">
          <div class="card card-elevated">
            <div class="card-body">
              <h2 class="tw-text-sm tw-font-semibold tw-mb-2">Yachts</h2>
              <div class="tw-text-slate-500 tw-text-xs">Coming soon.</div>
            </div>
          </div>
        </div>
        <!-- Packages placeholder -->
        <div id="packages" class="tw-hidden" role="tabpanel" aria-labelledby="packages-tab">
          <div class="card card-elevated">
            <div class="card-body">
              <h2 class="tw-text-sm tw-font-semibold tw-mb-2">Packages</h2>
              <div class="tw-text-slate-500 tw-text-xs">Coming soon.</div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Trust signals above footer -->
<div class="tw-max-w-screen-2xl tw-mx-auto tw-px-4 tw-mt-3">
  <div class="tw-grid tw-grid-cols-1">
    <div class="tw-col-span-1">
      <div class="trust-bar trust-strip tw-p-3">
        <div class="trust-grid">
          <div class="trust-item"><span class="icon"><i class="bi bi-shield-lock"></i></span><div><div class="label">SSL Secure</div><div class="small text-muted">256-bit encryption</div></div></div>
          <div class="trust-item"><span class="icon"><i class="bi bi-patch-check"></i></span><div><div class="label">Verified Suppliers</div><div class="small text-muted">Curated inventory</div></div></div>
          <div class="trust-item"><span class="icon"><i class="bi bi-headset"></i></span><div><div class="label">24x7 Support</div><div class="small text-muted">Priority agent help</div></div></div>
          <div class="trust-item"><span class="icon"><i class="bi bi-cash-coin"></i></span><div><div class="label">Best Price</div><div class="small text-muted">Transparent margins</div></div></div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Mobile bottom nav -->
<div class="agent-bottom-nav md:tw-hidden">
  <div class="tw-flex tw-gap-1 tw-px-2 tw-py-1" role="tablist">
    <button class="tw-flex-1 tw-flex tw-flex-col tw-items-center tw-justify-center tw-gap-0.5 tw-border tw-rounded-xl tw-min-h-11 tw-text-slate-700 tw-bg-slate-50 tab-btn-mobile active" data-target="#activities" aria-label="Activities"><i class="bi bi-ticket-perforated"></i><div class="tw-text-[11px] tw-font-semibold">Activities</div></button>
    <button class="tw-flex-1 tw-flex tw-flex-col tw-items-center tw-justify-center tw-gap-0.5 tw-border tw-rounded-xl tw-min-h-11 tw-text-slate-700 tw-bg-slate-50 tab-btn-mobile" data-target="#cars" aria-label="Taxi"><i class="bi bi-taxi-front"></i><div class="tw-text-[11px] tw-font-semibold">Taxi</div></button>
    <button class="tw-flex-1 tw-flex tw-flex-col tw-items-center tw-justify-center tw-gap-0.5 tw-border tw-rounded-xl tw-min-h-11 tw-text-slate-700 tw-bg-slate-50 tab-btn-mobile" data-target="#hotels" aria-label="Hotels"><i class="bi bi-building"></i><div class="tw-text-[11px] tw-font-semibold">Hotels</div></button>
    <button class="tw-flex-1 tw-flex tw-flex-col tw-items-center tw-justify-center tw-gap-0.5 tw-border tw-rounded-xl tw-min-h-11 tw-text-slate-700 tw-bg-slate-50 tab-btn-mobile" data-target="#yachts" aria-label="Yachts"><i class="bi bi-tsunami"></i><div class="tw-text-[11px] tw-font-semibold">Yachts</div></button>
    <button class="tw-flex-1 tw-flex tw-flex-col tw-items-center tw-justify-center tw-gap-0.5 tw-border tw-rounded-xl tw-min-h-11 tw-text-slate-700 tw-bg-slate-50 tab-btn-mobile" data-target="#packages" aria-label="Packages"><i class="bi bi-box-seam"></i><div class="tw-text-[11px] tw-font-semibold">Packages</div></button>
  </div>
  </div>

<!-- Floating action: New Booking (future hook) -->
<div class="agent-cta md:tw-hidden">
  <button class="tw-rounded-full tw-shadow tw-bg-[var(--b2b-primary-600,#2563eb)] hover:tw-bg-[var(--b2b-primary-700,#1d4ed8)] tw-text-white" style="width:52px;height:52px"><i class="bi bi-plus-lg"></i></button>
  </div>

<script>
  // Tabs without Bootstrap: simple toggle
  function setActiveTab(targetSelector){
    const panes = document.querySelectorAll('#agentTabsContent > div[role="tabpanel"]');
    panes.forEach(p => { if (p) p.classList.add('tw-hidden'); });
    const target = document.querySelector(targetSelector);
    if (target) target.classList.remove('tw-hidden');
    // desktop buttons
    document.querySelectorAll('#agentTabs .tab-btn').forEach(btn => {
      const t = btn.getAttribute('data-target');
      if (t === targetSelector) {
        btn.classList.add('tw-bg-white/10','tw-text-white','tw-border','tw-border-white/20');
      } else {
        btn.classList.remove('tw-bg-white/10','tw-text-white','tw-border','tw-border-white/20');
      }
    });
    // mobile buttons
    document.querySelectorAll('.tab-btn-mobile').forEach(btn => {
      const t = btn.getAttribute('data-target');
      if (t === targetSelector) {
        btn.classList.add('active');
      } else {
        btn.classList.remove('active');
      }
    });
  }

  document.addEventListener('DOMContentLoaded', function(){
    // wire desktop
    document.querySelectorAll('#agentTabs .tab-btn').forEach(btn => {
      btn.addEventListener('click', () => setActiveTab(btn.getAttribute('data-target')));
    });
    // wire mobile
    document.querySelectorAll('.tab-btn-mobile').forEach(btn => {
      btn.addEventListener('click', () => setActiveTab(btn.getAttribute('data-target')));
    });
    // default active: activities
    setActiveTab('#activities');
  });

  // Hero Quick Actions: activate tab and scroll to it
  function gotoTab(targetSelector){
    try {
      setActiveTab(targetSelector);
      const contentWrap = document.querySelector('#agentTabsContent') || document.querySelector(targetSelector);
      if (contentWrap && typeof contentWrap.scrollIntoView === 'function') {
        setTimeout(() => contentWrap.scrollIntoView({behavior:'smooth', block:'start'}), 50);
      }
    } catch(e) { /* noop */ }
  }


  // Hotel search
  const hotelForm = document.getElementById('hotelSearchForm');
  const hotelResults = document.getElementById('hotelResults');
  if (hotelForm) {
    hotelForm.addEventListener('submit', async (ev) => {
      ev.preventDefault();
      const city = document.getElementById('hotelCity').value.trim();
      const checkin = document.getElementById('hotelCheckin').value;
      const checkout = document.getElementById('hotelCheckout').value;
      const adults = document.getElementById('hotelGuests').value || 2;
      hotelResults.innerHTML = `
        <div class="skeleton-box mb-2">
          <div class="skeleton skeleton-line w-50 mb-2"></div>
          <div class="skeleton skeleton-line w-75 mb-2"></div>
          <div class="skeleton skeleton-line w-25"></div>
        </div>`;
      try {
        const url = `/b2b/api/hotels/search?city=${encodeURIComponent(city)}&checkin=${encodeURIComponent(checkin)}&checkout=${encodeURIComponent(checkout)}&adults=${encodeURIComponent(adults)}`;
        const res = await fetch(url, {headers:{'Accept':'application/json'}});
        const json = await res.json();
        const items = json.data || [];
        if (!items.length) { hotelResults.innerHTML = '<div class="text-muted small">No hotels found.</div>'; return; }
        hotelResults.innerHTML = items.map(h => `
          <div class="border rounded p-2 mb-2">
            <div class="d-flex justify-content-between">
              <div>
                <div class="fw-semibold">${h.name}</div>
                <div class="text-muted small">${h.city}, ${h.country} • ${'★'.repeat(h.stars || 0)}</div>
              </div>
              <div class="text-end">
                <div class="fw-semibold">THB ${Number(h.nightly_from||0).toFixed(2)}/night</div>
                <div class="small text-muted">Est. total: THB ${Number(h.total_estimate||0).toFixed(2)}</div>
                <button class="btn btn-sm btn-outline-primary mt-1" data-hotel-id="${h.id}" onclick="loadHotelDetails(${h.id})">View</button>
              </div>
            </div>
          </div>`).join('');
      } catch (e) {
        hotelResults.innerHTML = '<div class="text-danger small">Error loading results.</div>';
      }
    });
  }

  // Hotel details (basic)
  async function loadHotelDetails(id) {
    try {
      const checkin = document.getElementById('hotelCheckin').value;
      const checkout = document.getElementById('hotelCheckout').value;
      const res = await fetch(`/b2b/api/hotels/details?id=${id}&checkin=${encodeURIComponent(checkin)}&checkout=${encodeURIComponent(checkout)}`, {headers:{'Accept':'application/json'}});
      const json = await res.json();
      const rlist = (json.rooms||[]).map(r => `<li>${r.name} <span class="text-muted small">(cap: ${r.capacity||2})</span></li>`).join('');
      alert(`${json.hotel.name}\nRooms:\n- ${(json.rooms||[]).map(r=>r.name).join('\n- ')}`);
    } catch (e) { alert('Failed to load details'); }
  }
  window.loadHotelDetails = loadHotelDetails;

  // Activities search (manual). On submit, navigate to activities list page.
  const actForm = document.getElementById('activitySearchForm');
  if (actForm) {
    actForm.addEventListener('submit', (ev) => {
      ev.preventDefault();
      const q = (document.getElementById('activityQuery')?.value || '').trim();
      const url = q ? `/agent/activities?q=${encodeURIComponent(q)}` : '/agent/activities';
      window.location.href = url;
    });
  }

  // Activity details modal + loader
  function ensureActivityModal() {
    let modal = document.getElementById('activityDetailsModal');
    if (!modal) {
      const wrapper = document.createElement('div');
      wrapper.innerHTML = `
      <div class="modal fade" id="activityDetailsModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title">Activity Details</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <div id="activityDetailsBody" class="small text-muted">Loading…</div>
              <div id="activitySelectionsWrap" class="mt-3" style="display:none">
                <div class="d-flex justify-content-between align-items-center mb-1">
                  <div class="fw-semibold">Selections <span class="badge bg-secondary" id="activitySelectionsCount">0</span></div>
                  <div class="small text-muted">Total: <strong id="activitySelectionsTotal">0.00</strong> <span id="activitySelectionsCurrency">THB</span></div>
                </div>
                <div id="activitySelections" class="border rounded p-2 small"></div>
              </div>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-outline-primary me-auto" id="btnBookAll" disabled onclick="bookAllSelections()"><i class="bi bi-cart-check"></i> Checkout</button>
              <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
          </div>
        </div>
      </div>`;
      document.body.appendChild(wrapper.firstElementChild);
    }
  }

  async function loadActivityDetails(id) {
    ensureActivityModal();
    const modalEl = document.getElementById('activityDetailsModal');
    const bodyEl = document.getElementById('activityDetailsBody');
    if (bodyEl) bodyEl.innerHTML = 'Loading…';
    const modal = new bootstrap.Modal(modalEl);
    modal.show();
    try {
      const res = await fetch(`/b2b/api/activities/details?id=${id}`, {headers:{'Accept':'application/json'}});
      const data = await res.json();
      const pkg = data.package || {};
      const variants = data.variants || [];
      const prices = data.prices || [];
      const requiresShow = (pkg.requires_show_time === 1 || pkg.requires_show_time === '1');

      // Group prices by variant
      const pricesByVariant = prices.reduce((acc, p) => {
        const vid = p.variant_id;
        (acc[vid] = acc[vid] || []).push(p);
        return acc;
      }, {});

      const variantCards = variants.map((v, vIdx) => {
        const vpricesAll = (pricesByVariant[v.id] || []);
        const nonFlat = vpricesAll.filter(p => p.pax_type !== 'flat');
        const flat = vpricesAll.find(p => p.pax_type === 'flat');
        const minPer = nonFlat.length ? Math.min(...nonFlat.map(p => Number(p.agent_price||0))) : null;
        const headerRight = `
          <div class=\"text-end small\">
            ${minPer !== null ? `<div>Normal from <strong>THB ${minPer.toFixed(2)}</strong></div>` : ''}
            ${flat ? `<div class=\"text-success\">Group <strong>THB ${Number(flat.agent_price||0).toFixed(2)}</strong> <span class=\"text-muted\">(min ${flat.min_quantity||1})</span></div>` : ''}
          </div>`;
        const rows = nonFlat.map(p => {
          const label = `${p.pax_type}`;
          const priceStr = `${Number(p.agent_price||0).toFixed(2)} ${p.currency||'THB'}`;
          return `
            <div class=\"d-flex justify-content-between align-items-center py-2 border-bottom\">
              <div>
                <div class=\"fw-semibold\">${label}</div>
                <div class=\"text-muted small\">${priceStr}${p.pickup_type?` • pickup: ${p.pickup_type}`:''}</div>
              </div>
              <div class=\"d-flex align-items-center gap-2\"> 
                <div class=\"input-group input-group-sm\" style=\"width:140px\"> 
                  <button class=\"btn btn-outline-secondary qty-minus\" type=\"button\">−</button> 
                  <input type=\"number\" class=\"form-control form-control-sm price-qty text-center\" data-variant-id=\"${v.id}\" data-unit-price=\"${Number(p.agent_price||0)}\" data-currency=\"${p.currency||'THB'}\" value=\"0\" min=\"0\"> 
                  <button class=\"btn btn-outline-secondary qty-plus\" type=\"button\">+</button> 
                </div> 
                <button class=\"btn btn-sm btn-outline-secondary\" onclick=\"addToCartFromButton(this, ${pkg.id}, ${p.variant_id}, ${p.id}, '${p.pax_type}', ${Number(p.agent_price||0)}, '${p.currency||'THB'}', '${(v.name||'').replace(/\\\"/g,'\\\\\\\"') + ' • ' + (p.pax_type||'')}', false)\"><i class=\"bi bi-plus\"></i> Add</button>
              </div>
            </div>`;
        }).join('');
        const collapseId = `variant_${v.id}_body`;
        const isOpen = vIdx < 3; // keep first 3 expanded
        return `
        <div class=\"border rounded p-2 mb-2\" id=\"variant_${v.id}_container\">
          <div class=\"d-flex justify-content-between align-items-center\"> 
            <button class=\"btn btn-link p-0 text-start fw-semibold\" data-bs-toggle=\"collapse\" data-bs-target=\"#${collapseId}\" aria-expanded=\"${isOpen?'true':'false'}\" aria-controls=\"${collapseId}\">${v.name}</button>
            ${headerRight}
          </div>
          <div id=\"${collapseId}\" class=\"collapse ${isOpen?'show':''}\">
            ${requiresShow ? `
            <div class=\"mt-2\"> 
              <label class=\"form-label small mb-1\">Showtime</label>
              <select id=\"showtime_for_variant_${v.id}\" class=\"form-select form-select-sm\"> 
                ${(v.showtimes||[]).length ? (v.showtimes||[]).map(t=>`<option value=\"${t}\">${t}</option>`).join('') : '<option value=\"\">No times available</option>'}
              </select>
            </div>` : ''}
            <div class=\"mt-2\"> 
              ${nonFlat.length ? `
                <div class=\"border rounded\"> 
                  ${rows}
                </div>` : '<div class="text-muted small">No per-person prices for this variant.</div>'}
              <div id=\"variant_${v.id}_flat_offer\" class=\"mt-2\" style=\"display:none\"></div>
              <div id=\"variant_${v.id}_flat_meta\" data-has-flat=\"${flat?1:0}\" data-min-qty=\"${flat? (flat.min_quantity||''): ''}\" data-agent-price=\"${flat? (flat.agent_price||''): ''}\" data-currency=\"${flat? (flat.currency||'THB'): ''}\" data-price-id=\"${flat? flat.id: ''}\"></div>
            </div>
          </div>
        </div>`;
      }).join('');

      const img = pkg.thumbnail_path ? `<img src="${pkg.thumbnail_path}" alt="${pkg.name}" class="rounded" style="width:140px;height:105px;object-fit:cover">` : '';

      const html = `
        <div class="d-flex gap-3 align-items-start mb-3">
          ${img}
          <div>
            <div class="h6 mb-1">${pkg.name||''}</div>
            <div class="text-muted small">${pkg.city||''}</div>
          </div>
        </div>
        <div class="mb-3">
          <div class="fw-semibold mb-1">Variants</div>
          ${variantCards || '<div class="text-muted small">No active variants.</div>'}
        </div>
        `;

      if (bodyEl) bodyEl.innerHTML = html;
      // After render, wire flat offer activation based on per-variant summed qty from per-person rows
      const alerted = new Set();
      function calcVariantSum(variantId) {
        const cont = document.getElementById(`variant_${variantId}_container`);
        if (!cont) return { qty:0, subtotal:0, currency:'THB' };
        let qty = 0;
        let subtotal = 0;
        let currency = 'THB';
        cont.querySelectorAll('.price-qty').forEach(inp => {
          const q = parseInt(inp.value||'0',10);
          const unit = parseFloat(inp.getAttribute('data-unit-price')||'0');
          const cur = inp.getAttribute('data-currency')||'THB';
          if (!isNaN(q) && q>0) {
            qty += q;
            subtotal += q * unit;
            currency = cur;
          }
        });
        return { qty, subtotal, currency };
      }
      function updateVariantFlatOffer(variantId) {
        const meta = document.getElementById(`variant_${variantId}_flat_meta`);
        const offer = document.getElementById(`variant_${variantId}_flat_offer`);
        if (!meta || !offer) return;
        const hasFlat = meta.getAttribute('data-has-flat') === '1';
        if (!hasFlat) { offer.style.display='none'; offer.innerHTML=''; return; }
        const minq = parseInt(meta.getAttribute('data-min-qty')||'0',10);
        const price = parseFloat(meta.getAttribute('data-agent-price')||'0');
        const currency = meta.getAttribute('data-currency')||'THB';
        const priceId = parseInt(meta.getAttribute('data-price-id')||'0',10);
        const vAgg = calcVariantSum(variantId);
        if (vAgg.qty >= minq && minq>0) {
          offer.style.display='block';
          const vName = (variants.find(x => Number(x.id) === Number(variantId))?.name || 'Variant').replace(/"/g,'\\"');
          offer.innerHTML = `
            <div class=\"d-flex flex-wrap justify-content-between align-items-center border rounded p-2 gap-2\">
              <div class=\"small flex-grow-1\">
                <span>Flat ${minq}+ total for </span>
                <input type=\"number\" id=\"variant_${variantId}_flat_qty\" class=\"form-control form-control-sm d-inline-block\" value=\"${vAgg.qty}\" min=\"${minq}\" style=\"width:90px\"> <span>pax:</span>
                <strong id=\"variant_${variantId}_flat_total\"></strong> <span>${currency}</span>
                <div class=\"text-muted mt-1\"><small>Per-person total: <span id=\"variant_${variantId}_pp_total\"></span> ${vAgg.currency} • You save: <span id=\"variant_${variantId}_save\"></span> ${vAgg.currency}</small></div>
                <div class=\"mt-1\"><small><strong>New cart total if applied:</strong> <span id=\"variant_${variantId}_cart_new_total\"></span> ${vAgg.currency}</small></div>
              </div>
              <div class=\"d-flex align-items-center gap-2\">
                <button class=\"btn btn-sm btn-outline-secondary\" onclick=\"addToCartFromButton(this, ${pkg.id}, ${variantId}, ${priceId}, 'flat', ${price}, '${currency}', '${vName} • flat', true)\"><i class=\"bi bi-plus\"></i> Add</button>
              </div>
            </div>
            <div class=\"alert alert-success py-2 px-3 mt-2 mb-2\">Group booking discount activated for ${vName}: group ${minq}+ applied.</div>`;
          const qtyEl = document.getElementById(`variant_${variantId}_flat_qty`);
          const totalEl = document.getElementById(`variant_${variantId}_flat_total`);
          const ppEl = document.getElementById(`variant_${variantId}_pp_total`);
          const saveEl = document.getElementById(`variant_${variantId}_save`);
          const cartNewEl = document.getElementById(`variant_${variantId}_cart_new_total`);
          const compute = () => {
            const q = Math.max(minq, parseInt(qtyEl.value||`${minq}`,10));
            const groups = Math.ceil(q / minq);
            const flatTotal = groups * price;
            totalEl.textContent = flatTotal.toFixed(2);
            ppEl.textContent = (vAgg.subtotal || 0).toFixed(2);
            const savings = Math.max(0, (vAgg.subtotal||0) - flatTotal);
            saveEl.textContent = savings.toFixed(2);
            try {
              const currentCartTotal = (selectionsState.items||[]).reduce((acc,it)=>acc + (parseFloat(it.total)||0), 0);
              const projected = Math.max(0, currentCartTotal - (vAgg.subtotal||0) + flatTotal);
              if (cartNewEl) cartNewEl.textContent = projected.toFixed(2);
            } catch(_) {}
          };
          compute();
          qtyEl.addEventListener('input', compute);
          if (!alerted.has(variantId)) { alerted.add(variantId); }
        } else {
          offer.style.display='none';
          offer.innerHTML='';
          alerted.delete(variantId);
        }
      }
      function wireQtyInputs() {
        document.querySelectorAll('#activityDetailsBody .price-qty').forEach(inp => {
          const toggleBtn = () => {
            const val = parseInt(inp.value||'0',10) || 0;
            const row = inp.closest('.d-flex');
            const addBtn = row ? row.querySelector('button.btn.btn-sm.btn-outline-secondary') : null;
            if (addBtn) addBtn.disabled = val < 1;
          };
          inp.addEventListener('input', () => {
            const vid = parseInt(inp.getAttribute('data-variant-id')||'0',10);
            toggleBtn();
            if (vid) updateVariantFlatOffer(vid);
          });
          // Plus/Minus controls
          const row = inp.closest('.d-flex');
          const minusBtn = row ? row.querySelector('.qty-minus') : null;
          const plusBtn = row ? row.querySelector('.qty-plus') : null;
          if (minusBtn) minusBtn.addEventListener('click', () => {
            const current = Math.max(0, parseInt(inp.value||'0',10) || 0);
            const next = Math.max(0, current - 1);
            inp.value = String(next);
            inp.dispatchEvent(new Event('input'));
          });
          if (plusBtn) plusBtn.addEventListener('click', () => {
            const current = Math.max(0, parseInt(inp.value||'0',10) || 0);
            const next = current + 1;
            inp.value = String(next);
            inp.dispatchEvent(new Event('input'));
          });
          // Initialize disabled/enabled state
          toggleBtn();
        });
      }
      // initial wiring and calculation for all variants
      wireQtyInputs();
      (variants||[]).forEach(v => updateVariantFlatOffer(v.id));
    } catch (e) {
      if (bodyEl) bodyEl.innerHTML = '<div class="text-danger">Failed to load details.</div>';
    }
  }
  window.loadActivityDetails = loadActivityDetails;

  // Selections cart state
  const selectionsState = { items: [], currency: 'THB' };
  function refreshSelectionsUI() {
    const wrap = document.getElementById('activitySelectionsWrap');
    const listEl = document.getElementById('activitySelections');
    const countEl = document.getElementById('activitySelectionsCount');
    const totalEl = document.getElementById('activitySelectionsTotal');
    const currEl = document.getElementById('activitySelectionsCurrency');
    const btnAll = document.getElementById('btnBookAll');
    const items = selectionsState.items;
    if (!wrap || !listEl) return;
    wrap.style.display = items.length ? 'block' : 'none';
    // Hide the header total; we show the projected total within each variant discount panel
    if (totalEl && totalEl.parentElement) totalEl.parentElement.style.display = 'none';
    if (countEl) countEl.textContent = String(items.length);
    let total = 0;
    items.forEach(it => { total += (parseFloat(it.total)||0); });
    if (totalEl) totalEl.textContent = total.toFixed(2);
    if (currEl) currEl.textContent = selectionsState.currency || 'THB';
    if (btnAll) btnAll.disabled = items.length === 0;
    listEl.innerHTML = (items.map((it, idx) => `
      <div class="d-flex justify-content-between align-items-center py-1 border-bottom">
        <div>
          <div>${it.label}</div>
          <div class="text-muted">qty ${it.qty} • ${it.pax_type} • ${Number(it.total||0).toFixed(2)} ${it.currency}</div>
        </div>
        <button class="btn btn-sm btn-link text-danger" onclick="removeSelection(${idx})"><i class="bi bi-x"></i></button>
      </div>
    `).join('')) || '<div class="text-muted">No selections yet.</div>';
    // Trigger recompute of any visible flat panels' projected totals
    try {
      document.querySelectorAll('[id$="_flat_qty"]').forEach(el => {
        el.dispatchEvent(new Event('input'));
      });
    } catch(_) {}
  }
  function removeSelection(idx) { selectionsState.items.splice(idx,1); refreshSelectionsUI(); }

  function addToCartFromButton(btnEl, packageId, variantId, priceId, paxType, agentPrice, currency, label, isFlat) {
    try {
      let qty = 0;
      if (btnEl) {
        // For per-person rows, qty input is adjacent in the same flex row
        const row = btnEl.closest('.d-flex');
        const rowQty = row ? row.querySelector('.price-qty') : null;
        if (rowQty) qty = parseInt(rowQty.value||'0',10);
      }
      if (isFlat) {
        const fq = document.getElementById(`variant_${variantId}_flat_qty`);
        if (fq) qty = parseInt(fq.value||'0',10);
      }
      // Require at least 1 to add
      if (!qty || isNaN(qty) || qty < 1) { return; }
      const meta = document.getElementById(`variant_${variantId}_flat_meta`);
      let total = 0;
      if (paxType === 'flat' && meta) {
        const minq = Math.max(1, parseInt(meta.getAttribute('data-min-qty')||'1',10));
        const groups = Math.ceil(qty / minq);
        total = groups * Number(agentPrice||0);
      } else {
        total = Number(agentPrice||0) * qty;
      }
      const stEl = document.getElementById(`showtime_for_variant_${variantId}`);
      const show_time = stEl ? (stEl.value||'') : '';
      selectionsState.currency = currency || selectionsState.currency;
      selectionsState.items.push({ package_id: packageId, variant_id: variantId, price_id: priceId, qty, pax_type: paxType, total, currency, label, show_time });
      refreshSelectionsUI();
    } catch (e) { alert('Failed to add'); }
  }
  window.addToCartFromButton = addToCartFromButton;

  // Lightweight result modal for bookings
  function ensureBookingResultModal() {
    let m = document.getElementById('bookingResultModal');
    if (!m) {
      const wrap = document.createElement('div');
      wrap.innerHTML = `
      <div class="modal fade" id="bookingResultModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title">Booking Result</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <div id="bookingResultBody" class="small text-muted">Processing…</div>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-primary" data-bs-dismiss="modal">OK</button>
            </div>
          </div>
        </div>
      </div>`;
      document.body.appendChild(wrap.firstElementChild);
    }
  }

  // Checkout modal
  function ensureCheckoutModal() {
    let m = document.getElementById('checkoutModal');
    if (!m) {
      const wrap = document.createElement('div');
      wrap.innerHTML = `
      <div class="modal fade" id="checkoutModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title">Checkout</h5>
              <div class="ms-auto small text-muted" id="checkoutWalletInfo"></div>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <div id="checkoutBody" class="small text-muted">Preparing checkout…</div>
            </div>
            <div class="modal-footer" id="checkoutFooter">
              <button type="button" class="btn btn-primary" id="checkoutPayBtn" disabled>Pay with Wallet</button>
              <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
          </div>
        </div>
      </div>`;
      document.body.appendChild(wrap.firstElementChild);
    }
  }

  async function loadWalletIntoCheckout() {
    try {
      const el = document.getElementById('checkoutWalletInfo');
      if (!el) return;
      el.textContent = 'Wallet: …';
      const res = await fetch('/b2b/api/wallet', { headers: { 'Accept': 'application/json' } });
      if (!res.ok) { el.textContent = 'Wallet: –'; return; }
      const data = await res.json();
      if (typeof data.balance !== 'undefined') {
        el.textContent = `Wallet: ${Number(data.balance||0).toFixed(2)} ${data.currency||'THB'}`;
      }
    } catch (_) {
      const el = document.getElementById('checkoutWalletInfo');
      if (el) el.textContent = 'Wallet: –';
    }
  }

  async function createCheckoutOrder() {
    const cBody = document.getElementById('checkoutBody');
    const payBtn = document.getElementById('checkoutPayBtn');
    try {
      // Validate selections
      const invalid = (selectionsState.items||[]).some(it => !it || isNaN(parseInt(it.qty||'0',10)) || parseInt(it.qty,10) <= 0);
      if (invalid || !selectionsState.items.length) {
        if (cBody) cBody.innerHTML = '<div class="text-danger">Your cart is empty or has invalid quantities.</div>';
        if (payBtn) { payBtn.disabled = true; }
        return;
      }
      if (cBody) cBody.innerHTML = '<div class="text-muted">Creating order…</div>';
      if (payBtn) { payBtn.disabled = true; payBtn.textContent = 'Pay with Wallet'; payBtn.onclick = null; }
      const payload = { items: selectionsState.items.map(it => ({ package_id: it.package_id, variant_id: it.variant_id, price_id: it.price_id, qty: it.qty, show_time: it.show_time })) };
      const res = await fetch('/b2b/api/checkout/create', { method:'POST', headers:{'Content-Type':'application/json','Accept':'application/json','X-CSRF-Token': (window.CSRF_TOKEN||'')}, body: JSON.stringify(payload)});
      const json = await res.json();
      if (!res.ok || json.error) {
        if (cBody) cBody.innerHTML = `<div class="text-danger mb-2">${(json && json.error) ? json.error : 'Failed to create order.'}</div><button class="btn btn-outline-secondary btn-sm" onclick="createCheckoutOrder()">Retry</button>`;
        return;
      }
      // Render order summary
      const order = json.order || {};
      const items = json.items || order.items || [];
      const currency = json.currency || order.currency || (items[0]?.currency) || selectionsState.currency || 'THB';
      const subtotal = Number(json.subtotal || order.subtotal || items.reduce((a,b)=>a + (parseFloat(b.total||b.amount||0)),0));
      const fees = Number(json.fees || order.fees || 0);
      const total = Number(json.total || order.total || (subtotal + fees));
      const list = items.length ? items.map((it, i) => `
        <div class="d-flex justify-content-between py-1 border-bottom">
          <div>${it.label || it.name || ('Item #' + (i+1))} <span class="text-muted small">× ${it.qty || 1}</span></div>
          <div class="text-muted small">${Number(it.total || it.amount || 0).toFixed(2)} ${it.currency||currency}</div>
        </div>`).join('') : '<div class="text-muted">No items.</div>';
      if (cBody) cBody.innerHTML = `
        <div class="mb-2">Order <strong>#${order.id || json.order_id || ''}</strong></div>
        <div class="border rounded p-2 mb-2">${list}</div>
        <div class="d-flex justify-content-between small"><div>Subtotal</div><div>${subtotal.toFixed(2)} ${currency}</div></div>
        <div class="d-flex justify-content-between small"><div>Fees</div><div>${fees.toFixed(2)} ${currency}</div></div>
        <div class="d-flex justify-content-between"><div><strong>Total</strong></div><div><strong>${total.toFixed(2)} ${currency}</strong></div></div>
        <hr>
        <div class="small">Payment method:</div>
        <div class="d-flex gap-2">
          <button class="btn btn-outline-primary btn-sm" disabled>Wallet</button>
          <button class="btn btn-outline-secondary btn-sm" disabled title="Coming soon">Stripe</button>
        </div>`;
      const oid = order.id || json.order_id;
      if (payBtn && oid) { payBtn.disabled = false; payBtn.textContent = 'Pay with Wallet'; payBtn.onclick = () => payCheckoutWallet(oid); }
    } catch (e) {
      if (cBody) cBody.innerHTML = '<div class="text-danger mb-2">Unexpected error while creating order.</div><button class="btn btn-outline-secondary btn-sm" onclick="createCheckoutOrder()">Retry</button>';
      if (payBtn) { payBtn.disabled = true; }
    }
  }

  async function payCheckoutWallet(orderId) {
    const payBtn = document.getElementById('checkoutPayBtn');
    const body = document.getElementById('checkoutBody');
    try {
      if (payBtn) { payBtn.disabled = true; payBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Processing…'; }
      const res = await fetch('/b2b/api/checkout/pay-wallet', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json', 'Accept': 'application/json', 'X-CSRF-Token': (window.CSRF_TOKEN||'') },
        body: JSON.stringify({ order_id: orderId })
      });
      const json = await res.json();
      if (!res.ok || json.error) {
        if (body) body.innerHTML = `<div class="text-danger">${(json && json.error) ? json.error : 'Payment failed.'}</div>`;
        if (payBtn) { payBtn.disabled = false; payBtn.textContent = 'Pay with Wallet'; }
        return;
      }
      // Success UI
      const bookings = json.bookings || json.items || [];
      const currency = json.currency || (bookings[0]?.currency) || 'THB';
      const total = Number(json.total || bookings.reduce((a,b)=>a + (parseFloat(b.total)||0),0) || 0);
      const list = bookings.length ? bookings.map(b => `
        <div class="d-flex justify-content-between py-1 border-bottom">
          <div>#${String(b.booking_id || b.id || '')}</div>
          <div class="text-muted small">${Number(b.total||0).toFixed(2)} ${b.currency||currency}</div>
        </div>`).join('') : '<div class="text-muted">No booking details returned.</div>';
      if (body) body.innerHTML = `
        <div class="alert alert-success">Payment successful. Booking(s) confirmed.</div>
        <div class="border rounded p-2 mb-2">${list}</div>
        <div class="text-end"><strong>Total paid:</strong> ${total.toFixed(2)} ${currency}</div>`;
      // Clear cart and refresh wallet
      selectionsState.items = []; refreshSelectionsUI(); loadWallet();
      // Disable pay button after success
      if (payBtn) { payBtn.disabled = true; payBtn.textContent = 'Paid'; }
    } catch (e) {
      if (body) body.innerHTML = '<div class="text-danger">Unexpected error while processing payment.</div>';
      if (payBtn) { payBtn.disabled = false; payBtn.textContent = 'Pay with Wallet'; }
    }
  }

  async function bookAllSelections() {
    try {
      if (!selectionsState.items.length) return;
      // Immediately create order (no contact yet) and redirect to checkout page
      const payload = { items: selectionsState.items.map(it => ({ package_id: it.package_id, variant_id: it.variant_id, price_id: it.price_id, qty: it.qty, show_time: it.show_time })) };
      const res = await fetch('/b2b/api/checkout/create', { method:'POST', headers:{ 'Content-Type':'application/json', 'Accept':'application/json', 'X-CSRF-Token': (window.CSRF_TOKEN||'') }, body: JSON.stringify(payload) });
      const json = await res.json();
      if (!res.ok || json.error || !json.order_id) { alert((json && json.error) ? json.error : 'Failed to create order.'); return; }
      if (!json.checkout_url) { alert('Order created but checkout link is missing. Please try again.'); return; }
      const next = json.checkout_url;
      window.location.href = next;
    } catch (e) { alert('Error creating bookings'); }
    finally {
      const btn = document.getElementById('btnBookAll');
      if (btn) { btn.innerHTML = '<i class="bi bi-cart-check"></i> Checkout'; }
    }
  }
  window.bookAllSelections = bookAllSelections;

  // Book selected activity price
  async function bookActivity(btnEl, packageId, variantId, priceId, isFlat=false) {
    try {
      let qty = 1;
      // Prefer nearest row qty if present
      if (btnEl) {
        const tr = btnEl.closest('tr');
        const rowQty = tr ? tr.querySelector('.price-qty') : null;
        if (rowQty) qty = Math.max(1, parseInt(rowQty.value||'1',10));
      }
      // For flat offer, use the variant-specific flat qty input if present
      if (isFlat) {
        const fq = document.getElementById(`variant_${variantId}_flat_qty`);
        if (fq) qty = Math.max(1, parseInt(fq.value||'1',10));
      }
      // Safe default if nothing else found
      if (!qty || isNaN(qty)) { qty = 1; }
      let show_time = '';
      const stEl = document.getElementById(`showtime_for_variant_${variantId}`);
      if (stEl) show_time = stEl.value || '';

      const res = await fetch('/b2b/api/activities/book', {
        method: 'POST',
        headers: {'Content-Type':'application/json','Accept':'application/json'},
        body: JSON.stringify({ package_id: packageId, variant_id: variantId, price_id: priceId, qty, show_time })
      });
      const json = await res.json();
      if (!res.ok || json.error) {
        alert(json.error || 'Failed to create booking');
        return;
      }
      alert(`Booking created: #${json.booking_id}\nTotal: ${json.total} ${json.currency}`);
    } catch (e) {
      alert('Error creating booking');
    }
  }
  window.bookActivity = bookActivity;

  // Taxi quote
  const taxiForm = document.getElementById('taxiQuoteForm');
  const taxiResults = document.getElementById('taxiResults');
  if (taxiForm) {
    taxiForm.addEventListener('submit', async (ev) => {
      ev.preventDefault();
      const from = document.getElementById('taxiFrom').value.trim();
      const to = document.getElementById('taxiTo').value.trim();
      const at = document.getElementById('taxiAt').value;
      taxiResults.innerHTML = '<div class="text-muted">Loading…</div>';
      try {
        const res = await fetch(`/b2b/api/taxi/quote?from=${encodeURIComponent(from)}&to=${encodeURIComponent(to)}&at=${encodeURIComponent(at)}`, {headers:{'Accept':'application/json'}});
        const json = await res.json();
        const items = json.data || [];
        if (!items.length) { taxiResults.innerHTML = '<div class="text-muted small">No quotes found.</div>'; return; }
        taxiResults.innerHTML = items.map(t => `
          <div class="border rounded p-2 mb-2 d-flex justify-content-between">
            <div>
              <div class="fw-semibold">${t.name}</div>
              <div class="text-muted small">${t.route}</div>
            </div>
            <div class="text-end">
              <div class="fw-semibold">THB ${Number(t.price||0).toFixed(2)}</div>
              <button class="btn btn-sm btn-outline-primary mt-1">Book</button>
            </div>
          </div>`).join('');
      } catch (e) {
        taxiResults.innerHTML = '<div class="text-danger small">Error loading quotes.</div>';
      }
    });
  }

  // Contact modal submit -> create checkout order
  const contactForm = document.getElementById('contactForm');
  const contactName = document.getElementById('contactName');
  const contactMobile = document.getElementById('contactMobile');
  const contactEmail = document.getElementById('contactEmail');
  const contactWhatsapp = document.getElementById('contactWhatsapp');
  const contactError = document.getElementById('contactFormError');
  const contactSubmitBtn = document.getElementById('contactSubmitBtn');
  if (contactForm) {
    contactForm.addEventListener('submit', async (ev) => {
      ev.preventDefault();
      const name = (contactName?.value||'').trim();
      const mobile = (contactMobile?.value||'').trim();
      const email = (contactEmail?.value||'').trim();
      const whatsapp = (contactWhatsapp?.value||'').trim();
      if (!name || name.length < 2) { contactError.classList.remove('d-none'); contactError.textContent = 'Please enter a valid name (min 2 chars).'; return; }
      if (!mobile || mobile.length < 6) { contactError.classList.remove('d-none'); contactError.textContent = 'Please enter a valid mobile (min 6 chars).'; return; }
      if (email && !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email)) { contactError.classList.remove('d-none'); contactError.textContent = 'Please enter a valid email address.'; return; }
      contactError.classList.add('d-none');

      const items = Array.isArray(window.__pendingCheckoutItems) ? window.__pendingCheckoutItems : []; 
      if (!items.length) { contactError.classList.remove('d-none'); contactError.textContent = 'No items to checkout.'; return; }

      try {
        if (contactSubmitBtn) { contactSubmitBtn.disabled = true; contactSubmitBtn.textContent = 'Creating…'; }
        const payload = { items, customer_name: name, customer_mobile: mobile, customer_email: email, customer_whatsapp: whatsapp };
        const res = await fetch('/b2b/api/checkout/create', { method:'POST', headers:{ 'Content-Type':'application/json', 'Accept':'application/json', 'X-CSRF-Token': (window.CSRF_TOKEN||'') }, body: JSON.stringify(payload) });
        const json = await res.json();
        if (!res.ok || json.error || !json.order_id) { contactError.classList.remove('d-none'); contactError.textContent = (json && json.error) ? json.error : 'Failed to create order.'; if (contactSubmitBtn) { contactSubmitBtn.disabled = false; contactSubmitBtn.textContent = 'Continue to Checkout'; } return; }
        // Hide modal and redirect
        try { const modalEl = document.getElementById('contactModal'); if (modalEl) { const inst = bootstrap.Modal.getInstance(modalEl) || new bootstrap.Modal(modalEl); inst.hide(); } } catch(_) {}
        if (!json.checkout_url) { contactError.classList.remove('d-none'); contactError.textContent = 'Checkout link missing. Please try again.'; if (contactSubmitBtn) { contactSubmitBtn.disabled = false; contactSubmitBtn.textContent = 'Continue to Checkout'; } return; }
        const next = json.checkout_url;
        window.location.href = next;
      } catch (e) {
        contactError.classList.remove('d-none');
        contactError.textContent = 'Unexpected error while creating order.';
      } finally {
        if (contactSubmitBtn) { contactSubmitBtn.disabled = false; contactSubmitBtn.textContent = 'Continue to Checkout'; }
      }
    });
  }

  // Init
  loadWallet();

  // Hero form host logic: move active tab's form into hero white box
  const heroHost = document.getElementById('heroFormHost');
  const topPills = document.getElementById('agentPillsTop');
  const desktopTabs = document.getElementById('agentTabs');

  const formConfigs = {
    hotels: {
      form: () => document.querySelector('#hotels form#hotelSearchForm'),
      card: () => document.querySelector('#hotels .card:first-child')
    },
    activities: {
      form: () => document.querySelector('#activities form#activitySearchForm'),
      card: () => document.querySelector('#activities .card:first-child')
    },
    cars: {
      form: () => document.querySelector('#cars form#taxiQuoteForm'),
      card: () => document.querySelector('#cars .card:first-child')
    }
  };

  function empty(el){ while(el && el.firstChild){ el.removeChild(el.firstChild); } }

  function syncTopPills(activeId){
    if (!topPills) return;
    topPills.querySelectorAll('button[data-bs-target]').forEach(btn => {
      const tgt = (btn.getAttribute('data-bs-target')||'').replace('#','');
      btn.classList.toggle('active', tgt === activeId);
      btn.setAttribute('aria-selected', tgt === activeId ? 'true' : 'false');
    });
  }

  function moveFormFor(paneId){
    if (!heroHost) return;
    // Unhide any previously hidden cards
    Object.keys(formConfigs).forEach(k => {
      const card = formConfigs[k].card();
      if (card) card.classList.remove('d-none');
    });
    // Clear hero host
    empty(heroHost);
    const cfg = formConfigs[paneId];
    if (!cfg) return;
    const form = cfg.form();
    const card = cfg.card();
    if (form) {
      heroHost.appendChild(form); // move node (keeps IDs and listeners)
      if (card) card.classList.add('d-none');
    }
    syncTopPills(paneId);
  }

  function getPaneIdFromTarget(target){
    const sel = typeof target === 'string' ? target : (target.getAttribute('data-bs-target')||'');
    return sel.replace('#','');
  }

  // Listen to tab change from hero pills
  if (topPills) {
    topPills.addEventListener('shown.bs.tab', (ev) => {
      const paneId = getPaneIdFromTarget(ev.target);
      moveFormFor(paneId);
    });
  }
  // Listen to desktop tab change to keep hero synced
  if (desktopTabs) {
    desktopTabs.addEventListener('shown.bs.tab', (ev) => {
      const paneId = getPaneIdFromTarget(ev.target);
      moveFormFor(paneId);
    });
  }

  // Initial placement: default Hotels
  moveFormFor('hotels');
</script>
