<?php
// app/Views/agent/activities_list.php
// Dedicated Activities List page for B2B Agent
$q = isset($q) ? (string)$q : (string)($_GET['q'] ?? '');
$city = isset($city) ? (string)$city : (string)($_GET['city'] ?? '');
?>
<div class="activities-page-bg">
<div class="tw-max-w-screen-2xl tw-mx-auto tw-px-4 tw-py-3">
  <div class="tw-flex tw-items-center tw-justify-between tw-mb-3">
    <h1 class="tw-text-base tw-font-semibold tw-m-0">Activities</h1>
    <a href="/agent" class="tw-inline-flex tw-items-center tw-gap-1 tw-rounded-lg tw-border tw-border-slate-300 tw-text-slate-700 hover:tw-bg-slate-50 tw-px-3 tw-py-1 tw-text-sm">
      <i class="bi bi-arrow-left"></i>
      Back
    </a>
  </div>
</div>

  <div class="tw-rounded-2xl tw-bg-white tw-shadow-[0_2px_10px_rgba(0,0,0,0.05)] tw-border tw-border-black/5 tw-mb-3">
    <div class="tw-p-4">
      <form class="tw-grid tw-grid-cols-12 tw-gap-2 tw-items-end" id="activitiesListSearch">
        <div class="tw-col-span-12 lg:tw-col-span-5">
          <label class="tw-text-xs tw-font-medium tw-text-slate-600">Activity / City</label>
          <div class="tw-relative">
            <span class="tw-absolute tw-right-3 tw-top-1/2 tw--translate-y-1/2 tw-text-slate-400"><i class="bi bi-search"></i></span>
            <input type="text" id="q" name="q" value="<?= htmlspecialchars($q) ?>" placeholder="Type activity name or city" class="tw-w-full tw-border tw-border-slate-300 tw-rounded-xl tw-py-2 tw-pl-3 tw-pr-9 focus:tw-outline-none focus:tw-ring-2 focus:tw-ring-blue-600/30 focus:tw-border-blue-600">
          </div>
        </div>
        <div class="tw-col-span-6 lg:tw-col-span-3">
          <label class="tw-text-xs tw-font-medium tw-text-slate-600">City</label>
          <input type="text" id="city" name="city" value="<?= htmlspecialchars($city) ?>" placeholder="Bangkok, Phuket…" class="tw-w-full tw-border tw-border-slate-300 tw-rounded-xl tw-py-2 tw-px-3 focus:tw-outline-none focus:tw-ring-2 focus:tw-ring-blue-600/30 focus:tw-border-blue-600">
        </div>
        <div class="tw-col-span-6 lg:tw-col-span-2">
          <label class="tw-text-xs tw-font-medium tw-text-slate-600">Sort</label>
          <select id="sort" class="tw-w-full tw-border tw-border-slate-300 tw-rounded-xl tw-py-2 tw-px-3 focus:tw-outline-none focus:tw-ring-2 focus:tw-ring-blue-600/30 focus:tw-border-blue-600">
            <option value="relevance">Relevance</option>
            <option value="price_asc">Price (Low → High)</option>
            <option value="price_desc">Price (High → Low)</option>
          </select>
        </div>
        <div class="tw-col-span-6 lg:tw-col-span-2">
          <button class="tw-inline-flex tw-items-center tw-justify-center tw-gap-2 tw-w-full tw-rounded-xl tw-bg-blue-700 hover:tw-bg-blue-800 tw-text-white tw-font-semibold tw-py-2 tw-px-3" type="submit">
            <i class="bi bi-search"></i>
            Find
          </button>
        </div>
      </form>
    </div>
  </div>

  <div class="tw-grid tw-grid-cols-1 lg:tw-grid-cols-12 tw-gap-3">
    <div class="lg:tw-col-span-3">
      <div class="tw-sticky tw-top-3 tw-rounded-2xl tw-bg-white tw-shadow-[0_2px_10px_rgba(0,0,0,0.05)] tw-border tw-border-black/5">
        <div class="tw-p-4">
          <div class="tw-flex tw-items-center tw-justify-between tw-mb-2">
            <div class="tw-font-semibold">Filters</div>
            <button id="btnClearFilters" class="tw-text-sm tw-text-blue-700 hover:tw-text-blue-800">Clear all</button>
          </div>

          <div class="tw-mb-3">
            <label class="tw-text-xs tw-font-medium tw-text-slate-600">Price range (THB)</label>
            <div class="tw-grid tw-grid-cols-2 tw-gap-2">
              <input type="number" min="0" step="1" id="minPrice" class="tw-w-full tw-border tw-border-slate-300 tw-rounded-xl tw-py-2 tw-px-3 focus:tw-outline-none focus:tw-ring-2 focus:tw-ring-blue-600/20 focus:tw-border-blue-600" placeholder="Min">
              <input type="number" min="0" step="1" id="maxPrice" class="tw-w-full tw-border tw-border-slate-300 tw-rounded-xl tw-py-2 tw-px-3 focus:tw-outline-none focus:tw-ring-2 focus:tw-ring-blue-600/20 focus:tw-border-blue-600" placeholder="Max">
            </div>
          </div>

          <div class="tw-mb-3">
            <div class="tw-text-xs tw-font-medium tw-text-slate-600 tw-mb-1">Categories</div>
            <label class="tw-flex tw-items-center tw-gap-2 tw-text-sm tw-text-slate-700"><input type="checkbox" value="Sightseeing" id="catSight" class="tw-rounded tw-border-slate-300"> Sightseeing</label>
            <label class="tw-flex tw-items-center tw-gap-2 tw-text-sm tw-text-slate-700"><input type="checkbox" value="Shows" id="catShows" class="tw-rounded tw-border-slate-300"> Shows</label>
            <label class="tw-flex tw-items-center tw-gap-2 tw-text-sm tw-text-slate-700"><input type="checkbox" value="Parks" id="catParks" class="tw-rounded tw-border-slate-300"> Parks</label>
          </div>

          <div class="tw-mb-2">
            <div class="tw-text-xs tw-font-medium tw-text-slate-600 tw-mb-1">Rating</div>
            <label class="tw-flex tw-items-center tw-gap-2 tw-text-sm tw-text-slate-700"><input type="radio" name="rating" id="r4" value="4" class="tw-border-slate-300"> 4+ stars</label>
            <label class="tw-flex tw-items-center tw-gap-2 tw-text-sm tw-text-slate-700"><input type="radio" name="rating" id="r3" value="3" class="tw-border-slate-300"> 3+ stars</label>
            <label class="tw-flex tw-items-center tw-gap-2 tw-text-sm tw-text-slate-700"><input type="radio" name="rating" id="rAny" value="" checked class="tw-border-slate-300"> Any</label>
          </div>

          <div class="tw-mt-3 tw-grid">
            <button id="btnApplyFilters" class="tw-inline-flex tw-items-center tw-justify-center tw-rounded-xl tw-border tw-border-blue-700 tw-text-blue-700 hover:tw-bg-blue-50 tw-py-2 tw-px-3 tw-font-semibold" type="button">Apply filters</button>
          </div>
        </div>
      </div>
    </div>

    <div class="lg:tw-col-span-9">
      <div class="tw-flex tw-items-center tw-justify-between tw-mb-2">
        <div id="resultsMeta" class="tw-text-sm tw-text-slate-500"></div>
        <div id="pagerTop" class="tw-text-sm"></div>
      </div>
      <div id="resultsList" class="tw-space-y-2"></div>
      <div class="tw-flex tw-items-center tw-justify-between tw-mt-2">
        <div></div>
        <nav id="pagerBottom"></nav>
      </div>
    </div>
  </div>
</div>

<script>
(function(){
  // Apply page background (whitesmoke) while on this page, with strong override
  try {
    document.documentElement.classList.add('bg-booking');
    document.body.classList.add('bg-booking');
    document.body.classList.add('page-activities');
    document.documentElement.style.backgroundColor = 'whitesmoke';
    document.body.style.backgroundColor = 'whitesmoke';
  } catch(e) {}
  window.addEventListener('beforeunload', function(){
    try {
      document.documentElement.classList.remove('bg-booking');
      document.body.classList.remove('bg-booking');
      document.body.classList.remove('page-activities');
      document.documentElement.style.backgroundColor = '';
      document.body.style.backgroundColor = '';
    } catch(e) {}
  });

  const form = document.getElementById('activitiesListSearch');
  const inputQ = document.getElementById('q');
  const inputCity = document.getElementById('city');
  const selectSort = document.getElementById('sort');
  const meta = document.getElementById('resultsMeta');
  const list = document.getElementById('resultsList');
  const minPrice = document.getElementById('minPrice');
  const maxPrice = document.getElementById('maxPrice');
  const btnApplyFilters = document.getElementById('btnApplyFilters');
  const btnClearFilters = document.getElementById('btnClearFilters');
  const pagerTop = document.getElementById('pagerTop');
  const pagerBottom = document.getElementById('pagerBottom');

  let allItems = [];
  let view = 'list';
  let page = 1;
  const pageSize = 20;

  function skeleton() {
    return `
      <div class="tw-animate-pulse tw-space-y-2 tw-mb-2">
        <div class="tw-h-4 tw-w-1/2 tw-bg-slate-200 tw-rounded"></div>
        <div class="tw-h-3 tw-w-3/4 tw-bg-slate-200 tw-rounded"></div>
        <div class="tw-h-3 tw-w-1/4 tw-bg-slate-200 tw-rounded"></div>
      </div>`;
  }

  function priceNum(x){ return Number(x || 0); }

  function applyClientFilters(items){
    let out = items.slice();
    const min = minPrice.value ? Number(minPrice.value) : null;
    const max = maxPrice.value ? Number(maxPrice.value) : null;
    if (min !== null) out = out.filter(i => priceNum(i.from_price) >= min);
    if (max !== null) out = out.filter(i => priceNum(i.from_price) <= max);
    // Category & rating are stubs for now (no data fields guaranteed)
    return out;
  }

  function applySort(items){
    const s = selectSort.value;
    const arr = items.slice();
    if (s === 'price_asc') arr.sort((a,b)=>priceNum(a.from_price)-priceNum(b.from_price));
    else if (s === 'price_desc') arr.sort((a,b)=>priceNum(b.from_price)-priceNum(a.from_price));
    return arr;
  }

  function renderPager(total){
    const pages = Math.max(1, Math.ceil(total / pageSize));
    if (page > pages) page = pages;
    const btnBase = "tw-inline-flex tw-items-center tw-justify-center tw-rounded-lg tw-border tw-border-slate-300 tw-bg-white hover:tw-bg-slate-50 tw-text-slate-700 tw-px-2.5 tw-py-1 tw-text-sm";
    const btnActive = "tw-bg-blue-700 tw-text-white tw-border-blue-700 hover:tw-bg-blue-800";
    const btnDisabled = "tw-opacity-50 tw-pointer-events-none";
    const toLink = (p) => `<li><a class="page-link ${btnBase} ${p===page?btnActive:''}" href="#" data-page="${p}">${p}</a></li>`;
    const parts = [];
    parts.push(`<ul class="tw-flex tw-items-center tw-gap-1">`);
    parts.push(`<li><a class="page-link ${btnBase} ${page<=1?btnDisabled:''}" href="#" data-page="${page-1}">Prev</a></li>`);
    for (let p=1;p<=pages;p++){
      if (p===1||p===pages||Math.abs(p-page)<=2) { parts.push(toLink(p)); }
      else if (Math.abs(p-page)===3) { parts.push(`<li><span class="${btnBase} tw-cursor-default">…</span></li>`); }
    }
    parts.push(`<li><a class="page-link ${btnBase} ${page>=pages?btnDisabled:''}" href="#" data-page="${page+1}">Next</a></li>`);
    parts.push(`</ul>`);
    const html = parts.join('');
    pagerTop.innerHTML = html;
    pagerBottom.innerHTML = html;
    [pagerTop, pagerBottom].forEach(el => el.querySelectorAll('a.page-link').forEach(a => a.addEventListener('click', (ev)=>{
      ev.preventDefault();
      const p = Number(a.getAttribute('data-page'));
      if (!Number.isNaN(p) && p>=1) { page = p; draw(); window.scrollTo({top:0,behavior:'smooth'}); }
    })));
  }

  function cardHtml(a){
    const price = `THB ${priceNum(a.from_price).toFixed(2)}`;
    return `
      <div class="tw-rounded-2xl tw-bg-white tw-border tw-border-black/5 tw-shadow-[0_2px_10px_rgba(0,0,0,0.05)] tw-p-3 tw-grid tw-grid-cols-[140px_1fr_auto] tw-gap-3 tw-items-center">
        <div class="tw-rounded-xl tw-overflow-hidden tw-bg-slate-100 tw-aspect-[4/3]">
          ${a.thumbnail ? `<img src="${a.thumbnail}" alt="${a.name}" class="tw-w-full tw-h-full tw-object-cover">` : ''}
        </div>
        <div>
          <div class="tw-font-semibold">${a.name}</div>
          <div class="tw-text-slate-500 tw-text-sm">${a.city || ''}</div>
        </div>
        <div class="tw-text-right">
          <div class="tw-font-semibold">${price}</div>
          <button type="button" class="tw-inline-flex tw-items-center tw-rounded-xl tw-border tw-border-blue-700 tw-text-blue-700 hover:tw-bg-blue-50 tw-px-3 tw-py-1 tw-text-sm tw-mt-1" data-id="${a.id}">View</button>
        </div>
      </div>`;
  }

  function draw(){
    // Filter + sort + paginate
    let items = applyClientFilters(allItems);
    const total = items.length;
    items = applySort(items);
    const start = (page-1)*pageSize;
    const slice = items.slice(start, start+pageSize);
    meta.textContent = `${total} activit${total===1?'y':'ies'} found`;
    if (!slice.length) { list.innerHTML = '<div class="tw-text-slate-500 tw-text-sm">No activities found. Try different filters.</div>'; renderPager(total); return; }
    list.innerHTML = slice.map(cardHtml).join('');
    renderPager(total);
  }

  async function search() {
    const q = (inputQ.value || '').trim();
    const city = (inputCity.value || '').trim();
    const params = new URLSearchParams();
    if (q) params.set('q', q);
    if (city) params.set('city', city);
    list.innerHTML = skeleton();
    meta.textContent = 'Searching…';
    page = 1;
    try {
      const res = await fetch(`/b2b/api/activities/search?${params.toString()}`, { headers: { 'Accept': 'application/json' } });
      const json = await res.json();
      allItems = Array.isArray(json.data) ? json.data : [];
      draw();
      // Sync URL
      const newUrl = `/agent/activities${params.toString()?('?' + params.toString()):''}`;
      if (newUrl !== window.location.pathname + window.location.search) {
        window.history.replaceState(null, '', newUrl);
      }
    } catch (e) {
      meta.textContent = '';
      list.innerHTML = '<div class="tw-text-red-600 tw-text-sm">Failed to load activities.</div>';
    }
  }

  form.addEventListener('submit', function(ev){ ev.preventDefault(); search(); });
  selectSort.addEventListener('change', function(){ page=1; draw(); });
  btnApplyFilters.addEventListener('click', function(){ page=1; draw(); });
  btnClearFilters.addEventListener('click', function(ev){ ev.preventDefault(); minPrice.value=''; maxPrice.value=''; document.getElementById('rAny').checked = true; page=1; draw(); });
  // View toggle removed; default remains list

  // Auto-run search on first load when q present
  if ((inputQ.value || '').trim() !== '' || (inputCity.value || '').trim() !== '') { search(); }
  else { meta.textContent = 'Enter a search term to find activities.'; }
})();
</script>

<style>
  /* Full-page whitesmoke wrapper to ensure consistent background regardless of theme layers */
  .activities-page-bg { background: #f5f5f5 !important; min-height: 100vh; width: 100%; }

  /* Booking.com-like light gray page background - enforce on html and body */
  html.bg-booking, body.bg-booking { background-color: #f5f5f5 !important; }

  /* HARD override of global gradient in main layout for this page only */
  body.b2b.page-activities { background: #f5f5f5 !important; background-image: none !important; }

  /* Removed Bootstrap-based results list/card CSS; cards now use Tailwind utilities in markup */
</style>
