<?php
// app/Views/agent/packages_list.php
$q = isset($q) ? (string)$q : (string)($_GET['q'] ?? '');
$city = isset($city) ? (string)$city : (string)($_GET['city'] ?? '');
?>

<!-- Local Tailwind (unprefixed) for this view -->
<script>window.tailwind=window.tailwind||{};tailwind.config={theme:{extend:{colors:{brand:{DEFAULT:'#003580',600:'#00285F'}}}}};</script>
<script src="https://cdn.tailwindcss.com"></script>

<div class="min-h-screen">
  <!-- Top bar: Title and Back -->
  <div class="max-w-7xl mx-auto px-4 pt-4 pb-2">
    <div class="flex items-center justify-between">
      <h1 class="text-lg font-semibold m-0">Packages</h1>
      <a href="/agent" class="inline-flex items-center gap-1 rounded-lg border border-slate-300 text-slate-700 hover:bg-slate-50 px-3 py-1 text-sm">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-4 h-4"><path fill-rule="evenodd" d="M10.03 3.97a.75.75 0 010 1.06L5.81 9.25H21a.75.75 0 010 1.5H5.81l4.22 4.22a.75.75 0 11-1.06 1.06l-5.5-5.5a.75.75 0 010-1.06l5.5-5.5a.75.75 0 011.06 0z" clip-rule="evenodd"/></svg>
        Back
      </a>
    </div>
  </div>

  <!-- Search bar -->
  <section class="bg-gradient-to-b from-[#F5F8FF] to-white">
    <div class="max-w-7xl mx-auto px-4 py-6 md:py-8">
      <div class="relative z-10 bg-white shadow-xl ring-1 ring-slate-200 rounded-2xl px-3 py-3 md:px-4 md:py-4">
        <form id="pkgSearch" class="grid md:grid-cols-4 gap-2 md:gap-3 items-end">
          <div class="md:col-span-3">
            <label class="text-xs text-slate-600">Package / City</label>
            <div class="relative">
              <input id="q" name="q" value="<?= htmlspecialchars($q ?: ($city? ($q?"$q, $city":$city) : '')) ?>" class="w-full pr-9 rounded-full h-11 border border-slate-200 px-4 focus:ring-2 focus:ring-blue-600/20 focus:outline-none" placeholder="Coral Island Tour, Phuket" />
              <span class="pointer-events-none absolute inset-y-0 right-3 flex items-center text-slate-400">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-5 h-5"><path fill-rule="evenodd" d="M10.5 3.75a6.75 6.75 0 104.243 12.03l3.238 3.239a.75.75 0 101.06-1.061l-3.238-3.238A6.75 6.75 0 0010.5 3.75zm0 1.5a5.25 5.25 0 110 10.5 5.25 5.25 0 010-10.5z" clip-rule="evenodd"/></svg>
              </span>
              <input type="hidden" id="city" name="city" value="<?= htmlspecialchars($city) ?>" />
            </div>
          </div>
          <div class="flex items-end">
            <button type="submit" class="inline-flex items-center justify-center w-full rounded-full h-11 px-6 bg-blue-900 hover:bg-blue-800 text-white font-semibold">Search</button>
          </div>
        </form>
      </div>
    </div>
  </section>

  <!-- Content -->
  <main class="max-w-7xl mx-auto px-4 py-6">
    <div class="flex items-center justify-between gap-3 mb-4">
      <p id="meta" class="text-sm text-slate-600">&nbsp;</p>
      <div class="text-sm" id="pagerTop"></div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-12 gap-6">
      <aside class="lg:col-span-4 xl:col-span-3">
        <div class="bg-white shadow ring-1 ring-slate-200 rounded-2xl p-4">
          <div class="mb-2"><h3 class="font-semibold">Filters</h3></div>
          <div class="text-sm text-slate-500">Use the search bar to filter by package name or city.</div>
        </div>
      </aside>
      <section class="lg:col-span-8 xl:col-span-9 space-y-4">
        <div id="list" class="space-y-4"></div>
        <div class="flex items-center justify-center gap-2 pt-2" id="pagerBottom"></div>
      </section>
    </div>
  </main>
</div>

<!-- Loading overlay -->
<div id="loadingOverlay" class="fixed inset-0 bg-white/70 backdrop-blur-sm z-40" aria-live="polite" aria-busy="true">
  <div class="absolute inset-0 flex items-center justify-center">
    <div class="flex flex-col items-center gap-3 text-slate-700">
      <svg class="animate-spin h-8 w-8 text-blue-900" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" aria-hidden="true">
        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z"></path>
      </svg>
      <div class="text-sm font-medium">Fetching packages…</div>
    </div>
  </div>
  <span class="sr-only">Loading</span>
</div>

<script>
(function(){
  const form = document.getElementById('pkgSearch');
  const inputQ = document.getElementById('q');
  const inputCity = document.getElementById('city');
  const list = document.getElementById('list');
  const meta = document.getElementById('meta');
  const pagerTop = document.getElementById('pagerTop');
  const pagerBottom = document.getElementById('pagerBottom');
  const overlay = document.getElementById('loadingOverlay');

  let allItems = []; let page = 1; const pageSize = 20;
  function setLoading(on){ overlay.classList.toggle('hidden', !on); }
  function priceNum(x){ return Number(x||0); }

  function renderPager(total){
    const pages = Math.max(1, Math.ceil(total / pageSize));
    if (page > pages) page = pages;
    const cls = 'inline-flex items-center justify-center rounded-lg border border-slate-300 bg-white hover:bg-slate-50 text-slate-700 px-2.5 py-1 text-sm';
    const active = 'bg-blue-700 text-white border-blue-700 hover:bg-blue-800';
    const dis = 'opacity-50 pointer-events-none';
    const toLink = (p) => `<a href="#" data-page="${p}" class="page-link ${cls} ${p===page?active:''}">${p}</a>`;
    const parts = [];
    parts.push(`<a href="#" data-page="${page-1}" class="page-link ${cls} ${page<=1?dis:''}">Prev</a>`);
    for (let p=1;p<=pages;p++){
      if (p===1||p===pages||Math.abs(p-page)<=2) parts.push(toLink(p));
      else if (Math.abs(p-page)===3) parts.push(`<span class="${cls}">…</span>`);
    }
    parts.push(`<a href="#" data-page="${page+1}" class="page-link ${cls} ${page>=pages?dis:''}">Next</a>`);
    const html = parts.join(' ');
    pagerTop.innerHTML = html; pagerBottom.innerHTML = html;
    [pagerTop, pagerBottom].forEach(el => el.querySelectorAll('a.page-link').forEach(a => a.addEventListener('click', (ev)=>{
      ev.preventDefault(); const p = Number(a.getAttribute('data-page')); if (!Number.isNaN(p) && p>=1){ page=p; draw(); window.scrollTo({top:0,behavior:'smooth'}); }
    })));
  }

  function cardHtml(a){
    const amount = priceNum(a.from_price).toFixed(2);
    const priceHtml = `฿ ${amount}`;
    return `
      <article class="bg-white shadow-sm ring-1 ring-slate-100 rounded-2xl p-3 transition hover:shadow-md">
        <div class="grid sm:grid-cols-12 gap-3">
          <div class="sm:col-span-3">
            <div class="w-full h-24 bg-slate-100 rounded-xl overflow-hidden">
              ${a.thumbnail ? `<img class=\"w-full h-full object-cover\" src=\"${a.thumbnail}\" alt=\"${a.name}\" loading=\"lazy\"/>` : ''}
            </div>
          </div>
          <div class="sm:col-span-6 p-2">
            <h3 class="font-semibold">${a.name}</h3>
            <div class="mt-1 text-sm text-slate-600">${a.subtitle || ''}</div>
            ${a.city ? `<div class=\"mt-1 text-xs text-slate-500\">${a.city}</div>` : ''}
          </div>
          <div class="sm:col-span-3 p-2 flex flex-col justify-between items-stretch sm:items-end sm:border-l border-slate-100 sm:pl-4 gap-2">
            <div class="text-left sm:text-right">
              <div class="text-slate-500 text-xs">Starting from</div>
              <div class="text-2xl font-extrabold">${priceHtml}</div>
              <div class="text-slate-500 text-[11px]">per person</div>
            </div>
            <button type="button" class="inline-flex items-center justify-center gap-2 rounded-full bg-blue-900 hover:bg-blue-800 text-white px-5 py-2 text-sm shadow-sm w-full sm:w-auto" data-id="${a.id}">
              <span>View</span>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4"><path stroke-linecap="round" stroke-linejoin="round" d="M8.25 4.5l7.5 7.5-7.5 7.5" /></svg>
            </button>
          </div>
        </div>
      </article>`;
  }

  function draw(){
    const total = allItems.length;
    const start = (page-1)*pageSize; const slice = allItems.slice(start, start+pageSize);
    meta.textContent = `${total} package${total===1?'':'s'} found`;
    if (!slice.length){ list.innerHTML = '<div class="text-slate-500 text-sm">No packages found. Try different filters.</div>'; renderPager(total); return; }
    list.innerHTML = slice.map(cardHtml).join('');
    renderPager(total);
  }

  async function search(){
    list.innerHTML = '<div class="animate-pulse space-y-2"><div class="h-4 w-1/2 bg-slate-200 rounded"></div><div class="h-3 w-3/4 bg-slate-200 rounded"></div><div class="h-3 w-1/4 bg-slate-200 rounded"></div></div>';
    meta.textContent = 'Searching…'; page = 1; setLoading(true);

    const sp = new URLSearchParams();
    const qv = (inputQ.value||'').trim(); if (qv) sp.set('q', qv);
    const city = (inputCity.value||'').trim(); if (city) sp.set('city', city);

    try{
      // Reuse activities endpoint which returns vendor packages for agents
      const res = await fetch(`/b2b/api/activities/search?${sp.toString()}`, { headers: { 'Accept':'application/json' } });
      const js = await res.json();
      const data = Array.isArray(js.data) ? js.data : [];
      allItems = data; draw();
      const newUrl = `/agent/packages${sp.toString()?('?' + sp.toString()):''}`;
      if (newUrl !== window.location.pathname + window.location.search){ window.history.replaceState(null, '', newUrl); }
    }catch(e){ meta.textContent=''; list.innerHTML = '<div class="text-red-600 text-sm">Failed to load packages.</div>'; }
    finally{ setLoading(false); }
  }

  form.addEventListener('submit', function(ev){ ev.preventDefault(); search(); });
  // Initial
  search();
})();
</script>
