<?php
// Agent Landing Page - Tailwind (tw- prefix), vanilla JS
?>
<section class="tw-bg-gradient-to-b tw-from-[#003580] tw-via-[#1B4F9C] tw-to-[#EEF2FF]">
  <div class="tw-max-w-7xl tw-mx-auto tw-px-4 tw-pt-14 tw-pb-16 tw-text-center">
    <h1 class="tw-text-white tw-text-[20px] tw-font-extrabold tw-text-center">Search. Sell. Manage — your B2B travel workspace.</h1>

    <div class="tw-mt-6 tw-bg-white/95 tw-backdrop-blur tw-rounded-2xl tw-border tw-border-slate-200 tw-shadow-xl tw-mx-auto tw-max-w-6xl">
      <div class="tw-px-3 tw-py-3 tw-pb-4 tw-flex tw-gap-2 tw-relative tw-overflow-x-auto tw-overscroll-x-contain no-scrollbar tw-whitespace-nowrap tw-snap-x tw-snap-mandatory md:tw-flex-wrap md:tw-whitespace-normal md:tw-overflow-visible" data-tabs role="tablist" aria-label="Search categories">
        <!-- Activities (selected) -->
        <button class="tab-btn tw-inline-flex tw-items-center tw-gap-2 tw-whitespace-nowrap tw-snap-start tw-px-4 tw-py-2 tw-rounded-full tw-bg-white tw-text-[#1B4F9C] tw-font-semibold tw-shadow tw-ring-2 tw-ring-[#1B4F9C] focus:tw-outline-none focus:tw-ring-2 focus:tw-ring-offset-2 focus:tw-ring-[#1B4F9C]" data-tab="activities" role="tab" aria-selected="true">
          <svg class="tw-w-4 tw-h-4" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true"><path d="M11.48 3.499a.75.75 0 0 1 1.04 0l1.616 1.616a2.25 2.25 0 0 0 1.591.659h2.284a.75.75 0 0 1 .53 1.28l-1.616 1.616a2.25 2.25 0 0 0-.659 1.59v2.285a.75.75 0 0 1-1.28.53l-1.616-1.616a2.25 2.25 0 0 0-1.59-.659H9.75a.75.75 0 0 1-.53-1.28l1.616-1.616a2.25 2.25 0 0 0 .659-1.59V4.03c0-.199.079-.39.225-.531Z"/><path d="M6.75 13.5a.75.75 0 0 1 .75.75v2.25h2.25a.75.75 0 0 1 0 1.5H7.5v2.25a.75.75 0 0 1-1.5 0V18H3.75a.75.75 0 0 1 0-1.5H6v-2.25a.75.75 0 0 1 .75-.75Z"/></svg>
          Activities
        </button>
        <!-- Taxi (cars pane) -->
        <button class="tab-btn tw-inline-flex tw-items-center tw-gap-2 tw-whitespace-nowrap tw-snap-start tw-px-4 tw-py-2 tw-rounded-full tw-bg-white tw-text-slate-700 tw-border tw-border-slate-200 tw-shadow-sm hover:tw-bg-slate-50 focus:tw-outline-none focus:tw-ring-2 focus:tw-ring-offset-2 focus:tw-ring-[#1B4F9C]" data-tab="cars" role="tab" aria-selected="false">
          <svg class="tw-w-4 tw-h-4" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true"><path d="M5.25 12 6.6 7.8A3 3 0 0 1 9.45 6h5.1a3 3 0 0 1 2.85 1.8L18.75 12M4.5 15.75h15a1.5 1.5 0 0 0 1.5-1.5V12a1.5 1.5 0 0 0-1.5-1.5h-15A1.5 1.5 0 0 0 3 12v2.25a1.5 1.5 0 0 0 1.5 1.5Z"/><path d="M7.5 18a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm9 0a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Z"/></svg>
          Taxi
        </button>
        <!-- Hotel (hotels pane) -->
        <button class="tab-btn tw-inline-flex tw-items-center tw-gap-2 tw-whitespace-nowrap tw-snap-start tw-px-4 tw-py-2 tw-rounded-full tw-bg-white tw-text-slate-700 tw-border tw-border-slate-200 tw-shadow-sm hover:tw-bg-slate-50 focus:tw-outline-none focus:tw-ring-2 focus:tw-ring-offset-2 focus:tw-ring-[#1B4F9C]" data-tab="hotels" role="tab" aria-selected="false">
          <svg class="tw-w-4 tw-h-4" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true"><path d="M3.75 20.25a.75.75 0 0 1-.75-.75V5.25A2.25 2.25 0 0 1 5.25 3h7.5A2.25 2.25 0 0 1 15 5.25v14.25a.75.75 0 0 1-.75.75h-10.5ZM6 7.5h3v3H6v-3Zm0 4.5h3v3H6v-3Zm4.5-4.5H13.5v3H10.5v-3Zm0 4.5H13.5v3H10.5v-3Z"/><path d="M18 7.5h2.25A1.75 1.75 0 0 1 22 9.25v10.25a.75.75 0 0 1-.75.75H18a.75.75 0 0 1-.75-.75V8.25A.75.75 0 0 1 18 7.5Z"/></svg>
          Hotel
        </button>
        <!-- Yachts -->
        <button class="tab-btn tw-inline-flex tw-items-center tw-gap-2 tw-whitespace-nowrap tw-snap-start tw-px-4 tw-py-2 tw-rounded-full tw-bg-white tw-text-slate-700 tw-border tw-border-slate-200 tw-shadow-sm hover:tw-bg-slate-50 focus:tw-outline-none focus:tw-ring-2 focus:tw-ring-offset-2 focus:tw-ring-[#1B4F9C]" data-tab="yachts" role="tab" aria-selected="false">
          <svg class="tw-w-4 tw-h-4" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true"><path d="M3 17.25c1.2 0 1.8-.75 3-.75s1.8.75 3 .75 1.8-.75 3-.75 1.8.75 3 .75 1.8-.75 3-.75 1.8.75 3 .75v1.5c-1.2 0-1.8-.75-3-.75s-1.8.75-3 .75-1.8-.75-3-.75-1.8.75-3 .75-1.8-.75-3-.75-1.8.75-3 .75v-1.5Z"/><path d="M12 3.75 6 12h6V3.75Zm6 8.25H12v3h8.25a.75.75 0 0 0 .68-1.06l-1.93-3.86a.75.75 0 0 0-.68-.41h-1.32Z"/></svg>
          Yachts
        </button>
        <!-- Packages -->
        <button class="tab-btn tw-inline-flex tw-items-center tw-gap-2 tw-whitespace-nowrap tw-snap-start tw-px-4 tw-py-2 tw-rounded-full tw-bg-white tw-text-slate-700 tw-border tw-border-slate-200 tw-shadow-sm hover:tw-bg-slate-50 focus:tw-outline-none focus:tw-ring-2 focus:tw-ring-offset-2 focus:tw-ring-[#1B4F9C]" data-tab="packages" role="tab" aria-selected="false">
          <svg class="tw-w-4 tw-h-4" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true"><path d="M12 2.25 8.25 4.5 12 6.75 15.75 4.5 12 2.25Zm-6 4.5L9.75 9v12H6a1.5 1.5 0 0 1-1.5-1.5V6.75ZM14.25 21V9l3.75-2.25v12.75A1.5 1.5 0 0 1 16.5 21h-2.25Z"/></svg>
          Packages
        </button>
        <span class="tw-flex-none tw-w-3"></span>
        <span id="tabIndicator" class="tw-absolute tw-bottom-0 tw-h-0.5 tw-bg-[#1B4F9C] tw-rounded-full tw-transition-all tw-duration-300" style="left:0;width:0"></span>
      </div>
      <div class="tw-p-4 md:tw-p-5 tw-space-y-3">
        <!-- Hotels pane (hidden by default) -->
        <div data-pane="hotels" role="tabpanel" class="tw-hidden" aria-hidden="true">
          <div class="tw-grid tw-grid-cols-1 md:tw-grid-cols-5 tw-gap-3">
            <div class="md:tw-col-span-2">
              <label class="tw-text-xs tw-text-slate-600">Location</label>
              <input id="hotelCity" autocomplete="off" class="tw-w-full tw-h-11 tw-rounded-xl tw-border tw-border-slate-300 focus:tw-ring-2 focus:tw-ring-[#1B4F9C] focus:tw-outline-none tw-px-3" placeholder="City or hotel in Thailand (e.g., Bangkok, Phuket)" />
            </div>
            <div>
              <label class="tw-text-xs tw-text-slate-600">Check-in</label>
              <input id="hotelCheckin" type="date" class="tw-w-full tw-h-11 tw-rounded-xl tw-border tw-border-slate-300 focus:tw-ring-2 focus:tw-ring-[#1B4F9C] focus:tw-outline-none tw-px-3" />
            </div>
            <div>
              <label class="tw-text-xs tw-text-slate-600">Check-out</label>
              <input id="hotelCheckout" type="date" class="tw-w-full tw-h-11 tw-rounded-xl tw-border tw-border-slate-300 focus:tw-ring-2 focus:tw-ring-[#1B4F9C] focus:tw-outline-none tw-px-3" />
            </div>
            <div>
              <label class="tw-text-xs tw-text-slate-600">Guests</label>
              <select id="hotelGuests" class="tw-w-full tw-h-11 tw-rounded-xl tw-border tw-border-slate-300 focus:tw-ring-2 focus:tw-ring-[#1B4F9C] focus:tw-outline-none tw-px-3"><option>2 Adults, 1 Room</option><option>3 Adults, 1 Room</option></select>
            </div>
          </div>
        </div>
        <!-- Activities pane (default visible) -->
        <div data-pane="activities" role="tabpanel">
          <div class="tw-grid tw-grid-cols-1 tw-gap-3">
            <div class="tw-relative">
              <label class="tw-text-xs tw-text-slate-600">Activity / City</label>
              <input id="actQuery" autocomplete="off" class="tw-w-full tw-h-11 tw-rounded-xl tw-border tw-border-slate-300 focus:tw-ring-2 focus:tw-ring-[#1B4F9C] focus:tw-outline-none tw-px-3" placeholder="Search Thailand activities or cities (e.g., Bangkok, Phuket, Phi Phi tour)" />
              <div id="actSuggest" class="tw-absolute tw-top-full tw-z-50 tw-left-0 tw-right-0 tw-mt-1 tw-bg-white tw-border tw-border-slate-200 tw-rounded-xl tw-shadow-xl tw-overflow-auto tw-max-h-72 tw-hidden" role="listbox" aria-label="Suggestions"></div>
            </div>
          </div>
        </div>
        <!-- Cars pane -->
        <div class="tw-hidden" data-pane="cars" role="tabpanel" aria-hidden="true">
          <div class="tw-grid tw-grid-cols-1 md:tw-grid-cols-5 tw-gap-3">
            <div class="md:tw-col-span-2">
              <label class="tw-text-xs tw-text-slate-600">Pickup</label>
              <input class="tw-w-full tw-h-11 tw-rounded-xl tw-border tw-border-slate-300 focus:tw-ring-2 focus:tw-ring-[#1B4F9C] focus:tw-outline-none tw-px-3" placeholder="BKK (Suvarnabhumi) Airport" />
            </div>
            <div class="md:tw-col-span-2">
              <label class="tw-text-xs tw-text-slate-600">Drop</label>
              <input class="tw-w-full tw-h-11 tw-rounded-xl tw-border tw-border-slate-300 focus:tw-ring-2 focus:tw-ring-[#1B4F9C] focus:tw-outline-none tw-px-3" placeholder="Hotel / Address" />
            </div>
            <div>
              <label class="tw-text-xs tw-text-slate-600">Date</label>
              <input type="date" class="tw-w-full tw-h-11 tw-rounded-xl tw-border tw-border-slate-300 focus:tw-ring-2 focus:tw-ring-[#1B4F9C] focus:tw-outline-none tw-px-3" />
            </div>
          </div>
        </div>
        <!-- Yachts pane -->
        <div class="tw-hidden" data-pane="yachts" role="tabpanel" aria-hidden="true">
          <div class="tw-grid tw-grid-cols-1 md:tw-grid-cols-3 tw-gap-3">
            <div>
              <label class="tw-text-xs tw-text-slate-600">City</label>
              <input class="tw-w-full tw-h-11 tw-rounded-xl tw-border tw-border-slate-300 focus:tw-ring-2 focus:tw-ring-[#1B4F9C] focus:tw-outline-none tw-px-3" placeholder="Phuket" />
            </div>
            <div>
              <label class="tw-text-xs tw-text-slate-600">Date</label>
              <input type="date" class="tw-w-full tw-h-11 tw-rounded-xl tw-border tw-border-slate-300 focus:tw-ring-2 focus:tw-ring-[#1B4F9C] focus:tw-outline-none tw-px-3" />
            </div>
            <div>
              <label class="tw-text-xs tw-text-slate-600">Guests</label>
              <select class="tw-w-full tw-h-11 tw-rounded-xl tw-border tw-border-slate-300 focus:tw-ring-2 focus:tw-ring-[#1B4F9C] focus:tw-outline-none tw-px-3"><option>4</option><option>8</option></select>
            </div>
          </div>
        </div>
        <!-- Packages pane -->
        <div class="tw-hidden" data-pane="packages" role="tabpanel" aria-hidden="true">
          <div class="tw-grid tw-grid-cols-1 md:tw-grid-cols-4 tw-gap-3">
            <div class="md:tw-col-span-2">
              <label class="tw-text-xs tw-text-slate-600">Destination</label>
              <input class="tw-w-full tw-h-11 tw-rounded-xl tw-border tw-border-slate-300 focus:tw-ring-2 focus:tw-ring-[#1B4F9C] focus:tw-outline-none tw-px-3" placeholder="Bali 5N6D" />
            </div>
            <div>
              <label class="tw-text-xs tw-text-slate-600">Start</label>
              <input type="date" class="tw-w-full tw-h-11 tw-rounded-xl tw-border tw-border-slate-300 focus:tw-ring-2 focus:tw-ring-[#1B4F9C] focus:tw-outline-none tw-px-3" />
            </div>
            <div>
              <label class="tw-text-xs tw-text-slate-600">Pax</label>
              <select class="tw-w-full tw-h-11 tw-rounded-xl tw-border tw-border-slate-300 focus:tw-ring-2 focus:tw-ring-[#1B4F9C] focus:tw-outline-none tw-px-3"><option>2</option><option>4</option></select>
            </div>
          </div>
        </div>

        <div class="tw-flex tw-flex-col tw-gap-3 md:tw-flex-row md:tw-items-center md:tw-justify-between">
          <span class="tw-flex tw-items-center tw-gap-2 tw-text-sm tw-text-slate-600">
            <span class="tw-inline-flex tw-items-center tw-px-2 tw-py-0.5 tw-rounded-full tw-bg-[#1B4F9C]/10 tw-text-[#1B4F9C] tw-border tw-border-[#1B4F9C]/20 tw-text-xs tw-font-semibold">Instant</span>
            Best rates. Instant confirmation.
          </span>
          <div class="tw-flex tw-flex-col md:tw-flex-row tw-gap-2">
            <a href="#" id="actSearchBtn" class="tw-inline-flex tw-items-center tw-justify-center tw-h-11 tw-px-6 tw-rounded-xl tw-shadow-md tw-bg-[#1B4F9C] tw-text-white tw-w-full md:tw-w-auto">Search</a>
            <a href="/agent/taxis" class="tw-inline-flex tw-items-center tw-justify-center tw-h-11 tw-px-4 tw-rounded-xl tw-shadow-sm tw-bg-white tw-text-[#1B4F9C] tw-border tw-border-slate-200 tw-w-full md:tw-w-auto">Open Taxis</a>
            <a href="/agent/yachts" class="tw-inline-flex tw-items-center tw-justify-center tw-h-11 tw-px-4 tw-rounded-xl tw-shadow-sm tw-bg-white tw-text-[#1B4F9C] tw-border tw-border-slate-200 tw-w-full md:tw-w-auto">Open Yachts</a>
            <a href="/agent/packages" class="tw-inline-flex tw-items-center tw-justify-center tw-h-11 tw-px-4 tw-rounded-xl tw-shadow-sm tw-bg-white tw-text-[#1B4F9C] tw-border tw-border-slate-200 tw-w-full md:tw-w-auto">Open Packages</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="tw-py-10 tw-bg-[#EEF2FF]">
  <div class="tw-max-w-7xl tw-mx-auto tw-px-4">
    <div class="tw-flex tw-items-center tw-justify-between tw-mb-4">
      <h2 class="tw-text-xl sm:tw-text-2xl tw-font-extrabold">Featured Packages</h2>
    </div>
    <div class="tw-relative">
      <button id="pkgPrev" aria-label="Previous" class="tw-hidden sm:tw-grid tw-place-items-center tw-absolute tw-left-2 tw-top-1/2 -tw-translate-y-1/2 tw-w-10 tw-h-10 tw-rounded-full tw-bg-white tw-text-[#1B4F9C] tw-border tw-border-slate-200 tw-shadow hover:tw-bg-[#1B4F9C] hover:tw-text-white tw-transition tw-z-10">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="tw-w-5 tw-h-5"><path fill-rule="evenodd" d="M15.78 19.28a.75.75 0 01-1.06 0l-6-6a.75.75 0 010-1.06l6-6a.75.75 0 111.06 1.06L10.06 12l5.72 5.72a.75.75 0 010 1.06z" clip-rule="evenodd"/></svg>
      </button>
      <button id="pkgNext" aria-label="Next" class="tw-hidden sm:tw-grid tw-place-items-center tw-absolute tw-right-2 tw-top-1/2 -tw-translate-y-1/2 tw-w-10 tw-h-10 tw-rounded-full tw-bg-white tw-text-[#1B4F9C] tw-border tw-border-slate-200 tw-shadow hover:tw-bg-[#1B4F9C] hover:tw-text-white tw-transition tw-z-10">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="tw-w-5 tw-h-5"><path fill-rule="evenodd" d="M8.22 4.72a.75.75 0 011.06 0l6 6a.75.75 0 010 1.06l-6 6a.75.75 0 11-1.06-1.06L13.94 12 8.22 6.28a.75.75 0 010-1.06z" clip-rule="evenodd"/></svg>
      </button>
      <div id="pkgScroller" tabindex="0" class="no-scrollbar tw-overflow-x-auto tw-scroll-smooth tw-snap-x tw-snap-mandatory tw-pr-8 tw-pl-8" aria-label="Featured packages carousel" role="region">
        <div class="tw-flex tw-gap-4 tw-w-max tw-pr-3">
          <?php
            $cards = [
              ['title'=>'Bangkok City Break 3N4D','badge'=>'Hotel + Transfers','price'=>'THB 9,990'],
              ['title'=>'Phuket Beach Escape 4N5D','badge'=>'Hotel + Tours','price'=>'THB 12,900'],
              ['title'=>'Chiang Mai Nature 3N4D','badge'=>'Hotel + Activities','price'=>'THB 8,500'],
              ['title'=>'Krabi Island Hopping 3N4D','badge'=>'Hotel + Tours','price'=>'THB 10,500'],
              ['title'=>'Pattaya Fun Getaway 2N3D','badge'=>'Hotel + Transfers','price'=>'THB 5,990'],
            ];
            foreach($cards as $c): ?>
            <article class="tw-bg-white tw-rounded-2xl tw-border tw-border-slate-200 tw-shadow-sm tw-overflow-hidden tw-snap-start tw-min-w-[15.5rem] sm:tw-min-w-[18rem] tw-w-[18rem] tw-flex tw-flex-col">
              <div class="tw-aspect-[16/9] tw-bg-slate-100"></div>
              <div class="tw-h-1 tw-bg-[#1B4F9C]"></div>
              <div class="tw-p-4 tw-flex tw-flex-col tw-h-full">
                <div class="tw-flex tw-items-center tw-justify-between"><h3 class="tw-font-semibold tw-line-clamp-2 tw-min-h-[3.25rem]"><?= htmlspecialchars($c['title']) ?></h3><span class="tw-text-xs tw-rounded tw-bg-slate-100 tw-py-1 tw-px-2"><?= htmlspecialchars($c['badge']) ?></span></div>
                <p class="tw-text-slate-600 tw-text-sm tw-mt-1">Sample itinerary</p>
                <div class="tw-flex tw-items-center tw-justify-between tw-mt-3"><div class="tw-text-sm tw-text-slate-600">per person</div><div class="tw-text-2xl tw-font-extrabold"><?= htmlspecialchars($c['price']) ?></div></div>
                <a class="tw-inline-flex tw-items-center tw-justify-center tw-h-10 tw-rounded-xl tw-bg-[#1B4F9C] tw-text-white tw-w-full tw-mt-3 tw-mt-auto" href="#">View details</a>
              </div>
            </article>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="tw-py-8 tw-bg-white">
  <div class="tw-max-w-7xl tw-mx-auto tw-px-4">
    <div class="tw-flex tw-items-center tw-justify-between tw-mb-4">
      <h2 class="tw-text-xl sm:tw-text-2xl tw-font-extrabold">Instant Book Activities</h2>
    </div>
    <div class="tw-relative">
      <button id="actPrev" aria-label="Previous" class="tw-hidden sm:tw-grid tw-place-items-center tw-absolute tw-left-2 tw-top-1/2 -tw-translate-y-1/2 tw-w-10 tw-h-10 tw-rounded-full tw-bg-white tw-text-[#1B4F9C] tw-border tw-border-slate-200 tw-shadow hover:tw-bg-[#1B4F9C] hover:tw-text-white tw-transition tw-z-10">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="tw-w-5 tw-h-5"><path fill-rule="evenodd" d="M15.78 19.28a.75.75 0 01-1.06 0l-6-6a.75.75 0 010-1.06l6-6a.75.75 0 111.06 1.06L10.06 12l5.72 5.72a.75.75 0 010 1.06z" clip-rule="evenodd"/></svg>
      </button>
      <button id="actNext" aria-label="Next" class="tw-hidden sm:tw-grid tw-place-items-center tw-absolute tw-right-2 tw-top-1/2 -tw-translate-y-1/2 tw-w-10 tw-h-10 tw-rounded-full tw-bg-white tw-text-[#1B4F9C] tw-border tw-border-slate-200 tw-shadow hover:tw-bg-[#1B4F9C] hover:tw-text-white tw-transition tw-z-10">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="tw-w-5 tw-h-5"><path fill-rule="evenodd" d="M8.22 4.72a.75.75 0 011.06 0l6 6a.75.75 0 010 1.06l-6 6a.75.75 0 11-1.06-1.06L13.94 12 8.22 6.28a.75.75 0 010-1.06z" clip-rule="evenodd"/></svg>
      </button>
      <div id="actScroller" tabindex="0" class="no-scrollbar tw-overflow-x-auto tw-scroll-smooth tw-snap-x tw-snap-mandatory tw-pr-8 tw-pl-8" aria-label="Instant book activities carousel" role="region">
        <div class="tw-flex tw-gap-4 tw-w-max tw-pr-3">
          <?php
            $acts = [
              ['title'=>'Phi Phi Islands Tour by Speedboat','badge'=>'Instant','price'=>'THB 1,200','city'=>'Phuket'],
              ['title'=>'Safari World & Marine Park','badge'=>'Mobile Ticket','price'=>'THB 1,000','city'=>'Bangkok'],
              ['title'=>'Chiang Mai Elephant Sanctuary (Ethical)','badge'=>'Instant','price'=>'THB 1,800','city'=>'Chiang Mai'],
              ['title'=>'James Bond Island Tour','badge'=>'Mobile Ticket','price'=>'THB 1,200','city'=>'Phang Nga'],
              ['title'=>'Nong Nooch Tropical Garden','badge'=>'Instant','price'=>'THB 500','city'=>'Pattaya'],
            ];
            foreach($acts as $a): ?>
            <article class="tw-bg-white tw-rounded-2xl tw-border tw-border-slate-200 tw-shadow-sm tw-overflow-hidden tw-snap-start tw-min-w-[15.5rem] sm:tw-min-w-[18rem] tw-w-[18rem] tw-flex tw-flex-col">
              <div class="tw-aspect-[16/9] tw-bg-slate-100"></div>
              <div class="tw-h-1 tw-bg-[#1B4F9C]"></div>
              <div class="tw-p-4 tw-flex tw-flex-col tw-h-full">
                <div class="tw-flex tw-items-center tw-justify-between"><h3 class="tw-font-semibold tw-line-clamp-2 tw-min-h-[3.25rem]"><?= htmlspecialchars($a['title']) ?></h3><span class="tw-text-xs tw-rounded tw-bg-slate-100 tw-py-1 tw-px-2"><?= htmlspecialchars($a['badge']) ?></span></div>
                <p class="tw-text-slate-600 tw-text-sm tw-mt-1"><?php if (isset($a['city'])) { echo htmlspecialchars($a['city']); } else { echo 'Thailand'; } ?></p>
                <div class="tw-flex tw-items-center tw-justify-between tw-mt-3"><div class="tw-text-sm tw-text-slate-600">per person</div><div class="tw-text-2xl tw-font-extrabold"><?= htmlspecialchars($a['price']) ?></div></div>
                <a class="tw-inline-flex tw-items-center tw-justify-center tw-h-10 tw-rounded-xl tw-bg-[#1B4F9C] tw-text-white tw-w-full tw-mt-3 tw-mt-auto" href="#">Book now</a>
              </div>
            </article>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="tw-py-10">
  <div class="tw-max-w-7xl tw-mx-auto tw-px-4 tw-grid tw-gap-4 sm:tw-grid-cols-2 lg:tw-grid-cols-4">
    <?php
      $high = [
        ['title'=>'Curated inventory','tag'=>'Hotels','desc'=>'Live rates, instant confirmation, printable vouchers.'],
        ['title'=>'Top experiences','tag'=>'Activities','desc'=>'Best sellers and city highlights with real-time slots.'],
        ['title'=>'Transfers & rentals','tag'=>'Cars','desc'=>'Transparent pricing for airport and city rides.'],
        ['title'=>'Stripe-powered','tag'=>'B2B Wallet','desc'=>'Agent wallet, top-ups, settlements and statements.'],
      ];
      foreach($high as $h): ?>
      <article class="tw-bg-white tw-rounded-2xl tw-border tw-border-slate-200 tw-shadow-sm tw-p-5">
        <div class="tw-text-xs tw-rounded tw-bg-slate-100 tw-text-slate-800 tw-px-2 tw-py-1"><?= htmlspecialchars($h['tag']) ?></div>
        <h3 class="tw-mt-2 tw-font-semibold"><?= htmlspecialchars($h['title']) ?></h3>
        <p class="tw-text-slate-600 tw-text-sm"><?= htmlspecialchars($h['desc']) ?></p>
      </article>
    <?php endforeach; ?>
  </div>
</section>

<script>
(function(){
  // Tabs
  const tabsWrap = document.querySelector('[data-tabs]');
  let currentTab = 'activities';
  if (tabsWrap){
    const tabs = Array.from(tabsWrap.querySelectorAll('.tab-btn'));
    const panes = Array.from(document.querySelectorAll('[data-pane]'));
    const indicator = document.getElementById('tabIndicator');
    const activate = (name, btn) => {
      panes.forEach(p => {
        const on = p.getAttribute('data-pane')===name;
        p.classList.toggle('tw-hidden', !on);
        p.toggleAttribute('aria-hidden', !on);
      });
      tabs.forEach(t => t.setAttribute('aria-selected', String(t===btn)));
      if (btn){
        const r = btn.getBoundingClientRect();
        const pr = tabsWrap.getBoundingClientRect();
        const left = r.left - pr.left + tabsWrap.scrollLeft;
        indicator.style.left = left + 'px';
        indicator.style.width = r.width + 'px';
      }
      currentTab = name;
    };
    tabsWrap.addEventListener('click', (e)=>{
      const btn = e.target.closest('.tab-btn');
      if(!btn) return;
      const name = btn.getAttribute('data-tab');
      activate(name, btn);
    });
    // init
    const first = tabs[0];
    if(first) activate(first.getAttribute('data-tab'), first);
  }
  // Simple scrollers
  function setupScroller(id, prevId, nextId){
    const scroller = document.getElementById(id);
    if(!scroller) return;
    const prev = document.getElementById(prevId);
    const next = document.getElementById(nextId);
    const step = 320;
    prev && prev.addEventListener('click', ()=> scroller.scrollBy({left:-step, behavior:'smooth'}));
    next && next.addEventListener('click', ()=> scroller.scrollBy({left: step, behavior:'smooth'}));
  }
  setupScroller('pkgScroller','pkgPrev','pkgNext');
  setupScroller('actScroller','actPrev','actNext');
  // Search button -> activities or hotels list based on active tab
  const $searchBtn = document.getElementById('actSearchBtn');
  if ($searchBtn) {
    $searchBtn.addEventListener('click', (e)=>{
      e.preventDefault();
      // If Hotels tab active, route to /agent/hotels with params
      if (typeof currentTab !== 'undefined' && currentTab === 'hotels') {
        const city = document.getElementById('hotelCity')?.value.trim() || '';
        const checkin = document.getElementById('hotelCheckin')?.value || '';
        const checkout = document.getElementById('hotelCheckout')?.value || '';
        const guestsText = document.getElementById('hotelGuests')?.value || '';
        // Parse guests like "2 Adults, 1 Room"
        let adults = 2, rooms = 1;
        const m = guestsText.match(/(\d+)\s*Adults?.*?(\d+)\s*Rooms?/i);
        if (m) { adults = parseInt(m[1],10) || adults; rooms = parseInt(m[2],10) || rooms; }
        const params = new URLSearchParams();
        if (city) params.set('city', city);
        if (checkin) params.set('checkin', checkin);
        if (checkout) params.set('checkout', checkout);
        if (adults) params.set('adults', String(adults));
        if (rooms) params.set('rooms', String(rooms));
        const url = '/agent/hotels' + (params.toString() ? ('?' + params.toString()) : '');
        window.location.href = url;
        return;
      }
      // Default: Activities search
      const q = document.getElementById('actQuery')?.value.trim() || '';
      const params = new URLSearchParams();
      if (q) params.set('q', q);
      const url = '/agent/activities' + (params.toString() ? ('?' + params.toString()) : '');
      window.location.href = url;
    });
  }
  // Activities typeahead
  const $q = document.getElementById('actQuery');
  const $box = document.getElementById('actSuggest');
  if ($q && $box){
    let t = null; let last = ''; let flat = []; let activeIdx = -1;
    const hide = ()=>{ $box.classList.add('tw-hidden'); $box.innerHTML=''; activeIdx=-1; flat=[]; };
    const escHtml = (s)=> s.replace(/[&<>]/g, ch=>({"&":"&amp;","<":"&lt;",">":"&gt;"}[ch]));
    const highlight = (name, q)=>{
      if (!q) return escHtml(name);
      const i = name.toLowerCase().indexOf(q.toLowerCase());
      if (i<0) return escHtml(name);
      return escHtml(name.slice(0,i)) + '<strong class="tw-text-slate-900">' + escHtml(name.slice(i,i+q.length)) + '</strong>' + escHtml(name.slice(i+q.length));
    };
    const render = (items)=>{
      if (!items || items.length===0) { hide(); return; }
      // Group into Cities and Activities like booking.com
      const cities = items.filter(x=>x.type==='city');
      const acts = items.filter(x=>x.type==='activity');
      const sec = (title, arr)=>{
        if (arr.length===0) return '';
        const rows = arr.map((it, idx)=>{
          const isCity = it.type==='city';
          const icon = isCity
            ? '<svg class="tw-w-4 tw-h-4 tw-text-slate-500" viewBox="0 0 24 24" fill="currentColor"><path d="M3 9.75 12 3l9 6.75V21a.75.75 0 0 1-.75.75H3.75A.75.75 0 0 1 3 21V9.75Zm9 2.25H8.25a.75.75 0 0 0-.75.75V21h4.5v-8.25a.75.75 0 0 0-.75-.75Z"/></svg>'
            : '<svg class="tw-w-4 tw-h-4 tw-text-[#1B4F9C]" viewBox="0 0 24 24" fill="currentColor"><path d="M11.48 3.499a.75.75 0 0 1 1.04 0l1.616 1.616a2.25 2.25 0 0 0 1.591.659h2.284a.75.75 0 0 1 .53 1.28l-1.616 1.616a2.25 2.25 0 0 0-.659 1.59v2.285a.75.75 0 0 1-1.28.53l-1.616-1.616a.75.75 0 0 1-.53-1.28l1.616-1.616a2.25 2.25 0 0 0 .659-1.59V4.03c0-.199.079-.39.225-.531Z"/></svg>';
          const sub = it.city && it.type==='activity' ? `<span class=\"tw-text-xs tw-text-slate-500\">${escHtml(it.city)}</span>` : '';
          return `<button type=\"button\" role=\"option\" data-type=\"${it.type}\" data-id=\"${it.id ?? ''}\" class=\"sug-item tw-w-full tw-text-left tw-flex tw-items-center tw-gap-3 tw-px-3 tw-py-2 hover:tw-bg-slate-50 focus:tw-bg-slate-50\">
            ${icon}
            <span class=\"tw-flex tw-flex-col\"><span class=\"tw-text-sm tw-text-slate-800\">${highlight(it.name, $q.value.trim())}</span>${sub}</span>
          </button>`;
        }).join('');
        return `<div class=\"tw-py-1\"><div class=\"tw-text-[11px] tw-font-semibold tw-text-slate-500 tw-uppercase tw-tracking-wide tw-px-3 tw-py-1\">${title}</div>${rows}</div>`;
      };
      const html = sec('Cities', cities) + sec('Activities', acts);
      $box.innerHTML = html;
      $box.classList.remove('tw-hidden');
      // Build flat list for keyboard nav
      flat = Array.from($box.querySelectorAll('.sug-item'));
      activeIdx = flat.length>0 ? 0 : -1;
      updateActive();
    };
    const updateActive = ()=>{
      flat.forEach((el,i)=>{
        el.classList.toggle('tw-bg-slate-50', i===activeIdx);
      });
      if (flat[activeIdx]) flat[activeIdx].scrollIntoView({ block: 'nearest' });
    };
    const fetchSuggest = async (q)=>{
      try{
        const url = `/b2b/api/activities/suggest?q=${encodeURIComponent(q)}&country=Thailand`;
        const res = await fetch(url, { headers: { 'Accept': 'application/json' } });
        if (!res.ok) { hide(); return; }
        const js = await res.json();
        render(js.data || []);
      }catch(e){ hide(); }
    };
    const debounced = (val)=>{
      if (t) clearTimeout(t);
      t = setTimeout(()=>{ fetchSuggest(val); }, 200);
    };
    $q.addEventListener('input', (e)=>{
      const v = e.target.value.trim();
      if (v === '') { hide(); return; }
      if (v === last) return;
      last = v;
      debounced(v);
    });
    $q.addEventListener('focus', ()=>{ if ($q.value.trim()!=='') debounced($q.value.trim()); });
    document.addEventListener('click', (ev)=>{ if (!($box.contains(ev.target) || $q.contains(ev.target))) hide(); });
    $box.addEventListener('click', (e)=>{
      const btn = e.target.closest('button[role="option"]');
      if (!btn) return;
      const type = btn.getAttribute('data-type');
      const id = btn.getAttribute('data-id');
      const name = btn.querySelector('.tw-text-sm')?.textContent || '';
      if (type === 'activity' && id) {
        // Navigate to Activity Detail page
        window.location.href = '/agent/activities/detail?id=' + encodeURIComponent(id);
      } else {
        // City suggestion -> Activities list filtered by city
        const params = new URLSearchParams();
        params.set('city', name);
        window.location.href = '/agent/activities?' + params.toString();
      }
      hide();
    });
    // Keyboard navigation like booking.com
    $q.addEventListener('keydown', (e)=>{
      if ($box.classList.contains('tw-hidden')) return;
      if (e.key === 'ArrowDown') { e.preventDefault(); if (flat.length){ activeIdx = Math.min(flat.length-1, activeIdx+1); updateActive(); } }
      else if (e.key === 'ArrowUp') { e.preventDefault(); if (flat.length){ activeIdx = Math.max(0, activeIdx-1); updateActive(); } }
      else if (e.key === 'Enter') { if (activeIdx>=0 && flat[activeIdx]) { e.preventDefault(); flat[activeIdx].click(); } }
      else if (e.key === 'Escape') { hide(); }
    });
  }
})();
</script>
