<?php
// app/Views/agent/activity_detail.php
// Expects: $id (int)
$activityId = (int)($id ?? 0);
?>
<section class="tw-space-y-4">
  <nav class="tw-text-sm">
    <a href="/agent/activities" class="tw-text-[#1B4F9C] hover:tw-underline">Activities</a>
    <span class="tw-text-slate-500">/</span>
    <span class="tw-text-slate-700">Detail</span>
  </nav>

  <div id="actContainer" class="tw-bg-white tw-border tw-border-slate-200 tw-rounded-2xl tw-shadow-sm tw-overflow-hidden">
    <div class="tw-p-4 tw-border-b tw-border-slate-200 tw-flex tw-items-center tw-justify-between">
      <div>
        <h1 id="actTitle" class="tw-text-xl tw-font-extrabold tw-text-slate-900">Loading...</h1>
        <div id="actSub" class="tw-text-sm tw-text-slate-600 tw-mt-0.5"></div>
      </div>
      <a href="/agent/activities" class="tw-text-sm tw-text-[#1B4F9C] hover:tw-underline">Back to list</a>
    </div>
    <div class="tw-grid tw-grid-cols-1 lg:tw-grid-cols-3">
      <div class="lg:tw-col-span-2 tw-p-4 tw-space-y-4">
        <div id="actGallery" class="tw-aspect-[16/9] tw-bg-slate-100 tw-rounded-xl"></div>
        <article id="actDesc" class="tw-prose tw-max-w-none tw-prose-slate"></article>
        <section>
          <h2 class="tw-font-semibold tw-mb-2">Variants</h2>
          <div id="actVariants" class="tw-grid tw-grid-cols-1 md:tw-grid-cols-2 tw-gap-2"></div>
        </section>
        <section>
          <h2 class="tw-font-semibold tw-mb-2">Show times</h2>
          <div id="actShows" class="tw-flex tw-flex-wrap tw-gap-2"></div>
        </section>
      </div>
      <aside class="tw-p-4 tw-border-t lg:tw-border-t-0 lg:tw-border-l tw-border-slate-200 tw-space-y-3">
        <h2 class="tw-font-semibold">Book this activity</h2>
        <form id="bookForm" method="post" action="/agent/booking/create/activity" class="tw-space-y-3">
          <input type="hidden" name="csrf_token" value="<?= htmlspecialchars(App\Core\Security::csrfToken()) ?>">
          <input type="hidden" name="package_id" id="f_package_id" value="<?= (int)$activityId ?>">
          <input type="hidden" name="variant_id" id="f_variant_id">
          <input type="hidden" name="price_id" id="f_price_id">

          <div>
            <label class="tw-text-xs tw-text-slate-600">Date</label>
            <input type="date" name="date" class="tw-w-full tw-h-11 tw-rounded-xl tw-border tw-border-slate-300 focus:tw-ring-2 focus:tw-ring-[#1B4F9C] focus:tw-outline-none tw-px-3" required />
          </div>
          <div>
            <label class="tw-text-xs tw-text-slate-600">Pax</label>
            <input type="number" name="pax" min="1" value="1" class="tw-w-full tw-h-11 tw-rounded-xl tw-border tw-border-slate-300 focus:tw-ring-2 focus:tw-ring-[#1B4F9C] focus:tw-outline-none tw-px-3" />
          </div>
          <div>
            <label class="tw-text-xs tw-text-slate-600">Show time</label>
            <select name="show_time" id="f_show_time" class="tw-w-full tw-h-11 tw-rounded-xl tw-border tw-border-slate-300 focus:tw-ring-2 focus:tw-ring-[#1B4F9C] focus:tw-outline-none tw-px-3"></select>
          </div>
          <button type="submit" class="tw-w-full tw-h-11 tw-rounded-xl tw-bg-[#1B4F9C] tw-text-white tw-font-semibold">Create booking</button>
          <div id="formHint" class="tw-text-xs tw-text-slate-600"></div>
        </form>
      </aside>
    </div>
  </div>
</section>

<script>
(function(){
  const ACT_ID = <?= json_encode((int)$activityId) ?>;
  const $title = document.getElementById('actTitle');
  const $sub = document.getElementById('actSub');
  const $desc = document.getElementById('actDesc');
  const $variants = document.getElementById('actVariants');
  const $shows = document.getElementById('actShows');
  const $showSel = document.getElementById('f_show_time');
  const $fVariant = document.getElementById('f_variant_id');
  const $fPrice = document.getElementById('f_price_id');
  const $hint = document.getElementById('formHint');

  function esc(s){ return (s||'').replace(/[&<>]/g, ch=>({"&":"&amp;","<":"&lt;",">":"&gt;"}[ch])); }

  function setLoading(on){
    if(on){ $title.textContent = 'Loading...'; }
  }

  function pickDefaultShow(shows){
    $showSel.innerHTML = '';
    if (!shows || !shows.length){ $showSel.innerHTML = '<option value="">--</option>'; return; }
    for (const s of shows){
      const opt = document.createElement('option');
      opt.value = s.time || s; opt.textContent = s.label || s.time || s;
      $showSel.appendChild(opt);
    }
  }

  function renderVariants(list){
    $variants.innerHTML = '';
    if (!list || !list.length){ $variants.innerHTML = '<div class="tw-text-sm tw-text-slate-600">No variants available.</div>'; return; }
    list.forEach(v => {
      const prices = (v.prices||[]).map(p=>({ id:p.id, label:`${p.pax_type||p.price_type||'Price'} — ${p.currency||''} ${p.agent_price ?? p.customer_price ?? p.price}` }));
      const card = document.createElement('div');
      card.className = 'tw-border tw-border-slate-200 tw-rounded-xl tw-p-3 tw-space-y-2';
      card.innerHTML = `
        <div class="tw-font-semibold">${esc(v.name || 'Variant')}</div>
        <div class="tw-space-y-2">
          ${prices.map(p=>`<label class=\"tw-flex tw-items-center tw-gap-2 tw-text-sm\"><input type=\"radio\" name=\"pricePick\" value=\"${p.id}\" class=\"tw-accent-[#1B4F9C]\"> <span>${esc(p.label)}</span></label>`).join('')}
        </div>
      `;
      card.addEventListener('change', (e)=>{
        if (e.target && e.target.name==='pricePick'){
          $fVariant.value = v.id || '';
          $fPrice.value = e.target.value;
          $hint.textContent = 'Selected: ' + (v.name||'') + ' • price #' + e.target.value;
        }
      });
      $variants.appendChild(card);
    });
  }

  async function load(){
    try{
      setLoading(true);
      const res = await fetch(`/b2b/api/activities/details?id=${encodeURIComponent(ACT_ID)}`, { headers: { 'Accept': 'application/json' } });
      if (!res.ok) throw new Error('Failed to load activity');
      const js = await res.json();
      const d = js.data || js || {};
      $title.textContent = d.name || 'Activity';
      $sub.textContent = [d.city, d.country].filter(Boolean).join(' • ');
      if (d.description_html){ $desc.innerHTML = d.description_html; }
      else if (d.description){ $desc.textContent = d.description; }
      renderVariants(d.variants || d.packages || []);
      pickDefaultShow(d.show_times || d.showtimes || []);
    } catch(e){
      $title.textContent = 'Activity unavailable';
      $desc.innerHTML = '<div class="tw-text-sm tw-text-red-600">' + esc(e.message||'Error') + '</div>';
    }
  }

  load();
})();
</script>
