<?php
// Temporary placeholder for Agent Activities page (Tailwind tw- prefix)
$title = $title ?? 'Activities (Revamp in Progress)';
$q = $q ?? '';
$city = $city ?? '';
?>
<section class="tw-bg-white tw-min-h-[60vh]">
  <div class="tw-max-w-3xl tw-mx-auto tw-px-4 tw-py-14">
    <div class="tw-flex tw-items-center tw-gap-3">
      <a href="/agent" class="tw-inline-flex tw-items-center tw-justify-center tw-w-10 tw-h-10 tw-rounded-xl tw-border tw-border-slate-200 tw-text-slate-600 hover:tw-bg-slate-50" aria-label="Back to dashboard">
        <svg class="tw-w-5 tw-h-5" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true"><path fill-rule="evenodd" d="M15.78 19.28a.75.75 0 01-1.06 0l-6-6a.75.75 0 010-1.06l6-6a.75.75 0 111.06 1.06L10.06 12l5.72 5.72a.75.75 0 010 1.06z" clip-rule="evenodd"/></svg>
      </a>
      <h1 class="tw-text-xl sm:tw-text-2xl tw-font-extrabold tw-text-slate-900"><?= htmlspecialchars($title) ?></h1>
    </div>

    <div class="tw-mt-6 tw-rounded-2xl tw-border tw-border-slate-200 tw-bg-slate-50 tw-p-6">
      <div class="tw-flex tw-items-start tw-gap-3">
        <span class="tw-grid tw-place-items-center tw-w-10 tw-h-10 tw-rounded-xl tw-bg-[#1B4F9C]/10 tw-text-[#1B4F9C]">
          <svg class="tw-w-5 tw-h-5" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true"><path d="M12 2.25A9.75 9.75 0 1 0 21.75 12 9.761 9.761 0 0 0 12 2.25Zm.75 4.5a.75.75 0 1 0-1.5 0v6a.75.75 0 0 0 .379.65l3.75 2.25a.75.75 0 1 0 .742-1.3L12.75 12.3V6.75Z"/></svg>
        </span>
        <div>
          <h2 class="tw-font-semibold tw-text-slate-900">Activities page redesign in progress</h2>
          <p class="tw-text-slate-600 tw-text-sm">We're rebuilding this page with a new design. Please check back soon. You can still use search from the dashboard.</p>
          <?php if ($q || $city): ?>
            <p class="tw-text-xs tw-text-slate-500 tw-mt-2">Your last query was kept for reference: <span class="tw-font-semibold">q</span> = "<?= htmlspecialchars($q) ?>", <span class="tw-font-semibold">city</span> = "<?= htmlspecialchars($city) ?>"</p>
          <?php endif; ?>
        </div>
      </div>

      <div class="tw-mt-6 tw-flex tw-flex-col sm:tw-flex-row tw-gap-3">
        <a href="/agent" class="tw-inline-flex tw-items-center tw-justify-center tw-h-11 tw-px-5 tw-rounded-xl tw-bg-[#1B4F9C] tw-text-white">Go to Dashboard</a>
        <a href="/agent/bookings" class="tw-inline-flex tw-items-center tw-justify-center tw-h-11 tw-px-5 tw-rounded-xl tw-border tw-border-slate-200 tw-bg-white tw-text-slate-700">View Bookings</a>
      </div>
    </div>

    <p class="tw-text-xs tw-text-slate-500 tw-mt-6">If you need this page earlier, share the new design and we will implement it.</p>
  </div>
</section>
