<?php
// app/Views/agent/activities_list_v1.php
// Activities List v1 — hotel-list prototype styling (unprefixed Tailwind) with Activities data
$q = isset($q) ? (string)$q : (string)($_GET['q'] ?? '');
$city = isset($city) ? (string)$city : (string)($_GET['city'] ?? '');
?>

<!-- Local Tailwind (unprefixed) and Flatpickr only for this view -->
<script>window.tailwind=window.tailwind||{};tailwind.config={theme:{extend:{colors:{brand:{DEFAULT:'#003580',600:'#00285F'}}}}};</script>
<script src="https://cdn.tailwindcss.com"></script>

<div class="min-h-screen">
  <!-- Top bar: Title and Back -->
  <div class="max-w-7xl mx-auto px-4 pt-4 pb-2">
    <div class="flex items-center justify-between">
      <h1 class="text-lg font-semibold m-0">Activities</h1>
      <a href="/agent" class="inline-flex items-center gap-1 rounded-lg border border-slate-300 text-slate-700 hover:bg-slate-50 px-3 py-1 text-sm">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-4 h-4"><path fill-rule="evenodd" d="M10.03 3.97a.75.75 0 010 1.06L5.81 9.25H21a.75.75 0 010 1.5H5.81l4.22 4.22a.75.75 0 11-1.06 1.06l-5.5-5.5a.75.75 0 010-1.06l5.5-5.5a.75.75 0 011.06 0z" clip-rule="evenodd"/></svg>
        Back
      </a>
    </div>
  </div>

  <!-- Search bar -->
  <section class="bg-gradient-to-b from-[#F5F8FF] to-white">
    <div class="max-w-7xl mx-auto px-4 py-6 md:py-8">
      <div class="relative z-10 bg-white shadow-xl ring-1 ring-slate-200 rounded-2xl px-3 py-3 md:px-4 md:py-4">
        <form id="actSearch" class="grid md:grid-cols-4 gap-2 md:gap-3 items-end">
          <div class="md:col-span-3">
            <label class="text-xs text-slate-600">Activity / City</label>
            <div class="relative">
              <input id="q" name="q" value="<?= htmlspecialchars($q ?: ($city? ($q?"$q, $city":$city) : '')) ?>" class="w-full pr-9 rounded-full h-11 border border-slate-200 px-4 focus:ring-2 focus:ring-blue-600/20 focus:outline-none" placeholder="Alcazar Show, Pattaya" />
              <span class="pointer-events-none absolute inset-y-0 right-3 flex items-center text-slate-400">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-5 h-5"><path fill-rule="evenodd" d="M10.5 3.75a6.75 6.75 0 104.243 12.03l3.238 3.239a.75.75 0 101.06-1.061l-3.238-3.238A6.75 6.75 0 0010.5 3.75zm0 1.5a5.25 5.25 0 110 10.5 5.25 5.25 0 010-10.5z" clip-rule="evenodd"/></svg>
              </span>
              <input type="hidden" id="city" name="city" value="<?= htmlspecialchars($city) ?>" />
              <!-- Suggestions dropdown -->
              <div id="suggest" class="absolute left-0 right-0 mt-1 bg-white border border-slate-200 rounded-xl shadow-lg overflow-hidden hidden z-20"></div>
            </div>
          </div>
          <div class="flex items-end">
            <button type="submit" class="inline-flex items-center justify-center w-full rounded-full h-11 px-6 bg-blue-900 hover:bg-blue-800 text-white font-semibold">Search</button>
          </div>
        </form>
      </div>
    </div>
  </section>

  <!-- Content -->
  <main class="max-w-7xl mx-auto px-4 py-6">
    <div class="flex items-center justify-between gap-3 mb-4">
      <p id="meta" class="text-sm text-slate-600">&nbsp;</p>
      <div class="text-sm" id="pagerTop"></div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-12 gap-6">
      <!-- Sidebar filters -->
      <aside class="lg:col-span-4 xl:col-span-3">
        <div class="bg-white shadow ring-1 ring-slate-200 rounded-2xl p-4">
          <div class="mb-4">
            <h3 class="font-semibold">Filters</h3>
          </div>
          <div class="md:hidden">
            <button id="mobileShowFilters" class="btn btn-outline w-full border border-slate-300 rounded-lg py-2">Filters</button>
          </div>
          <div id="mobileAdvancedFilters" class="hidden md:block">
            <div class="border-t pt-4 mt-4">
              <h3 class="font-semibold">Activity Type</h3>
              <div class="mt-2 flex flex-wrap gap-2 text-sm" id="typeFilters">
                <button type="button" data-type="" class="px-3 py-1 rounded-full border border-slate-200 bg-slate-50">Any</button>
                <button type="button" data-type="family" class="px-3 py-1 rounded-full border border-slate-200 bg-slate-50">Family</button>
                <button type="button" data-type="adult_only" class="px-3 py-1 rounded-full border border-slate-200 bg-slate-50">Only Adult</button>
              </div>
            </div>
            <div class="border-t pt-4 mt-4">
              <div class="flex items-center justify-between">
                <h3 class="font-semibold">Cities</h3>
                <a href="#" id="clearCity" class="text-xs text-blue-700">Clear</a>
              </div>
              <div id="cityList" class="mt-2 grid grid-cols-2 gap-2 text-sm max-h-64 overflow-auto pr-1"></div>
            </div>
          </div>
        </div>
      </aside>

      <!-- Results -->
      <section class="lg:col-span-8 xl:col-span-9 space-y-4">
        <div id="list" class="space-y-4"></div>
        <div class="flex items-center justify-center gap-2 pt-2" id="pagerBottom"></div>
      </section>
    </div>
  </main>
</div>

<!-- Loading overlay -->
<div id="loadingOverlay" class="fixed inset-0 bg-white/70 backdrop-blur-sm z-40" aria-live="polite" aria-busy="true">
  <div class="absolute inset-0 flex items-center justify-center">
    <div class="flex flex-col items-center gap-3 text-slate-700">
      <svg class="animate-spin h-8 w-8 text-blue-900" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" aria-hidden="true">
        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z"></path>
      </svg>
      <div class="text-sm font-medium">Fetching activities…</div>
    </div>
  </div>
  <span class="sr-only">Loading</span>
</div>

<script>
(function(){
  const form = document.getElementById('actSearch');
  const inputQ = document.getElementById('q');
  const inputCity = document.getElementById('city');
  const list = document.getElementById('list');
  const meta = document.getElementById('meta');
  const pagerTop = document.getElementById('pagerTop');
  const pagerBottom = document.getElementById('pagerBottom');
  const mobileBtn = document.getElementById('mobileShowFilters');
  const mobilePanel = document.getElementById('mobileAdvancedFilters');
  const suggestBox = document.getElementById('suggest');
  const typeWrap = document.getElementById('typeFilters');
  const cityList = document.getElementById('cityList');
  const clearCity = document.getElementById('clearCity');

  let allItems = []; let page = 1; const pageSize = 20;
  let selectedType = (new URLSearchParams(location.search)).get('type') || '';
  let currentCtrl = null; // AbortController for fetch cancellation

  function debounce(fn, wait){
    let t; return function(){ const ctx=this, args=arguments; clearTimeout(t); t=setTimeout(()=>fn.apply(ctx,args), wait); };
  }

  function highlightFilters(){
    if (typeWrap){
      typeWrap.querySelectorAll('button[data-type]').forEach(btn=>{
        const on = btn.getAttribute('data-type') === selectedType;
        btn.classList.toggle('bg-blue-900', on);
        btn.classList.toggle('text-white', on);
        btn.classList.toggle('border-blue-900', on);
        btn.classList.toggle('bg-slate-50', !on);
        btn.classList.toggle('text-slate-800', !on);
        btn.classList.toggle('border-slate-200', !on);
      });
    }
    if (cityList){
      const cval = (inputCity.value||'').trim();
      cityList.querySelectorAll('button[data-city]').forEach(btn=>{
        const on = btn.getAttribute('data-city')===cval;
        btn.classList.toggle('bg-blue-100', on);
        btn.classList.toggle('border-blue-300', on);
      });
    }
  }

  async function loadCities(){
    if (!cityList) return;
    try{
      const res = await fetch('/b2b/api/activities/cities?country=Thailand', { headers: { 'Accept':'application/json' } });
      const js = await res.json();
      const arr = Array.isArray(js.data) ? js.data : [];
      cityList.innerHTML = arr.map(r=>`<button type="button" data-city="${r.city}" class="px-3 py-1 rounded-full border border-slate-200 bg-white hover:bg-slate-50">${r.city}</button>`).join('');
      cityList.addEventListener('click', function(ev){
        const b = ev.target.closest('button[data-city]'); if (!b) return;
        const c = b.getAttribute('data-city');
        inputCity.value = c; inputQ.value = c;
        highlightFilters(); search();
      });
      highlightFilters();
    }catch(e){ /* silent */ }
  }

  async function loadSuggestions(q){
    if (!q || q.trim().length < 2) { suggestBox.classList.add('hidden'); suggestBox.innerHTML=''; return; }
    try{
      const res = await fetch(`/b2b/api/activities/suggest?q=${encodeURIComponent(q)}&country=Thailand`, { headers: { 'Accept':'application/json' } });
      const js = await res.json();
      const items = (js.data||[]).filter(x=>x.type==='city');
      if (!items.length) { suggestBox.classList.add('hidden'); suggestBox.innerHTML=''; return; }
      suggestBox.innerHTML = items.map(it=>`<button type="button" data-city="${it.city}" class="w-full text-left px-4 py-2 hover:bg-slate-50">${it.city}</button>`).join('');
      suggestBox.classList.remove('hidden');
    }catch(e){ suggestBox.classList.add('hidden'); suggestBox.innerHTML=''; }
  }

  function skeleton(){
    return '<div class="animate-pulse space-y-2"><div class="h-4 w-1/2 bg-slate-200 rounded"></div><div class="h-3 w-3/4 bg-slate-200 rounded"></div><div class="h-3 w-1/4 bg-slate-200 rounded"></div></div>';
  }

  function priceNum(x){ return Number(x||0); }

  function renderPager(total){
    const pages = Math.max(1, Math.ceil(total / pageSize));
    if (page > pages) page = pages;
    const cls = 'inline-flex items-center justify-center rounded-lg border border-slate-300 bg-white hover:bg-slate-50 text-slate-700 px-2.5 py-1 text-sm';
    const active = 'bg-blue-700 text-white border-blue-700 hover:bg-blue-800';
    const dis = 'opacity-50 pointer-events-none';
    const toLink = (p) => `<a href="#" data-page="${p}" class="page-link ${cls} ${p===page?active:''}">${p}</a>`;
    const parts = [];
    parts.push(`<a href="#" data-page="${page-1}" class="page-link ${cls} ${page<=1?dis:''}">Prev</a>`);
    for (let p=1;p<=pages;p++){
      if (p===1||p===pages||Math.abs(p-page)<=2) parts.push(toLink(p));
      else if (Math.abs(p-page)===3) parts.push(`<span class="${cls}">…</span>`);
    }
    parts.push(`<a href="#" data-page="${page+1}" class="page-link ${cls} ${page>=pages?dis:''}">Next</a>`);
    const html = parts.join(' ');
    pagerTop.innerHTML = html; pagerBottom.innerHTML = html;
    [pagerTop, pagerBottom].forEach(el => el.querySelectorAll('a.page-link').forEach(a => a.addEventListener('click', (ev)=>{
      ev.preventDefault(); const p = Number(a.getAttribute('data-page')); if (!Number.isNaN(p) && p>=1){ page=p; draw(); window.scrollTo({top:0,behavior:'smooth'}); }
    })));
  }

  function cardHtml(a){
    const currency = a.currency || 'THB';
    const amount = priceNum(a.from_price).toFixed(2);
    const priceHtml = (currency === 'THB')
      ? `<span class=\"font-semibold\" title=\"Thai Baht\">฿</span> ${amount}`
      : `${currency} ${amount}`;
    const tags = a.tags && a.tags.length ? a.tags.slice(0,3) : [];
    return `
      <article class="bg-white shadow-sm ring-1 ring-slate-100 rounded-2xl p-3 transition hover:shadow-md">
        <div class="grid sm:grid-cols-12 gap-3">
          <div class="sm:col-span-3">
            <div class="w-full h-24 bg-slate-100 rounded-xl overflow-hidden">
              ${a.thumbnail ? `<img class=\"w-full h-full object-cover\" src=\"${a.thumbnail}\" alt=\"${a.name}\" loading=\"lazy\"/>` : ''}
            </div>
          </div>
          <div class="sm:col-span-6 p-2">
            <h3 class="font-semibold">${a.name}</h3>
            <div class="mt-1 text-sm text-slate-600">${a.subtitle || 'Popular experience'}</div>
            ${a.city ? `
            <div class=\"mt-1 text-xs text-slate-500 flex items-center gap-1\">
              <svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"currentColor\" class=\"w-4 h-4 text-slate-400\"><path fill-rule=\"evenodd\" d=\"M11.54 22.35a.75.75 0 00.92 0c1.106-.866 6.79-5.476 6.79-11.1a7.25 7.25 0 10-14.5 0c0 5.624 5.684 10.234 6.79 11.1zM12 12.5a2.5 2.5 0 100-5 2.5 2.5 0 000 5z\" clip-rule=\"evenodd\"/></svg>
              <span>${a.city}</span>
            </div>` : ''}
            ${ (a.show_time || a.showtime || (a.times && a.times.length)) ? `
            <div class=\"mt-1 text-xs text-slate-600\"><span class=\"font-medium\">Show time:</span> ${a.show_time || a.showtime || (Array.isArray(a.times)? a.times.join(', '): '')}</div>` : ''}
          </div>
          <div class="sm:col-span-3 p-2 flex flex-col justify-between items-stretch sm:items-end sm:border-l border-slate-100 sm:pl-4 gap-2">
            <div class="text-left sm:text-right">
              <div class="text-slate-500 text-xs">Starting from</div>
              <div class="text-2xl font-extrabold">${priceHtml}</div>
              <div class="text-slate-500 text-[11px]">per person</div>
            </div>
            <button type="button" class="inline-flex items-center justify-center gap-2 rounded-full bg-blue-900 hover:bg-blue-800 text-white px-5 py-2 text-sm shadow-sm w-full sm:w-auto" data-id="${a.id}">
              <span>Select Package</span>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4"><path stroke-linecap="round" stroke-linejoin="round" d="M8.25 4.5l7.5 7.5-7.5 7.5" /></svg>
            </button>
          </div>
        </div>
      </article>`;
  }

  function draw(){
    const total = allItems.length;
    const start = (page-1)*pageSize; const slice = allItems.slice(start, start+pageSize);
    meta.textContent = `${total} activit${total===1?'y':'ies'} found`;
    if (!slice.length){ list.innerHTML = '<div class="text-slate-500 text-sm">No activities found. Try different filters.</div>'; renderPager(total); return; }
    list.innerHTML = slice.map(cardHtml).join('');
    renderPager(total);
  }

  const overlay = document.getElementById('loadingOverlay');
  function setLoading(on){ if (!overlay) return; overlay.classList.toggle('hidden', !on); }

  async function search(){
    const typed = (inputQ.value||'').trim();
    const city = (inputCity.value||'').trim();
    list.innerHTML = skeleton(); meta.textContent = 'Searching…'; page = 1;
    setLoading(true);

    async function fetchOnce(sp){
      if (currentCtrl) { try { currentCtrl.abort(); } catch(_){} }
      currentCtrl = new AbortController();
      const res = await fetch(`/b2b/api/activities/search?${sp.toString()}`, { headers: { 'Accept':'application/json' }, signal: currentCtrl.signal });
      return res.json();
    }

    try{
      // 1) Try as CITY search first (typed -> city)
      let used = 'city';
      let p1 = new URLSearchParams();
      if (typed) p1.set('city', typed);
      if (city) p1.set('city', city); // explicit hidden city overrides
      if (selectedType) p1.set('type', selectedType);
      let json = await fetchOnce(p1);
      let data = Array.isArray(json.data) ? json.data : [];
      console.debug('[activities] city search URL', `/b2b/api/activities/search?${p1.toString()}`, 'count', data.length);
      if (!data.length && typed){
        // 2) Fallback to Q search (name/vendor)
        used = 'q';
        let p2 = new URLSearchParams();
        p2.set('q', typed);
        if (city) p2.set('city', city);
        if (selectedType) p2.set('type', selectedType);
        json = await fetchOnce(p2);
        data = Array.isArray(json.data) ? json.data : [];
        meta.textContent = data.length ? `${data.length} activities found (matched by name/vendor)` : 'No activities found';
        console.debug('[activities] q search URL', `/b2b/api/activities/search?${p2.toString()}`, 'count', data.length);
        // set URL based on q mode
        const newUrl = `/agent/activities?${p2.toString()}`;
        if (newUrl !== window.location.pathname + window.location.search){ window.history.replaceState(null, '', newUrl); }
      } else {
        // set URL based on city mode
        const newUrl = `/agent/activities${p1.toString()?('?' + p1.toString()):''}`;
        if (newUrl !== window.location.pathname + window.location.search){ window.history.replaceState(null, '', newUrl); }
      }
      allItems = data; draw();
    }catch(e){ if (e.name === 'AbortError') return; meta.textContent = ''; list.innerHTML = '<div class="text-red-600 text-sm">Failed to load activities.</div>'; }
    finally { setLoading(false); }
  }

  form.addEventListener('submit', function(ev){ ev.preventDefault(); search(); });
  // Live search as user types (starts from 2 chars)
  inputQ.addEventListener('input', debounce(function(){
    const val = (this.value||'').trim();
    loadSuggestions(val);
    if (val.length >= 2 || val === '') { search(); }
  }, 300));
  // Suggestions click
  suggestBox.addEventListener('click', function(e){
    const btn = e.target.closest('button[data-city]'); if (!btn) return;
    const c = btn.getAttribute('data-city');
    inputQ.value = c; inputCity.value = c;
    suggestBox.classList.add('hidden'); suggestBox.innerHTML='';
    search();
  });
  // Activity Type click
  if (typeWrap){
    typeWrap.addEventListener('click', function(ev){
      const b = ev.target.closest('button[data-type]'); if (!b) return;
      selectedType = b.getAttribute('data-type') || '';
      highlightFilters();
      search();
    });
  }
  // Clear city
  if (clearCity){ clearCity.addEventListener('click', function(ev){ ev.preventDefault(); inputCity.value=''; inputQ.value=''; highlightFilters(); search(); }); }
  document.addEventListener('click', function(ev){
    const btn = ev.target.closest('button[data-id]'); if (!btn) return;
    const id = btn.getAttribute('data-id'); if (id) window.location.href = '/agent/activities/detail?id=' + encodeURIComponent(id);
  });

  // Mobile filters toggle
  if (mobileBtn && mobilePanel){ mobileBtn.addEventListener('click', ()=>{ mobilePanel.classList.toggle('hidden'); }); }

  // Initial load
  loadCities(); highlightFilters(); search();
})();
</script>
