<?php
// app/Views/partials/agent_top_nav.php
$reqPath = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH) ?? '/';
$active = function (string $path) use ($reqPath) {
  return ($reqPath === $path) || str_starts_with($reqPath, $path . '/');
};
?>
<ul class="navbar-nav me-auto mb-2 mb-lg-0 align-items-center gap-2 gap-lg-3">
  <li class="nav-item">
    <a class="nav-link <?php echo $active('/agent') && $reqPath === '/agent' ? 'active' : ''; ?>" href="/agent">
      <i class="bi bi-speedometer2 me-1"></i> Dashboard
    </a>
  </li>
  <li class="nav-item">
    <a class="nav-link <?php echo $active('/agent/wallet') ? 'active' : ''; ?>" href="/agent/wallet">
      <i class="bi bi-wallet2 me-1"></i> Wallet
    </a>
  </li>
  <li class="nav-item">
    <a class="nav-link <?php echo $active('/agent/bookings') ? 'active' : ''; ?>" href="/agent/bookings">
      <i class="bi bi-journal-text me-1"></i> Bookings
    </a>
  </li>
  <li class="nav-item">
    <a class="nav-link <?php echo $active('/agent/orders') ? 'active' : ''; ?>" href="/agent/orders">
      <i class="bi bi-receipt me-1"></i> Orders
    </a>
  </li>
  <li class="nav-item">
    <a class="nav-link <?php echo $active('/agent/support') ? 'active' : ''; ?>" href="/agent/support">
      <i class="bi bi-life-preserver me-1"></i> Support
    </a>
  </li>
</ul>
