<?php
// app/Views/layouts/main.php
$title = $title ?? 'B2B Travel';
$csrf = App\Core\Security::csrfToken();
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title) ?> - B2B Travel</title>
  <base href="<?= rtrim(APP_URL, '/') ?>/">
  <meta name="theme-color" content="#0b3d91" />
  <!-- Inline SVG favicon to avoid 404 and keep branding local -->
  <link rel="icon" href="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 64 64'%3E%3Crect width='64' height='64' rx='12' fill='%230b3d91'/%3E%3Cpath fill='%23fff' d='M18 42l8-20h4l8 20h-4l-1.8-5H23.8L22 42h-4zm7.8-9h10.4L31 21.8 25.8 33z'/%3E%3C/svg%3E" />
  <?php
    $rootPath = dirname(__DIR__, 3); // project root
    $iconsCssFs = $rootPath . '/public/assets/vendor/bootstrap-icons/bootstrap-icons.css';
  ?>
  <link href="/assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <!-- Removed Google Fonts to avoid external dependency -->
  <?php if (file_exists($iconsCssFs)): ?>
  <link href="/assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <?php else: ?>
  <!-- Fallback to CDN for Bootstrap Icons when local copy is unavailable -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet" integrity="sha384-2n1Zl8gT2w9R6Lr9mU9c7YQ0yG3mX8r3fAQc3r1mN3nY5z9qk9qkJ7u3mYV1mW9g" crossorigin="anonymous">
  <?php endif; ?>
  <link href="/assets/css/booking.css" rel="stylesheet">
  <script>window.CSRF_TOKEN='<?= $csrf ?>';</script>
</head>
<body>
<?php 
  $reqPath = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH) ?? '/';
  $role = $_SESSION['user']['role'] ?? '';
  $isAdminUser = ($role === 'Admin');
  $isAgentUser = ($role === 'B2B Agent');
  $isAdminPage = str_starts_with($reqPath, '/admin');
  $isAgentPage = str_starts_with($reqPath, '/agent') || str_starts_with($reqPath, '/b2b');
  // Show full header on admin pages (enable top menu)
  $blankAdmin = false; 
  // Toggle admin sidebar visibility (off)
  $showAdminSidebar = false;
?>
<nav class="navbar navbar-expand-lg navbar-dark sticky-top shadow-sm">
  <div class="container-xxl">
    <a class="navbar-brand fw-bold brand" href="/"><i class="bi bi-compass me-1"></i> b2btravel</a>
    <?php if (($isAdminPage ?? false) && !$blankAdmin && $showAdminSidebar): ?>
      <button class="btn btn-light ms-2 d-lg-none" type="button" data-bs-toggle="offcanvas" data-bs-target="#adminSidebar" aria-controls="adminSidebar">
        <i class="bi bi-list"></i> Menu
      </button>
    <?php endif; ?>
    <?php if (!$blankAdmin): ?>
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav" aria-controls="nav" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>
      <div class="collapse navbar-collapse" id="nav">
        <?php if ($isAdminUser && $isAdminPage): ?>
          <?php 
            // Build and render admin top menu using classes for easy future edits
            $items = \App\Core\Menu\AdminMenu::items();
            $reqPath = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH) ?? '/';
            include __DIR__ . '/../partials/admin_top_nav.php';
          ?>
        <?php elseif ($isAgentUser && $isAgentPage): ?>
          <?php 
            // Render agent top nav
            include __DIR__ . '/../partials/agent_top_nav.php';
          ?>
        <?php else: ?>
          <ul class="navbar-nav me-auto mb-2 mb-lg-0 align-items-center gap-2 gap-lg-3">
            <li class="nav-item"><a class="nav-link" href="/hotels">Hotels</a></li>
            <li class="nav-item"><a class="nav-link" href="/users">Users</a></li>
            <?php if ($isAdminUser && !$isAdminPage): ?>
              <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" href="#" id="adminMenu" role="button" data-bs-toggle="dropdown" aria-expanded="false"><i class="bi bi-speedometer2 me-1"></i> Admin</a>
                <ul class="dropdown-menu" aria-labelledby="adminMenu">
                  <li><a class="dropdown-item" href="/admin">Dashboard</a></li>
                  <li><hr class="dropdown-divider"></li>
                  <li><a class="dropdown-item" href="/admin/wallet/manual">Wallet Manual Entry</a></li>
                  <li><a class="dropdown-item" href="/admin/wallet/ledger">Wallet Ledger</a></li>
                  <li><hr class="dropdown-divider"></li>
                  <li><a class="dropdown-item" href="/admin/promos">Promo Codes</a></li>
                  <li><a class="dropdown-item" href="/admin/corporates">Corporate Accounts</a></li>
                </ul>
              </li>
            <?php endif; ?>
          </ul>
        <?php endif; ?>
        <ul class="navbar-nav ms-auto align-items-center">
          <?php if (!empty($_SESSION['user'])): ?>
            <li class="nav-item dropdown">
              <a href="#" class="nav-link dropdown-toggle d-flex align-items-center gap-2" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                <span class="avatar bg-light d-inline-flex align-items-center justify-content-center rounded-circle" style="width:28px;height:28px;">
                  <i class="bi bi-person-fill"></i>
                </span>
              </a>
              <ul class="dropdown-menu dropdown-menu-end shadow">
                <li class="px-3 py-2">
                  <div class="fw-semibold mb-0"><?= htmlspecialchars($_SESSION['user']['name']) ?></div>
                  <div class="small text-muted text-uppercase"><?= htmlspecialchars($_SESSION['user']['role']) ?></div>
                </li>
                <li><hr class="dropdown-divider"></li>
                <li><a class="dropdown-item" href="/admin"><i class="bi bi-speedometer2 me-2"></i>Dashboard</a></li>
                <li><a class="dropdown-item text-danger" href="/logout"><i class="bi bi-box-arrow-right me-2"></i>Sign out</a></li>
              </ul>
            </li>
          <?php else: ?>
            <li class="nav-item"><a class="btn btn-primary btn-sm" href="/login/select"><i class="bi bi-person-circle me-1"></i> Login</a></li>
          <?php endif; ?>
        </ul>
      </div>
    <?php endif; ?>
  </div>
</nav>
<?php if ($isAdminUser && $isAdminPage && !$blankAdmin && $showAdminSidebar): ?>
  <!-- Mobile Offcanvas Sidebar -->
  <div class="offcanvas offcanvas-start d-lg-none" tabindex="-1" id="adminSidebar" aria-labelledby="adminSidebarLabel">
    <div class="offcanvas-header">
      <h5 class="offcanvas-title" id="adminSidebarLabel">Admin Menu</h5>
      <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
      <div class="list-group list-group-flush">
        <?php $isActive = fn(string $path) => $reqPath === $path || (str_starts_with($reqPath, $path.'/')); ?>
        <a href="/admin" class="list-group-item list-group-item-action d-flex align-items-center <?php echo $isActive('/admin') && $reqPath === '/admin' ? 'active' : ''; ?>" <?php echo ($isActive('/admin') && $reqPath === '/admin') ? 'aria-current="page"' : ''; ?>><i class="bi bi-speedometer2 me-2"></i> Dashboard</a>
        <div class="list-group-item small text-uppercase text-muted fw-bold">Wallet</div>
        <a href="/admin/wallet/manual" class="list-group-item list-group-item-action <?php echo $isActive('/admin/wallet/manual') ? 'active' : ''; ?>" <?php echo $isActive('/admin/wallet/manual') ? 'aria-current="page"' : ''; ?>><i class="bi bi-plus-circle me-2"></i> Manual Entry</a>
        <a href="/admin/wallet/ledger" class="list-group-item list-group-item-action <?php echo $isActive('/admin/wallet/ledger') ? 'active' : ''; ?>" <?php echo $isActive('/admin/wallet/ledger') ? 'aria-current="page"' : ''; ?>><i class="bi bi-journal-text me-2"></i> Ledger</a>
        <div class="list-group-item small text-uppercase text-muted fw-bold">Marketing</div>
        <a href="/admin/promos" class="list-group-item list-group-item-action <?php echo $isActive('/admin/promos') ? 'active' : ''; ?>" <?php echo $isActive('/admin/promos') ? 'aria-current="page"' : ''; ?>><i class="bi bi-tag me-2"></i> Promo Codes</a>
        <a href="/admin/corporates" class="list-group-item list-group-item-action <?php echo $isActive('/admin/corporates') ? 'active' : ''; ?>" <?php echo $isActive('/admin/corporates') ? 'aria-current="page"' : ''; ?>><i class="bi bi-briefcase me-2"></i> Corporate Accounts</a>
        <div class="list-group-item small text-uppercase text-muted fw-bold">Users</div>
        <a href="/users" class="list-group-item list-group-item-action <?php echo $isActive('/users') ? 'active' : ''; ?>" <?php echo $isActive('/users') ? 'aria-current="page"' : ''; ?>><i class="bi bi-people me-2"></i> Users</a>
      </div>
    </div>
  </div>
<?php endif; ?>
<?php if ($blankAdmin): ?>
  <main class="container-fluid my-4 admin-container"></main>
<?php else: ?>
  <main class="<?php echo ($isAdminPage ?? false) ? 'container-fluid' : 'container-xxl'; ?> my-4 admin-container">
    <?php if (!empty($_SESSION['flash'])): ?>
      <div class="alert alert-warning shadow-sm border-0 py-2"><?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
    <?php endif; ?>
    <div class="row g-4">
      <?php if ($isAdminUser && $isAdminPage && $showAdminSidebar): ?>
        <aside class="col-12 col-lg-3 col-xl-2 col-sidebar d-none d-lg-block"></aside>
      <?php endif; ?>
      <section class="<?php echo ($isAdminUser && $isAdminPage && $showAdminSidebar) ? 'col-12 col-lg-9 col-xl-10' : 'col-12'; ?>">
        <div class="card card-elevated">
          <div class="card-body">
            <?php include $templatePath; ?>
          </div>
        </div>
      </section>
    </div>
  </main>
<?php endif; ?>
<footer class="border-top py-4 mt-5 bg-white">
  <div class="container d-flex justify-content-between">
    <div> <?= date('Y') ?> B2B Travel</div>
    <div>
      <a href="#" class="me-3">Support</a>
      <a href="#" class="me-3">Terms</a>
      <a href="#">Privacy</a>
    </div>
  </div>
</footer>
<?php
  $jqueryWeb = '/assets/vendor/jquery/jquery-3.7.1.min.js';
  $jqueryFs  = $rootPath . '/public' . $jqueryWeb;
?>
<script src="/assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<?php if (file_exists($jqueryFs)): ?>
<script src="<?= $jqueryWeb ?>"></script>
<?php endif; ?>
<?php
  // Avoid loading app.js (which depends on jQuery) on partners list page
  $currentPath = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH) ?? '/';
  if ($currentPath !== '/admin/management/partners'):
?>
<script src="/assets/js/app.js"></script>
<?php endif; ?>
</body>
</html>
