<?php
// app/Views/agent/support.php
?>
<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <h1 class="h5 mb-0">Support</h1>
    <a href="/agent" class="btn btn-sm btn-outline-secondary">Dashboard</a>
  </div>

  <div class="row g-3">
    <div class="col-12 col-lg-7">
      <div class="card shadow-sm">
        <div class="card-header bg-white"><strong>Contact Support</strong></div>
        <div class="card-body">
          <form method="post" action="/b2b/support/ticket">
            <input type="hidden" name="_token" value="<?= App\Core\Security::csrfToken(); ?>">
            <div class="mb-3">
              <label class="form-label">Subject</label>
              <input type="text" class="form-control" name="subject" placeholder="Short subject" required>
            </div>
            <div class="mb-3">
              <label class="form-label">Message</label>
              <textarea class="form-control" name="message" rows="5" placeholder="Describe your issue or question" required></textarea>
            </div>
            <div class="d-flex justify-content-between align-items-center">
              <div class="small text-muted">Avg reply time: within 24h</div>
              <button class="btn btn-primary"><i class="bi bi-send me-1"></i> Send</button>
            </div>
          </form>
        </div>
      </div>
    </div>
    <div class="col-12 col-lg-5">
      <div class="card shadow-sm h-100">
        <div class="card-header bg-white"><strong>Help & Resources</strong></div>
        <div class="list-group list-group-flush">
          <a href="#" class="list-group-item list-group-item-action"><i class="bi bi-book me-2"></i>Booking guide</a>
          <a href="#" class="list-group-item list-group-item-action"><i class="bi bi-shield-lock me-2"></i>Wallet & payments</a>
          <a href="#" class="list-group-item list-group-item-action"><i class="bi bi-people me-2"></i>Agent FAQs</a>
        </div>
        <div class="card-body">
          <div class="small text-muted">Hotline</div>
          <div class="fw-semibold">+66-2-123-4567</div>
          <div class="small text-muted mt-2">Email</div>
          <div class="fw-semibold">support@b3bthaihub.com</div>
        </div>
      </div>
    </div>
  </div>
</div>
