<?php
// app/Views/agent/orders.php
?>
<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <h1 class="h5 mb-0">My Orders</h1>
    <a href="/agent" class="btn btn-sm btn-outline-secondary">Dashboard</a>
  </div>

  <div class="card shadow-sm">
    <div class="card-header bg-white d-flex align-items-center justify-content-between">
      <div><strong>Recent Orders</strong> <span class="text-muted small">(latest 100)</span></div>
      <div class="small text-muted">Total: <?php echo isset($orders) ? count($orders) : 0; ?></div>
    </div>
    <div class="table-responsive">
      <table class="table align-middle mb-0">
        <thead>
          <tr>
            <th>ID</th>
            <th>Module</th>
            <th>PAX</th>
            <th>Total</th>
            <th>Status</th>
            <th>Created</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
        <?php if (!empty($orders)): foreach ($orders as $o): ?>
          <tr>
            <td><a href="/agent/orders/view?id=<?php echo (int)$o['id']; ?>">#<?php echo (int)$o['id']; ?></a></td>
            <td class="text-capitalize"><?php echo htmlspecialchars($o['module']); ?></td>
            <td><?php echo (int)$o['pax']; ?></td>
            <td><strong><?php echo number_format((float)$o['price'], 2); ?></strong> THB</td>
            <td>
              <?php $s=(string)$o['status']; $badge=$s==='confirmed'||$s==='completed'||$s==='paid'?'bg-success':($s==='pending'?'bg-warning text-dark':($s==='cancelled'?'bg-danger':'bg-secondary')); ?>
              <span class="badge <?php echo $badge; ?>"><?php echo htmlspecialchars($s); ?></span>
            </td>
            <td class="text-nowrap">&nbsp;<?php echo htmlspecialchars($o['created_at'] ?? ''); ?></td>
            <td class="text-end"><a class="btn btn-sm btn-outline-primary" href="/agent/orders/view?id=<?php echo (int)$o['id']; ?>">View</a></td>
          </tr>
        <?php endforeach; else: ?>
          <tr>
            <td colspan="7" class="py-5">
              <div class="text-center">
                <div class="mb-2 fw-semibold">No orders yet</div>
                <div class="text-muted small mb-3">Orders appear after a booking is confirmed/paid/completed.</div>
                <div class="d-flex gap-2 justify-content-center">
                  <a href="/agent/bookings" class="btn btn-sm btn-primary">Go to Bookings</a>
                  <a href="/agent/wallet" class="btn btn-sm btn-outline-secondary">View Wallet</a>
                </div>
              </div>
            </td>
          </tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
