<?php
/** @var array $booking */
/** @var array|null $item */
/** @var int|null $orderId */
/** @var array|null $variant */
/** @var array|null $priceRow */
/** @var float $unitPrice */
/** @var array $breakdown */
?>
<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <h1 class="h5 mb-0">Booking #<?php echo (int)$booking['id']; ?></h1>
    <div class="d-flex gap-2">
      <a href="/agent/bookings" class="btn btn-sm btn-outline-secondary"><i class="bi bi-arrow-left"></i> Back to Bookings</a>
      <?php if (($booking['status'] ?? '') === 'pending'): ?>
        <a href="/agent/booking/pay?id=<?php echo (int)$booking['id']; ?>" class="btn btn-sm btn-primary"><i class="bi bi-credit-card"></i> Pay via Wallet</a>
      <?php endif; ?>
    </div>
  </div>

  <div class="row g-3">
    <div class="col-md-7">
      <div class="card shadow-sm">
        <div class="card-header bg-white">
          <strong>Item Details</strong>
        </div>
        <div class="card-body">
          <div class="d-flex gap-3">
            <?php if (!empty($item['thumbnail_path'])): ?>
              <img src="<?php echo htmlspecialchars($item['thumbnail_path']); ?>" alt="thumb" class="rounded" style="width:120px;height:90px;object-fit:cover;">
            <?php else: ?>
              <div class="bg-light border rounded d-flex align-items-center justify-content-center" style="width:120px;height:90px;">
                <i class="bi bi-image text-muted"></i>
              </div>
            <?php endif; ?>
            <div>
              <div class="text-capitalize text-muted">Module: <?php echo htmlspecialchars($booking['module']); ?></div>
              <h2 class="h6 mb-1"><?php echo htmlspecialchars($item['name'] ?? ''); ?></h2>
              <?php if (!empty($item['vendor_name'])): ?>
                <div class="small text-muted">Vendor: <?php echo htmlspecialchars($item['vendor_name']); ?></div>
              <?php endif; ?>
              <?php if (!empty($item['city'])): ?>
                <div class="small text-muted">City: <?php echo htmlspecialchars($item['city']); ?></div>
              <?php endif; ?>
              <?php if (!empty($variant['name'])): ?>
                <div class="small">Variant: <strong><?php echo htmlspecialchars($variant['name']); ?></strong></div>
              <?php endif; ?>
              <?php if (!empty($breakdown['show_time'])): ?>
                <div class="small">Show time: <strong><?php echo htmlspecialchars($breakdown['show_time']); ?></strong></div>
              <?php endif; ?>
            </div>
          </div>
          <hr>
          <div class="row g-2">
            <div class="col-6">
              <div class="small text-muted">PAX Type</div>
              <div class="fw-semibold text-capitalize"><?php echo htmlspecialchars($breakdown['pax_type'] ?: '-'); ?></div>
            </div>
            <div class="col-6">
              <div class="small text-muted">Total PAX</div>
              <div class="fw-semibold"><?php echo (int)$breakdown['pax']; ?></div>
            </div>
            <?php if (!empty($breakdown['adults'])): ?>
              <div class="col-6">
                <div class="small text-muted">Adults</div>
                <div class="fw-semibold"><?php echo (int)$breakdown['adults']; ?></div>
              </div>
            <?php endif; ?>
            <?php if (!empty($breakdown['children'])): ?>
              <div class="col-6">
                <div class="small text-muted">Children</div>
                <div class="fw-semibold"><?php echo (int)$breakdown['children']; ?></div>
              </div>
            <?php endif; ?>
            <?php if (!empty($breakdown['infants'])): ?>
              <div class="col-6">
                <div class="small text-muted">Infants</div>
                <div class="fw-semibold"><?php echo (int)$breakdown['infants']; ?></div>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>

    <div class="col-md-5">
      <div class="card shadow-sm">
        <div class="card-header bg-white">
          <strong>Booking Summary</strong>
        </div>
        <div class="card-body">
          <dl class="row mb-0">
            <dt class="col-5">Booking ID</dt>
            <dd class="col-7">#<?php echo (int)$booking['id']; ?></dd>
            <dt class="col-5">Unit Price</dt>
            <dd class="col-7"><?php echo number_format((float)$unitPrice, 2); ?> THB</dd>
            <dt class="col-5">Quantity (PAX)</dt>
            <dd class="col-7"><?php echo (int)($booking['pax'] ?? 1); ?></dd>
            <dt class="col-5">Line Total</dt>
            <dd class="col-7"><strong><?php echo number_format((float)($booking['price'] ?? 0), 2); ?></strong> THB</dd>
            <dt class="col-5">Status</dt>
            <dd class="col-7"><span class="badge <?php echo ($booking['status']==='pending'?'bg-warning text-dark':'bg-success'); ?>"><?php echo htmlspecialchars($booking['status']); ?></span></dd>
            <dt class="col-5">Created</dt>
            <dd class="col-7"><?php echo htmlspecialchars($booking['created_at'] ?? ''); ?></dd>
            <?php if (!empty($orderId)): ?>
              <dt class="col-5">Order</dt>
              <dd class="col-7"><a href="/agent/orders/view?id=<?php echo (int)$orderId; ?>">#<?php echo (int)$orderId; ?></a></dd>
            <?php endif; ?>
          </dl>
        </div>
        <div class="card-footer bg-white d-flex justify-content-between">
          <a href="/agent/bookings" class="btn btn-outline-secondary"><i class="bi bi-arrow-left"></i> Back</a>
          <?php if (($booking['status'] ?? '') === 'pending'): ?>
            <a href="/agent/booking/pay?id=<?php echo (int)$booking['id']; ?>" class="btn btn-primary"><i class="bi bi-credit-card"></i> Pay via Wallet</a>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>
