<?php
/**
 * Agent Portal Dashboard - Public View
 * Accessible at: /b2b/agent/dashboard.php
 */

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Set page title
$title = 'Agent Portal - Professional Travel Agent Dashboard';

// Include header
require_once __DIR__ . '/../../app/Views/agent/partials/public_header.php';
?>

<!-- Hero Section -->
<div class="bg-gradient-to-r from-blue-600 to-indigo-700 text-white">
    <div class="max-w-7xl mx-auto py-16 px-4 sm:py-24 sm:px-6 lg:px-8 text-center">
        <h1 class="text-4xl font-extrabold tracking-tight sm:text-5xl lg:text-6xl">
            Welcome to Your Agent Portal
        </h1>
        <p class="mt-6 max-w-3xl mx-auto text-xl text-blue-100">
            Access exclusive travel deals, manage bookings, and grow your business with our powerful agent tools.
        </p>
        <div class="mt-10 flex justify-center gap-4">
            <a href="login.php" class="px-8 py-3 border border-transparent text-base font-medium rounded-md text-blue-700 bg-white hover:bg-blue-50 md:py-4 md:text-lg md:px-10 transition-all duration-200">
                Agent Login
            </a>
            <a href="register.php" class="px-8 py-3 border border-transparent text-base font-medium rounded-md text-white bg-blue-500 bg-opacity-20 hover:bg-opacity-30 md:py-4 md:text-lg md:px-10 transition-all duration-200">
                Register as Agent
            </a>
        </div>
    </div>
</div>

<!-- Features Section -->
<div class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="lg:text-center">
            <h2 class="text-3xl font-extrabold text-gray-900 sm:text-4xl">
                Everything You Need to Succeed
            </h2>
            <p class="mt-4 max-w-2xl text-xl text-gray-500 lg:mx-auto">
                Our agent portal is designed to help you manage your travel business efficiently.
            </p>
        </div>

        <div class="mt-20">
            <div class="space-y-10 md:space-y-0 md:grid md:grid-cols-2 md:gap-x-8 md:gap-y-10">
                <!-- Feature 1 -->
                <div class="relative">
                    <div class="absolute flex items-center justify-center h-12 w-12 rounded-md bg-blue-500 text-white">
                        <i class="fas fa-chart-line text-xl"></i>
                    </div>
                    <div class="ml-16">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">Real-time Analytics</h3>
                        <p class="mt-2 text-base text-gray-500">Track your bookings, commissions, and performance metrics in real-time.</p>
                    </div>
                </div>

                <!-- Feature 2 -->
                <div class="relative">
                    <div class="absolute flex items-center justify-center h-12 w-12 rounded-md bg-blue-500 text-white">
                        <i class="fas fa-percentage text-xl"></i>
                    </div>
                    <div class="ml-16">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">Competitive Commissions</h3>
                        <p class="mt-2 text-base text-gray-500">Earn attractive commissions on all bookings made through your portal.</p>
                    </div>
                </div>

                <!-- Feature 3 -->
                <div class="relative">
                    <div class="absolute flex items-center justify-center h-12 w-12 rounded-md bg-blue-500 text-white">
                        <i class="fas fa-headset text-xl"></i>
                    </div>
                    <div class="ml-16">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">24/7 Support</h3>
                        <p class="mt-2 text-base text-gray-500">Our dedicated support team is always here to assist you.</p>
                    </div>
                </div>

                <!-- Feature 4 -->
                <div class="relative">
                    <div class="absolute flex items-center justify-center h-12 w-12 rounded-md bg-blue-500 text-white">
                        <i class="fas fa-tools text-xl"></i>
                    </div>
                    <div class="ml-16">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">Powerful Tools</h3>
                        <p class="mt-2 text-base text-gray-500">Access a suite of tools designed specifically for travel agents.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Testimonials -->
<div class="bg-gray-50 py-16">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="lg:text-center">
            <h2 class="text-3xl font-extrabold text-gray-900 sm:text-4xl">
                Trusted by Travel Agents
            </h2>
            <p class="mt-4 max-w-2xl text-xl text-gray-500 lg:mx-auto">
                Join thousands of travel professionals growing their business with us.
            </p>
        </div>

        <div class="mt-16 grid grid-cols-1 gap-8 md:grid-cols-2 lg:grid-cols-3">
            <!-- Testimonial 1 -->
            <div class="bg-white p-6 rounded-lg shadow-md">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="h-12 w-12 rounded-full bg-blue-100 flex items-center justify-center">
                            <span class="text-blue-600 text-xl font-bold">JD</span>
                        </div>
                    </div>
                    <div class="ml-4">
                        <h4 class="text-lg font-semibold text-gray-900">John D.</h4>
                        <p class="text-sm text-gray-500">Travel Agent, 5+ years</p>
                    </div>
                </div>
                <p class="mt-4 text-gray-600">"This platform has transformed how I manage my travel business. The tools are intuitive and the support is exceptional."</p>
            </div>

            <!-- Testimonial 2 -->
            <div class="bg-white p-6 rounded-lg shadow-md">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="h-12 w-12 rounded-full bg-blue-100 flex items-center justify-center">
                            <span class="text-blue-600 text-xl font-bold">MS</span>
                        </div>
                    </div>
                    <div class="ml-4">
                        <h4 class="text-lg font-semibold text-gray-900">Maria S.</h4>
                        <p class="text-sm text-gray-500">Agency Owner</p>
                    </div>
                </div>
                <p class="mt-4 text-gray-600">"The commission structure is the most competitive I've found, and the platform is incredibly easy to use."</p>
            </div>

            <!-- Testimonial 3 -->
            <div class="bg-white p-6 rounded-lg shadow-md">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="h-12 w-12 rounded-full bg-blue-100 flex items-center justify-center">
                            <span class="text-blue-600 text-xl font-bold">RK</span>
                        </div>
                    </div>
                    <div class="ml-4">
                        <h4 class="text-lg font-semibold text-gray-900">Robert K.</h4>
                        <p class="text-sm text-gray-500">Independent Agent</p>
                    </div>
                </div>
                <p class="mt-4 text-gray-600">"I've been able to grow my business by 40% since joining. The real-time analytics are a game-changer."</p>
            </div>
        </div>
    </div>
</div>

<!-- CTA Section -->
<div class="bg-white">
    <div class="max-w-7xl mx-auto py-12 px-4 sm:px-6 lg:py-16 lg:px-8 lg:flex lg:items-center lg:justify-between">
        <h2 class="text-3xl font-extrabold tracking-tight text-gray-900 sm:text-4xl">
            <span class="block">Ready to get started?</span>
            <span class="block text-blue-600">Join our network of professional travel agents today.</span>
        </h2>
        <div class="mt-8 flex lg:mt-0 lg:flex-shrink-0">
            <div class="inline-flex rounded-md shadow">
                <a href="register.php" class="inline-flex items-center justify-center px-5 py-3 border border-transparent text-base font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700">
                    Get Started
                </a>
            </div>
            <div class="ml-3 inline-flex rounded-md shadow">
                <a href="login.php" class="inline-flex items-center justify-center px-5 py-3 border border-transparent text-base font-medium rounded-md text-blue-600 bg-white hover:bg-gray-50">
                    Sign In
                </a>
            </div>
        </div>
    </div>
</div>

<?php
// Include footer
require_once __DIR__ . '/../../app/Views/agent/partials/public_footer.php';
?>
