<?php
// b2b/agent/bootstrap.php - Bootstrap file for Agent Portal

// Load configuration
$config = require __DIR__ . '/../../config/config.php';

// Set error reporting based on environment
if ($config['environment'] === 'development') {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

// Set timezone
date_default_timezone_set($config['timezone'] ?? 'UTC');

// Start session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Include necessary files
require_once __DIR__ . '/../../app/Core/Router.php';
require_once __DIR__ . '/../../app/Core/Controller.php';
require_once __DIR__ . '/../../app/Core/View.php';
require_once __DIR__ . '/../../app/Core/Security.php';
require_once __DIR__ . '/../../app/Core/Auth.php';
require_once __DIR__ . '/../../app/Core/Database.php';

// Include controllers
require_once __DIR__ . '/../../app/Controllers/AgentAuthController.php';
