<?php
// app/Views/verify.php (Public universal verification page)
$title = $title ?? 'Booking Verification';
$code = (string)($code ?? '');
$result = $result ?? null; // ['type' => 'taxi|hotel|activity', 'data' => array] or null
$type = is_array($result) ? ($result['type'] ?? '') : '';
$data = is_array($result) ? ($result['data'] ?? []) : [];
$paid = strtolower((string)($data['payment_status'] ?? '')) === 'paid';
$status = strtolower((string)($data['status'] ?? ''));
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= htmlspecialchars($title) ?></title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
  <style>
    :root{--ink:#0f172a;--muted:#64748b;--ok:#16a34a;--warn:#f59e0b;--err:#dc2626}
    *{box-sizing:border-box}
    body{margin:0;background:#f8fafc;font-family:Inter,system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;color:var(--ink)}
    .wrap{max-width:720px;margin:36px auto;padding:0 16px}
    .card{background:#fff;border:1px solid #e2e8f0;border-radius:14px;box-shadow:0 8px 24px rgba(2,6,23,.06);overflow:hidden}
    .hdr{padding:18px 20px;background:linear-gradient(90deg,#1d4ed8,#3b82f6);color:#fff}
    .hdr h1{margin:0;font-size:18px}
    .body{padding:20px}
    form{display:flex;gap:8px;flex-wrap:wrap}
    input[type=text]{flex:1 1 320px;padding:10px 12px;border:1px solid #cbd5e1;border-radius:10px;font-size:14px}
    button{padding:10px 14px;border-radius:10px;border:1px solid #1d4ed8;background:#1d4ed8;color:#fff;font-weight:700;cursor:pointer}
    .stat{display:inline-flex;align-items:center;gap:8px;padding:8px 10px;border-radius:999px;font-weight:700;margin-top:12px}
    .ok{background:#dcfce7;color:var(--ok);border:1px solid #bbf7d0}
    .warn{background:#fef3c7;color:var(--warn);border:1px solid #fde68a}
    .err{background:#fee2e2;color:var(--err);border:1px solid #fecaca}
    .row{display:grid;grid-template-columns:1fr 1fr;gap:14px;margin-top:14px}
    .item{padding:10px 12px;background:#f8fafc;border:1px solid #e5e7eb;border-radius:10px}
    .label{font-size:12px;color:var(--muted);margin-bottom:3px}
    .value{font-weight:600}
    @media (max-width:640px){.row{grid-template-columns:1fr}}
  </style>
</head>
<body>
  <div class="wrap">
    <div class="card">
      <div class="hdr">
        <h1>Universal Booking Verification</h1>
      </div>
      <div class="body">
        <form method="get" action="<?= htmlspecialchars(base_url('verify')) ?>">
          <input type="text" name="code" placeholder="Enter booking code (e.g., TAX-20250922-21)" value="<?= htmlspecialchars($code) ?>" required />
          <button type="submit">Verify</button>
        </form>

        <?php if ($code !== ''): ?>
          <?php if ($result): ?>
            <?php
              $badgeClass = $status === 'cancelled' ? 'err' : ($paid ? 'ok' : 'warn');
              $badgeText = strtoupper($type) . ' • ' . ($status === 'cancelled' ? 'Cancelled' : ($paid ? 'Verified & Paid' : 'Verified (Unpaid)'));
            ?>
            <div class="stat <?= $badgeClass ?>">
              <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                <?php if ($badgeClass==='ok'): ?>
                  <path d="M9 12l2 2 4-4m6 2a10 10 0 11-20 0 10 10 0 0120 0z"/>
                <?php elseif ($badgeClass==='warn'): ?>
                  <path d="M12 9v4m0 4h.01M10.29 3.86L1.82 18a2 2 0 001.71 3h16.94a2 2 0 001.71-3L13.71 3.86a2 2 0 00-3.42 0z"/>
                <?php else: ?>
                  <path d="M12 9v2m0 4h.01M10 3h4l7 7v7a4 4 0 01-4 4H7a4 4 0 01-4-4v-7l7-7z"/>
                <?php endif; ?>
              </svg>
              <span><?= htmlspecialchars($badgeText) ?></span>
            </div>

            <div class="row">
              <?php if ($type === 'taxi'): ?>
                <div class="item"><div class="label">From</div><div class="value"><?= htmlspecialchars((string)($data['from_text'] ?? '')) ?></div></div>
                <div class="item"><div class="label">To</div><div class="value"><?= htmlspecialchars((string)($data['to_text'] ?? '')) ?></div></div>
                <div class="item"><div class="label">Trip Date</div><div class="value"><?= htmlspecialchars((string)($data['trip_date'] ?? '')) ?></div></div>
                <div class="item"><div class="label">Pax</div><div class="value"><?= (int)($data['pax'] ?? 1) ?></div></div>
                <div class="item"><div class="label">Vehicle</div><div class="value"><?= htmlspecialchars((string)($data['vehicle_type'] ?? $data['ride_name'] ?? '')) ?></div></div>
              <?php elseif ($type === 'hotel'): ?>
                <div class="item"><div class="label">Guest</div><div class="value"><?= htmlspecialchars((string)($data['guest_name'] ?? '')) ?></div></div>
                <div class="item"><div class="label">Hotel</div><div class="value"><?= htmlspecialchars((string)($data['hotel_name'] ?? '')) ?></div></div>
                <div class="item"><div class="label">Check-in</div><div class="value"><?= htmlspecialchars((string)($data['checkin_date'] ?? '')) ?></div></div>
                <div class="item"><div class="label">Check-out</div><div class="value"><?= htmlspecialchars((string)($data['checkout_date'] ?? '')) ?></div></div>
              <?php elseif ($type === 'activity'): ?>
                <div class="item"><div class="label">Guest</div><div class="value"><?= htmlspecialchars((string)($data['customer_name'] ?? '')) ?></div></div>
                <div class="item"><div class="label">Activity</div><div class="value"><?= htmlspecialchars((string)($data['activity_name'] ?? '')) ?></div></div>
                <div class="item"><div class="label">Travel Date</div><div class="value"><?= htmlspecialchars((string)($data['travel_date'] ?? '')) ?></div></div>
                <div class="item"><div class="label">Pax</div><div class="value"><?= (int)($data['pax'] ?? 1) ?></div></div>
              <?php endif; ?>
            </div>
          <?php else: ?>
            <div class="stat err" style="margin-top:12px">
              <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor"><path d="M12 9v2m0 4h.01M10 3h4l7 7v7a4 4 0 01-4 4H7a4 4 0 01-4-4v-7l7-7z"/></svg>
              <span>No booking found for this code.</span>
            </div>
          <?php endif; ?>
        <?php endif; ?>
      </div>
    </div>
  </div>
</body>
</html>
