<?php
// app/Views/vendor/jobs.php
$title = $title ?? 'My Jobs';
$rows = $rows ?? [];
$filters = $filters ?? [];
$csrf = $csrf ?? '';
?>
<div class="container py-3">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h2 class="h5 mb-0"><i class="bi bi-clipboard-check me-2"></i>My Taxi Jobs</h2>
    <a href="/vendor/logout" class="btn btn-sm btn-outline-secondary">Logout</a>
  </div>

  <form class="row g-2 mb-3">
    <div class="col-auto">
      <input type="date" name="date" value="<?= htmlspecialchars((string)($filters['date']??'')) ?>" class="form-control form-control-sm">
    </div>
    <div class="col-auto">
      <select name="status" class="form-select form-select-sm">
        <option value="">Any Status</option>
        <?php foreach (['pending','confirmed','cancelled','refunded'] as $s): ?>
          <option value="<?= $s ?>" <?= (($filters['status']??'')===$s?'selected':'') ?>><?= ucfirst($s) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-auto">
      <button class="btn btn-sm btn-primary">Filter</button>
    </div>
  </form>

  <div class="table-responsive">
    <table class="table table-sm table-striped align-middle">
      <thead>
        <tr>
          <th>#</th>
          <th>Code</th>
          <th>Pickup</th>
          <th>Route</th>
          <th>Pax</th>
          <th>Status</th>
          <th>Pay</th>
          <th>Amount</th>
          <th>Vendor Cost</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
          <tr>
            <td><?= (int)$r['id'] ?></td>
            <td><span class="fw-semibold"><?= htmlspecialchars((string)($r['booking_code'] ?? '')) ?></span></td>
            <td><?= htmlspecialchars((string)($r['trip_date'] ?? '')) ?> <?php if (!empty($r['pickup_time'])): ?><span class="text-muted small"><?= htmlspecialchars(' '.$r['pickup_time']) ?></span><?php endif; ?></td>
            <td><?= htmlspecialchars((string)($r['from_text'] ?? '')) ?> → <?= htmlspecialchars((string)($r['to_text'] ?? '')) ?></td>
            <td><?= (int)($r['pax'] ?? 1) ?></td>
            <td><span class="badge bg-light text-dark"><?= htmlspecialchars((string)($r['status'] ?? '')) ?></span></td>
            <td><span class="badge bg-light text-dark"><?= htmlspecialchars((string)($r['payment_status'] ?? '')) ?></span></td>
            <td><?= number_format((float)($r['amount_total'] ?? 0), 2) . ' ' . htmlspecialchars((string)($r['currency'] ?? 'THB')) ?></td>
            <td><?= number_format((float)($r['vendor_cost'] ?? 0), 2) . ' ' . htmlspecialchars((string)($r['vendor_currency'] ?? ($r['currency'] ?? 'THB'))) ?></td>
            <td><a href="/vendor/job/view?id=<?= (int)$r['id'] ?>" class="btn btn-sm btn-outline-primary">Open</a></td>
          </tr>
        <?php endforeach; ?>
        <?php if (empty($rows)): ?>
          <tr><td colspan="8" class="text-center text-muted py-3">No jobs.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
